/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.sprite;

import java.awt.Dimension;
import java.util.Collection;

/**
 * @author Pierre Lando
 */
public interface SpriteManager {

    /**
     * Create a sprite of given size.
     * @param width  the sprite width.
     * @param height the sprite height.
     * @return a new sprite.
     */
    Sprite createSprite(int width, int height);

    /**
     * Create a sprite of given size.
     * @param dimension the given dimension.
     * @return a new sprite.
     */
    Sprite createSprite(Dimension dimension);

    /**
     * Create a rotatable sprite of given size.
     * @param width  the sprite width.
     * @param height the sprite height.
     * @return a new sprite.
     */
    Sprite createRotatableSprite(int width, int height);

    /**
     * Release all resources used by the given sprite.
     * @param sprite the given sprite.
     */
    void dispose(Sprite sprite);

    /**
     * Release all resources used by the given sprites.
     * @param sprites the given sprites.
     */
    void dispose(Collection<Sprite> sprites);

    /**
     * Return the dimension in pixel of the given text entity.
     * @param textEntity the given text entity.
     * @return the dimension in pixel of the given text entity.
     */
    Dimension getSize(TextEntity textEntity);

}
