/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.sprite;

/**
 * @author Pierre Lando
 */
public interface SpriteDrawer {

    /**
     * Origin position.
     */
    public enum OriginPosition {
        CENTER,
        UPPER_LEFT
    }

    /**
     * Ask this drawer to draw with the given drawing tools.
     * @param drawingTools the givens drawing tools.
     */
    void draw(SpriteDrawingTools drawingTools);

    /**
     * Return the origin position.
     * Warning: change the returned value during a draw call have no effect.
     * @return the origin position.
     */
    OriginPosition getOriginPosition();
}
