/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.jogl.sprite;

import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

/**
 * @author Pierre Lando
 */
interface JoGLSpriteRenderer {

    /**
     * Draw this sprite with the given drawing tools at the given position.
     * @param drawingTools the drawing tools to use.
     * @param anchor anchor position.
     * @param positions the position.
     */
    void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, ElementsBuffer positions);

    /**
     * Draw this sprite with the given drawing tools at the given position.
     * @param drawingTools the drawing tools to use.
     * @param anchor anchor position.
     * @param position the position.
     */
    void draw(JoGLDrawingTools drawingTools, SpriteAnchorPosition anchor, Vector3d position);

    /**
     * Ask this sprite to dispose.
     * @param drawingTools the drawing tools to use.
     */
    void dispose(JoGLDrawingTools drawingTools);

    /**
     * Ask the sprite to reset the OpenGl status.
     */
    void reload();
}
