/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.implementation.jogl;

/**
 * @author Pierre Lando
 */
public class JoGLParameters {

    /**
     * Default constructor.
     * It's package : only JoGLCanvas need this kind of object.
     */
    JoGLParameters() {
    }

    /**
     * Use display list.
     * @return true if use display list.
     */
    public boolean useDisplayList() {
        return false;
    }

    /**
     * Use VBO.
     * @return true if use VBO.
     */
    public boolean useVBO() {
        return true;
    }

    /**
     * Use point sprite.
     * @return true if use point sprite.
     */
    public boolean usePointSprite() {
        return true;
    }
}
