/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2012 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.textureExample;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;

/**
 * @author Pierre Lando
 */
public class SimpleGeometry extends DefaultGeometry implements Geometry {


    public SimpleGeometry(Canvas canvas) {
        ElementsBuffer vertices = canvas.getBuffersManager().createElementsBuffer();
        vertices.setData(new float[] {
                -1, -1, 0, 1,
                -1, +1, 0, 1,
                +1, +1, 0, 1,
                +1, -1, 0, 1,
        }, 4);

        IndicesBuffer indices = canvas.getBuffersManager().createIndicesBuffer();
        indices.setData(new int[] {
                0, 1 ,2, 0, 2, 3
        });

        ElementsBuffer textureCoordinates =  canvas.getBuffersManager().createElementsBuffer();
        textureCoordinates.setData(new float[] {
                0, 0,
                0, 1,
                1, 1,
                1, 0
        }, 2);

        setFillDrawingMode(FillDrawingMode.TRIANGLES);
        setVertices(vertices);
        setIndices(indices);
        setTextureCoordinates(textureCoordinates);
    }
}
