/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.sprite;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;

import com.sun.opengl.util.Animator;

/**
 * @author Pierre Lando
 */
public class SpriteGLExample {

    /**
     * Private constructor.
     * This is the main class.
     */
    private SpriteGLExample() {
    }

    public static void main(String[] arguments) {

        JFrame frame = new JFrame("JoGLCanvas");
        frame.setSize(800, 600);

        GLJPanel panel = new GLJPanel();

        Animator animator = new Animator();
        animator.add(panel);

        animator.start();

        frame.add(panel);


        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        canvas.setMainDrawer(new SpriteDrawerExample(canvas));

        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
