/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.sprite;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.sprite.Sprite;
import org.scilab.forge.scirenderer.sprite.SpriteAnchorPosition;
import org.scilab.forge.scirenderer.sprite.SpriteDrawer;
import org.scilab.forge.scirenderer.sprite.SpriteDrawingTools;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;

/**
 * @author Pierre Lando
 */
public class SpriteDrawerExample implements Drawer {


    private final Sprite sprite;
    private final ElementsBuffer position;
    private int v;

    public SpriteDrawerExample(Canvas canvas) {
        sprite = canvas.getSpriteManager().createSprite(20, 20);
        sprite.setDrawer(getSpriteDrawer());

        position = canvas.getBuffersManager().createElementsBuffer();
        position.setData(new float[] {
                -1, -1, +1, 1,
                -1, -1, -1, 1,
                -1, +1, +1, 1,
                -1, +1, -1, 1,
                +1, -1, +1, 1,
                +1, -1, -1, 1,
                +1, +1, +1, 1,
                +1, +1, -1, 1,
        }, 4);
    }

    @Override
    public void draw(DrawingTools drawingTools) {
        drawingTools.clear(new Color(.2f, .3f, .4f));

        try {
            Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(drawingTools.getCanvas().getDimension(), 1f);
            drawingTools.getTransformationManager().getProjectionStack().push(projection);
            drawingTools.getTransformationManager().getModelViewStack().push(TransformationFactory.getScaleTransformation(.1, .1, .1));
            drawingTools.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(v, 1, 2, 3));
        } catch (DegenerateMatrixException ignored) {
            // Should not occur.
        }

        v++;
        drawingTools.draw(sprite, SpriteAnchorPosition.CENTER, position);
    }

    public SpriteDrawer getSpriteDrawer() {
        return new SpriteDrawer() {

            @Override
            public void draw(SpriteDrawingTools drawingTools) {
                drawingTools.fillDisc(0, 0, 10, new Color(1, 0, 0));

                Appearance appearance = new Appearance();
                appearance.setLineColor(new Color(0, 1, 0));
                drawingTools.drawCircle(0, 0, 14, appearance);

                appearance.setLineColor(new Color(0, 0, 0));
                drawingTools.drawPolyline(new int[] {
                        -5, 0,
                        0, +5,
                        +5, 0,
                        0, -5,
                        -5, 0
                }, appearance);
            }

            @Override
            public OriginPosition getOriginPosition() {
                return SpriteDrawer.OriginPosition.CENTER;
            }
        };
    }
}
