/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 * Copyright (C) 2011 - DIGITEO - Manuel Juliachs
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.rotatableSprite;


import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;

import com.sun.opengl.util.Animator;

/**
 * A basic example featuring rotatable 2D sprites.
 *
 * @author Pierre Lando
 * @author Manuel Juliachs
 */
public class RotatableSpriteExample {

    /**
     * Private constructor.
     * This is the main class.
     */
    private RotatableSpriteExample() {
    }

    public static void main(String[] arguments) {

        JFrame frame = new JFrame("Rotatable Sprite Example");
        frame.setSize(800, 600);

        GLJPanel panel = new GLJPanel();
        frame.add(panel);


        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        final RotatableSpriteDrawerExample drawer = new RotatableSpriteDrawerExample(canvas);
        canvas.setMainDrawer(drawer);

        /* Key listener */
        frame.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_T) {
                    drawer.toggleAnchorDisplay();
                } else if (e.getKeyCode() == KeyEvent.VK_D) {
                    drawer.switchRotationDirection();
                } else if (e.getKeyCode() == KeyEvent.VK_M) {
                    drawer.toggleMessageDisplay();
                }
            }
        });

        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        Animator animator = new Animator();
        animator.add(panel);
        animator.start();
    }
}
