/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.jlatex;

import org.scilab.forge.jlatexmath.TeXConstants;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import java.awt.BorderLayout;

/**
 * @author Pierre Lando
 */
public class LatexCompositor extends JComponent {

    private static final String GAUSS = "\\int_{-\\infty}^{+\\infty}\\!e^{-x^2}\\, \\mathrm{d}x = \\sqrt \\pi";
    private final PlainDocument document;

    /**
     * Default constructor.
     */
    public LatexCompositor() {
        setLayout(new BorderLayout());
        document = new PlainDocument();
        try {
            document.insertString(0, GAUSS, null);
        } catch (BadLocationException ignored) {
        }

        document.addDocumentListener(new DocumentListener() {
            @Override
            public void insertUpdate(DocumentEvent e) {
                fireDataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                fireDataChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                fireDataChanged();
            }
        });

        JTextArea textArea = new JTextArea(document);
        add(textArea, BorderLayout.CENTER);
    }

    public TeXIcon getTextIcon() {
        try {
            TeXFormula formula = new TeXFormula(document.getText(0, document.getLength()));
            return formula.createTeXIcon(TeXConstants.STYLE_DISPLAY, 32);
        } catch (org.scilab.forge.jlatexmath.ParseException e) {
            return null;
        } catch (BadLocationException e) {
            return null;
        }
    }

    public void addListener(LatexDrawer latexDrawer) {
        listenerList.add(LatexCompositorListener.class, latexDrawer);
        latexDrawer.DataChanged(this);
    }

    private void fireDataChanged() {
        for (LatexCompositorListener listener : listenerList.getListeners(LatexCompositorListener.class)) {
            listener.DataChanged(this);
        }
    }
}
