/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.jlatex;

import com.sun.opengl.util.Animator;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;

import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;
import java.awt.BorderLayout;

/**
 * @author Pierre Lando
 */
public class Latex {

    /**
     * Private constructor.
     * This is the main class.
     */
    private Latex() {
    }

    public static void main(String[] arguments) {

        LatexCompositor latexCompositor = new LatexCompositor();

        JFrame frame = new JFrame("Latex JoGL Drawing Example");
        frame.setLayout(new BorderLayout());
        frame.setSize(800, 600);

        GLJPanel panel = new GLJPanel();

        Animator animator = new Animator();
        animator.add(panel);

        animator.start();

        frame.add(panel, BorderLayout.CENTER);
        frame.add(latexCompositor, BorderLayout.SOUTH);


        Canvas canvas = JoGLCanvasFactory.createCanvas(panel);

        LatexDrawer latexDrawer = new LatexDrawer(canvas);
        latexCompositor.addListener(latexDrawer);

        canvas.setMainDrawer(latexDrawer);

        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
