/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009-2011 - DIGITEO - Pierre Lando
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 */

package org.scilab.forge.scirenderer.examples.clippingExample;

import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.examples.utils.MouseRotationAdapter;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector4d;
import org.scilab.forge.scirenderer.utils.shapes.geometry.TetrahedronFactory;

import javax.swing.BoundedRangeModel;

/**
 * @author Pierre Lando
 */
public class ClippingDrawer implements Drawer {
    private final MouseRotationAdapter mra;
    private final Geometry tetrahedron;
    private final BoundedRangeModel brm;

    public ClippingDrawer(Canvas canvas, MouseRotationAdapter mra, BoundedRangeModel brm) {
        this.mra = mra;
        this.tetrahedron = TetrahedronFactory.createTetrahedron(canvas);
        this.brm = brm;
    }

    @Override
    public void draw(DrawingTools dt) {
        dt.clear(new Color(1f, 1f, 1f));

        try {
            Transformation projection = TransformationFactory.getPreferredAspectRatioTransformation(dt.getCanvas().getDimension(), 1f);
            dt.getTransformationManager().getProjectionStack().push(projection);
            dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getScaleTransformation(.6, .6, .6));
            dt.getTransformationManager().getModelViewStack().pushRightMultiply(TransformationFactory.getRotationTransformation(mra.getRotation()));
            ClippingPlane cp = dt.getClippingManager().getClippingPlane(0);
            cp.setEnable(true);
            cp.setEquation(new Vector4d(-1, 0, 0, -getValue()));

            Appearance appearance = new Appearance();
            appearance.setFillColor(new Color(1f, 0f, 0f));
            appearance.setLineColor(new Color(.2f, .2f, .2f));
            appearance.setLineWidth(3);
            dt.draw(tetrahedron, appearance);

            cp.setEquation(new Vector4d(1, 0, 0, getValue()));
            appearance.setFillColor(new Color(0f, 1f, 0f));
            dt.draw(tetrahedron, appearance);

            cp.setEnable(false);
        } catch (SciRendererException ignored) {
            // Should not occur.
        }
    }

    private double getValue() {
        return -(double) brm.getValue() / 100.0;
    }
}
