#ifndef SCIMBRIDGEEXCEPTION_H_
#define SCIMBRIDGEEXCEPTION_H_

#include "scim-bridge.h"

typedef struct _ScimBridgeException
{
    int err_no;
    char *message;
} ScimBridgeException;

#ifdef __cplusplus
extern "C"
{
#endif

    void scim_bridge_exception_initialize (ScimBridgeException *except);
    void scim_bridge_exception_finalize (ScimBridgeException *except);
    void scim_bridge_exception_copy (ScimBridgeException *dest, const ScimBridgeException *except);
    void scim_bridge_exception_set_message (ScimBridgeException *except, const char *new_message);
    const char *scim_bridge_exception_get_message (const ScimBridgeException *except);
    void scim_bridge_exception_set_errno (ScimBridgeException *except, const int new_errno);
    int scim_bridge_exception_get_errno (const ScimBridgeException *except);
    const char *scim_bridge_exception_get_strerror (const ScimBridgeException *except);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEEXCEPTION_H_*/
