#include <alloca.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "scim-bridge-environment.h"
#include "scim-bridge-output.h"

/* Helper functions */
static void vfprintfln (FILE *stream, const char *format, va_list ap)
{
    size_t format_len = strlen (format) + 1;
    char *new_format = alloca (sizeof (char) * (format_len + 1));
    strcpy (new_format, format);
    new_format[format_len - 1] = '\n';
    new_format[format_len] = '\0';
    vfprintf (stream, new_format, ap);
}


/* Implementations */
void scim_bridge_println (const char* format,...)
{
    va_list ap;
    va_start (ap, format);
    vfprintfln (stdout, format, ap);
    va_end (ap);
}


void scim_bridge_perrorln (const char* format,...)
{
    va_list ap;
    va_start (ap, format);
    vfprintfln (stderr, format, ap);
    va_end (ap);
}


void scim_bridge_pdebugln (ScimBridgeDebugFlag flag, ScimBridgeDebugLevel level, const char* format,...)
{
    if ((flag & scim_bridge_environment_get_debug_flags ()) && ((10 - level) <= scim_bridge_environment_get_debug_level ())) {
        va_list ap;
        va_start (ap, format);
        vfprintfln (stdout, format, ap);
        va_end (ap);
    }
}


void scim_bridge_print (const char* format,...)
{
    va_list ap;
    va_start (ap, format);
    vfprintf (stdout, format, ap);
    va_end (ap);
}


void scim_bridge_perror (const char* format,...)
{
    va_list ap;
    va_start (ap, format);
    vfprintf (stderr, format, ap);
    va_end (ap);
}


void scim_bridge_pdebug (ScimBridgeDebugFlag flag, ScimBridgeDebugLevel level, const char* format,...)
{
    if ((flag & scim_bridge_environment_get_debug_flags ()) && ((10 - level) <= scim_bridge_environment_get_debug_level ())) {
        va_list ap;
        va_start (ap, format);
        vfprintf (stdout, format, ap);
        va_end (ap);
    }
}
