#ifndef SCIMBRIDGEAGENTKERNEL_H_
#define SCIMBRIDGEAGENTKERNEL_H_

#define Uses_SCIM_ATTRIBUTE
#define Uses_SCIM_BACKEND
#define Uses_SCIM_IMENGINE
#define Uses_SCIM_IMENGINE_MODULE
#define Uses_SCIM_CONFIG
#define Uses_SCIM_CONFIG_MODULE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_TRANSACTION
#define Uses_SCIM_HOTKEY
#define Uses_SCIM_PANEL_CLIENT

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-agent-exception.h"

class ScimBridgeAgentPanelListener
{

    public:

        /* Callback from panel */
        virtual int get_scim_panel_fd () = 0;
        virtual void scim_panel_handler (int condition) = 0;
        virtual void scim_panel_shutdowned () = 0;
        virtual bool is_scim_panel_shutdown_triggered () = 0;
        
        virtual void agent_update_lockfile () = 0;

    protected:

        ScimBridgeAgentPanelListener () {}
        virtual ~ScimBridgeAgentPanelListener () {}
};

class ScimBridgeAgentKernel
{

    public:

        static ScimBridgeAgentKernel *create (bool exit_with_no_client_value) throw (ScimBridgeAgentException);

        virtual ~ScimBridgeAgentKernel () {};

        virtual void connect (const int input_fd, const int output_fd) throw (ScimBridgeAgentException) = 0;

    protected:

        ScimBridgeAgentKernel () {}

};
#endif                                            /*SCIMBRIDGEAGENTKERNEL_H_*/
