#ifndef SCIMBRIDGEAGENTIMCONTEXT_H_
#define SCIMBRIDGEAGENTIMCONTEXT_H_

#define Uses_SCIM_ATTRIBUTE
#define Uses_SCIM_IMENGINE
#define Uses_SCIM_IMENGINE_MODULE

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-keyevent.h"
#include "scim-bridge-imcontext-common.h"

class ScimBridgeAgentClientPeer;

class ScimBridgeAgentIMContext: public ScimBridgeIMContext
{
    public:

        /* static functions */
        static void set_on_the_spot_enabled (bool enabled);
        static bool is_on_the_spot_enabled ();
        static bool is_imengine_shared ();
        static void set_imengine_shared (bool shared);
        static scim::IMEngineInstancePointer get_shared_imengine ();
        static void release_shared_imengine ();

        static ScimBridgeAgentIMContext *find (ScimBridgeIMContextID id);

        ScimBridgeAgentIMContext ();
        ~ScimBridgeAgentIMContext ();

        void free ();

        bool process_key_event (const scim::KeyEvent &keyevent);

        const scim::AttributeList &get_preedit_attribute_list ();
        void set_preedit_attribute_list (const scim::AttributeList &attr_list);
        const scim::WideString &get_preedit_string ();
        void set_preedit_string (const scim::WideString & wstr);
        void move_preedit_caret (int caret_pos);
        void set_preedit_caret (int caret_pos);
        const int get_preedit_caret () const;
        void set_preedit_shown (bool shown);
        const bool is_preedit_shown () const;
        void reset_preedit ();

        const int get_cursor_x () const;
        const int get_cursor_y () const;
        void set_cursor_x (int new_x);
        void set_cursor_y (int new_y);
        void set_cursor_location (int new_x, int new_y);

        const bool is_on () const;
        void turn_on ();
        void turn_off ();

        const ScimBridgeIMContextID get_id () const;
        const ScimBridgeIMContextID get_opponent_id () const;
        void set_opponent_id (ScimBridgeIMContextID new_opponent_id);

        void set_imengine (scim::IMEngineInstancePointer new_imengine);
        const scim::IMEngineInstancePointer get_imengine () const;

        void update_lookup_table_page_size (int page_size);
        void lookup_table_page_up ();
        void  lookup_table_page_down ();
        void trigger_property (const scim::String &property);
        const scim::String get_factory_uuid () const;
        void process_helper_event (const scim::String &helper_uuid, const scim::Transaction &trans);
        void select_candidate (int cand_index);

        void reset ();
        void focus_in ();
        void focus_out ();

        bool process_keyevent (const scim::KeyEvent &keyevent);

        const ScimBridgeAgentClientPeer *get_client_peer () const;
        ScimBridgeAgentClientPeer *get_client_peer ();
        void set_client_peer (ScimBridgeAgentClientPeer *new_client_peer);

    private:

        static scim::IMEngineInstancePointer shared_imengine;

        static bool on_the_spot;
        static bool imengine_shared;

        static void set_shared_imengine (scim::IMEngineInstancePointer new_imengine);

        scim::IMEngineInstancePointer imengine;
        scim::WideString preedit_string;
        scim::AttributeList preedit_attribute_list;

        bool preedit_shown;
        int preedit_caret;

        int cursor_x;
        int cursor_y;

        bool status;

        ScimBridgeAgentClientPeer *client_peer;

        void update_capabilities ();

};
#endif                                            /*SCIMBRIDGEAGENTIMCONTEXT_H_*/
