#ifndef SCIMBRIDGEAGENTCLIENTLISTENER_H_
#define SCIMBRIDGEAGENTCLIENTLISTENER_H_

#define Uses_SCIM_HOTKEY

#include <scim.h>

#include "scim-bridge.h"

class ScimBridgeAgentClientPeer;
class ScimBridgeAgentIMContext;

class ScimBridgeAgentClientListener
{

    public:

        /* Called from the client (through the messenger) */

        virtual const scim::KeyboardLayout &get_keyboard_layout () = 0;

        virtual ScimBridgeAgentIMContext *alloc_imcontext (ScimBridgeAgentClientPeer &client_peer) = 0;
        virtual void free_imcontext (ScimBridgeAgentIMContext &ic) = 0;
        virtual void reset_imcontext (ScimBridgeAgentIMContext &ic) = 0;
        virtual void focus_changed (ScimBridgeAgentIMContext &ic, bool focus_in) = 0;
        virtual bool keyevent_occured (ScimBridgeAgentIMContext &ic, const scim::KeyEvent &keyevent) = 0;
        virtual void cursor_location_changed (ScimBridgeAgentIMContext &ic, int cursor_x, int cursor_y) = 0;

        virtual void connection_closed (ScimBridgeAgentClientPeer &client_peer) = 0;

    protected:

        ScimBridgeAgentClientListener () {}
        virtual ~ScimBridgeAgentClientListener () {}

};
#endif                                            /*SCIMBRIDGEAGENTCLIENTLISTENER_H_*/
