//  Scicos
//
// Copyright (C) INRIA - METALAU Project <scicos@inria.fr>
// Copyright (C) 2018 - Samuel GOUGEON
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
// See the file ../license.txt
//
function [x,y,typ]=Resistor(job,arg1,arg2)
    // exemple d'un bloc implicit,
    //   -  sans entree ni sortie de conditionnement
    //   -  avec une entree et une sortie de type implicit et de dimension 1
    //   - avec un dialogue de saisie de parametre
    x=[];
    y=[];
    typ=[];
    select job
    case "set" then
        x=arg1;
        graphics=arg1.graphics;
        exprs=graphics.exprs
        model=arg1.model;
        while %t do
            [ok,R,exprs]=scicos_getvalue("Set Resistor block parameter",..
            "R (ohm)",list("vec",1),exprs)
            if ~ok then
                break,
            end
            model.rpar=R
            model.equations.parameters(2)=list(R)
            graphics.exprs=exprs
            // Updating the icon according to the resistance value:
            v = evstr(exprs);
            if v>=1e-5 & v<1e-2
                sv = msprintf("%d\\:\\mu\n",v*1e6)
            elseif v>=1e-2 & v<10
                sv = msprintf("%d\\:m\n",v*1000)
            elseif v>=10 & v<10000
                sv = msprintf("%d\\:\n",v)
            elseif v>=1e4 & v<1e7
                sv = msprintf("%d\\:k\n",v/1000)
            elseif v>=1e7 & v<1e10
                sv = msprintf("%d\\:M\n",v/1e6)
            else
                p = floor(log10(v));
                v = v/10^p;
                sv = msprintf("%3.1f\\,10^{%d}\\,\n",v,p)
            end
            lab = "Resistor;displayedLabel=" + ..
            "$\mathsf{\,\\\,\\\,\\\,\\\,\\\,\\\,\,\\\,\\\tiny{\!"+sv+"\Omega}}$"
            graphics.style = lab;
            x.graphics=graphics;
            //
            x.model=model
            break
        end
    case "define" then
        model=scicos_model()
        R=0.01
        model.rpar=R
        model.sim="resistor"
        model.blocktype="c"
        model.dep_ut=[%t %f]
        mo=modelica()
        mo.model="Resistor"
        mo.inputs="p";
        mo.outputs="n";
        mo.parameters=list("R",list(R))
        model.equations=mo
        model.in=ones(size(mo.inputs,"*"),1)
        model.out=ones(size(mo.outputs,"*"),1)
        exprs=string(R)
        gr_i=[]
        x=standard_define([2 2],model,exprs,list(gr_i,0))
        x.graphics.in_implicit=["I"]
        x.graphics.out_implicit=["I"]
    end
endfunction
