// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises - Charlotte HECQUET
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
//
// <-- ENGLISH IMPOSED -->
//
// <-- Non-regression test for bug 7133 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=7133
//
// <-- Short Description -->
// help_from_sci() with no input now runs a full demo

temp = editor;
function editor(name)
endfunction;
[helptxt, demotxt] = help_from_sci();
editor = temp;

refDemotxt = [
"mode(1)"
"//"
"// Demo of function_template.sci"
"//"
""
"[z] = test_fun(1, 2) // examples of use"
"halt()   // Press return to continue"
" "
"// An empty comment line in the Examples section will add a halt() statement"
"// in the demo file test_fun.dem.sce generated by help_from_sci."
"halt()   // Press return to continue"
" "
"//========= E N D === O F === D E M O =========//" ];

refHelptxt = [
"<?xml version=""1.0"" encoding=""UTF-8""?>"
""
"<!--"
" *"
" * This help file was generated from function_template.sci using help_from_sci()."
" *"
" --"+">"
""
"<refentry version=""5.0-subset Scilab"" xml:id=""function_template"" xml:lang=""en"""
"          xmlns=""http://docbook.org/ns/docbook"""
"          xmlns:xlink=""http://www.w3.org/1999/xlink"""
"          xmlns:svg=""http://www.w3.org/2000/svg"""
"          xmlns:ns3=""http://www.w3.org/1999/xhtml"""
"          xmlns:mml=""http://www.w3.org/1998/Math/MathML"""
"          xmlns:scilab=""http://www.scilab.org"""
"          xmlns:db=""http://docbook.org/ns/docbook"">"
""
"  <refnamediv>"
"    <refname>function_template</refname>"
"    <refpurpose>Short description on the first line following the function header.</refpurpose>"
"  </refnamediv>"
""
""
"<refsynopsisdiv>"
"   <title>Syntax</title>"
"   <synopsis>"
"   [z] = template_function(x,y) // calling examples, one pr. line"
"   "
"   </synopsis>"
"</refsynopsisdiv>"
""
"<refsection>"
"   <title>Parameters</title>"
"   <variablelist>"
"   <varlistentry><term>x:</term>"
"      <listitem><para> the x parameter   // single line description of each parameter.</para></listitem></varlistentry>"
"   <varlistentry><term>y:</term>"
"      <listitem><para> the y parameter   // parameter name and description must be</para></listitem></varlistentry>"
"   <varlistentry><term>z:</term>"
"      <listitem><para> the z parameter   // separated by "":"".</para></listitem></varlistentry>"
"   </variablelist>"
"</refsection>"
""
"<refsection>"
"   <title>Description</title>"
"   <para>"
"Here is a description of the function."
"Add an empty comment line to format the text into separate paragraphs."
"   </para>"
"   <para>"
"XML format commands may also be used directly in the text,"
"as in the following examples."
"   </para>"
"   <para>"
"This is an example of a itemized list:"
"<itemizedlist>"
"<listitem><para>An itemized list is shown here</para></listitem>"
"</itemizedlist>"
"The help text for help_from_sci was generated from the head comments section of help_from_sci.sci"
"Compare the output from head_comments(""help_from_sci"") and help(""help_from_sci"")"
"to see more examples on how to write the head comments section."
"   </para>"
"   <para>"
"This is an example of the programlisting tag:"
"<programlisting>z = test_fun(x, y)</programlisting>"
"   </para>"
"   <para>"
"This is an example of a latex equation:"
"<latex>"
"\begin{eqnarray}"
"m = |M| \beta^{1-p},"
"\end{eqnarray}"
"</latex>"
"   </para>"
"   <para>"
"</para>"
"</refsection>"
""
"<refsection>"
"   <title>Examples</title>"
"   <programlisting role=""example""><![CDATA["
"[z] = test_fun(1, 2) // examples of use"
""
"// An empty comment line in the Examples section will add a halt() statement"
"// in the demo file test_fun.dem.sce generated by help_from_sci."
""
"   ]]></programlisting>"
"</refsection>"
""
"<refsection>"
"   <title>See also</title>"
"   <simplelist type=""inline"">"
"   <member><link linkend=""help_from_sci"">help_from_sci</link></member>"
"   <member><link linkend=""help_skeleton"">help_skeleton</link></member>"
"   </simplelist>"
"</refsection>"
""
"<refsection>"
"   <title>Authors</title>"
"   <simplelist type=""vert"">"
"   <member>Author name </member><listitem><para> should be listed one pr line. Use "";"" to separate names from additional information</para></listitem>"
"   </simplelist>"
"</refsection>"
""
"<refsection>"
"   <title>Bibliography</title>"
"   <para>Literature references one pr. line</para>"
"</refsection>"
"</refentry>" ];

assert_checkequal(demotxt, refDemotxt);
assert_checkequal(helptxt, refHelptxt);
