// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL
// Copyright (C) 2010 - DIGITEO - Allan CORNET
// Copyright (C) 2016 - Scilab Enterprises - Paul Bignier
//
// This file is released under the 3-clause BSD license. See COPYING-BSD.

prot = funcprot();
funcprot(0);

function demo_colormap()

    // Parameters
    // =========================================================================

    frame_w              = 200;     // Frame width
    frame_h              = 330;     // Frame height

    plot_w               = 600;     // Plot width
    plot_h               = 550;     // Plot height

    margin_x             = 15;      // Horizontal margin between each elements
    margin_y             = 15;      // Vertical margin between each elements

    defaultfont          = "arial"; // Default Font
    text_font_size       = 12;      // Text font size

    // Figure creation
    // =========================================================================

    axes_w       = 3*margin_x + frame_w + plot_w;    // axes width
    axes_h       = 2*margin_y + max(frame_h,plot_h); // axes height

    fig_handle = figure( ...
    "infobar_visible", "off", ...
    "toolbar_visible", "off", ...
    "toolbar", "none", ...
    "default_axes", "on", ...
    "layout", "gridbag", ...
    "visible", "off", ...
    "background", -2, ...
    "figure_position", [0 0], ...
    "axes_size", [axes_w axes_h], ...
    "figure_name", "Colormap");

    c = createConstraints("gridbag", [2 1 1 1], [1 1], "vertical", "right");
    // Create an empty panel on the right to occupy the 3/4 of the screen (figure plot)
    empty_frame = uicontrol(fig_handle, "style", "frame","constraints", c);

    c = createConstraints("gridbag", [1 1 1 5], [0.05 1], "both", "left", [0 0], [150 0]);
    u = uicontrol(fig_handle, ...
    "style", "frame", ...
    "backgroundcolor", [1 1 1], ...
    "layout", "border", ...
    "constraints", c);

    // Add top and bottom empty panels to pad the upcoming colormap panel
    c = createConstraints("border", "top", [0 80]);
    top = uicontrol(u, "style", "frame", "backgroundcolor", [1 1 1], "constraints", c);
    c = createConstraints("border", "bottom", [0 80]);
    bottom = uicontrol(u, "style", "frame", "backgroundcolor", [1 1 1], "constraints", c);

    // Border for the colormap frame
    b_f_colormap = createBorderFont("", 18);
    b_l_colormap = createBorder("line", "navy", 2);
    b_colormap   = createBorder("titled", b_l_colormap, "Colormap", "center", "top", b_f_colormap, "navy");

    colormap_frame = uicontrol(u, ...
    "style", "frame", ...
    "backgroundcolor", [1 1 1], ...
    "border", b_colormap, ...
    "layout", "gridbag", ...
    "tag", "colormap_frame");

    demo_viewCode("colormap.dem.sce");

    fig_handle.color_map = jetcolormap(128);

    // Radio buttons
    // =========================================================================

    // Radio buttons : Jet

    c = createConstraints("gridbag", [1 1 1 1], [1 1], "both", "upper");
    square_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Jet", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 1, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "jetcolormap_radio");

    // Radio buttons : Parula

    c = createConstraints("gridbag", [1 2 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Parula", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "parulacolormap_radio");

    // Radio buttons : HSV

    c = createConstraints("gridbag", [1 3 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "HSV", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "HSVcolormap_radio");

    // Radio buttons : Hot

    c = createConstraints("gridbag", [1 4 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Hot", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "hotcolormap_radio");

    // Radio buttons : Gray

    c = createConstraints("gridbag", [1 5 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Gray", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "graycolormap_radio");

    // Radio buttons : Winter

    c = createConstraints("gridbag", [1 6 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Winter", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "wintercolormap_radio");

    // Radio buttons : Spring

    c = createConstraints("gridbag", [1 7 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Spring", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "springcolormap_radio");

    // Radio buttons : Summer

    c = createConstraints("gridbag", [1 8 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Summer", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "summercolormap_radio");

    // Radio buttons : Autumn

    c = createConstraints("gridbag", [1 9 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Autumn", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "autumncolormap_radio");

    // Radio buttons : Bone

    c = createConstraints("gridbag", [1 10 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Bone", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "bonecolormap_radio");

    // Radio buttons : Copper

    c = createConstraints("gridbag", [1 11 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Copper", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "coppercolormap_radio");

    // Radio buttons : Pink

    c = createConstraints("gridbag", [1 12 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Pink", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "pinkcolormap_radio");

    // Radio buttons : Rainbow

    c = createConstraints("gridbag", [1 13 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Rainbow", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "rainbowcolormap_radio");

    // Radio buttons : Ocean

    c = createConstraints("gridbag", [1 14 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "Ocean", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "oceancolormap_radio");

    // Radio buttons : White

    c = createConstraints("gridbag", [1 15 1 1], [1 1], "both", "upper");
    disk_radio = uicontrol( ...
    "parent"             , colormap_frame, ...
    "style"              , "radiobutton", ...
    "string"             , "White", ...
    "fontname"           , defaultfont, ...
    "fontunits"          , "points", ...
    "fontsize"           , text_font_size, ...
    "value"              , 0, ...
    "background"         , [1 1 1], ...
    "callback"           , "demo_update_colormap", ...
    "constraints"        , c, ...
    "tag"                , "whitecolormap_radio");

    // Plot3d creation
    // =========================================================================

    my_plot_axes = gca();

    my_plot_axes.x_label.text       = "";
    my_plot_axes.y_label.text       = "";
    my_plot_axes.z_label.text       = "";
    my_plot_axes.title.text         = "";
    my_plot_axes.title.font_size    = 5;
    my_plot_axes.rotation_angles(1) = 80;
    my_plot_axes.axes_bounds        = [ ((2*margin_x+frame_w)/axes_w)  0  1-((2*margin_x+frame_w)/axes_w)  1];

    // define colormap
    colormapSize = 128;
    f = gcf();
    f.color_map = jetcolormap(128);

    // generate facet coordinates
    x = %pi * [-1:0.05:1]';z = sin(x)*cos(x)';
    [x,y,z] = genfac3d(x,x,z);

    // generate colors
    // colors depending on z, between 1 and colormap size
    facetsColors = (z + 1) * (colormapSize - 1) / 2 + 1;

    // plot
    plot3d(x,y,list(z, facetsColors));

    // Colorbar
    z_min = min(z);
    z_max = max(z);
    colorbar(z_min,z_max);

    // Background
    my_plot_axes.background = color(240,240,240);

    my_plot3d = gce();

    my_plot_axes.rotation_angles(1) = 80;

    fig_handle.visible = "on";

endfunction


function demo_update_colormap()

    my_figure    = gcf();
    my_plot_axes = gca();

    my_figure.immediate_drawing = "off";

    set(findobj("tag", "jetcolormap_radio")     , "value", 0);
    set(findobj("tag", "parulacolormap_radio")  , "value", 0);
    set(findobj("tag", "hotcolormap_radio")     , "value", 0);
    set(findobj("tag", "graycolormap_radio")    , "value", 0);
    set(findobj("tag", "wintercolormap_radio")  , "value", 0);
    set(findobj("tag", "springcolormap_radio")  , "value", 0);
    set(findobj("tag", "summercolormap_radio")  , "value", 0);
    set(findobj("tag", "autumncolormap_radio")  , "value", 0);
    set(findobj("tag", "bonecolormap_radio")    , "value", 0);
    set(findobj("tag", "coppercolormap_radio")  , "value", 0);
    set(findobj("tag", "pinkcolormap_radio")    , "value", 0);
    set(findobj("tag", "HSVcolormap_radio")     , "value", 0);
    set(findobj("tag", "rainbowcolormap_radio") , "value", 0);
    set(findobj("tag", "oceancolormap_radio")   , "value", 0);
    set(findobj("tag", "whitecolormap_radio")   , "value", 0);

    set(gcbo, "value", 1);

    my_wanted_colormap = get(gcbo,"tag");

    if get(gcbo, "tag") == "jetcolormap_radio" then
        my_figure.color_map = jetcolormap(128);
    elseif get(gcbo, "tag") == "parulacolormap_radio" then
        my_figure.color_map = parulacolormap(128);
    elseif get(gcbo, "tag") == "hotcolormap_radio" then
        my_figure.color_map = hotcolormap(128);
    elseif get(gcbo, "tag") == "graycolormap_radio" then
        my_figure.color_map = graycolormap(128);
    elseif get(gcbo, "tag") == "wintercolormap_radio" then
        my_figure.color_map = wintercolormap(128);
    elseif get(gcbo, "tag") == "springcolormap_radio" then
        my_figure.color_map = springcolormap(128);
    elseif get(gcbo, "tag") == "summercolormap_radio" then
        my_figure.color_map = summercolormap(128);
    elseif get(gcbo, "tag") == "autumncolormap_radio" then
        my_figure.color_map = autumncolormap(128);
    elseif get(gcbo, "tag") == "bonecolormap_radio" then
        my_figure.color_map = bonecolormap(128);
    elseif get(gcbo, "tag") == "coppercolormap_radio" then
        my_figure.color_map = coppercolormap(128);
    elseif get(gcbo, "tag") == "pinkcolormap_radio" then
        my_figure.color_map = pinkcolormap(128);
    elseif get(gcbo, "tag") == "HSVcolormap_radio" then
        my_figure.color_map = hsvcolormap(128);
    elseif get(gcbo, "tag") == "rainbowcolormap_radio" then
        my_figure.color_map = rainbowcolormap(128);
    elseif get(gcbo, "tag") == "oceancolormap_radio" then
        my_figure.color_map = oceancolormap(128);
    elseif get(gcbo, "tag") == "whitecolormap_radio" then
        my_figure.color_map = whitecolormap(128);
    end

    // Background
    my_plot_axes.background = color(240,240,240);

    my_figure.immediate_drawing = "on";

endfunction

funcprot(prot);

demo_colormap();
clear demo_colormap;
