// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009 - DIGITEO - Vincent COUVERT
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
// Copyright (C) 2012 - DIGITEO - Allan CORNET
// Copyright (C) 2014 - Scilab Enterprises - Antoine ELIAS
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

function atomsGui()
    creation = %f;
    if creation then
        figwidth = 900;
        figheight = 600;
        defaultFontSize = 12;

        f = figure( ...
        "dockable", "off" , ...
        "infobar_visible", "off", ...
        "toolbar_visible", "off", ...
        "toolbar", "none", ...
        "menubar_visible", "on", ...
        "menubar", "none", ...
        "default_axes", "off", ...
        "tag", "atomsFigure", ...
        "visible", "off", ...
        "icon", "software-update-notinstalled", ...
        "position", [0 0 figwidth figheight], ...
        "layout", "border");

        h = uimenu( ...
        "parent", f, ...
        "tag", "home");

        // Menu File:Installed Modules
        uimenu( ...
        "parent", h, ...
        "callback", "cbAtomsGui", ...
        "tag", "homeMenu");

        // Menu File:Update List of Packages
        uimenu( ...
        "parent", h, ...
        "callback", "xinfo(_(''Updating the list of packages. Please wait... until Done.''));" + ...
        "atomsSystemUpdate();" + ...
        "xinfo(_(''Update done.''));" , ...
        "tag", "updatePackages");

        // Menu File:Close
        uimenu( ...
        "parent", h, ...
        "callback", "cbAtomsGui", ...
        "tag", "closeMenu");

        // Menu ?
        h = uimenu( ...
        "parent", f, ...
        "tag", "help");

        // Menu ?:Atoms Help...
        uimenu( ...
        "parent", h, ...
        "callback", "cbAtomsGui", ...
        "tag", "helpMenu");

        MainFrame = uicontrol(f, ...
        "Style", "frame", ...
        "background", [1 1 1], ...
        "Tag", "MainFrame");
        MainFrame.layout_options = createLayoutOptions("border", [5, 5]);
        MainFrame.layout = "border";

        //Left frame + listbox
        LeftFrame = uicontrol(MainFrame, ...
        "Style", "frame", ...
        "background", [1 1 1], ...
        "border", createBorder("titled", createBorder("line", "black", 1), ""), ...
        "constraints", createConstraints("border", "left", [300 0]), ...
        "Tag", "LeftFrame");
        LeftFrame.layout = "border";


        LeftListbox = uicontrol(LeftFrame, ...
        "Style" , "listbox", ...
        "FontSize", defaultFontSize, ...
        "String", "", ...
        "Callback", "cbAtomsGui", ...
        "Tag", "LeftListbox");

        //layer right frame
        LayerFrame = uicontrol(MainFrame, ...
        "style", "layer", ...
        "constraints", createConstraints("border", "center"), ...
        "tag", "LayerFrame");

        //1st layer, description module
        DescFrame = uicontrol(LayerFrame, ...
        "style", "frame", ...
        "background", [1 1 1], ...
        "border", createBorder("titled", createBorder("line", "black", 1), "", "", "", createBorderFont("", 14, "normal")), ...
        "layout", "border", ...
        "tag", "DescFrame");

        Desc = uicontrol(DescFrame, ...
        "Style", "text", ...
        "background", [1 1 1], ...
        "FontSize", defaultFontSize, ...
        "string", [""], ...
        "min", 0, ...
        "max", 2, ...
        "Tag", "Desc");

        ButtonFrame = uicontrol(DescFrame, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("border", "bottom"));
        ButtonFrame.layout_options = createLayoutOptions("grid", [1 4], [20, 0]);
        ButtonFrame.layout = "grid";

        backButton = uicontrol(ButtonFrame, ...
        "Style" , "pushbutton", ...
        "Callback", "cbAtomsGui", ...
        "Enable", "on", ...
        "Tag", "backButton");

        removeButton = uicontrol(ButtonFrame, ...
        "Style" , "pushbutton", ...
        "Callback", "cbAtomsGui", ...
        "Enable", "off", ...
        "Tag", "removeButton");

        installButton = uicontrol(ButtonFrame, ...
        "Style" , "pushbutton", ...
        "Callback", "cbAtomsGui", ...
        "Enable", "off", ...
        "Tag", "installButton");

        autoloadCheck = uicontrol(ButtonFrame, ...
        "Style" , "checkbox", ...
        "background", [1 1 1], ...
        "Callback", "cbAtomsGui", ...
        "Enable", "on", ...
        "Tag", "autoloadCheck");

        //2nd layer, installed modules
        HomeFrame = uicontrol(LayerFrame, ...
        "style", "frame", ...
        "background", [1 1 1], ...
        "border", createBorder("titled", createBorder("line", "black", 1), ""), ...
        "layout", "border", ...
        "tag", "HomeFrame");

        HomeListbox = uicontrol(HomeFrame,..
        "Style", "listbox",..
        "Background", [1 1 1],..
        "FontSize", defaultFontSize,..
        "Callback", "cbAtomsGui", ..
        "Tag", "HomeListbox");

        //message frame
        msgFrame = uicontrol(MainFrame, ...
        "style", "frame", ...
        "Background", [1 1 1], ...
        "layout", "border", ...
        "border", createBorder("titled", createBorder("line", "black", 1), ""), ...
        "constraints", createConstraints("border", "bottom", [0, 40]), ...
        "margins", [5 5 5 5], ...
        "tag", "msgFrame");

        msgText = uicontrol(msgFrame, ...
        "Style", "text", ...
        "HorizontalAlignment", "center", ...
        "VerticalAlignment", "middle", ...
        "FontSize", defaultFontSize, ...
        "Background", [1 1 1], ...
        "Tag", "msgText");

        saveGui(f, SCI + "/modules/atoms/gui/atomsGui.xml");
        delete(f);
    end //creation

    if ~isempty(get("atomsFigure")) then
        // Get focus on the GUI
        fig = get("atomsFigure");
        fig.visible = "on";
        return;
    end

    if ~ exists("atomsinternalslib") then
        load("SCI/modules/atoms/macros/atoms_internals/lib");
    end

    // Test connection
    allModules = [];
    errStatus  = execstr("allModules = atomsDESCRIPTIONget();", "errcatch");

    if errStatus<>0 | size(allModules, "*") == 0 then
        if size(atomsRepositoryList(),"*") > 0 then
            messagebox(gettext("No ATOMS module is available. Please, check your Internet connection or make sure that your OS is compatible with ATOMS."), gettext("ATOMS error"), "error");
        else
            messagebox(gettext("No ATOMS module is available: your repository list is empty."), gettext("ATOMS error"), "error");
        end
        return
    end

    atomsfig = loadGui(SCI + "/modules/atoms/gui/atomsGui.xml");
    set("atomsFigure", "userdata", allModules);

    // Build the module list (listbox on the left)
    LeftElements = atomsGetLeftListboxElts("filter:main");

    //localized title/menu

    //menu
    set("home", "label", _("File"));
    set("homeMenu", "label", _("Installed modules"));
    set("updatePackages", "label", _("Update List of Packages"));
    set("closeMenu", "label", _("Close"));
    set("help", "label", _("?"));
    set("helpMenu", "label", _("Atoms Help..."));

    set("LeftFrame", "UserData", "filter:main");

    set("atomsFigure", "figure_name", LeftElements("title")+" - ATOMS");

    set("LeftListbox", "string", LeftElements("items_str"));
    set("LeftListbox", "userdata", LeftElements("items_mat"));

    set("backButton", "String", _("Back"));
    set("removeButton", "String", _("Remove"));
    set("installButton", "String", _("Install"));
    set("autoloadCheck", "String", _("Autoload"), "TooltipString", _("Autoload"));


    homeFrame = get("HomeFrame");
    homFrame.border.title = _("List of installed modules");

    // Build the installed module list
    HomeElements = atomsGetHomeListboxElts();

    //Update Installed Toolbox Listbox
    set("HomeListbox", "String", HomeElements("items_str"));
    set("HomeListbox", "UserData", HomeElements("items_mat"));
    set("atomsFigure", "visible", "on");
    set("atomsFigure", "resizefcn", "atomsResize");

    atomsResize();
endfunction

