#include "CallGraphicController.hxx"
/* Generated by GIWS (version 2.0.1) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/graphic_objects.giws.xml 
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_graphic_objects {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * CallGraphicController::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

CallGraphicController::~CallGraphicController() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
CallGraphicController::CallGraphicController(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voiddeleteGraphicObjectjstringjava_lang_StringID=NULL;
jstringcloneGraphicObjectjstringjava_lang_StringID=NULL;
jstringaskGraphicObjectjintintID=NULL;
voidsetGraphicObjectRelationshipjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidremoveRelationShipAndDeletejstringjava_lang_StringID=NULL;
jstringgetGraphicObjectPropertyAsStringjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_Stringjintintjstringjava_lang_StringID=NULL;
jobjectArray_getGraphicObjectPropertyAsStringVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jdoublegetGraphicObjectPropertyAsDoublejstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubledoubleID=NULL;
jdoubleArray_getGraphicObjectPropertyAsDoubleVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubleArray_doubledoubleID=NULL;
jintgetGraphicObjectPropertyAsIntegerjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintintID=NULL;
jintArray_getGraphicObjectPropertyAsIntegerVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintArray_intintID=NULL;
jintgetGraphicObjectPropertyAsBooleanjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
jintArray_getGraphicObjectPropertyAsBooleanVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanArray_booleanbooleanID=NULL;
voidregisterScilabViewID=NULL;
voidunregisterScilabViewID=NULL;
jstringgetConsoleIdentifierID=NULL;
voidbuildFigureMenuBarjstringjava_lang_StringID=NULL;


}

CallGraphicController::CallGraphicController(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voiddeleteGraphicObjectjstringjava_lang_StringID=NULL;
jstringcloneGraphicObjectjstringjava_lang_StringID=NULL;
jstringaskGraphicObjectjintintID=NULL;
voidsetGraphicObjectRelationshipjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidremoveRelationShipAndDeletejstringjava_lang_StringID=NULL;
jstringgetGraphicObjectPropertyAsStringjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_Stringjintintjstringjava_lang_StringID=NULL;
jobjectArray_getGraphicObjectPropertyAsStringVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jdoublegetGraphicObjectPropertyAsDoublejstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubledoubleID=NULL;
jdoubleArray_getGraphicObjectPropertyAsDoubleVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubleArray_doubledoubleID=NULL;
jintgetGraphicObjectPropertyAsIntegerjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintintID=NULL;
jintArray_getGraphicObjectPropertyAsIntegerVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintArray_intintID=NULL;
jintgetGraphicObjectPropertyAsBooleanjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
jintArray_getGraphicObjectPropertyAsBooleanVectorjstringjava_lang_StringjintintID=NULL;
jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanArray_booleanbooleanID=NULL;
voidregisterScilabViewID=NULL;
voidunregisterScilabViewID=NULL;
jstringgetConsoleIdentifierID=NULL;
voidbuildFigureMenuBarjstringjava_lang_StringID=NULL;


}

// Generic methods

void CallGraphicController::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallGraphicController");
}
}

void CallGraphicController::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallGraphicController");
}
}
// Method(s)

void CallGraphicController::deleteGraphicObject (JavaVM * jvm_, char const* id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddeleteGraphicObjectjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "deleteGraphicObject", "(Ljava/lang/String;)V" ) ;
if (voiddeleteGraphicObjectjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "deleteGraphicObject");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voiddeleteGraphicObjectjstringjava_lang_StringID ,id_);
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallGraphicController::cloneGraphicObject (JavaVM * jvm_, char const* id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringcloneGraphicObjectjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "cloneGraphicObject", "(Ljava/lang/String;)Ljava/lang/String;" ) ;
if (jstringcloneGraphicObjectjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "cloneGraphicObject");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringcloneGraphicObjectjstringjava_lang_StringID ,id_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

char* CallGraphicController::askGraphicObject (JavaVM * jvm_, int typeName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringaskGraphicObjectjintintID = curEnv->GetStaticMethodID(cls, "askGraphicObject", "(I)Ljava/lang/String;" ) ;
if (jstringaskGraphicObjectjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "askGraphicObject");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringaskGraphicObjectjintintID ,typeName));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

void CallGraphicController::setGraphicObjectRelationship (JavaVM * jvm_, char const* parentId, char const* childId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetGraphicObjectRelationshipjstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setGraphicObjectRelationship", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidsetGraphicObjectRelationshipjstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectRelationship");
}

jstring parentId_ = curEnv->NewStringUTF( parentId );
if (parentId != NULL && parentId_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring childId_ = curEnv->NewStringUTF( childId );
if (childId != NULL && childId_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetGraphicObjectRelationshipjstringjava_lang_Stringjstringjava_lang_StringID ,parentId_, childId_);
                        curEnv->DeleteLocalRef(parentId_);
curEnv->DeleteLocalRef(childId_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallGraphicController::removeRelationShipAndDelete (JavaVM * jvm_, char const* id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveRelationShipAndDeletejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "removeRelationShipAndDelete", "(Ljava/lang/String;)V" ) ;
if (voidremoveRelationShipAndDeletejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeRelationShipAndDelete");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidremoveRelationShipAndDeletejstringjava_lang_StringID ,id_);
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallGraphicController::getGraphicObjectPropertyAsString (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetGraphicObjectPropertyAsStringjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsString", "(Ljava/lang/String;I)Ljava/lang/String;" ) ;
if (jstringgetGraphicObjectPropertyAsStringjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsString");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetGraphicObjectPropertyAsStringjstringjava_lang_StringjintintID ,id_, propertyName));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, char const* value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_Stringjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;ILjava/lang/String;)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_Stringjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring value_ = curEnv->NewStringUTF( value );
if (value != NULL && value_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_Stringjintintjstringjava_lang_StringID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

char** CallGraphicController::getGraphicObjectPropertyAsStringVector (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArray_getGraphicObjectPropertyAsStringVectorjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsStringVector", "(Ljava/lang/String;I)[Ljava/lang/String;" ) ;
if (jobjectArray_getGraphicObjectPropertyAsStringVectorjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsStringVector");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getGraphicObjectPropertyAsStringVectorjstringjava_lang_StringjintintID ,id_, propertyName));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { int lenRow;
 lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[lenRow];
for (jsize i = 0; i < lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, char const* const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;I[Ljava/lang/String;)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray value_ = curEnv->NewObjectArray( valueSize, stringArrayClass, NULL);
if (value_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valueSize; i++)
{
jstring TempString = curEnv->NewStringUTF( value[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( value_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

double CallGraphicController::getGraphicObjectPropertyAsDouble (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetGraphicObjectPropertyAsDoublejstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsDouble", "(Ljava/lang/String;I)D" ) ;
if (jdoublegetGraphicObjectPropertyAsDoublejstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsDouble");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublegetGraphicObjectPropertyAsDoublejstringjava_lang_StringjintintID ,id_, propertyName));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, double value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubledoubleID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;ID)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubledoubleID ,id_, propertyName, value));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

double* CallGraphicController::getGraphicObjectPropertyAsDoubleVector (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoubleArray_getGraphicObjectPropertyAsDoubleVectorjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsDoubleVector", "(Ljava/lang/String;I)[D" ) ;
if (jdoubleArray_getGraphicObjectPropertyAsDoubleVectorjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsDoubleVector");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jdoubleArray res =  static_cast<jdoubleArray>( curEnv->CallStaticObjectMethod(cls, jdoubleArray_getGraphicObjectPropertyAsDoubleVectorjstringjava_lang_StringjintintID ,id_, propertyName));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jdouble *resultsArray = static_cast<jdouble *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
double* myArray= new double[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, double const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;I[D)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jdoubleArray value_ = curEnv->NewDoubleArray( valueSize ) ;

if (value_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( value_, 0, valueSize, (jdouble*)(value) ) ;


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjdoubleArray_doubledoubleID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int CallGraphicController::getGraphicObjectPropertyAsInteger (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetGraphicObjectPropertyAsIntegerjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsInteger", "(Ljava/lang/String;I)I" ) ;
if (jintgetGraphicObjectPropertyAsIntegerjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsInteger");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetGraphicObjectPropertyAsIntegerjstringjava_lang_StringjintintID ,id_, propertyName));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintintID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;II)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintintID ,id_, propertyName, value));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int* CallGraphicController::getGraphicObjectPropertyAsIntegerVector (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getGraphicObjectPropertyAsIntegerVectorjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsIntegerVector", "(Ljava/lang/String;I)[I" ) ;
if (jintArray_getGraphicObjectPropertyAsIntegerVectorjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsIntegerVector");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getGraphicObjectPropertyAsIntegerVectorjstringjava_lang_StringjintintID ,id_, propertyName));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, int const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;I[I)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jintArray value_ = curEnv->NewIntArray( valueSize ) ;

if (value_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( value_, 0, valueSize, (jint*)(value) ) ;


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjintArray_intintID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int CallGraphicController::getGraphicObjectPropertyAsBoolean (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetGraphicObjectPropertyAsBooleanjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsBoolean", "(Ljava/lang/String;I)I" ) ;
if (jintgetGraphicObjectPropertyAsBooleanjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsBoolean");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetGraphicObjectPropertyAsBooleanjstringjava_lang_StringjintintID ,id_, propertyName));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, bool value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;IZ)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean value_ = (static_cast<bool>(value) ? JNI_TRUE : JNI_FALSE);

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanbooleanID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int* CallGraphicController::getGraphicObjectPropertyAsBooleanVector (JavaVM * jvm_, char const* id, int propertyName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getGraphicObjectPropertyAsBooleanVectorjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "getGraphicObjectPropertyAsBooleanVector", "(Ljava/lang/String;I)[I" ) ;
if (jintArray_getGraphicObjectPropertyAsBooleanVectorjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getGraphicObjectPropertyAsBooleanVector");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getGraphicObjectPropertyAsBooleanVectorjstringjava_lang_StringjintintID ,id_, propertyName));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

bool CallGraphicController::setGraphicObjectProperty (JavaVM * jvm_, char const* id, int propertyName, bool const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanArray_booleanbooleanID = curEnv->GetStaticMethodID(cls, "setGraphicObjectProperty", "(Ljava/lang/String;I[Z)Z" ) ;
if (jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanArray_booleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setGraphicObjectProperty");
}

jstring id_ = curEnv->NewStringUTF( id );
if (id != NULL && id_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jbooleanArray value_ = curEnv->NewBooleanArray( valueSize ) ;
curEnv->SetBooleanArrayRegion( value_, 0, valueSize, (jboolean*)value ) ;

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleansetGraphicObjectPropertyjstringjava_lang_StringjintintjbooleanArray_booleanbooleanID ,id_, propertyName, value_));
                        curEnv->DeleteLocalRef(id_);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallGraphicController::registerScilabView (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidregisterScilabViewID = curEnv->GetStaticMethodID(cls, "registerScilabView", "()V" ) ;
if (voidregisterScilabViewID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "registerScilabView");
}

                         curEnv->CallStaticVoidMethod(cls, voidregisterScilabViewID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallGraphicController::unregisterScilabView (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidunregisterScilabViewID = curEnv->GetStaticMethodID(cls, "unregisterScilabView", "()V" ) ;
if (voidunregisterScilabViewID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "unregisterScilabView");
}

                         curEnv->CallStaticVoidMethod(cls, voidunregisterScilabViewID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallGraphicController::getConsoleIdentifier (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetConsoleIdentifierID = curEnv->GetStaticMethodID(cls, "getConsoleIdentifier", "()Ljava/lang/String;" ) ;
if (jstringgetConsoleIdentifierID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getConsoleIdentifier");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetConsoleIdentifierID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

void CallGraphicController::buildFigureMenuBar (JavaVM * jvm_, char const* figureId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidbuildFigureMenuBarjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "buildFigureMenuBar", "(Ljava/lang/String;)V" ) ;
if (voidbuildFigureMenuBarjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "buildFigureMenuBar");
}

jstring figureId_ = curEnv->NewStringUTF( figureId );
if (figureId != NULL && figureId_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidbuildFigureMenuBarjstringjava_lang_StringID ,figureId_);
                        curEnv->DeleteLocalRef(figureId_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
