/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2011-2011 - DIGITEO - Bruno JOFRET
 *
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

%module ScilabNativeView

%pragma(java) jniclasscode=%{
  static {
    try {
        System.loadLibrary("scigraphic_objects");
    } catch (UnsatisfiedLinkError e) {
      System.err.println("Native library failed to load. \n" + e);
      System.exit(1);
    }
  }
%}

%inline %{
    extern void ScilabNativeView__createObject(char* pstId);
    extern void ScilabNativeView__deleteObject(char* pstId);
    extern void ScilabNativeView__updateObject(char* pstId, int iProperty);
    extern void ScilabNativeView__setCurrentFigure(char* pstId);
    extern void ScilabNativeView__setCurrentSubWin(char* pstId);
    extern void ScilabNativeView__setCurrentObject(char* pstId);
    extern int ScilabNativeView__getValidDefaultFigureId();
    %}
