/* The following code was generated by JFlex 1.4.3 on 23/05/12 15:23 */

//CHECKSTYLE:OFF

package org.scilab.modules.scinotes;

import java.io.IOException;
import javax.swing.text.Element;
import javax.swing.text.BadLocationException;

@javax.annotation.Generated("JFlex")
@SuppressWarnings("fallthrough")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 23/05/12 15:23 from the specification file
 * <tt>./jflex/indentation.jflex</tt>
 */
public final class IndentScanner {

    /** This character denotes the end of file */
    public static final int YYEOF = -1;

    /** initial size of the lookahead buffer */
    private static final int ZZ_BUFFERSIZE = 16384;

    /** lexical states */
    public static final int BEG = 8;
    public static final int TAB = 6;
    public static final int WHITE = 4;
    public static final int YYINITIAL = 0;
    public static final int INDENT = 2;

    /**
     * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
     * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
     *                  at the beginning of a line
     * l is of the form l = 2*k, k a non negative integer
     */
    private static final int ZZ_LEXSTATE[] = {
        0,  0,  1,  1,  2,  2,  3,  3,  4, 5
    };

    /**
     * Translates characters to character classes
     */
    private static final String ZZ_CMAP_PACKED =
        "\11\0\1\31\1\1\2\0\1\4\22\0\1\30\1\3\1\6\3\3" +
        "\1\0\1\5\1\0\1\7\5\0\1\2\12\3\5\0\1\3\1\0" +
        "\32\3\2\0\1\7\1\0\1\3\1\0\1\27\1\3\1\13\1\26" +
        "\1\23\1\10\1\3\1\21\1\15\2\3\1\22\1\3\1\12\1\16" +
        "\2\3\1\17\1\25\1\14\1\11\1\3\1\20\1\3\1\24\1\3" +
        "\2\0\1\7\uff82\0";

    /**
     * Translates characters to character classes
     */
    private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

    /**
     * Translates DFA states to action switch labels.
     */
    private static final int [] ZZ_ACTION = zzUnpackAction();

    private static final String ZZ_ACTION_PACKED_0 =
        "\2\0\2\1\2\0\1\2\1\3\13\2\2\1\1\4" +
        "\11\0\1\2\4\0\1\4\17\0\1\2\1\0\1\5" +
        "\6\0\1\2\4\0\1\6\1\0\1\2\1\6\4\0" +
        "\1\2\2\0\2\2\4\0\1\2\2\0\1\2\1\0" +
        "\3\2\1\5";

    private static int [] zzUnpackAction() {
        int [] result = new int[92];
        int offset = 0;
        offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int [] result) {
        int i = 0;       /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do result[j++] = value;
            while (--count > 0);
        }
        return j;
    }


    /* error codes */
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;

    /* error messages for the codes above */
    private static final String ZZ_ERROR_MSG[] = {
        "Unkown internal scanner error",
        "Error: could not match input",
        "Error: pushback value was too large"
    };

    /** the input device */
    private java.io.Reader zzReader;

    /** the current state of the DFA */
    private int zzState;

    /** the current lexical state */
    private int zzLexicalState = YYINITIAL;

    /** this buffer contains the current text to be matched and is
        the source of the yytext() string */
    private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

    /** the textposition at the last accepting state */
    private int zzMarkedPos;

    /** the current text position in the buffer */
    private int zzCurrentPos;

    /** startRead marks the beginning of the yytext() string in the buffer */
    private int zzStartRead;

    /** endRead marks the last character in the buffer, that has been read
        from input */
    private int zzEndRead;

    /** number of newlines encountered up to the start of the matched text */
    private int yyline;

    /** the number of characters up to the start of the matched text */
    private int yychar;

    /**
     * the number of characters from the last newline up to the start of the
     * matched text
     */
    private int yycolumn;

    /**
     * zzAtBOL == true <=> the scanner is currently at the beginning of a line
     */
    private boolean zzAtBOL = true;

    /** zzAtEOF == true <=> the scanner is at the EOF */
    private boolean zzAtEOF;

    /** denotes if the user-EOF-code has already been executed */
    private boolean zzEOFDone;

    /* user code: */
    private ScilabDocument doc;
    private Element elem;

    public IndentScanner(ScilabDocument doc) {
        this.doc = doc;
        this.elem = doc.getDefaultRootElement();
    }

    public int getIndentNumber(int lineNumber, char type) {
        if (lineNumber < 0) {
            return 0;
        }
        try {
            Element line = elem.getElement(lineNumber);
            int startL = line.getStartOffset();
            int endL = line.getEndOffset();
            yyreset(new ScilabDocumentReader(doc, startL, endL));
            switch (type) {
                case ' ':
                    yybegin(WHITE);
                    break;
                case '\t':
                    yybegin(TAB);
                    break;
                default:
                    yybegin(WHITE);
            }
            return yylex();
        } catch (IOException e) {
            return 0;
        }
    }

    public int getTabsAtBeginning(int pos) {
        Element line = elem.getElement(pos);
        int startL = line.getStartOffset();
        int endL = line.getEndOffset();
        try {
            yyreset(new ScilabDocumentReader(doc, startL, endL));
            yybegin(BEG);
            if (yylex() == 1) {
                return yylength();
            }
        } catch (IOException e) {
            return 0;
        }
        return 0;
    }

    public void getIndentLevel(int pos, int[] level) {
        Element line = elem.getElement(elem.getElementIndex(pos));
        int startL = line.getStartOffset();
        int endL = line.getEndOffset();
        level[0] = 0;
        level[1] = 0;
        try {
            yyreset(new ScilabDocumentReader(doc, startL, endL));
            yybegin(INDENT);
            do {
                switch (yylex()) {
                    case 0:
                        break;
                    case 1:
                        level[1]++;
                        break;
                    case 2:
                        if (level[1] > 0) {
                            level[1]--;
                        } else {
                            level[0]++;
                        }
                        break;
                    case 3:
                        if (level[1] == 0) {
                            level[0]++;
                            level[1]++;
                        }
                }
            } while (zzMarkedPos != 0);
        } catch (IOException e) { }
    }


    /**
     * Creates a new scanner
     * There is also a java.io.InputStream version of this constructor.
     *
     * @param   in  the java.io.Reader to read input from.
     */
    public IndentScanner(java.io.Reader in) {
        this.zzReader = in;
    }

    /**
     * Creates a new scanner.
     * There is also java.io.Reader version of this constructor.
     *
     * @param   in  the java.io.Inputstream to read input from.
     */
    public IndentScanner(java.io.InputStream in) {
        this(new java.io.InputStreamReader(in));
    }

    /**
     * Unpacks the compressed character translation table.
     *
     * @param packed   the packed character translation table
     * @return         the unpacked character translation table
     */
    private static char [] zzUnpackCMap(String packed) {
        char [] map = new char[0x10000];
        int i = 0;  /* index in packed string  */
        int j = 0;  /* index in unpacked array */
        while (i < 106) {
            int  count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do map[j++] = value;
            while (--count > 0);
        }
        return map;
    }


    /**
     * Refills the input buffer.
     *
     * @return      <code>false</code>, iff there was new input.
     *
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    private boolean zzRefill() throws java.io.IOException {

        /* first: make room (if you can) */
        if (zzStartRead > 0) {
            System.arraycopy(zzBuffer, zzStartRead,
                             zzBuffer, 0,
                             zzEndRead - zzStartRead);

            /* translate stored positions */
            zzEndRead -= zzStartRead;
            zzCurrentPos -= zzStartRead;
            zzMarkedPos -= zzStartRead;
            zzStartRead = 0;
        }

        /* is the buffer big enough? */
        if (zzCurrentPos >= zzBuffer.length) {
            /* if not: blow it up */
            char newBuffer[] = new char[zzCurrentPos * 2];
            System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
            zzBuffer = newBuffer;
        }

        /* finally: fill the buffer with new input */
        int numRead = zzReader.read(zzBuffer, zzEndRead,
                                    zzBuffer.length - zzEndRead);

        if (numRead > 0) {
            zzEndRead += numRead;
            return false;
        }
        // unlikely but not impossible: read 0 characters, but not at end of stream
        if (numRead == 0) {
            int c = zzReader.read();
            if (c == -1) {
                return true;
            } else {
                zzBuffer[zzEndRead++] = (char) c;
                return false;
            }
        }

        // numRead < 0
        return true;
    }


    /**
     * Closes the input stream.
     */
    public final void yyclose() throws java.io.IOException {
        zzAtEOF = true;            /* indicate end of file */
        zzEndRead = zzStartRead;  /* invalidate buffer    */

        if (zzReader != null)
            zzReader.close();
    }


    /**
     * Resets the scanner to read from a new input stream.
     * Does not close the old reader.
     *
     * All internal variables are reset, the old input stream
     * <b>cannot</b> be reused (internal buffer is discarded and lost).
     * Lexical state is set to <tt>ZZ_INITIAL</tt>.
     *
     * @param reader   the new input stream
     */
    public final void yyreset(java.io.Reader reader) {
        zzReader = reader;
        zzAtBOL  = true;
        zzAtEOF  = false;
        zzEOFDone = false;
        zzEndRead = zzStartRead = 0;
        zzCurrentPos = zzMarkedPos = 0;
        yyline = yychar = yycolumn = 0;
        zzLexicalState = YYINITIAL;
    }


    /**
     * Returns the current lexical state.
     */
    public final int yystate() {
        return zzLexicalState;
    }


    /**
     * Enters a new lexical state
     *
     * @param newState the new lexical state
     */
    public final void yybegin(int newState) {
        zzLexicalState = newState;
    }


    /**
     * Returns the text matched by the current regular expression.
     */
    public final String yytext() {
        return new String( zzBuffer, zzStartRead, zzMarkedPos - zzStartRead );
    }


    /**
     * Returns the character at position <tt>pos</tt> from the
     * matched text.
     *
     * It is equivalent to yytext().charAt(pos), but faster
     *
     * @param pos the position of the character to fetch.
     *            A value from 0 to yylength()-1.
     *
     * @return the character at position pos
     */
    public final char yycharat(int pos) {
        return zzBuffer[zzStartRead + pos];
    }


    /**
     * Returns the length of the matched text region.
     */
    public final int yylength() {
        return zzMarkedPos - zzStartRead;
    }


    /**
     * Reports an error that occurred while scanning.
     *
     * In a wellformed scanner (no or only correct usage of
     * yypushback(int) and a match-all fallback rule) this method
     * will only be called with things that "Can't Possibly Happen".
     * If this method is called, something is seriously wrong
     * (e.g. a JFlex bug producing a faulty scanner etc.).
     *
     * Usual syntax/scanner level error handling should be done
     * in error fallback rules.
     *
     * @param   errorCode  the code of the errormessage to display
     */
    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        } catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
        }

        throw new Error(message);
    }


    /**
     * Pushes the specified amount of characters back into the input stream.
     *
     * They will be read again by then next call of the scanning method
     *
     * @param number  the number of characters to be read again.
     *                This number must not be greater than yylength()!
     */
    public void yypushback(int number)  {
        if ( number > yylength() )
            zzScanError(ZZ_PUSHBACK_2BIG);

        zzMarkedPos -= number;
    }


    /**
     * Resumes scanning until the next regular expression is matched,
     * the end of input is encountered or an I/O-Error occurs.
     *
     * @return      the next token
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    public int yylex() throws java.io.IOException {
        int zzInput;
        int zzAction;

        // cached fields:
        int zzCurrentPosL;
        int zzMarkedPosL;
        int zzEndReadL = zzEndRead;
        char [] zzBufferL = zzBuffer;
        char [] zzCMapL = ZZ_CMAP;


        while (true) {
            zzMarkedPosL = zzMarkedPos;

            yychar += zzMarkedPosL - zzStartRead;

            if (zzMarkedPosL > zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n':
                    case '\u000B':
                    case '\u000C':
                    case '\u0085':
                    case '\u2028':
                    case '\u2029':
                        zzAtBOL = true;
                        break;
                    case '\r':
                        if (zzMarkedPosL < zzEndReadL)
                            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        else if (zzAtEOF)
                            zzAtBOL = false;
                        else {
                            boolean eof = zzRefill();
                            zzMarkedPosL = zzMarkedPos;
                            zzEndReadL = zzEndRead;
                            zzBufferL = zzBuffer;
                            if (eof)
                                zzAtBOL = false;
                            else
                                zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        }
                        break;
                    default:
                        zzAtBOL = false;
                }
            }
            zzAction = -1;

            zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

            if (zzAtBOL)
                zzState = ZZ_LEXSTATE[zzLexicalState + 1];
            else
                zzState = ZZ_LEXSTATE[zzLexicalState];


            zzForAction: {
                while (true) {

                    if (zzCurrentPosL < zzEndReadL)
                        zzInput = zzBufferL[zzCurrentPosL++];
                    else if (zzAtEOF) {
                        zzInput = YYEOF;
                        break zzForAction;
                    } else {
                        // store back cached positions
                        zzCurrentPos  = zzCurrentPosL;
                        zzMarkedPos   = zzMarkedPosL;
                        boolean eof = zzRefill();
                        // get translated positions and possibly new buffer
                        zzCurrentPosL  = zzCurrentPos;
                        zzMarkedPosL   = zzMarkedPos;
                        zzBufferL      = zzBuffer;
                        zzEndReadL     = zzEndRead;
                        if (eof) {
                            zzInput = YYEOF;
                            break zzForAction;
                        } else {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                    }
                    zzInput = zzCMapL[zzInput];

                    boolean zzIsFinal = false;
                    boolean zzNoLookAhead = false;

                    zzForNext: {
                        switch (zzState) {
                            case 1:
                                switch (zzInput) {
                                    case 0:
                                    case 4:
                                    case 24:
                                    case 25:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 1:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    case 2:
                                        zzIsFinal = true;
                                        zzState = 8;
                                        break zzForNext;
                                    case 5:
                                    case 6:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                    case 7:
                                        zzIsFinal = true;
                                        zzState = 11;
                                        break zzForNext;
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 12;
                                        break zzForNext;
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 13;
                                        break zzForNext;
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 14;
                                        break zzForNext;
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 15;
                                        break zzForNext;
                                    case 16:
                                        zzIsFinal = true;
                                        zzState = 16;
                                        break zzForNext;
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 17;
                                        break zzForNext;
                                    case 21:
                                        zzIsFinal = true;
                                        zzState = 18;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 9;
                                        break zzForNext;
                                }

                            case 2:
                                switch (zzInput) {
                                    case 24:
                                        zzIsFinal = true;
                                        zzState = 19;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                }

                            case 3:
                                switch (zzInput) {
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 20;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                }

                            case 4:
                                switch (zzInput) {
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                }

                            case 5:
                                switch (zzInput) {
                                    case 24:
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 21;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                }

                            case 8:
                                switch (zzInput) {
                                    case 2:
                                        zzState = 22;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 9:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 10:
                                switch (zzInput) {
                                    case 5:
                                    case 6:
                                        zzIsFinal = true;
                                        zzState = 31;
                                        break zzForNext;
                                    case 1:
                                    case 4:
                                        break zzForAction;
                                    default:
                                        zzState = 30;
                                        break zzForNext;
                                }

                            case 11:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 12:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 9:
                                        zzState = 32;
                                        break zzForNext;
                                    case 14:
                                        zzState = 33;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 13:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 23:
                                        zzState = 34;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 14:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 15:
                                        zzState = 35;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 15:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 16:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 17:
                                        zzState = 37;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 17:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 19:
                                        zzState = 28;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 10:
                                        zzState = 38;
                                        break zzForNext;
                                    case 18:
                                        zzState = 39;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 18:
                                switch (zzInput) {
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    case 8:
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzState = 24;
                                        break zzForNext;
                                    case 12:
                                        zzState = 25;
                                        break zzForNext;
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    case 16:
                                        zzState = 27;
                                        break zzForNext;
                                    case 21:
                                        zzState = 29;
                                        break zzForNext;
                                    case 19:
                                        zzState = 40;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 19:
                                switch (zzInput) {
                                    case 24:
                                        zzIsFinal = true;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 20:
                                switch (zzInput) {
                                    case 25:
                                        zzIsFinal = true;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 21:
                                switch (zzInput) {
                                    case 24:
                                    case 25:
                                        zzIsFinal = true;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 22:
                                switch (zzInput) {
                                    case 1:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForNext;
                                }

                            case 23:
                                switch (zzInput) {
                                    case 9:
                                        zzState = 41;
                                        break zzForNext;
                                    case 14:
                                        zzState = 42;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 24:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 43;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 25:
                                switch (zzInput) {
                                    case 15:
                                        zzState = 44;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 26:
                                switch (zzInput) {
                                    case 8:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 27:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 45;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 28:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 46;
                                        break zzForNext;
                                    case 18:
                                        zzState = 47;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 29:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 48;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 30:
                                switch (zzInput) {
                                    case 5:
                                    case 6:
                                        zzIsFinal = true;
                                        zzState = 31;
                                        break zzForNext;
                                    case 1:
                                    case 4:
                                        break zzForAction;
                                    default:
                                        break zzForNext;
                                }

                            case 31:
                                switch (zzInput) {
                                    case 5:
                                    case 6:
                                        zzState = 30;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 32:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 49;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 33:
                                switch (zzInput) {
                                    case 15:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 34:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 50;
                                        break zzForNext;
                                    case 21:
                                        zzState = 51;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 35:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 36:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 37:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 53;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 38:
                                switch (zzInput) {
                                    case 22:
                                        zzIsFinal = true;
                                        zzState = 54;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 39:
                                switch (zzInput) {
                                    case 21:
                                        zzState = 55;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 40:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 46;
                                        break zzForNext;
                                    case 18:
                                        zzState = 56;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 41:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 57;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 42:
                                switch (zzInput) {
                                    case 15:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 43:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 58;
                                        break zzForNext;
                                    case 21:
                                        zzState = 59;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 44:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 45:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 60;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 46:
                                switch (zzInput) {
                                    case 22:
                                        zzIsFinal = true;
                                        zzState = 61;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 47:
                                switch (zzInput) {
                                    case 21:
                                        zzState = 62;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 48:
                                switch (zzInput) {
                                    case 18:
                                        zzState = 63;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 49:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 64;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 50:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 65;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 51:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 66;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 52:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        break zzForNext;
                                }

                            case 53:
                                switch (zzInput) {
                                    case 18:
                                        zzState = 67;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 54:
                                switch (zzInput) {
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 68;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 55:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 69;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 56:
                                switch (zzInput) {
                                    case 21:
                                        zzState = 62;
                                        break zzForNext;
                                    case 19:
                                        zzState = 70;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 57:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 58:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 72;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 59:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 60:
                                switch (zzInput) {
                                    case 18:
                                        zzState = 59;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 61:
                                switch (zzInput) {
                                    case 8:
                                        zzState = 73;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 62:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 74;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 63:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 75;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 64:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 76;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 65:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 66;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 66:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 67:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 68:
                                switch (zzInput) {
                                    case 9:
                                        zzIsFinal = true;
                                        zzState = 77;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 69:
                                switch (zzInput) {
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 78;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 70:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 79;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 71:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 80;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 72:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 73:
                                switch (zzInput) {
                                    case 9:
                                        zzState = 41;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 74:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 26;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 75:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 81;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 76:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 82;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 77:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 83;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 78:
                                switch (zzInput) {
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 66;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 79:
                                switch (zzInput) {
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 80:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 84;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 81:
                                switch (zzInput) {
                                    case 12:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 82:
                                switch (zzInput) {
                                    case 14:
                                        zzState = 85;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 83:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 86;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 84:
                                switch (zzInput) {
                                    case 14:
                                        zzState = 87;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 85:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 86:
                                switch (zzInput) {
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 88;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 87:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 6;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 88:
                                switch (zzInput) {
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 89;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 89:
                                switch (zzInput) {
                                    case 14:
                                        zzIsFinal = true;
                                        zzState = 90;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 90:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 91;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            case 91:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 4:
                                    case 5:
                                    case 6:
                                    case 7:
                                    case 24:
                                    case 25:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                }

                            default:
                                // if this is ever reached, there is a serious bug in JFlex
                                zzScanError(ZZ_UNKNOWN_ERROR);
                                break;
                        }
                    }

                    if ( zzIsFinal ) {
                        zzAction = zzState;
                        zzMarkedPosL = zzCurrentPosL;
                        if ( zzNoLookAhead ) break zzForAction;
                    }

                }
            }

            // store back cached position
            zzMarkedPos = zzMarkedPosL;

            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 5 : {
                    return 2;
                }
                case 7:
                    break;
                case 6: {
                    return 3;
                }
                case 8:
                    break;
                case 1: {
                    return yylength();
                }
                case 9:
                    break;
                case 3: {
                    return 0;
                }
                case 10:
                    break;
                case 4: {
                    return 1;
                }
                case 11:
                    break;
                case 2: {
                }
                case 12:
                    break;
                default:
                    if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
                        zzAtEOF = true;
                        {
                            return 0;
                        }
                    } else {
                        zzScanError(ZZ_NO_MATCH);
                    }
            }
        }
    }


}
