/* The following code was generated by JFlex 1.4.3 on 30/11/10 14:38 */

//CHECKSTYLE:OFF

package org.scilab.forge.scidoc.XML;

import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 30/11/10 14:38 from the specification file
 * <tt>xml.jflex</tt>
 */
public final class XMLLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int CLEANFIRST = 12;
  public static final int CLEAN = 10;
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 2;
  public static final int CDATA = 4;
  public static final int TAG = 6;
  public static final int PI = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6, 6
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\15\2\0\1\15\22\0\1\1\1\13\1\27\1\3"+
    "\2\0\1\2\1\30\5\0\1\7\1\10\1\25\12\11\1\5\1\4"+
    "\1\12\1\26\1\14\1\24\1\0\1\21\1\6\1\17\1\20\1\6"+
    "\16\6\1\22\6\6\1\16\1\10\1\23\1\10\1\5\1\10\32\6"+
    "\74\10\1\10\10\10\27\5\1\10\37\5\1\10\u0208\5\160\10\16\5"+
    "\1\10\u1c81\5\14\10\2\5\63\10\57\0\u0120\5\u0a70\0\u03f0\5\21\0"+
    "\ua7ff\5\u2100\0\u04d0\5\40\0\u020e\5\2\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\2\1\3\4\0\2\1\1\0\1\4\1\2"+
    "\1\0\1\5\1\3\1\6\1\0\1\7\1\10\1\7"+
    "\1\11\1\12\3\7\1\13\1\7\1\14\1\15\1\16"+
    "\1\17\1\20\1\7\1\21\1\22\10\0\1\23\1\24"+
    "\1\0\1\25\1\0\1\26\2\0\1\27\2\0\1\30"+
    "\1\0\1\31\1\32\2\0\1\33\4\0\1\34";

  private static int [] zzUnpackAction() {
    int [] result = new int[66];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

    private int whitesOnFirstLine;
    private int saveLexState;
    private AbstractXMLCodeHandler handler;

    public XMLLexer() { }

    private String trimEnd(String str) {
        int end = str.length() - 1;
        int i = end;
        for (; i >= 0; i--) {
           char c = str.charAt(i);
           if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
              break;
           }
        }
        if (i != end) {
           return str.substring(0, i + 1);
        }

        return str;
    }

    public String convert(AbstractXMLCodeHandler h, String code) {
        Reader reader = new StringReader(trimEnd(code));
        String str = convert(h, reader, true);
        try {
          reader.close();
        } catch (IOException e) { }

        return str;
    }

    public String convert(AbstractXMLCodeHandler h, Reader code, boolean ret) {
        if (code == null) {
           return null;
        } else {
           handler = h;
           whitesOnFirstLine = 0;
           yyreset(code);
           yybegin(CLEANFIRST);
           try {
               yylex();
           } catch (IOException e) {
               return null;
           }
           if (ret) {
               return h.toString();
           }
           return "";
        }
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public XMLLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public XMLLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 132) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public void yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzState = 8; break zzForNext;
                case 10: zzState = 9; break zzForNext;
                case 13: zzIsFinal = true; zzState = 10; break zzForNext;
                default: zzIsFinal = true; zzState = 7; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 7: zzState = 12; break zzForNext;
                case 13: zzIsFinal = true; zzState = 13; break zzForNext;
                default: zzIsFinal = true; zzState = 11; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 15; break zzForNext;
                case 19: zzState = 16; break zzForNext;
                default: zzIsFinal = true; zzState = 14; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 18; break zzForNext;
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzIsFinal = true; zzState = 19; break zzForNext;
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 20; break zzForNext;
                case 13: zzIsFinal = true; zzState = 21; break zzForNext;
                case 21: zzIsFinal = true; zzState = 22; break zzForNext;
                case 23: zzIsFinal = true; zzState = 23; break zzForNext;
                case 24: zzIsFinal = true; zzState = 24; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 17; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 18; break zzForNext;
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzIsFinal = true; zzState = 19; break zzForNext;
                case 23: zzIsFinal = true; zzState = 23; break zzForNext;
                case 24: zzIsFinal = true; zzState = 24; break zzForNext;
                case 13: zzIsFinal = true; zzState = 25; break zzForNext;
                case 20: zzIsFinal = true; zzState = 26; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 17; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 28; break zzForNext;
                case 13: zzIsFinal = true; zzState = 29; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 27; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 31; break zzForNext;
                case 13: zzIsFinal = true; zzState = 32; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 30; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 10: 
                case 13: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 8:
              switch (zzInput) {
                case 3: 
                case 6: 
                case 9: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzIsFinal = true; break zzForNext;
                case 4: zzIsFinal = true; zzState = 33; break zzForNext;
                case 10: 
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 7; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzIsFinal = true; zzState = 34; break zzForNext;
                case 11: zzState = 35; break zzForNext;
                case 20: zzState = 36; break zzForNext;
                case 21: zzState = 37; break zzForNext;
                default: break zzForAction;
              }

            case 10:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 11:
              switch (zzInput) {
                case 7: zzState = 38; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 12:
              switch (zzInput) {
                case 7: zzState = 39; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 11; break zzForNext;
              }

            case 13:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 14:
              switch (zzInput) {
                case 19: zzState = 40; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 15:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 16:
              switch (zzInput) {
                case 19: zzState = 41; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 14; break zzForNext;
              }

            case 18:
              switch (zzInput) {
                case 1: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 19:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: zzState = 42; break zzForNext;
                case 22: zzIsFinal = true; zzNoLookAhead = true; zzState = 43; break zzForNext;
                default: break zzForAction;
              }

            case 21:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 22:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 44; break zzForNext;
                default: break zzForAction;
              }

            case 23:
              switch (zzInput) {
                case 23: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                case 13: break zzForAction;
                default: zzState = 45; break zzForNext;
              }

            case 24:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                case 13: break zzForAction;
                default: zzState = 47; break zzForNext;
              }

            case 25:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 26:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 48; break zzForNext;
                default: break zzForAction;
              }

            case 28:
              switch (zzInput) {
                case 1: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 29:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 31:
              switch (zzInput) {
                case 1: zzIsFinal = true; break zzForNext;
                case 13: zzIsFinal = true; zzState = 32; break zzForNext;
                default: break zzForAction;
              }

            case 32:
              switch (zzInput) {
                case 13: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 33:
              switch (zzInput) {
                case 10: 
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 7; break zzForNext;
              }

            case 34:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 35:
              switch (zzInput) {
                case 7: zzState = 49; break zzForNext;
                case 14: zzState = 50; break zzForNext;
                default: break zzForAction;
              }

            case 36:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzIsFinal = true; zzState = 51; break zzForNext;
                default: break zzForAction;
              }

            case 37:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: zzState = 52; break zzForNext;
                default: break zzForAction;
              }

            case 38:
              switch (zzInput) {
                case 7: zzState = 53; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 11; break zzForNext;
              }

            case 39:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 54; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 11; break zzForNext;
              }

            case 40:
              switch (zzInput) {
                case 19: zzState = 55; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 14; break zzForNext;
              }

            case 41:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 56; break zzForNext;
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 14; break zzForNext;
              }

            case 42:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: break zzForNext;
                case 22: zzIsFinal = true; zzNoLookAhead = true; zzState = 43; break zzForNext;
                default: break zzForAction;
              }

            case 45:
              switch (zzInput) {
                case 23: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                case 13: break zzForAction;
                default: break zzForNext;
              }

            case 47:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzNoLookAhead = true; zzState = 46; break zzForNext;
                case 13: break zzForAction;
                default: break zzForNext;
              }

            case 49:
              switch (zzInput) {
                case 7: zzIsFinal = true; zzNoLookAhead = true; zzState = 57; break zzForNext;
                default: break zzForAction;
              }

            case 50:
              switch (zzInput) {
                case 15: zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 51:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 52:
              switch (zzInput) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: break zzForNext;
                case 1: zzState = 59; break zzForNext;
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 53:
              switch (zzInput) {
                case 12: 
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 11; break zzForNext;
              }

            case 55:
              switch (zzInput) {
                case 12: 
                case 13: break zzForAction;
                default: zzIsFinal = true; zzState = 14; break zzForNext;
              }

            case 58:
              switch (zzInput) {
                case 16: zzState = 61; break zzForNext;
                default: break zzForAction;
              }

            case 59:
              switch (zzInput) {
                case 1: break zzForNext;
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 61:
              switch (zzInput) {
                case 17: zzState = 62; break zzForNext;
                default: break zzForAction;
              }

            case 62:
              switch (zzInput) {
                case 18: zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 63:
              switch (zzInput) {
                case 17: zzState = 64; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 14: zzIsFinal = true; zzNoLookAhead = true; zzState = 65; break zzForNext;
                default: break zzForAction;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 15: 
          { yypushback(1);
                                     yybegin(YYINITIAL);
          }
        case 29: break;
        case 27: 
          { handler.handleLowClose("&#0060;/");
                                     String str = yytext();
                                     handler.handleOpenTagName(str.substring(2, str.length() - 1).trim());
                                     handler.handleGreat("&#0062;");
          }
        case 30: break;
        case 5: 
          { handler.handleNothing("\n");
                                     saveLexState = COMMENT;
                                     yybegin(CLEAN);
          }
        case 31: break;
        case 25: 
          { yybegin(YYINITIAL);
                                     handler.handleCdataEnd("]]&#0062;");
          }
        case 32: break;
        case 28: 
          { yybegin(CDATA);
                                     handler.handleOpenCdata("&#0060;![CDATA[");
          }
        case 33: break;
        case 14: 
          { handler.handleNothing("\n");
          }
        case 34: break;
        case 23: 
          { yybegin(PI);
                                     handler.handleOpenInstr("&#0060;?");
                                     handler.handleInstrName(yytext().substring(2));
          }
        case 35: break;
        case 2: 
          { handler.handleComment(yytext());
          }
        case 36: break;
        case 18: 
          { yybegin(TAG);
                                     handler.handleLow("&#0060;");
                                     handler.handleOpenTagName(yytext().substring(1));
          }
        case 37: break;
        case 4: 
          { handler.handleNothing("\n");
                                     saveLexState = YYINITIAL;
                                     yybegin(CLEAN);
          }
        case 38: break;
        case 16: 
          { whitesOnFirstLine = yylength();
                                     yybegin(YYINITIAL);
          }
        case 39: break;
        case 12: 
          { yypushback(1);
                                     yybegin(saveLexState);
          }
        case 40: break;
        case 17: 
          { handler.handleEntity("&amp;" + yytext().substring(1));
          }
        case 41: break;
        case 6: 
          { handler.handleNothing("\n");
                                     saveLexState = CDATA;
                                     yybegin(CLEAN);
          }
        case 42: break;
        case 22: 
          { yybegin(YYINITIAL);
                                     handler.handleCloseInstr("?&#0062;");
          }
        case 43: break;
        case 11: 
          { handler.handleNothing("\n");
                                     saveLexState = PI;
                                     yybegin(CLEAN);
          }
        case 44: break;
        case 8: 
          { handler.handleNothing(" ");
          }
        case 45: break;
        case 24: 
          { yybegin(YYINITIAL);
                                     handler.handleCommentEnd("--&#0062;");
          }
        case 46: break;
        case 21: 
          { handler.handleAttributeValue(yytext());
          }
        case 47: break;
        case 1: 
          { handler.handleDefault(yytext());
          }
        case 48: break;
        case 9: 
          { yybegin(YYINITIAL);
                                     handler.handleGreat("&#0062;");
          }
        case 49: break;
        case 3: 
          { handler.handleCdata(yytext());
          }
        case 50: break;
        case 13: 
          { int len = yylength() - whitesOnFirstLine;
                                     if (len > 0) {
                                        yypushback(len);
                                     }
                                     yybegin(saveLexState);
          }
        case 51: break;
        case 20: 
          { yybegin(YYINITIAL);
                                     handler.handleAutoClose("/&#0062;");
          }
        case 52: break;
        case 26: 
          { yybegin(COMMENT);
                                     handler.handleOpenComment("&#0060;!--");
          }
        case 53: break;
        case 19: 
          { String str = yytext();
                                     handler.handleAttributeName(str.substring(0, str.length() - 1));
                                     handler.handleEqual("=");
          }
        case 54: break;
        case 10: 
          { handler.handleNothing("\n");
                                     saveLexState = TAG;
                                     yybegin(CLEAN);
          }
        case 55: break;
        case 7: 
          { 
          }
        case 56: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
