/* Generated by GIWS (version 1.2.1) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/


#ifndef __ORG_SCILAB_MODULES_GUI_BRIDGE_CALLSCILABBRIDGE__
#define __ORG_SCILAB_MODULES_GUI_BRIDGE_CALLSCILABBRIDGE__
#include <iostream>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <jni.h>

#include "GiwsException.hxx"

#ifndef _MSC_VER /* Defined anyway with Visual */
#if !defined(byte)
typedef signed char byte;
#else
#pragma message("Byte has been redefined elsewhere. Some problems can happen")
#endif
#endif

namespace org_scilab_modules_gui_bridge {
class CallScilabBridge {

private:
JavaVM * jvm;

protected:
jmethodID jintnewWindowID; // cache method id
jmethodID jintnewMenuBarID; // cache method id
jmethodID jintnewMenuID; // cache method id
jmethodID jintnewPushButtonID; // cache method id
jmethodID jintnewEditBoxID; // cache method id
jmethodID jintnewLabelID; // cache method id
jmethodID jintnewCheckBoxID; // cache method id
jmethodID jintnewRadioButtonID; // cache method id
jmethodID jintnewSliderID; // cache method id
jmethodID jintnewPopupMenuID; // cache method id
jmethodID jintnewListBoxID; // cache method id
jmethodID jintnewFrameID; // cache method id
jmethodID jstringnewContextMenujobjectArray_ID; // cache method id
jclass stringArrayClass;
jmethodID jintnewContextMenuID; // cache method id
jmethodID voiddestroyWidgetjintID; // cache method id
jmethodID voiddestroyFramejintID; // cache method id
jmethodID jintnewWindowjintID; // cache method id
jmethodID voidsetFigureAsParentjintjintID; // cache method id
jmethodID voidsetMenuAsParentjintjintID; // cache method id
jmethodID voidsetRootAsParentjintID; // cache method id
jmethodID voidsetParentjintjintID; // cache method id
jmethodID voidsetPushButtonParentjintjintID; // cache method id
jmethodID voidremovePushButtonFromParentjintjintID; // cache method id
jmethodID voidsetEditBoxParentjintjintID; // cache method id
jmethodID voidremoveEditBoxFromParentjintjintID; // cache method id
jmethodID voidsetLabelParentjintjintID; // cache method id
jmethodID voidremoveLabelFromParentjintjintID; // cache method id
jmethodID voidsetCheckBoxParentjintjintID; // cache method id
jmethodID voidremoveCheckBoxFromParentjintjintID; // cache method id
jmethodID voidsetRadioButtonParentjintjintID; // cache method id
jmethodID voidremoveRadioButtonFromParentjintjintID; // cache method id
jmethodID voidsetSliderParentjintjintID; // cache method id
jmethodID voidremoveSliderFromParentjintjintID; // cache method id
jmethodID voidsetPopupMenuParentjintjintID; // cache method id
jmethodID voidremovePopupMenuFromParentjintjintID; // cache method id
jmethodID voidsetListBoxParentjintjintID; // cache method id
jmethodID voidremoveListBoxFromParentjintjintID; // cache method id
jmethodID voidsetFrameParentjintjintID; // cache method id
jmethodID voidremoveFrameFromParentjintjintID; // cache method id
jmethodID voidsetWidgetTextjintjstringID; // cache method id
jmethodID jstringgetWidgetTextjintID; // cache method id
jmethodID voidsetFrameTextjintjstringID; // cache method id
jmethodID jstringgetFrameTextjintID; // cache method id
jmethodID voidsetWidgetBackgroundColorjintjintjintjintID; // cache method id
jmethodID jintArray_getWidgetBackgroundColorjintID; // cache method id
jmethodID voidsetWidgetForegroundColorjintjintjintjintID; // cache method id
jmethodID jintArray_getWidgetForegroundColorjintID; // cache method id
jmethodID voidsetFrameBackgroundColorjintjintjintjintID; // cache method id
jmethodID jintArray_getFrameBackgroundColorjintID; // cache method id
jmethodID voidsetFrameForegroundColorjintjintjintjintID; // cache method id
jmethodID jintArray_getFrameForegroundColorjintID; // cache method id
jmethodID voidsetWidgetFontNamejintjstringID; // cache method id
jmethodID jstringgetWidgetFontNamejintID; // cache method id
jmethodID voidsetWidgetFontWeightjintjstringID; // cache method id
jmethodID voidsetWidgetFontSizejintjintID; // cache method id
jmethodID jintgetWidgetFontSizejintID; // cache method id
jmethodID voidsetWidgetFontAnglejintjstringID; // cache method id
jmethodID voidsetFrameFontNamejintjstringID; // cache method id
jmethodID jstringgetFrameFontNamejintID; // cache method id
jmethodID voidsetFrameFontWeightjintjstringID; // cache method id
jmethodID voidsetFrameFontSizejintjintID; // cache method id
jmethodID jintgetFrameFontSizejintID; // cache method id
jmethodID voidsetFrameFontAnglejintjstringID; // cache method id
jmethodID voidsetWidgetPositionjintjintjintjintjintID; // cache method id
jmethodID jintArray_getWidgetPositionjintID; // cache method id
jmethodID voidsetFramePositionjintjintjintjintjintID; // cache method id
jmethodID jintArray_getFramePositionjintID; // cache method id
jmethodID voidsetWidgetCallbackjintjstringjintID; // cache method id
jmethodID voidsetFrameCallbackjintjstringjintID; // cache method id
jmethodID voidsetWidgetHorizontalAlignmentjintjstringID; // cache method id
jmethodID voidsetWidgetVerticalAlignmentjintjstringID; // cache method id
jmethodID voidsetSliderMinorTickSpacingjintjintID; // cache method id
jmethodID voidsetSliderMajorTickSpacingjintjintID; // cache method id
jmethodID voidsetListBoxSelectedIndicesjintjintArray_ID; // cache method id
jmethodID jintArray_getListBoxSelectedIndicesjintID; // cache method id
jmethodID jintgetListBoxSelectionSizejintID; // cache method id
jmethodID voidsetPopupMenuSelectedIndexjintjintID; // cache method id
jmethodID jintgetPopupMenuSelectedIndexjintID; // cache method id
jmethodID voidsetSliderValuejintjintID; // cache method id
jmethodID jintgetSliderValuejintID; // cache method id
jmethodID voidsetRadioButtonCheckedjintjbooleanID; // cache method id
jmethodID jbooleanisRadioButtonCheckedjintID; // cache method id
jmethodID voidsetCheckBoxCheckedjintjbooleanID; // cache method id
jmethodID jbooleanisCheckBoxCheckedjintID; // cache method id
jmethodID voidsetSliderMinValuejintjintID; // cache method id
jmethodID voidsetSliderMaxValuejintjintID; // cache method id
jmethodID voidsetSliderVerticaljintID; // cache method id
jmethodID voidsetSliderHorizontaljintID; // cache method id
jmethodID voidsetListBoxMultipleSelectionEnabledjintjbooleanID; // cache method id
jmethodID jobjectArray_getListBoxAllItemsTextjintID; // cache method id
jmethodID jintgetListBoxNumberOfItemsjintID; // cache method id
jmethodID voidsetListBoxTextjintjobjectArray_ID; // cache method id
jmethodID voidsetListBoxListBoxTopjintjintID; // cache method id
jmethodID jintgetListBoxListBoxTopjintID; // cache method id
jmethodID jobjectArray_getPopupMenuAllItemsTextjintID; // cache method id
jmethodID jintgetPopupMenuNumberOfItemsjintID; // cache method id
jmethodID voidsetPopupMenuTextjintjobjectArray_ID; // cache method id
jmethodID voidsetWidgetReliefjintjstringID; // cache method id
jmethodID voidsetFrameReliefjintjstringID; // cache method id
jmethodID voidsetRootMenuEnabledjstringjbooleanID; // cache method id
jmethodID voidsetRootSubMenuEnabledjstringjintjbooleanID; // cache method id
jmethodID voidsetFigureMenuEnabledjintjstringjbooleanID; // cache method id
jmethodID voidsetFigureSubMenuEnabledjintjstringjintjbooleanID; // cache method id
jmethodID voidsetWidgetEnablejintjbooleanID; // cache method id
jmethodID voidsetFrameEnablejintjbooleanID; // cache method id
jmethodID jbooleanisWidgetEnablejintID; // cache method id
jmethodID jbooleanisFrameEnablejintID; // cache method id
jmethodID voidsetMenuCheckedjintjbooleanID; // cache method id
jmethodID jbooleanisMenuCheckedjintID; // cache method id
jmethodID voidremoveRootMenujstringID; // cache method id
jmethodID voidremoveFigureMenujintjstringID; // cache method id
jmethodID jstringdisplayAndWaitContextMenujintID; // cache method id
jmethodID jintnewMessageBoxID; // cache method id
jmethodID voidsetMessageBoxTitlejintjstringID; // cache method id
jmethodID voidsetMessageBoxMessagejintjstringID; // cache method id
jmethodID voidsetMessageBoxMessagejintjobjectArray_ID; // cache method id
jmethodID voidmessageBoxDisplayAndWaitjintID; // cache method id
jmethodID jintgetMessageBoxSelectedButtonjintID; // cache method id
jmethodID voidsetMessageBoxDefaultSelectedButtonsjintjintArray_ID; // cache method id
jmethodID jintArray_getMessageBoxUserSelectedButtonsjintID; // cache method id
jmethodID voidsetMessageBoxButtonsLabelsjintjobjectArray_ID; // cache method id
jmethodID voidsetMessageBoxInitialValuejintjobjectArray_ID; // cache method id
jmethodID jobjectArray_getMessageBoxValuejintID; // cache method id
jmethodID jintgetMessageBoxValueSizejintID; // cache method id
jmethodID voidsetMessageBoxListBoxItemsjintjobjectArray_ID; // cache method id
jmethodID jintgetMessageBoxSelectedItemjintID; // cache method id
jmethodID voidsetMessageBoxLineLabelsjintjobjectArray_ID; // cache method id
jmethodID voidsetMessageBoxColumnLabelsjintjobjectArray_ID; // cache method id
jmethodID voidsetMessageBoxDefaultInputjintjobjectArray_ID; // cache method id
jmethodID voidsetMessageBoxModaljintjbooleanID; // cache method id
jmethodID voidsetMessageBoxIconjintjstringID; // cache method id
jmethodID jbooleanisToolbarVisiblejintID; // cache method id
jmethodID voidsetToolbarVisiblejintjbooleanID; // cache method id
jmethodID voidsetEventHandlerjintjstringID; // cache method id
jmethodID voidsetEventHandlerEnabledjintjbooleanID; // cache method id
jmethodID jintnewWaitBarID; // cache method id
jmethodID voidsetWaitBarMessagejintjobjectArray_ID; // cache method id
jmethodID voidsetWaitBarValuejintjintID; // cache method id
jmethodID voiddestroyWaitBarjintID; // cache method id
jmethodID voidsetWaitBarIndeterminateModejintjbooleanID; // cache method id
jmethodID voidlaunchHelpBrowserjobjectArray_jstringID; // cache method id
jmethodID voidsearchKeywordjobjectArray_jstringjstringjbooleanID; // cache method id
jmethodID voidsaveMainWindowSettingsID; // cache method id
jmethodID voidsaveHelpWindowSettingsID; // cache method id
jmethodID jintnewExportFileChooserjintID; // cache method id
jmethodID jintnewFontChooserID; // cache method id
jmethodID voidfontChooserDisplayAndWaitjintID; // cache method id
jmethodID voidsetFontChooserFontNamejintjstringID; // cache method id
jmethodID voidsetFontChooserFontSizejintjintID; // cache method id
jmethodID voidsetFontChooserBoldjintjbooleanID; // cache method id
jmethodID voidsetFontChooserItalicjintjbooleanID; // cache method id
jmethodID jstringgetFontChooserFontNamejintID; // cache method id
jmethodID jintgetFontChooserFontSizejintID; // cache method id
jmethodID jbooleangetFontChooserBoldjintID; // cache method id
jmethodID jbooleangetFontChooserItalicjintID; // cache method id
jmethodID jintnewColorChooserID; // cache method id
jmethodID voidcolorChooserDisplayAndWaitjintID; // cache method id
jmethodID voidsetColorChooserDefaultColorjintjintArray_ID; // cache method id
jmethodID jintArray_getColorChooserSelectedColorjintID; // cache method id
jmethodID voidsetColorChooserTitlejintjstringID; // cache method id
jmethodID voidsetWidgetVisiblejintjbooleanID; // cache method id
jmethodID voidsetFrameVisiblejintjbooleanID; // cache method id
jmethodID jbooleanisWidgetVisiblejintID; // cache method id
jmethodID jbooleanisFrameVisiblejintID; // cache method id
jmethodID jstringgetClipboardContentsID; // cache method id
jmethodID voidpasteClipboardIntoConsoleID; // cache method id
jmethodID voidcopyConsoleSelectionID; // cache method id
jmethodID voidemptyClipboardID; // cache method id
jmethodID voidsetClipboardContentsjstringID; // cache method id
jmethodID voidcopyFigureToClipBoardjintID; // cache method id
jmethodID jintgetScreenResolutionID; // cache method id
jmethodID jdoublegetScreenWidthID; // cache method id
jmethodID jdoublegetScreenHeightID; // cache method id
jmethodID jintgetScreenDepthID; // cache method id
jmethodID jbooleanprintFigurejintjbooleanjbooleanID; // cache method id
jmethodID jbooleanprintFilejstringID; // cache method id
jmethodID jbooleanprintStringjstringjstringID; // cache method id
jmethodID jbooleanpageSetupID; // cache method id
jmethodID voidrequestWidgetFocusjintID; // cache method id
jmethodID voidrequestFrameFocusjintID; // cache method id
jmethodID voidraiseWindowjintID; // cache method id
jmethodID voiduseCanvasForDisplayjbooleanID; // cache method id
jmethodID jbooleanuseCanvasForDisplayID; // cache method id
jmethodID voidscilabAboutBoxID; // cache method id



jobject instance;
jclass instanceClass; // cache class


/**
* Get the environment matching to the current thread.
*/
virtual JNIEnv * getCurrentEnv();

public:
// Constructor
/**
* Create a wrapping of the object from a JNIEnv.
* It will call the default constructor
* @param JEnv_ the Java Env
*/
CallScilabBridge(JavaVM * jvm_);

/**
* Create a wrapping of an already existing object from a JNIEnv.
* The object must have already been instantiated
* @param JEnv_ the Java Env
* @param JObj the object
*/
CallScilabBridge(JavaVM * jvm_, jobject JObj);


/** 
* This is a fake constructor to avoid the constructor
* chaining when dealing with extended giws classes 
*/
#ifdef FAKEGIWSDATATYPE
CallScilabBridge(fakeGiwsDataType::fakeGiwsDataType /* unused */) {}
#endif

// Destructor
~CallScilabBridge();

// Generic method
// Synchronization methods
/**
* Enter monitor associated with the object.
* Equivalent of creating a "synchronized(obj)" scope in Java.
*/
void synchronize();

/**
* Exit monitor associated with the object.
* Equivalent of ending a "synchronized(obj)" scope.
*/
void endSynchronize();

// Methods
static int newWindow(JavaVM * jvm_);

static int newMenuBar(JavaVM * jvm_);

static int newMenu(JavaVM * jvm_);

static int newPushButton(JavaVM * jvm_);

static int newEditBox(JavaVM * jvm_);

static int newLabel(JavaVM * jvm_);

static int newCheckBox(JavaVM * jvm_);

static int newRadioButton(JavaVM * jvm_);

static int newSlider(JavaVM * jvm_);

static int newPopupMenu(JavaVM * jvm_);

static int newListBox(JavaVM * jvm_);

static int newFrame(JavaVM * jvm_);

static char * newContextMenu(JavaVM * jvm_, char ** menuLabels, int menuLabelsSize);

static int newContextMenu(JavaVM * jvm_);

static void destroyWidget(JavaVM * jvm_, int objID);

static void destroyFrame(JavaVM * jvm_, int objID);

static int newWindow(JavaVM * jvm_, int figureIndex);

static void setFigureAsParent(JavaVM * jvm_, int figureID, int objID);

static void setMenuAsParent(JavaVM * jvm_, int menuID, int objID);

static void setRootAsParent(JavaVM * jvm_, int objID);

static void setParent(JavaVM * jvm_, int parentID, int objID);

static void setPushButtonParent(JavaVM * jvm_, int parentID, int objID);

static void removePushButtonFromParent(JavaVM * jvm_, int parentID, int objID);

static void setEditBoxParent(JavaVM * jvm_, int parentID, int objID);

static void removeEditBoxFromParent(JavaVM * jvm_, int parentID, int objID);

static void setLabelParent(JavaVM * jvm_, int parentID, int objID);

static void removeLabelFromParent(JavaVM * jvm_, int parentID, int objID);

static void setCheckBoxParent(JavaVM * jvm_, int parentID, int objID);

static void removeCheckBoxFromParent(JavaVM * jvm_, int parentID, int objID);

static void setRadioButtonParent(JavaVM * jvm_, int parentID, int objID);

static void removeRadioButtonFromParent(JavaVM * jvm_, int parentID, int objID);

static void setSliderParent(JavaVM * jvm_, int parentID, int objID);

static void removeSliderFromParent(JavaVM * jvm_, int parentID, int objID);

static void setPopupMenuParent(JavaVM * jvm_, int parentID, int objID);

static void removePopupMenuFromParent(JavaVM * jvm_, int parentID, int objID);

static void setListBoxParent(JavaVM * jvm_, int parentID, int objID);

static void removeListBoxFromParent(JavaVM * jvm_, int parentID, int objID);

static void setFrameParent(JavaVM * jvm_, int parentID, int objID);

static void removeFrameFromParent(JavaVM * jvm_, int parentID, int objID);

static void setWidgetText(JavaVM * jvm_, int objID, char * text);

static char * getWidgetText(JavaVM * jvm_, int objID);

static void setFrameText(JavaVM * jvm_, int objID, char * text);

static char * getFrameText(JavaVM * jvm_, int objID);

static void setWidgetBackgroundColor(JavaVM * jvm_, int objID, int red, int green, int blue);

static int* getWidgetBackgroundColor(JavaVM * jvm_, int objID);

static void setWidgetForegroundColor(JavaVM * jvm_, int objID, int red, int green, int blue);

static int* getWidgetForegroundColor(JavaVM * jvm_, int objID);

static void setFrameBackgroundColor(JavaVM * jvm_, int objID, int red, int green, int blue);

static int* getFrameBackgroundColor(JavaVM * jvm_, int objID);

static void setFrameForegroundColor(JavaVM * jvm_, int objID, int red, int green, int blue);

static int* getFrameForegroundColor(JavaVM * jvm_, int objID);

static void setWidgetFontName(JavaVM * jvm_, int objID, char * name);

static char * getWidgetFontName(JavaVM * jvm_, int objID);

static void setWidgetFontWeight(JavaVM * jvm_, int objID, char * weight);

static void setWidgetFontSize(JavaVM * jvm_, int objID, int size);

static int getWidgetFontSize(JavaVM * jvm_, int objID);

static void setWidgetFontAngle(JavaVM * jvm_, int objID, char * angle);

static void setFrameFontName(JavaVM * jvm_, int objID, char * name);

static char * getFrameFontName(JavaVM * jvm_, int objID);

static void setFrameFontWeight(JavaVM * jvm_, int objID, char * weight);

static void setFrameFontSize(JavaVM * jvm_, int objID, int size);

static int getFrameFontSize(JavaVM * jvm_, int objID);

static void setFrameFontAngle(JavaVM * jvm_, int objID, char * angle);

static void setWidgetPosition(JavaVM * jvm_, int objID, int x, int y, int width, int height);

static int* getWidgetPosition(JavaVM * jvm_, int objID);

static void setFramePosition(JavaVM * jvm_, int objID, int x, int y, int width, int height);

static int* getFramePosition(JavaVM * jvm_, int objID);

static void setWidgetCallback(JavaVM * jvm_, int objID, char * text, int type);

static void setFrameCallback(JavaVM * jvm_, int objID, char * text, int type);

static void setWidgetHorizontalAlignment(JavaVM * jvm_, int objID, char * alignment);

static void setWidgetVerticalAlignment(JavaVM * jvm_, int objID, char * alignment);

static void setSliderMinorTickSpacing(JavaVM * jvm_, int objID, int space);

static void setSliderMajorTickSpacing(JavaVM * jvm_, int objID, int space);

static void setListBoxSelectedIndices(JavaVM * jvm_, int objID, int* indices, int indicesSize);

static int* getListBoxSelectedIndices(JavaVM * jvm_, int objID);

static int getListBoxSelectionSize(JavaVM * jvm_, int objID);

static void setPopupMenuSelectedIndex(JavaVM * jvm_, int objID, int index);

static int getPopupMenuSelectedIndex(JavaVM * jvm_, int objID);

static void setSliderValue(JavaVM * jvm_, int objID, int index);

static int getSliderValue(JavaVM * jvm_, int objID);

static void setRadioButtonChecked(JavaVM * jvm_, int objID, bool status);

static bool isRadioButtonChecked(JavaVM * jvm_, int objID);

static void setCheckBoxChecked(JavaVM * jvm_, int objID, bool status);

static bool isCheckBoxChecked(JavaVM * jvm_, int objID);

static void setSliderMinValue(JavaVM * jvm_, int objID, int value);

static void setSliderMaxValue(JavaVM * jvm_, int objID, int value);

static void setSliderVertical(JavaVM * jvm_, int objID);

static void setSliderHorizontal(JavaVM * jvm_, int objID);

static void setListBoxMultipleSelectionEnabled(JavaVM * jvm_, int objID, bool status);

static char ** getListBoxAllItemsText(JavaVM * jvm_, int objID);

static int getListBoxNumberOfItems(JavaVM * jvm_, int objID);

static void setListBoxText(JavaVM * jvm_, int objID, char ** text, int textSize);

static void setListBoxListBoxTop(JavaVM * jvm_, int objID, int index);

static int getListBoxListBoxTop(JavaVM * jvm_, int objID);

static char ** getPopupMenuAllItemsText(JavaVM * jvm_, int objID);

static int getPopupMenuNumberOfItems(JavaVM * jvm_, int objID);

static void setPopupMenuText(JavaVM * jvm_, int objID, char ** text, int textSize);

static void setWidgetRelief(JavaVM * jvm_, int objID, char * reliefType);

static void setFrameRelief(JavaVM * jvm_, int objID, char * reliefType);

static void setRootMenuEnabled(JavaVM * jvm_, char * menuName, bool status);

static void setRootSubMenuEnabled(JavaVM * jvm_, char * menuName, int position, bool status);

static void setFigureMenuEnabled(JavaVM * jvm_, int figureID, char * menuName, bool status);

static void setFigureSubMenuEnabled(JavaVM * jvm_, int figureID, char * menuName, int position, bool status);

static void setWidgetEnable(JavaVM * jvm_, int objID, bool status);

static void setFrameEnable(JavaVM * jvm_, int objID, bool status);

static bool isWidgetEnable(JavaVM * jvm_, int objID);

static bool isFrameEnable(JavaVM * jvm_, int objID);

static void setMenuChecked(JavaVM * jvm_, int objID, bool status);

static bool isMenuChecked(JavaVM * jvm_, int objID);

static void removeRootMenu(JavaVM * jvm_, char * menuName);

static void removeFigureMenu(JavaVM * jvm_, int figureID, char * menuName);

static char * displayAndWaitContextMenu(JavaVM * jvm_, int ID);

static int newMessageBox(JavaVM * jvm_);

static void setMessageBoxTitle(JavaVM * jvm_, int id, char * title);

static void setMessageBoxMessage(JavaVM * jvm_, int id, char * message);

static void setMessageBoxMessage(JavaVM * jvm_, int id, char ** message, int messageSize);

static void messageBoxDisplayAndWait(JavaVM * jvm_, int id);

static int getMessageBoxSelectedButton(JavaVM * jvm_, int id);

static void setMessageBoxDefaultSelectedButtons(JavaVM * jvm_, int id, int* index, int indexSize);

static int* getMessageBoxUserSelectedButtons(JavaVM * jvm_, int id);

static void setMessageBoxButtonsLabels(JavaVM * jvm_, int id, char ** labels, int labelsSize);

static void setMessageBoxInitialValue(JavaVM * jvm_, int id, char ** value, int valueSize);

static char ** getMessageBoxValue(JavaVM * jvm_, int id);

static int getMessageBoxValueSize(JavaVM * jvm_, int id);

static void setMessageBoxListBoxItems(JavaVM * jvm_, int id, char ** items, int itemsSize);

static int getMessageBoxSelectedItem(JavaVM * jvm_, int id);

static void setMessageBoxLineLabels(JavaVM * jvm_, int id, char ** labels, int labelsSize);

static void setMessageBoxColumnLabels(JavaVM * jvm_, int id, char ** labels, int labelsSize);

static void setMessageBoxDefaultInput(JavaVM * jvm_, int id, char ** values, int valuesSize);

static void setMessageBoxModal(JavaVM * jvm_, int id, bool status);

static void setMessageBoxIcon(JavaVM * jvm_, int id, char * name);

static bool isToolbarVisible(JavaVM * jvm_, int figNum);

static void setToolbarVisible(JavaVM * jvm_, int figNum, bool status);

static void setEventHandler(JavaVM * jvm_, int figNum, char * command);

static void setEventHandlerEnabled(JavaVM * jvm_, int figNum, bool status);

static int newWaitBar(JavaVM * jvm_);

static void setWaitBarMessage(JavaVM * jvm_, int id, char ** message, int messageSize);

static void setWaitBarValue(JavaVM * jvm_, int id, int value);

static void destroyWaitBar(JavaVM * jvm_, int objID);

static void setWaitBarIndeterminateMode(JavaVM * jvm_, int objID, bool status);

static void launchHelpBrowser(JavaVM * jvm_, char ** helps, int helpsSize, char * language);

static void searchKeyword(JavaVM * jvm_, char ** helps, int helpsSize, char * keyword, char * language, bool fullText);

static void saveMainWindowSettings(JavaVM * jvm_);

static void saveHelpWindowSettings(JavaVM * jvm_);

static int newExportFileChooser(JavaVM * jvm_, int figureId);

static int newFontChooser(JavaVM * jvm_);

static void fontChooserDisplayAndWait(JavaVM * jvm_, int objID);

static void setFontChooserFontName(JavaVM * jvm_, int objID, char * fontName);

static void setFontChooserFontSize(JavaVM * jvm_, int objID, int fontSize);

static void setFontChooserBold(JavaVM * jvm_, int objID, bool bold);

static void setFontChooserItalic(JavaVM * jvm_, int objID, bool italic);

static char * getFontChooserFontName(JavaVM * jvm_, int objID);

static int getFontChooserFontSize(JavaVM * jvm_, int objID);

static bool getFontChooserBold(JavaVM * jvm_, int objID);

static bool getFontChooserItalic(JavaVM * jvm_, int objID);

static int newColorChooser(JavaVM * jvm_);

static void colorChooserDisplayAndWait(JavaVM * jvm_, int objID);

static void setColorChooserDefaultColor(JavaVM * jvm_, int objID, int* rgb, int rgbSize);

static int* getColorChooserSelectedColor(JavaVM * jvm_, int objID);

static void setColorChooserTitle(JavaVM * jvm_, int objID, char * title);

static void setWidgetVisible(JavaVM * jvm_, int objID, bool status);

static void setFrameVisible(JavaVM * jvm_, int objID, bool status);

static bool isWidgetVisible(JavaVM * jvm_, int objID);

static bool isFrameVisible(JavaVM * jvm_, int objID);

static char * getClipboardContents(JavaVM * jvm_);

static void pasteClipboardIntoConsole(JavaVM * jvm_);

static void copyConsoleSelection(JavaVM * jvm_);

static void emptyClipboard(JavaVM * jvm_);

static void setClipboardContents(JavaVM * jvm_, char * text);

static void copyFigureToClipBoard(JavaVM * jvm_, int figID);

static int getScreenResolution(JavaVM * jvm_);

static double getScreenWidth(JavaVM * jvm_);

static double getScreenHeight(JavaVM * jvm_);

static int getScreenDepth(JavaVM * jvm_);

static bool printFigure(JavaVM * jvm_, int figID, bool postScript, bool displayDialog);

static bool printFile(JavaVM * jvm_, char * fileName);

static bool printString(JavaVM * jvm_, char * theString, char * pageHeader);

static bool pageSetup(JavaVM * jvm_);

static void requestWidgetFocus(JavaVM * jvm_, int objID);

static void requestFrameFocus(JavaVM * jvm_, int objID);

static void raiseWindow(JavaVM * jvm_, int objID);

static void useCanvasForDisplay(JavaVM * jvm_, bool onOrOff);

static bool useCanvasForDisplay(JavaVM * jvm_);

static void scilabAboutBox(JavaVM * jvm_);


                        /**
                        * Get class name to use for static methods
                        * @return class name to use for static methods
                        */
                        
                static const std::string className()
                {
                return "org/scilab/modules/gui/bridge/CallScilabBridge";
                }
                
};


}
#endif
