#include "JOGLConstant.hxx"
/* Generated by GIWS (version 1.2.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2010 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_graphic_export {

// Returns the current env

JNIEnv * JOGLConstant::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

JOGLConstant::~JOGLConstant() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
JOGLConstant::JOGLConstant(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintget_GL_RGBAID=NULL; 
jintget_GL_RGBID=NULL; 
jintget_GL_CURRENT_RASTER_POSITION_VALIDID=NULL; 
jintget_GL_CURRENT_RASTER_POSITIONID=NULL; 
jintget_GL_CURRENT_RASTER_COLORID=NULL; 
jintget_GL_SRC_ALPHAID=NULL; 
jintget_GL_ONE_MINUS_SRC_ALPHAID=NULL; 
jintget_GL_ONEID=NULL; 
jintget_GL_ZEROID=NULL; 
jintget_GL_COLOR_INDEXID=NULL; 
jintget_GL_POINT_TOKENID=NULL; 
jintget_GL_LINE_TOKENID=NULL; 
jintget_GL_LINE_RESET_TOKENID=NULL; 
jintget_GL_POLYGON_TOKENID=NULL; 
jintget_GL_BITMAP_TOKENID=NULL; 
jintget_GL_DRAW_PIXEL_TOKENID=NULL; 
jintget_GL_COPY_PIXEL_TOKENID=NULL; 
jintget_GL_PASS_THROUGH_TOKENID=NULL; 
jintget_GL_FEEDBACKID=NULL; 
jintget_GL_COLOR_CLEAR_VALUEID=NULL; 
jintget_GL_INDEX_CLEAR_VALUEID=NULL; 
jintget_GL_RENDERID=NULL; 
jintget_GL_VIEWPORTID=NULL; 
jintget_GL_BLENDID=NULL; 
jintget_GL_BLEND_SRCID=NULL; 
jintget_GL_BLEND_DSTID=NULL; 
jintget_GL_3D_COLORID=NULL; 
jintget_GL_FLOATID=NULL; 
jintget_GL_UNSIGNED_BYTEID=NULL; 
jintget_GL_POINTSID=NULL; 
jintget_GL_POLYGON_OFFSET_FACTORID=NULL; 
jintget_GL_POLYGON_OFFSET_UNITSID=NULL; 
jintget_GL_LINE_STIPPLE_PATTERNID=NULL; 
jintget_GL_LINE_STIPPLE_REPEATID=NULL; 


}

JOGLConstant::JOGLConstant(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintget_GL_RGBAID=NULL; 
jintget_GL_RGBID=NULL; 
jintget_GL_CURRENT_RASTER_POSITION_VALIDID=NULL; 
jintget_GL_CURRENT_RASTER_POSITIONID=NULL; 
jintget_GL_CURRENT_RASTER_COLORID=NULL; 
jintget_GL_SRC_ALPHAID=NULL; 
jintget_GL_ONE_MINUS_SRC_ALPHAID=NULL; 
jintget_GL_ONEID=NULL; 
jintget_GL_ZEROID=NULL; 
jintget_GL_COLOR_INDEXID=NULL; 
jintget_GL_POINT_TOKENID=NULL; 
jintget_GL_LINE_TOKENID=NULL; 
jintget_GL_LINE_RESET_TOKENID=NULL; 
jintget_GL_POLYGON_TOKENID=NULL; 
jintget_GL_BITMAP_TOKENID=NULL; 
jintget_GL_DRAW_PIXEL_TOKENID=NULL; 
jintget_GL_COPY_PIXEL_TOKENID=NULL; 
jintget_GL_PASS_THROUGH_TOKENID=NULL; 
jintget_GL_FEEDBACKID=NULL; 
jintget_GL_COLOR_CLEAR_VALUEID=NULL; 
jintget_GL_INDEX_CLEAR_VALUEID=NULL; 
jintget_GL_RENDERID=NULL; 
jintget_GL_VIEWPORTID=NULL; 
jintget_GL_BLENDID=NULL; 
jintget_GL_BLEND_SRCID=NULL; 
jintget_GL_BLEND_DSTID=NULL; 
jintget_GL_3D_COLORID=NULL; 
jintget_GL_FLOATID=NULL; 
jintget_GL_UNSIGNED_BYTEID=NULL; 
jintget_GL_POINTSID=NULL; 
jintget_GL_POLYGON_OFFSET_FACTORID=NULL; 
jintget_GL_POLYGON_OFFSET_UNITSID=NULL; 
jintget_GL_LINE_STIPPLE_PATTERNID=NULL; 
jintget_GL_LINE_STIPPLE_REPEATID=NULL; 


}

// Generic methods

void JOGLConstant::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "JOGLConstant");
}
}

void JOGLConstant::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "JOGLConstant");
}
}
// Method(s)

int JOGLConstant::get_GL_RGBA (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_RGBAID = curEnv->GetStaticMethodID(cls, "get_GL_RGBA", "()I" ) ;
if (jintget_GL_RGBAID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_RGBA");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_RGBAID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_RGB (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_RGBID = curEnv->GetStaticMethodID(cls, "get_GL_RGB", "()I" ) ;
if (jintget_GL_RGBID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_RGB");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_RGBID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_CURRENT_RASTER_POSITION_VALID (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_CURRENT_RASTER_POSITION_VALIDID = curEnv->GetStaticMethodID(cls, "get_GL_CURRENT_RASTER_POSITION_VALID", "()I" ) ;
if (jintget_GL_CURRENT_RASTER_POSITION_VALIDID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_CURRENT_RASTER_POSITION_VALID");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_CURRENT_RASTER_POSITION_VALIDID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_CURRENT_RASTER_POSITION (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_CURRENT_RASTER_POSITIONID = curEnv->GetStaticMethodID(cls, "get_GL_CURRENT_RASTER_POSITION", "()I" ) ;
if (jintget_GL_CURRENT_RASTER_POSITIONID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_CURRENT_RASTER_POSITION");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_CURRENT_RASTER_POSITIONID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_CURRENT_RASTER_COLOR (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_CURRENT_RASTER_COLORID = curEnv->GetStaticMethodID(cls, "get_GL_CURRENT_RASTER_COLOR", "()I" ) ;
if (jintget_GL_CURRENT_RASTER_COLORID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_CURRENT_RASTER_COLOR");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_CURRENT_RASTER_COLORID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_SRC_ALPHA (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_SRC_ALPHAID = curEnv->GetStaticMethodID(cls, "get_GL_SRC_ALPHA", "()I" ) ;
if (jintget_GL_SRC_ALPHAID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_SRC_ALPHA");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_SRC_ALPHAID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_ONE_MINUS_SRC_ALPHA (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_ONE_MINUS_SRC_ALPHAID = curEnv->GetStaticMethodID(cls, "get_GL_ONE_MINUS_SRC_ALPHA", "()I" ) ;
if (jintget_GL_ONE_MINUS_SRC_ALPHAID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_ONE_MINUS_SRC_ALPHA");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_ONE_MINUS_SRC_ALPHAID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_ONE (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_ONEID = curEnv->GetStaticMethodID(cls, "get_GL_ONE", "()I" ) ;
if (jintget_GL_ONEID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_ONE");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_ONEID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_ZERO (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_ZEROID = curEnv->GetStaticMethodID(cls, "get_GL_ZERO", "()I" ) ;
if (jintget_GL_ZEROID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_ZERO");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_ZEROID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_COLOR_INDEX (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_COLOR_INDEXID = curEnv->GetStaticMethodID(cls, "get_GL_COLOR_INDEX", "()I" ) ;
if (jintget_GL_COLOR_INDEXID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_COLOR_INDEX");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_COLOR_INDEXID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_POINT_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_POINT_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_POINT_TOKEN", "()I" ) ;
if (jintget_GL_POINT_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_POINT_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_POINT_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_LINE_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_LINE_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_LINE_TOKEN", "()I" ) ;
if (jintget_GL_LINE_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_LINE_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_LINE_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_LINE_RESET_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_LINE_RESET_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_LINE_RESET_TOKEN", "()I" ) ;
if (jintget_GL_LINE_RESET_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_LINE_RESET_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_LINE_RESET_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_POLYGON_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_POLYGON_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_POLYGON_TOKEN", "()I" ) ;
if (jintget_GL_POLYGON_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_POLYGON_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_POLYGON_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_BITMAP_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_BITMAP_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_BITMAP_TOKEN", "()I" ) ;
if (jintget_GL_BITMAP_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_BITMAP_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_BITMAP_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_DRAW_PIXEL_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_DRAW_PIXEL_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_DRAW_PIXEL_TOKEN", "()I" ) ;
if (jintget_GL_DRAW_PIXEL_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_DRAW_PIXEL_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_DRAW_PIXEL_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_COPY_PIXEL_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_COPY_PIXEL_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_COPY_PIXEL_TOKEN", "()I" ) ;
if (jintget_GL_COPY_PIXEL_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_COPY_PIXEL_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_COPY_PIXEL_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_PASS_THROUGH_TOKEN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_PASS_THROUGH_TOKENID = curEnv->GetStaticMethodID(cls, "get_GL_PASS_THROUGH_TOKEN", "()I" ) ;
if (jintget_GL_PASS_THROUGH_TOKENID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_PASS_THROUGH_TOKEN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_PASS_THROUGH_TOKENID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_FEEDBACK (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_FEEDBACKID = curEnv->GetStaticMethodID(cls, "get_GL_FEEDBACK", "()I" ) ;
if (jintget_GL_FEEDBACKID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_FEEDBACK");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_FEEDBACKID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_COLOR_CLEAR_VALUE (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_COLOR_CLEAR_VALUEID = curEnv->GetStaticMethodID(cls, "get_GL_COLOR_CLEAR_VALUE", "()I" ) ;
if (jintget_GL_COLOR_CLEAR_VALUEID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_COLOR_CLEAR_VALUE");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_COLOR_CLEAR_VALUEID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_INDEX_CLEAR_VALUE (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_INDEX_CLEAR_VALUEID = curEnv->GetStaticMethodID(cls, "get_GL_INDEX_CLEAR_VALUE", "()I" ) ;
if (jintget_GL_INDEX_CLEAR_VALUEID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_INDEX_CLEAR_VALUE");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_INDEX_CLEAR_VALUEID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_RENDER (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_RENDERID = curEnv->GetStaticMethodID(cls, "get_GL_RENDER", "()I" ) ;
if (jintget_GL_RENDERID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_RENDER");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_RENDERID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_VIEWPORT (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_VIEWPORTID = curEnv->GetStaticMethodID(cls, "get_GL_VIEWPORT", "()I" ) ;
if (jintget_GL_VIEWPORTID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_VIEWPORT");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_VIEWPORTID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_BLEND (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_BLENDID = curEnv->GetStaticMethodID(cls, "get_GL_BLEND", "()I" ) ;
if (jintget_GL_BLENDID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_BLEND");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_BLENDID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_BLEND_SRC (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_BLEND_SRCID = curEnv->GetStaticMethodID(cls, "get_GL_BLEND_SRC", "()I" ) ;
if (jintget_GL_BLEND_SRCID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_BLEND_SRC");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_BLEND_SRCID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_BLEND_DST (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_BLEND_DSTID = curEnv->GetStaticMethodID(cls, "get_GL_BLEND_DST", "()I" ) ;
if (jintget_GL_BLEND_DSTID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_BLEND_DST");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_BLEND_DSTID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_3D_COLOR (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_3D_COLORID = curEnv->GetStaticMethodID(cls, "get_GL_3D_COLOR", "()I" ) ;
if (jintget_GL_3D_COLORID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_3D_COLOR");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_3D_COLORID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_FLOAT (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_FLOATID = curEnv->GetStaticMethodID(cls, "get_GL_FLOAT", "()I" ) ;
if (jintget_GL_FLOATID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_FLOAT");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_FLOATID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_UNSIGNED_BYTE (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_UNSIGNED_BYTEID = curEnv->GetStaticMethodID(cls, "get_GL_UNSIGNED_BYTE", "()I" ) ;
if (jintget_GL_UNSIGNED_BYTEID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_UNSIGNED_BYTE");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_UNSIGNED_BYTEID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_POINTS (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_POINTSID = curEnv->GetStaticMethodID(cls, "get_GL_POINTS", "()I" ) ;
if (jintget_GL_POINTSID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_POINTS");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_POINTSID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_POLYGON_OFFSET_FACTOR (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_POLYGON_OFFSET_FACTORID = curEnv->GetStaticMethodID(cls, "get_GL_POLYGON_OFFSET_FACTOR", "()I" ) ;
if (jintget_GL_POLYGON_OFFSET_FACTORID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_POLYGON_OFFSET_FACTOR");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_POLYGON_OFFSET_FACTORID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_POLYGON_OFFSET_UNITS (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_POLYGON_OFFSET_UNITSID = curEnv->GetStaticMethodID(cls, "get_GL_POLYGON_OFFSET_UNITS", "()I" ) ;
if (jintget_GL_POLYGON_OFFSET_UNITSID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_POLYGON_OFFSET_UNITS");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_POLYGON_OFFSET_UNITSID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_LINE_STIPPLE_PATTERN (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_LINE_STIPPLE_PATTERNID = curEnv->GetStaticMethodID(cls, "get_GL_LINE_STIPPLE_PATTERN", "()I" ) ;
if (jintget_GL_LINE_STIPPLE_PATTERNID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_LINE_STIPPLE_PATTERN");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_LINE_STIPPLE_PATTERNID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int JOGLConstant::get_GL_LINE_STIPPLE_REPEAT (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintget_GL_LINE_STIPPLE_REPEATID = curEnv->GetStaticMethodID(cls, "get_GL_LINE_STIPPLE_REPEAT", "()I" ) ;
if (jintget_GL_LINE_STIPPLE_REPEATID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get_GL_LINE_STIPPLE_REPEAT");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintget_GL_LINE_STIPPLE_REPEATID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
