/*
 * -------------------------------------------------------------------------
 * symlet.c -- Symlet wavelets coefficients.
 * SWT - Scilab wavelet toolbox
 * Copyright (C) 2005-2006  Roger Liu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * -------------------------------------------------------------------------
 */

#include "swt_common.h"
#include "dwt.h"

/*********************************************
 * Local Variable (Filter Coefficent)
 ********************************************/

static const double sym4[8] = { -0.107148901418,
				-0.041910965125,
				0.703739068656,
				1.136658243408,
				0.421234534204,
				-0.140317634179,
				-0.017824701422,
				0.045570345896
};

static const double sym5[10] = { 0.038654795955,
				 0.041746864422,
				 -0.055344186117,
				 0.281990696854,
				 1.023052966854,
				 0.896581648380,
				 0.023478923136,
				 -0.247951362613,
				 -0.029842499869,
				 0.027632152958
};

static const double sym6[12] = { 0.021784700327,
				 0.004936612372,
				 -0.166863215412,
				 -0.068323121587,
				 0.694457972958,
				 1.113892783926,
				 0.477904371333,
				 -0.102724969862,
				 -0.029783751299,
				 0.063250562660,
				 0.002499922093,
				 -0.011031867509
};

static const double sym7[14] = { 0.003792658534,
				 -0.001481225915,
				 -0.017870431651,
				 0.043155452582,
				 0.096014767936,
				 -0.070078291222,
				 0.024665659489,
				 0.758162601968,
				 1.085782709814,
				 0.408183939725,
				 -0.198056706807,
				 -0.152463871896,
				 0.005671342686,
				 0.014521394762
};

static const double sym8[16] = { 0.002672793393,
				 -0.000428394300,
				 -0.021145686528,
				 0.005386388754,
				 0.069490465911,
				 -0.038493521263,
				 -0.073462508761,
				 0.515398670374,
				 1.099106630537,
				 0.680745347190,
				 -0.086653615406,
				 -0.202648655286,
				 0.010758611751,
				 0.044823623042,
				 -0.000766690896,
				 -0.004783458512
};

static const double sym9[18] = { 0.001512487309,
				 -0.000669141509,
				 -0.014515578553,
				 0.012528896242,
				 0.087791251554,
				 -0.025786445930,
				 -0.270893783503,
				 0.049882830959,
				 0.873048407349,
				 1.015259790832,
				 0.337658923602,
				 -0.077172161097,
				 0.000825140929,
				 0.042744433602,
				 -0.016303351226,
				 -0.018769396836,
				 0.000876502539,
				 0.001981193736
};

static const double sym10[20] = { 0.001089170447,
				  0.000135245026,
				  -0.012220642630,
				  -0.002072363923,
				  0.064950924579,
				  0.016418869426,
				  -0.225558972234,
				  -0.100240215031,
				  0.667071338154,
				  1.088251530500,
				  0.542813011213,
				  -0.050256540092,
				  -0.045240772218,
				  0.070703567750,
				  0.008152816799,
				  -0.028786231936,
				  -0.001137535314,
				  0.006495728375,
				  0.000080661204,
				  -0.000649589896
};

/*********************************************
 * Global Function
 ********************************************/

void
symlets_analysis_initialize (int member, swt_wavelet *pWaveStruct)
{
  int    count;
  double *pFilterCoef;

  pWaveStruct->length = 2 * member;

  switch (member)
    {
    case 4:
      pFilterCoef = sym4;
      break;
    case 5:
      pFilterCoef = sym5;
      break;
    case 6:
      pFilterCoef = sym6;
      break;
    case 7:
      pFilterCoef = sym7;
      break;
    case 8:
      pFilterCoef = sym8;
      break;
    case 9:
      pFilterCoef = sym9;
      break;
    case 10:
      pFilterCoef = sym10;
      break;
    default:
      printf("sym%d is not available!\n",member);
      exit(0);
    }

  wrev(pFilterCoef, pWaveStruct->length,
       LowDecomFilCoef, pWaveStruct->length);
  qmf_wrev(pFilterCoef, pWaveStruct->length,
	   HiDecomFilCoef, pWaveStruct->length);
  for (count = 0; count < pWaveStruct->length; count++)
    LowDecomFilCoef[count] /= sqrt(2.0);
  for (count = 0; count < pWaveStruct->length; count++)
    HiDecomFilCoef[count] /= sqrt(2.0);
  pWaveStruct->pLowPass = LowDecomFilCoef;
  pWaveStruct->pHiPass = HiDecomFilCoef;
    
  return;
}

void
symlets_synthesis_initialize (int member, swt_wavelet *pWaveStruct)
{
  int    count;
  double *pFilterCoef;

  pWaveStruct->length = 2 * member;

  switch (member)
    {
    case 4:
      pFilterCoef = sym4;
      break;
    case 5:
      pFilterCoef = sym5;
      break;
    case 6:
      pFilterCoef = sym6;
      break;
    case 7:
      pFilterCoef = sym7;
      break;
    case 8:
      pFilterCoef = sym8;
      break;
    case 9:
      pFilterCoef = sym9;
      break;
    case 10:
      pFilterCoef = sym10;
      break;
    default:
      printf("sym%d is not available!\n",member);
      exit(0);
    }

  verbatim_copy(pFilterCoef, pWaveStruct->length,
		LowReconFilCoef, pWaveStruct->length);
  qmf_even(pFilterCoef, pWaveStruct->length,
      HiReconFilCoef, pWaveStruct->length);
  for (count = 0; count < pWaveStruct->length; count++)
    LowReconFilCoef[count] /= sqrt(2.0);
  for (count = 0; count < pWaveStruct->length; count++)
    HiReconFilCoef[count] /= sqrt(2.0);
  pWaveStruct->pLowPass = LowReconFilCoef;
  pWaveStruct->pHiPass = HiReconFilCoef;
  
  return;

}
