/*
 * -------------------------------------------------------------------------
 * dwt.h -- Declarations for wavelet functions.
 * SWT - Scilab wavelet toolbox
 * Copyright (C) 2005-2006  Roger Liu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * -------------------------------------------------------------------------
 */

#include "swt_common.h"

/*********************************************
 * Macros
 ********************************************/

#define HAAR           0
#define DAUBECHIES     1
#define COIFLETS       2
#define SYMLETS        3
#define SPLINE_BIORTH  4
#define NOT_DEFINED    99


/*********************************************
 * Wavelet Structure Declarations
 ********************************************/

typedef struct {
  int     length;
  double  *pLowPass;
  double  *pHiPass;
} swt_wavelet;

typedef void(*Func)(int member, swt_wavelet *pWaveStruct);

typedef struct {
  char  wname[20];
  int   family;
  int   member;
  Func  analysis;
  Func  synthesis;
} wavelet_identity;



/*********************************************
 * Global Variable Declaration
 ********************************************/

extern double LowDecomFilCoef[30];
extern double LowReconFilCoef[30];
extern double HiDecomFilCoef[30];
extern double HiReconFilCoef[30];
extern wavelet_identity wi[];
extern int waveletIdentityNum;
extern extend_method dwtMode;
extern extension_identity ei[];
extern int extensionIdentityNum;
extern str_error_notification strErrNoti[];


//extern wavelet_identity wi[];


/*********************************************
 * Function Prototype
 ********************************************/

extern void haar_analysis_initialize (int member, swt_wavelet *pWaveStruct);
extern void haar_synthesis_initialize (int member, swt_wavelet *pWaveStruct);
extern void daubechies_analysis_initialize (int memeber, swt_wavelet *pWaveStruct);
extern void daubechies_synthesis_initialize (int memeber, swt_wavelet *pWaveStruct);
extern void symlets_analysis_initialize (int member, swt_wavelet *pWaveStruct);
extern void symlets_synthesis_initialize (int member, swt_wavelet *pWaveStruct);
extern void coiflets_analysis_initialize (int member, swt_wavelet *pWaveStruct);
extern void coiflets_synthesis_initialize (int member, swt_wavelet *pWaveStruct);
extern void sp_bior_analysis_initialize (int member, swt_wavelet *pWaveStruct);
extern void sp_bior_synthesis_initialize (int member, swt_wavelet *pWaveStruct);

/*------------------------------------------*/
/* Wavelet Family Function                  */
/* -----------------------------------------*/
extern void filter_clear ();
extern void orth_filt_group (double *filterIn, int sigInLength,
			     double *filterLowRec, 
			     double *filterLowDec,
			     double *filterHiRec, 
			     double *filterHiDec);
extern void bior_filt_group (double *f1, int sigInLength1, 
			     double *f2, int sigInLength2, 
			     double *lowDecom, int sigOutLength1, 
			     double *hiDecom, int sigOutLength2,
			     double *lowRecon, int sigOutLength3, 
			     double *hiRecon, int sigOutLength4);
extern void wavelet_parser (char *wname, int *family, int *member);
extern void wavelet_fun_parser (char *wname, int *ii);
extern void wave_len_validate (int sigInLen, int waveLength, int *lev, int *val);
extern void dwt_print();
extern void dwt_write (char *mode, int *errCode);
extern void dwt_parse(char **strr);
extern void dwt (double *sigIn, int sigInLength, double *lowDe, 
		 double *hiDe, int filterLen, double *approx, 
		 double *detail, int sigOutLength, 
		 extend_method extMethod);
extern void dwt_neo (double *sigIn, int sigInLength, double *lowDe, 
		 double *hiDe, int filterLen, double *approx, 
		 double *detail, int sigOutLength, 
		 extend_method extMethod);
extern void dwt_nex (double *sigIn, int sigInLength, double *lowDe, 
		     double *hiDe, int filterLen, double *approx, 
		     double *detail, int sigOutLength);
extern void dwt_no_extension (double *sigIn, int sigInLength, double *lowDe, 
     double *hiDe, int filterLen, double *approx, 
     double *detail, int sigOutLength);
extern void dwt_conv (double *sigIn, int sigInLength, double *lowDe, 
     double *hiDe, int filterLen, double *approx, 
     double *detail, int sigOutLength);
extern void idwt_complete (double *approx, double *detail, 
			   int sigInLength, double *lowRe, 
			   double *hiRe, int filterLen, 
			   double *sigOut, int sigOutLength);
extern void idwt_neo (double *approx, double *detail, 
			   int sigInLength, double *lowRe, 
			   double *hiRe, int filterLen, 
			   double *sigOut, int sigOutLength);
extern void idwt_complete_ex (double *approx, double *detail, 
			      int sigInLength, double *lowRe, 
			      double *hiRe, int filterLen, 
			      double *sigOut, int sigOutLength, 
			      extend_method extMethod);
extern void idwt_approx (double *approx, int sigInLength, 
			 double *lowRe, int filterLen, 
			 double *sigOut, int sigOutLength);
extern void idwt_approx_ex (double *approx, int sigInLength, 
			    double *lowRe, int filterLen, 
			    double *sigOut, int sigOutLength,
			    extend_method extMethod); 
extern void idwt_approx_neo (double *approx, int sigInLength, 
			    double *lowRe, int filterLen, 
			    double *sigOut, int sigOutLength);
extern void idwt_detail (double *detail, int sigInLength, 
			 double *hiRe, int filterLen, 
			 double *sigOut, int sigOutLength);
extern void idwt_detail_ex (double *detail, int sigInLength, 
			    double *hiRe, int filterLen, 
			    double *sigOut, int sigOutLength,
			    extend_method extMethod); 
extern void idwt_detail_neo (double *detail, int sigInLength, 
			    double *hiRe, int filterLen, 
			    double *sigOut, int sigOutLength); 
extern void wave_dec_len_cal (int filterLen, int sigLength,
			      int stride, int *waveDecLengthArray);
extern void wavedec (double *sigIn, int sigInLength, double *sigOut, 
		     int sigOutLength, double *lowDe, double *hiDe,
		     int filterLen, int *waveDecLengthArray, 
		     int lengthArrayLengh, int stride, 
		     extend_method extMethod);
extern void waverec (double *sigIn, int sigInLength, double *sigOut, 
		     int sigOutLength, double *lowRe, double *hiRe, 
		     int filterLen, int *waveDecLengthArray,
		     int lengthArraylength, int stride, 
		     extend_method extMethod);
extern void wenergy (double *coef, int coefLen, int *lenArray, 
		     int arrayLen, double *aE, int aELen, 
		     double *dE, int dELen);
extern void detcoef (double *sigIn, int sigInLength, 
		     int *waveDecLengthArray, int arrayLen, 
		     double *sigOut, int sigOutLength, 
		     int stride, int level);
extern void appcoef (double *sigIn, int sigInLength, double *sigOut, 
		     int sigOutLength, double *lowRe, double *hiRe, 
		     int filterLen, int *waveDecLengthArray,
		     int lengthArraylength, int stride, int level, 
		     extend_method extMethod);
extern void wrcoef (double *sigIn, int sigInLength, double *lowRe, 
		    double *hiRe, int filterLen, 
		    int *waveDecLengthArray, int arrayLen,
		    double *sigOut, int sigOutLength, 
		    char *coefType, int stride, int level, 
		    extend_method extMethod);
extern void upcoef_len_cal (int sigInLength, int filterLen, 
			    int stride, int *sigOutLength,
			    int *sigOutLengthDefault);
extern void upwlev (double *coefArray, int coefLen, 
		    int *waveDecLengthArray,	int arrayLen, 
		    double *lowRe, double *hiRe, int filterLen,
		    double *newCoefArray, int newCoefLen, 
		    int *newLenArray, int newArrayLen, 
		    double *approx, int approxLen, int stride,
		    extend_method extMethod);
extern void upcoef (double *sigIn, int sigInLength, double *lowRe,
		    double *hiRe, int filterLen, double *sigOut, 
		    int sigOutLength, int defaultLength, 
		    char *coefType, int step);
extern void dwt2D (double *matrixIn, int matrixInRow, 
		   int matrixInCol, double *matrixOutApprox, 
		   double *matrixOutColDetail, 
		   double *matrixOutRowDetail, 
		   double *matrixOutDetail, int matrixOutRow, 
		   int matrixOutCol, double *lowDe, double *hiDe, 
		   int filterLen, extend_method extMethod);
extern void dwt2D_neo (double *matrixIn, int matrixInRow, 
		   int matrixInCol, double *matrixOutApprox, 
		   double *matrixOutColDetail, 
		   double *matrixOutRowDetail, 
		   double *matrixOutDetail, int matrixOutRow, 
		   int matrixOutCol, double *lowDe, double *hiDe, 
		   int filterLen, extend_method extMethod);
extern void idwt2D (double *matrixInApprox, 
		    double *matrixInColDetail,
		    double *matrixInRowDetail, 
		    double *matrixInDetail,
		    int matrixInRow, int matrixInCol, double *lowRe,
		    double *hiRe, int filterLen, double *matrixOut,
		    int matrixOutRow, int matrixOutCol, 
		    extend_method extMethod);
extern void idwt2D_neo (double *matrixInApprox, double *matrixInColDetail,
	double *matrixInRowDetail, double *matrixInDetail,
	int matrixInRow, int matrixInCol, double *lowRe,
	double *hiRe, int filterLen, double *matrixOut,
	int matrixOutRow, int matrixOutCol);
extern void wave_mem_cal (int *pLen, int stride, int *total);
extern void matrix_wavedec_len_cal (int matrixInRow, int matrixInCol,
				    int stride, int filterLen, 
				    int *pLen);
extern void matrix_locate (int stride, int *pLen, int *pH, 
			   int *pV, int *pD);
extern void wavedec2 (double *matrixIn, int matrixInRow, 
		      int matrixInCol, double *lowDe, double *hiDe, 
		      int filterLen, int *pLen, double *coef, 
		      int sigOutLength, int stride, 
		      extend_method extMethod);
extern void waverec2 (double *coef, int sigInLength, double *lowRe, 
		      double *hiRe, int filterLen, double *matrixOut,
		      int matrixOutRow, int matrixOutCol, int *pLen, 
		      int stride, extend_method extMethod);
extern void wenergy_2output (double *coef, int sigInLength, 
			    int *pLen, double *ae, double *de, 
			    int deLength, int stride);
extern void wenergy_4output (double *coef, int sigInLength, 
			     int *pLen, double *ae, double *he, 
			     double *ve, double *de, int deLength, 
			     int stride);
extern void detcoef2 (double *coef, int sigInLength, double *coefOut,
		      int sigOutLength, int *pLen, int stride, 
		      int level, char *coefType);
extern void appcoef2 (double *coef, int sigInLength, double *lowRe, 
		      double *hiRe, int filterLen, double *coefOut, 
		      int matrixOutRow, int matrixOutCol, int *pLen, 
		      int stride, int level, extend_method extMethod);
extern void wrcoef2 (double *coef, int sigInLength, double *lowRe, 
		     double *hiRe, int filterLen, double *matrixOut, 
		     int matrixOutRow, int matrixOutCol, int *pLen, 
		     int stride, int level, char *type, 
		     extend_method extMethod);
extern void upwlev2 (double *coef, int sigInLength, double *lowRe, 
		     double *hiRe,
	 int filterLen, int *pLen, int matrixRow, int matrixCol,
	 double *approx, int approxLen, double *newCoef, 
	 int newCoefLen, int *newLenMatrix, int lenMatrixRow, 
	 int lenMatrixCol, int stride, extend_method extMethod);
extern void upcoef2 (double *matrixIn, int matrixInRow, 
		     int matrixInCol, double *lowRe, double *hiRe, 
		     int filterLen, double *matrixOut, 
		     int matrixOutRow, int matrixOutCol,
		     int matrixOutDefaultRow, 
		     int matrixOutDefaultCol,
		     int step, char *type, extend_method extMethod);
