/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_get_character_set_info(char * fname)
{
  int * sql_pointer_in = NULL;
  int * extra = NULL;

  MYSQL * mysql_ptr_in = NULL;
  MY_CHARSET_INFO cs;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double dbl_tmp = 0;

  const char * FieldNames[] = {"mysql_cs", 
			       "number",      /* character set number              */
			       "state",       /* character set state               */
			       "csname",      /* collation name                    */
			       "name",        /* character set name                */
			       "comment",     /* comment                           */
			       "dir",         /* character set directory           */
			       "mbminlen",    /* min. length for multibyte strings */
			       "mbmaxlen"};   /* max. length for multibyte strings */

  CheckRhs(1,1);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr_in = (MYSQL *)ptr_in;

  if (mysql_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  mysql_get_character_set_info(mysql_ptr_in, &cs);

  _SciErr = createMList(pvApiCtx, Rhs+1, 9, &extra);
  // Add the fields
  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 1, 1, 9, (char **)FieldNames);

  dbl_tmp = (double)cs.number;
  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 2, 1, 1, &dbl_tmp);

  dbl_tmp = (double)cs.state;
  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 3, 1, 1, &dbl_tmp);

  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 4, 1, 1, (char **)&cs.csname);

  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 5, 1, 1, (char **)&cs.name);
  
  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 6, 1, 1, (char **)&cs.comment);

  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 7, 1, 1, (char **)&cs.dir);

  dbl_tmp = (double)cs.mbminlen;
  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 8, 1, 1, &dbl_tmp);

  dbl_tmp = (double)cs.mbmaxlen;
  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 9, 1, 1, &dbl_tmp);

  LhsVar(1) = Rhs+1;

  return 0;
}
