// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009-2010 - DIGITEO - Yann COLLETTE
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//
function err_list = mysql_err_var()

err_list = mlist(['mysql_err', ...
                  'CR_MIN_ERROR', ...
		  'CR_ERROR_FIRST', ...
		  'CR_UNKNOWN_ERROR', ...
		  'CR_SOCKET_CREATE_ERROR', ...
		  'CR_CONNECTION_ERROR', ...
		  'CR_CONN_HOST_ERROR', ...
		  'CR_IPSOCK_ERROR', ...
		  'CR_UNKNOWN_HOST', ...
		  'CR_SERVER_GONE_ERROR', ...
		  'CR_VERSION_ERROR', ...
		  'CR_OUT_OF_MEMORY', ...
		  'CR_WRONG_HOST_INFO', ...
		  'CR_LOCALHOST_CONNECTION', ...
		  'CR_TCP_CONNECTION', ...
		  'CR_SERVER_HANDSHAKE_ERR', ...
		  'CR_SERVER_LOST', ...
		  'CR_COMMANDS_OUT_OF_SYNC', ...
		  'CR_NAMEDPIPE_CONNECTION', ...
		  'CR_NAMEDPIPEWAIT_ERROR', ...
		  'CR_NAMEDPIPEOPEN_ERROR', ...
		  'CR_NAMEDPIPESETSTATE_ERROR', ...
		  'CR_CANT_READ_CHARSET', ...
		  'CR_NET_PACKET_TOO_LARGE', ...
		  'CR_EMBEDDED_CONNECTION', ...
		  'CR_PROBE_SLAVE_STATUS', ...
		  'CR_PROBE_SLAVE_HOSTS', ...
		  'CR_PROBE_SLAVE_CONNECT', ...
		  'CR_PROBE_MASTER_CONNECT', ...
		  'CR_SSL_CONNECTION_ERROR', ...
		  'CR_MALFORMED_PACKET', ...
		  'CR_WRONG_LICENSE', ...
		  'CR_NULL_POINTER', ...
		  'CR_NO_PREPARE_STMT', ...
		  'CR_PARAMS_NOT_BOUND', ...
		  'CR_DATA_TRUNCATED', ...
		  'CR_NO_PARAMETERS_EXISTS', ...
		  'CR_INVALID_PARAMETER_NO', ...
		  'CR_INVALID_BUFFER_USE', ...
		  'CR_UNSUPPORTED_PARAM_TYPE', ...
		  'CR_SHARED_MEMORY_CONNECTION', ...
		  'CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR', ...
		  'CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR', ...
		  'CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR', ...
		  'CR_SHARED_MEMORY_CONNECT_MAP_ERROR', ...
		  'CR_SHARED_MEMORY_FILE_MAP_ERROR', ...
		  'CR_SHARED_MEMORY_MAP_ERROR', ...
		  'CR_SHARED_MEMORY_EVENT_ERROR', ...
		  'CR_SHARED_MEMORY_CONNECT_ABANDONED_ERROR', ...
		  'CR_SHARED_MEMORY_CONNECT_SET_ERROR', ...
		  'CR_CONN_UNKNOW_PROTOCOL', ...
		  'CR_INVALID_CONN_HANDLE', ...
		  'CR_SECURE_AUTH', ...
		  'CR_FETCH_CANCELED', ...
		  'CR_NO_DATA', ...
		  'CR_NO_STMT_METADATA', ...
		  'CR_NO_RESULT_SET', ...
		  'CR_NOT_IMPLEMENTED', ...
		  'CR_SERVER_LOST_EXTENDED', ...
		  'CR_STMT_CLOSED', ...
		  'CR_NEW_STMT_METADATA', ...
		  'CR_ERROR_LAST', ...
		  'CR_MAX_ERROR', ...
		  'ER_ERROR_FIRST', ...
		  'ER_HASHCHK', ...
		  'ER_NISAMCHK', ...
		  'ER_NO', ...
		  'ER_YES', ...
		  'ER_CANT_CREATE_FILE', ...
		  'ER_CANT_CREATE_TABLE', ...
		  'ER_CANT_CREATE_DB', ...
		  'ER_DB_CREATE_EXISTS', ...
		  'ER_DB_DROP_EXISTS', ...
		  'ER_DB_DROP_DELETE', ...
		  'ER_DB_DROP_RMDIR', ...
		  'ER_CANT_DELETE_FILE', ...
		  'ER_CANT_FIND_SYSTEM_REC', ...
		  'ER_CANT_GET_STAT', ...
		  'ER_CANT_GET_WD', ...
		  'ER_CANT_LOCK', ...
		  'ER_CANT_OPEN_FILE', ...
		  'ER_FILE_NOT_FOUND', ...
		  'ER_CANT_READ_DIR', ...
		  'ER_CANT_SET_WD', ...
		  'ER_CHECKREAD', ...
		  'ER_DISK_FULL', ...
		  'ER_DUP_KEY', ...
		  'ER_ERROR_ON_CLOSE', ...
		  'ER_ERROR_ON_READ', ...
		  'ER_ERROR_ON_RENAME', ...
		  'ER_ERROR_ON_WRITE', ...
		  'ER_FILE_USED', ...
		  'ER_FILSORT_ABORT', ...
		  'ER_FORM_NOT_FOUND', ...
		  'ER_GET_ERRNO', ...
		  'ER_ILLEGAL_HA', ...
		  'ER_KEY_NOT_FOUND', ...
		  'ER_NOT_FORM_FILE', ...
		  'ER_NOT_KEYFILE', ...
		  'ER_OLD_KEYFILE', ...
		  'ER_OPEN_AS_READONLY', ...
		  'ER_OUTOFMEMORY', ...
		  'ER_OUT_OF_SORTMEMORY', ...
		  'ER_UNEXPECTED_EOF', ...
		  'ER_CON_COUNT_ERROR', ...
		  'ER_OUT_OF_RESOURCES', ...
		  'ER_BAD_HOST_ERROR', ...
		  'ER_HANDSHAKE_ERROR', ...
		  'ER_DBACCESS_DENIED_ERROR', ...
		  'ER_ACCESS_DENIED_ERROR', ...
		  'ER_NO_DB_ERROR', ...
		  'ER_UNKNOWN_COM_ERROR', ...
		  'ER_BAD_NULL_ERROR', ...
		  'ER_BAD_DB_ERROR', ...
		  'ER_TABLE_EXISTS_ERROR', ...
		  'ER_BAD_TABLE_ERROR', ...
		  'ER_NON_UNIQ_ERROR', ...
		  'ER_SERVER_SHUTDOWN', ...
		  'ER_BAD_FIELD_ERROR', ...
		  'ER_WRONG_FIELD_WITH_GROUP', ...
		  'ER_WRONG_GROUP_FIELD', ...
		  'ER_WRONG_SUM_SELECT', ...
		  'ER_WRONG_VALUE_COUNT', ...
		  'ER_TOO_LONG_IDENT', ...
		  'ER_DUP_FIELDNAME', ...
		  'ER_DUP_KEYNAME', ...
		  'ER_DUP_ENTRY', ...
		  'ER_WRONG_FIELD_SPEC', ...
		  'ER_PARSE_ERROR', ...
		  'ER_EMPTY_QUERY', ...
		  'ER_NONUNIQ_TABLE', ...
		  'ER_INVALID_DEFAULT', ...
		  'ER_MULTIPLE_PRI_KEY', ...
		  'ER_TOO_MANY_KEYS', ...
		  'ER_TOO_MANY_KEY_PARTS', ...
		  'ER_TOO_LONG_KEY', ...
		  'ER_KEY_COLUMN_DOES_NOT_EXITS', ...
		  'ER_BLOB_USED_AS_KEY', ...
		  'ER_TOO_BIG_FIELDLENGTH', ...
		  'ER_WRONG_AUTO_KEY', ...
		  'ER_READY', ...
		  'ER_NORMAL_SHUTDOWN', ...
		  'ER_GOT_SIGNAL', ...
		  'ER_SHUTDOWN_COMPLETE', ...
		  'ER_FORCING_CLOSE', ... 
		  'ER_IPSOCK_ERROR', ...
		  'ER_NO_SUCH_INDEX', ...
		  'ER_WRONG_FIELD_TERMINATORS', ...
		  'ER_BLOBS_AND_NO_TERMINATED', ...
		  'ER_TEXTFILE_NOT_READABLE', ...
		  'ER_FILE_EXISTS_ERROR', ...
		  'ER_LOAD_INFO', ...
		  'ER_ALTER_INFO', ...
		  'ER_WRONG_SUB_KEY', ...
		  'ER_CANT_REMOVE_ALL_FIELDS', ...
		  'ER_CANT_DROP_FIELD_OR_KEY', ...
		  'ER_INSERT_INFO', ...
		  'ER_UPDATE_TABLE_USED', ...
		  'ER_NO_SUCH_THREAD', ...
		  'ER_KILL_DENIED_ERROR', ...
		  'ER_NO_TABLES_USED', ...
		  'ER_TOO_BIG_SET', ...
		  'ER_NO_UNIQUE_LOGFILE', ...
		  'ER_TABLE_NOT_LOCKED_FOR_WRITE', ...
		  'ER_TABLE_NOT_LOCKED', ...
		  'ER_BLOB_CANT_HAVE_DEFAULT', ...
		  'ER_WRONG_DB_NAME', ...
		  'ER_WRONG_TABLE_NAME', ...
		  'ER_TOO_BIG_SELECT', ...
		  'ER_UNKNOWN_ERROR', ...
		  'ER_UNKNOWN_PROCEDURE', ...
		  'ER_WRONG_PARAMCOUNT_TO_PROCEDURE', ...
		  'ER_WRONG_PARAMETERS_TO_PROCEDURE', ...
		  'ER_UNKNOWN_TABLE', ...
		  'ER_FIELD_SPECIFIED_TWICE', ...
		  'ER_INVALID_GROUP_FUNC_USE', ...
		  'ER_UNSUPPORTED_EXTENSION', ...
		  'ER_TABLE_MUST_HAVE_COLUMNS', ...
		  'ER_RECORD_FILE_FULL', ...
		  'ER_UNKNOWN_CHARACTER_SET', ...
		  'ER_TOO_MANY_TABLES', ...
		  'ER_TOO_MANY_FIELDS', ...
		  'ER_TOO_BIG_ROWSIZE', ...
		  'ER_STACK_OVERRUN', ...
		  'ER_WRONG_OUTER_JOIN', ...
		  'ER_NULL_COLUMN_IN_INDEX', ...
		  'ER_CANT_FIND_UDF', ...
		  'ER_CANT_INITIALIZE_UDF', ...
		  'ER_UDF_NO_PATHS', ...
		  'ER_UDF_EXISTS', ...
		  'ER_CANT_OPEN_LIBRARY', ...
		  'ER_CANT_FIND_DL_ENTRY', ...
		  'ER_FUNCTION_NOT_DEFINED', ...
		  'ER_HOST_IS_BLOCKED', ...
		  'ER_HOST_NOT_PRIVILEGED', ...
		  'ER_PASSWORD_ANONYMOUS_USER', ...
		  'ER_PASSWORD_NOT_ALLOWED', ...
		  'ER_PASSWORD_NO_MATCH', ...
		  'ER_UPDATE_INFO', ...
		  'ER_CANT_CREATE_THREAD', ...
		  'ER_WRONG_VALUE_COUNT_ON_ROW', ...
		  'ER_CANT_REOPEN_TABLE', ...
		  'ER_INVALID_USE_OF_NULL', ...
		  'ER_REGEXP_ERROR', ...
		  'ER_MIX_OF_GROUP_FUNC_AND_FIELDS', ...
		  'ER_NONEXISTING_GRANT', ...
		  'ER_TABLEACCESS_DENIED_ERROR', ...
		  'ER_COLUMNACCESS_DENIED_ERROR', ...
		  'ER_ILLEGAL_GRANT_FOR_TABLE', ...
		  'ER_GRANT_WRONG_HOST_OR_USER', ...
		  'ER_NO_SUCH_TABLE', ...
		  'ER_NONEXISTING_TABLE_GRANT', ...
		  'ER_NOT_ALLOWED_COMMAND', ...
		  'ER_SYNTAX_ERROR', ...
		  'ER_DELAYED_CANT_CHANGE_LOCK', ...
		  'ER_TOO_MANY_DELAYED_THREADS', ...
		  'ER_ABORTING_CONNECTION', ...
		  'ER_NET_PACKET_TOO_LARGE', ...
		  'ER_NET_READ_ERROR_FROM_PIPE', ...
		  'ER_NET_FCNTL_ERROR', ...
		  'ER_NET_PACKETS_OUT_OF_ORDER', ...
		  'ER_NET_UNCOMPRESS_ERROR', ...
		  'ER_NET_READ_ERROR', ...
		  'ER_NET_READ_INTERRUPTED', ...
		  'ER_NET_ERROR_ON_WRITE', ...
		  'ER_NET_WRITE_INTERRUPTED', ...
		  'ER_TOO_LONG_STRING', ...
		  'ER_TABLE_CANT_HANDLE_BLOB', ...
		  'ER_TABLE_CANT_HANDLE_AUTO_INCREMENT', ...
		  'ER_DELAYED_INSERT_TABLE_LOCKED', ...
		  'ER_WRONG_COLUMN_NAME', ...
		  'ER_WRONG_KEY_COLUMN', ...
		  'ER_WRONG_MRG_TABLE', ...
		  'ER_DUP_UNIQUE', ...
		  'ER_BLOB_KEY_WITHOUT_LENGTH', ...
		  'ER_PRIMARY_CANT_HAVE_NULL', ...
		  'ER_TOO_MANY_ROWS', ...
		  'ER_REQUIRES_PRIMARY_KEY', ...
		  'ER_NO_RAID_COMPILED', ...
		  'ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE', ...
		  'ER_KEY_DOES_NOT_EXITS', ...
		  'ER_CHECK_NO_SUCH_TABLE', ...
		  'ER_CHECK_NOT_IMPLEMENTED', ...
		  'ER_CANT_DO_THIS_DURING_AN_TRANSACTION', ...
		  'ER_ERROR_DURING_COMMIT', ...
		  'ER_ERROR_DURING_ROLLBACK', ...
		  'ER_ERROR_DURING_FLUSH_LOGS', ...
		  'ER_ERROR_DURING_CHECKPOINT', ...
		  'ER_NEW_ABORTING_CONNECTION', ...
		  'ER_DUMP_NOT_IMPLEMENTED', ...
		  'ER_FLUSH_MASTER_BINLOG_CLOSED', ...
		  'ER_INDEX_REBUILD', ...
		  'ER_MASTER', ...
		  'ER_MASTER_NET_READ', ...
		  'ER_MASTER_NET_WRITE', ...
		  'ER_FT_MATCHING_KEY_NOT_FOUND', ...
		  'ER_LOCK_OR_ACTIVE_TRANSACTION', ...
		  'ER_UNKNOWN_SYSTEM_VARIABLE', ...
		  'ER_CRASHED_ON_USAGE', ...
		  'ER_CRASHED_ON_REPAIR', ...
		  'ER_WARNING_NOT_COMPLETE_ROLLBACK', ...
		  'ER_TRANS_CACHE_FULL', ...
		  'ER_SLAVE_MUST_STOP', ...
		  'ER_SLAVE_NOT_RUNNING', ...
		  'ER_BAD_SLAVE', ...
		  'ER_MASTER_INFO', ...
		  'ER_SLAVE_THREAD', ...
		  'ER_TOO_MANY_USER_CONNECTIONS', ...
		  'ER_SET_CONSTANTS_ONLY', ...
		  'ER_LOCK_WAIT_TIMEOUT', ...
		  'ER_LOCK_TABLE_FULL', ...
		  'ER_READ_ONLY_TRANSACTION', ...
		  'ER_DROP_DB_WITH_READ_LOCK', ...
		  'ER_CREATE_DB_WITH_READ_LOCK', ...
		  'ER_WRONG_ARGUMENTS', ...
		  'ER_NO_PERMISSION_TO_CREATE_USER', ...
		  'ER_UNION_TABLES_IN_DIFFERENT_DIR', ...
		  'ER_LOCK_DEADLOCK', ...
		  'ER_TABLE_CANT_HANDLE_FT', ...
		  'ER_CANNOT_ADD_FOREIGN', ...
		  'ER_NO_REFERENCED_ROW', ...
		  'ER_ROW_IS_REFERENCED', ...
		  'ER_CONNECT_TO_MASTER', ...
		  'ER_QUERY_ON_MASTER', ...
		  'ER_ERROR_WHEN_EXECUTING_COMMAND', ...
		  'ER_WRONG_USAGE', ...
		  'ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT', ...
		  'ER_CANT_UPDATE_WITH_READLOCK', ...
		  'ER_MIXING_NOT_ALLOWED', ...
		  'ER_DUP_ARGUMENT', ...
		  'ER_USER_LIMIT_REACHED', ...
		  'ER_SPECIFIC_ACCESS_DENIED_ERROR', ...
		  'ER_LOCAL_VARIABLE', ...
		  'ER_GLOBAL_VARIABLE', ...
		  'ER_NO_DEFAULT', ...
		  'ER_WRONG_VALUE_FOR_VAR', ...
		  'ER_WRONG_TYPE_FOR_VAR', ...
		  'ER_VAR_CANT_BE_READ', ...
		  'ER_CANT_USE_OPTION_HERE', ...
		  'ER_NOT_SUPPORTED_YET', ...
		  'ER_MASTER_FATAL_ERROR_READING_BINLOG', ...
		  'ER_SLAVE_IGNORED_TABLE', ...
		  'ER_INCORRECT_GLOBAL_LOCAL_VAR', ...
		  'ER_WRONG_FK_DEF', ...
		  'ER_KEY_REF_DO_NOT_MATCH_TABLE_REF', ...
		  'ER_OPERAND_COLUMNS', ...
		  'ER_SUBQUERY_NO_1_ROW', ...
		  'ER_UNKNOWN_STMT_HANDLER', ...
		  'ER_CORRUPT_HELP_DB', ...
		  'ER_CYCLIC_REFERENCE', ...
		  'ER_AUTO_CONVERT', ...
		  'ER_ILLEGAL_REFERENCE', ...
		  'ER_DERIVED_MUST_HAVE_ALIAS', ...
		  'ER_SELECT_REDUCED', ...
		  'ER_TABLENAME_NOT_ALLOWED_HERE', ...
		  'ER_NOT_SUPPORTED_AUTH_MODE', ...
		  'ER_SPATIAL_CANT_HAVE_NULL', ...
		  'ER_COLLATION_CHARSET_MISMATCH', ...
		  'ER_SLAVE_WAS_RUNNING', ...
		  'ER_SLAVE_WAS_NOT_RUNNING', ...
		  'ER_TOO_BIG_FOR_UNCOMPRESS', ...
		  'ER_ZLIB_Z_MEM_ERROR', ...
		  'ER_ZLIB_Z_BUF_ERROR', ...
		  'ER_ZLIB_Z_DATA_ERROR', ...
		  'ER_CUT_VALUE_GROUP_CONCAT', ...
		  'ER_WARN_TOO_FEW_RECORDS', ...
		  'ER_WARN_TOO_MANY_RECORDS', ...
		  'ER_WARN_NULL_TO_NOTNULL', ...
		  'ER_WARN_DATA_OUT_OF_RANGE', ...
		  'WARN_DATA_TRUNCATED', ...
		  'ER_WARN_USING_OTHER_HANDLER', ...
		  'ER_CANT_AGGREGATE_2COLLATIONS', ...
		  'ER_DROP_USER', ...
		  'ER_REVOKE_GRANTS', ...
		  'ER_CANT_AGGREGATE_3COLLATIONS', ...
		  'ER_CANT_AGGREGATE_NCOLLATIONS', ...
		  'ER_VARIABLE_IS_NOT_STRUCT', ...
		  'ER_UNKNOWN_COLLATION', ...
		  'ER_SLAVE_IGNORED_SSL_PARAMS', ...
		  'ER_SERVER_IS_IN_SECURE_AUTH_MODE', ...
		  'ER_WARN_FIELD_RESOLVED', ...
		  'ER_BAD_SLAVE_UNTIL_COND', ...
		  'ER_MISSING_SKIP_SLAVE', ...
		  'ER_UNTIL_COND_IGNORED', ...
		  'ER_WRONG_NAME_FOR_INDEX', ...
		  'ER_WRONG_NAME_FOR_CATALOG', ...
		  'ER_WARN_QC_RESIZE', ...
		  'ER_BAD_FT_COLUMN', ...
		  'ER_UNKNOWN_KEY_CACHE', ...
		  'ER_WARN_HOSTNAME_WONT_WORK', ...
		  'ER_UNKNOWN_STORAGE_ENGINE', ...
		  'ER_WARN_DEPRECATED_SYNTAX', ...
		  'ER_NON_UPDATABLE_TABLE', ...
		  'ER_FEATURE_DISABLED', ...
		  'ER_OPTION_PREVENTS_STATEMENT', ...
		  'ER_DUPLICATED_VALUE_IN_TYPE', ...
		  'ER_TRUNCATED_WRONG_VALUE', ...
		  'ER_TOO_MUCH_AUTO_TIMESTAMP_COLS', ...
		  'ER_INVALID_ON_UPDATE', ...
		  'ER_UNSUPPORTED_PS', ...
		  'ER_GET_ERRMSG', ...
		  'ER_GET_TEMPORARY_ERRMSG', ...
		  'ER_UNKNOWN_TIME_ZONE', ...
		  'ER_WARN_INVALID_TIMESTAMP', ...
		  'ER_INVALID_CHARACTER_STRING', ...
		  'ER_WARN_ALLOWED_PACKET_OVERFLOWED', ...
		  'ER_CONFLICTING_DECLARATIONS', ...
		  'ER_SP_NO_RECURSIVE_CREATE', ...
		  'ER_SP_ALREADY_EXISTS', ...
		  'ER_SP_DOES_NOT_EXIST', ...
		  'ER_SP_DROP_FAILED', ...
		  'ER_SP_STORE_FAILED', ...
		  'ER_SP_LILABEL_MISMATCH', ...
		  'ER_SP_LABEL_REDEFINE', ...
		  'ER_SP_LABEL_MISMATCH', ...
		  'ER_SP_UNINIT_VAR', ...
		  'ER_SP_BADSELECT', ...
		  'ER_SP_BADRETURN', ...
		  'ER_SP_BADSTATEMENT', ...
		  'ER_UPDATE_LOG_DEPRECATED_IGNORED', ...
		  'ER_UPDATE_LOG_DEPRECATED_TRANSLATED', ...
		  'ER_QUERY_INTERRUPTED', ...
		  'ER_SP_WRONG_NO_OF_ARGS', ...
		  'ER_SP_COND_MISMATCH', ...
		  'ER_SP_NORETURN', ...
		  'ER_SP_NORETURNEND', ...
		  'ER_SP_BAD_CURSOR_QUERY', ...
		  'ER_SP_BAD_CURSOR_SELECT', ...
		  'ER_SP_CURSOR_MISMATCH', ...
		  'ER_SP_CURSOR_ALREADY_OPEN', ...
		  'ER_SP_CURSOR_NOT_OPEN', ...
		  'ER_SP_UNDECLARED_VAR', ...
		  'ER_SP_WRONG_NO_OF_FETCH_ARGS', ...
		  'ER_SP_FETCH_NO_DATA', ...
		  'ER_SP_DUP_PARAM', ...
		  'ER_SP_DUP_VAR', ...
		  'ER_SP_DUP_COND', ...
		  'ER_SP_DUP_CURS', ...
		  'ER_SP_CANT_ALTER', ...
		  'ER_SP_SUBSELECT_NYI', ...
		  'ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG', ...
		  'ER_SP_VARCOND_AFTER_CURSHNDLR', ...
		  'ER_SP_CURSOR_AFTER_HANDLER', ...
		  'ER_SP_CASE_NOT_FOUND', ...
		  'ER_FPARSER_TOO_BIG_FILE', ...
		  'ER_FPARSER_BAD_HEADER', ...
		  'ER_FPARSER_EOF_IN_COMMENT', ...
		  'ER_FPARSER_ERROR_IN_PARAMETER', ...
		  'ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER', ...
		  'ER_VIEW_NO_EXPLAIN', ...
		  'ER_FRM_UNKNOWN_TYPE', ...
		  'ER_WRONG_OBJECT', ...
		  'ER_NONUPDATEABLE_COLUMN', ...
		  'ER_VIEW_SELECT_DERIVED', ...
		  'ER_VIEW_SELECT_CLAUSE', ...
		  'ER_VIEW_SELECT_VARIABLE', ...
		  'ER_VIEW_SELECT_TMPTABLE', ...
		  'ER_VIEW_WRONG_LIST', ...
		  'ER_WARN_VIEW_MERGE', ...
		  'ER_WARN_VIEW_WITHOUT_KEY', ...
		  'ER_VIEW_INVALID', ...
		  'ER_SP_NO_DROP_SP', ...
		  'ER_SP_GOTO_IN_HNDLR', ...
		  'ER_TRG_ALREADY_EXISTS', ...
		  'ER_TRG_DOES_NOT_EXIST', ...
		  'ER_TRG_ON_VIEW_OR_TEMP_TABLE', ...
		  'ER_TRG_CANT_CHANGE_ROW', ...
		  'ER_TRG_NO_SUCH_ROW_IN_TRG', ...
		  'ER_NO_DEFAULT_FOR_FIELD', ...
		  'ER_DIVISION_BY_ZERO', ...
		  'ER_TRUNCATED_WRONG_VALUE_FOR_FIELD', ...
		  'ER_ILLEGAL_VALUE_FOR_TYPE', ...
		  'ER_VIEW_NONUPD_CHECK', ...
		  'ER_VIEW_CHECK_FAILED', ...
		  'ER_PROCACCESS_DENIED_ERROR', ...
		  'ER_RELAY_LOG_FAIL', ...
		  'ER_PASSWD_LENGTH', ...
		  'ER_UNKNOWN_TARGET_BINLOG', ...
		  'ER_IO_ERR_LOG_INDEX_READ', ...
		  'ER_BINLOG_PURGE_PROHIBITED', ...
		  'ER_FSEEK_FAIL', ...
		  'ER_BINLOG_PURGE_FATAL_ERR', ...
		  'ER_LOG_IN_USE', ...
		  'ER_LOG_PURGE_UNKNOWN_ERR', ...
		  'ER_RELAY_LOG_INIT', ...
		  'ER_NO_BINARY_LOGGING', ...
		  'ER_RESERVED_SYNTAX', ...
		  'ER_WSAS_FAILED', ...
		  'ER_DIFF_GROUPS_PROC', ...
		  'ER_NO_GROUP_FOR_PROC', ...
		  'ER_ORDER_WITH_PROC', ...
		  'ER_LOGGING_PROHIBIT_CHANGING_OF', ...
		  'ER_NO_FILE_MAPPING', ...
		  'ER_WRONG_MAGIC', ...
		  'ER_PS_MANY_PARAM', ...
		  'ER_KEY_PART_0', ...
		  'ER_VIEW_CHECKSUM', ...
		  'ER_VIEW_MULTIUPDATE', ...
		  'ER_VIEW_NO_INSERT_FIELD_LIST', ...
		  'ER_VIEW_DELETE_MERGE_VIEW', ...
		  'ER_CANNOT_USER', ...
		  'ER_XAER_NOTA', ...
		  'ER_XAER_INVAL', ...
		  'ER_XAER_RMFAIL', ...
		  'ER_XAER_OUTSIDE', ...
		  'ER_XAER_RMERR', ...
		  'ER_XA_RBROLLBACK', ...
		  'ER_NONEXISTING_PROC_GRANT', ...
		  'ER_PROC_AUTO_GRANT_FAIL', ...
		  'ER_PROC_AUTO_REVOKE_FAIL', ...
		  'ER_DATA_TOO_LONG', ...
		  'ER_SP_BAD_SQLSTATE', ...
		  'ER_STARTUP', ...
		  'ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR', ...
		  'ER_CANT_CREATE_USER_WITH_GRANT', ...
		  'ER_WRONG_VALUE_FOR_TYPE', ...
		  'ER_TABLE_DEF_CHANGED', ...
		  'ER_SP_DUP_HANDLER', ...
		  'ER_SP_NOT_VAR_ARG', ...
		  'ER_SP_NO_RETSET', ...
		  'ER_CANT_CREATE_GEOMETRY_OBJECT', ...
		  'ER_FAILED_ROUTINE_BREAK_BINLOG', ...
		  'ER_BINLOG_UNSAFE_ROUTINE', ...
		  'ER_BINLOG_CREATE_ROUTINE_NEED_SUPER', ...
		  'ER_EXEC_STMT_WITH_OPEN_CURSOR', ...
		  'ER_STMT_HAS_NO_OPEN_CURSOR', ...
		  'ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG', ...
		  'ER_NO_DEFAULT_FOR_VIEW_FIELD', ...
		  'ER_SP_NO_RECURSION', ...
		  'ER_TOO_BIG_SCALE', ...
		  'ER_TOO_BIG_PRECISION', ...
		  'ER_M_BIGGER_THAN_D', ...
		  'ER_WRONG_LOCK_OF_SYSTEM_TABLE', ...
		  'ER_CONNECT_TO_FOREIGN_DATA_SOURCE', ...
		  'ER_QUERY_ON_FOREIGN_DATA_SOURCE', ...
		  'ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST', ...
		  'ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE', ...
		  'ER_FOREIGN_DATA_STRING_INVALID', ...
		  'ER_CANT_CREATE_FEDERATED_TABLE', ...
		  'ER_TRG_IN_WRONG_SCHEMA', ...
		  'ER_STACK_OVERRUN_NEED_MORE', ...
		  'ER_TOO_LONG_BODY', ...
		  'ER_WARN_CANT_DROP_DEFAULT_KEYCACHE', ...
		  'ER_TOO_BIG_DISPLAYWIDTH', ...
		  'ER_XAER_DUPID', ...
		  'ER_DATETIME_FUNCTION_OVERFLOW', ...
		  'ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG', ...
		  'ER_VIEW_PREVENT_UPDATE', ...
		  'ER_PS_NO_RECURSION', ...
		  'ER_SP_CANT_SET_AUTOCOMMIT', ...
		  'ER_MALFORMED_DEFINER', ...
		  'ER_VIEW_FRM_NO_USER', ...
		  'ER_VIEW_OTHER_USER', ...
		  'ER_NO_SUCH_USER', ...
		  'ER_FORBID_SCHEMA_CHANGE', ...
		  'ER_ROW_IS_REFERENCED_2', ...
		  'ER_NO_REFERENCED_ROW_2', ...
		  'ER_SP_BAD_VAR_SHADOW', ...
		  'ER_TRG_NO_DEFINER', ...
		  'ER_OLD_FILE_FORMAT', ...
		  'ER_SP_RECURSION_LIMIT', ...
		  'ER_SP_PROC_TABLE_CORRUPT', ...
		  'ER_SP_WRONG_NAME', ...
		  'ER_TABLE_NEEDS_UPGRADE', ...
		  'ER_SP_NO_AGGREGATE', ...
		  'ER_MAX_PREPARED_STMT_COUNT_REACHED', ...
		  'ER_VIEW_RECURSIVE', ...
		  'ER_NON_GROUPING_FIELD_USED', ...
		  'ER_TABLE_CANT_HANDLE_SPKEYS', ...
		  'ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA', ...
		  'ER_REMOVED_SPACES', ...
		  'ER_AUTOINC_READ_FAILED', ...
		  'ER_USERNAME', ...
		  'ER_HOSTNAME', ...
		  'ER_WRONG_STRING_LENGTH', ...
		  'ER_NON_INSERTABLE_TABLE', ...
		  'ER_ADMIN_WRONG_MRG_TABLE', ...
		  'ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT', ...
		  'ER_NAME_BECOMES_EMPTY', ...
		  'ER_AMBIGUOUS_FIELD_TERM', ...
		  'ER_FOREIGN_SERVER_EXISTS', ...
		  'ER_FOREIGN_SERVER_DOESNT_EXIST', ...
		  'ER_ILLEGAL_HA_CREATE_OPTION', ...
		  'ER_PARTITION_REQUIRES_VALUES_ERROR', ...
		  'ER_PARTITION_WRONG_VALUES_ERROR', ...
		  'ER_PARTITION_MAXVALUE_ERROR', ...
		  'ER_PARTITION_SUBPARTITION_ERROR', ...
		  'ER_PARTITION_SUBPART_MIX_ERROR', ...
		  'ER_PARTITION_WRONG_NO_PART_ERROR', ...
		  'ER_PARTITION_WRONG_NO_SUBPART_ERROR', ...
		  'ER_CONST_EXPR_IN_PARTITION_FUNC_ERROR', ...
		  'ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR', ...
		  'ER_FIELD_NOT_FOUND_PART_ERROR', ...
		  'ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR', ...
		  'ER_INCONSISTENT_PARTITION_INFO_ERROR', ...
		  'ER_PARTITION_FUNC_NOT_ALLOWED_ERROR', ...
		  'ER_PARTITIONS_MUST_BE_DEFINED_ERROR', ...
		  'ER_RANGE_NOT_INCREASING_ERROR', ...
		  'ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR', ...
		  'ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR', ...
		  'ER_PARTITION_ENTRY_ERROR', ...
		  'ER_MIX_HANDLER_ERROR', ...
		  'ER_PARTITION_NOT_DEFINED_ERROR', ...
		  'ER_TOO_MANY_PARTITIONS_ERROR', ...
		  'ER_SUBPARTITION_ERROR', ...
		  'ER_CANT_CREATE_HANDLER_FILE', ...
		  'ER_BLOB_FIELD_IN_PART_FUNC_ERROR', ...
		  'ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF', ...
		  'ER_NO_PARTS_ERROR', ...
		  'ER_PARTITION_MGMT_ON_NONPARTITIONED', ...
		  'ER_FOREIGN_KEY_ON_PARTITIONED', ...
		  'ER_DROP_PARTITION_NON_EXISTENT', ...
		  'ER_DROP_LAST_PARTITION', ...
		  'ER_COALESCE_ONLY_ON_HASH_PARTITION', ...
		  'ER_REORG_HASH_ONLY_ON_SAME_NO', ...
		  'ER_REORG_NO_PARAM_ERROR', ...
		  'ER_ONLY_ON_RANGE_LIST_PARTITION', ...
		  'ER_ADD_PARTITION_SUBPART_ERROR', ...
		  'ER_ADD_PARTITION_NO_NEW_PARTITION', ...
		  'ER_COALESCE_PARTITION_NO_PARTITION', ...
		  'ER_REORG_PARTITION_NOT_EXIST', ...
		  'ER_SAME_NAME_PARTITION', ...
		  'ER_NO_BINLOG_ERROR', ...
		  'ER_CONSECUTIVE_REORG_PARTITIONS', ...
		  'ER_REORG_OUTSIDE_RANGE', ...
		  'ER_PARTITION_FUNCTION_FAILURE', ...
		  'ER_PART_STATE_ERROR', ...
		  'ER_LIMITED_PART_RANGE', ...
		  'ER_PLUGIN_IS_NOT_LOADED', ...
		  'ER_WRONG_VALUE', ...
		  'ER_NO_PARTITION_FOR_GIVEN_VALUE', ...
		  'ER_FILEGROUP_OPTION_ONLY_ONCE', ...
		  'ER_CREATE_FILEGROUP_FAILED', ...
		  'ER_DROP_FILEGROUP_FAILED', ...
		  'ER_TABLESPACE_AUTO_EXTEND_ERROR', ...
		  'ER_WRONG_SIZE_NUMBER', ...
		  'ER_SIZE_OVERFLOW_ERROR', ...
		  'ER_ALTER_FILEGROUP_FAILED', ...
		  'ER_BINLOG_ROW_LOGGING_FAILED', ...
		  'ER_BINLOG_ROW_WRONG_TABLE_DEF', ...
		  'ER_BINLOG_ROW_RBR_TO_SBR', ...
		  'ER_EVENT_ALREADY_EXISTS', ...
		  'ER_EVENT_STORE_FAILED', ...
		  'ER_EVENT_DOES_NOT_EXIST', ...
		  'ER_EVENT_CANT_ALTER', ...
		  'ER_EVENT_DROP_FAILED', ...
		  'ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG', ...
		  'ER_EVENT_ENDS_BEFORE_STARTS', ...
		  'ER_EVENT_EXEC_TIME_IN_THE_PAST', ...
		  'ER_EVENT_OPEN_TABLE_FAILED', ...
		  'ER_EVENT_NEITHER_M_EXPR_NOR_M_AT', ...
		  'ER_COL_COUNT_DOESNT_MATCH_CORRUPTED', ...
		  'ER_CANNOT_LOAD_FROM_TABLE', ...
		  'ER_EVENT_CANNOT_DELETE', ...
		  'ER_EVENT_COMPILE_ERROR', ...
		  'ER_EVENT_SAME_NAME', ...
		  'ER_EVENT_DATA_TOO_LONG', ...
		  'ER_DROP_INDEX_FK', ...
		  'ER_WARN_DEPRECATED_SYNTAX_WITH_VER', ...
		  'ER_CANT_WRITE_LOCK_LOG_TABLE', ...
		  'ER_CANT_LOCK_LOG_TABLE', ...
		  'ER_FOREIGN_DUPLICATE_KEY', ...
		  'ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE', ...
		  'ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR', ...
		  'ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT', ...
		  'ER_NDB_CANT_SWITCH_BINLOG_FORMAT', ...
		  'ER_PARTITION_NO_TEMPORARY', ...
		  'ER_PARTITION_CONST_DOMAIN_ERROR', ...
		  'ER_PARTITION_FUNCTION_IS_NOT_ALLOWED', ...
		  'ER_DDL_LOG_ERROR', ...
		  'ER_NULL_IN_VALUES_LESS_THAN', ...
		  'ER_WRONG_PARTITION_NAME', ...
		  'ER_CANT_CHANGE_TX_ISOLATION', ...
		  'ER_DUP_ENTRY_AUTOINCREMENT_CASE', ...
		  'ER_EVENT_MODIFY_QUEUE_ERROR', ...
		  'ER_EVENT_SET_VAR_ERROR', ...
		  'ER_PARTITION_MERGE_ERROR', ...
		  'ER_CANT_ACTIVATE_LOG', ...
		  'ER_RBR_NOT_AVAILABLE', ...
		  'ER_BASE64_DECODE_ERROR', ...
		  'ER_EVENT_RECURSION_FORBIDDEN', ...
		  'ER_EVENTS_DB_ERROR', ...
		  'ER_ONLY_INTEGERS_ALLOWED', ...
		  'ER_UNSUPORTED_LOG_ENGINE', ...
		  'ER_BAD_LOG_STATEMENT', ...
		  'ER_CANT_RENAME_LOG_TABLE', ...
		  'ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT', ...
		  'ER_WRONG_PARAMETERS_TO_NATIVE_FCT', ...
		  'ER_WRONG_PARAMETERS_TO_STORED_FCT', ...
		  'ER_NATIVE_FCT_NAME_COLLISION', ...
		  'ER_DUP_ENTRY_WITH_KEY_NAME', ...
		  'ER_BINLOG_PURGE_EMFILE', ...
		  'ER_EVENT_CANNOT_CREATE_IN_THE_PAST', ...
		  'ER_EVENT_CANNOT_ALTER_IN_THE_PAST', ...
		  'ER_SLAVE_INCIDENT', ...
		  'ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT', ...
		  'ER_BINLOG_UNSAFE_STATEMENT', ...
		  'ER_SLAVE_FATAL_ERROR', ...
		  'ER_SLAVE_RELAY_LOG_READ_FAILURE', ...
		  'ER_SLAVE_RELAY_LOG_WRITE_FAILURE', ...
		  'ER_SLAVE_CREATE_EVENT_FAILURE', ...
		  'ER_SLAVE_MASTER_COM_FAILURE', ...
		  'ER_BINLOG_LOGGING_IMPOSSIBLE', ...
		  'ER_VIEW_NO_CREATION_CTX', ...
		  'ER_VIEW_INVALID_CREATION_CTX', ...
		  'ER_SR_INVALID_CREATION_CTX', ...
		  'ER_TRG_CORRUPTED_FILE', ...
		  'ER_TRG_NO_CREATION_CTX', ...
		  'ER_TRG_INVALID_CREATION_CTX', ...
		  'ER_EVENT_INVALID_CREATION_CTX', ...
		  'ER_TRG_CANT_OPEN_TABLE', ...
		  'ER_CANT_CREATE_SROUTINE', ...
		  'ER_SLAVE_AMBIGOUS_EXEC_MODE', ...
		  'ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT', ...
		  'ER_SLAVE_CORRUPT_EVENT', ...
		  'ER_LOAD_DATA_INVALID_COLUMN', ...
		  'ER_LOG_PURGE_NO_FILE', ...
		  'ER_XA_RBTIMEOUT', ...
		  'ER_XA_RBDEADLOCK', ...
		  'ER_NEED_REPREPARE', ...
		  'ER_DELAYED_NOT_SUPPORTED', ...
		  'WARN_NO_MASTER_INFO', ...
		  'WARN_OPTION_IGNORED', ...
		  'WARN_PLUGIN_DELETE_BUILTIN', ...
		  'WARN_PLUGIN_BUSY', ...
		  'ER_VARIABLE_IS_READONLY', ...
		  'ER_WARN_ENGINE_TRANSACTION_ROLLBACK', ...
		  'ER_SLAVE_HEARTBEAT_FAILURE', ...
		  'ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE', ...
		  'ER_NDB_REPLICATION_SCHEMA_ERROR', ...
		  'ER_CONFLICT_FN_PARSE_ERROR', ...
		  'ER_EXCEPTIONS_WRITE_ERROR', ...
		  'ER_TOO_LONG_TABLE_COMMENT', ...
		  'ER_TOO_LONG_FIELD_COMMENT', ...
		  'ER_FUNC_INEXISTENT_NAME_COLLISION', ...
		  'ER_DATABASE_NAME', ...
		  'ER_TABLE_NAME', ...
		  'ER_PARTITION_NAME', ...
		  'ER_SUBPARTITION_NAME', ...
		  'ER_TEMPORARY_NAME', ...
		  'ER_RENAMED_NAME', ...
		  'ER_TOO_MANY_CONCURRENT_TRXS', ...
		  'WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED', ...
		  'ER_DEBUG_SYNC_TIMEOUT', ...
		  'ER_DEBUG_SYNC_HIT_LIMIT', ...
		  'ER_ERROR_LAST']);

err_list('ER_ERROR_FIRST')                           = 1000;
err_list('ER_HASHCHK')                               = 1000;
err_list('ER_NISAMCHK')                              = 1001;
err_list('ER_NO')                                    = 1002;
err_list('ER_YES')                                   = 1003;
err_list('ER_CANT_CREATE_FILE')                      = 1004;
err_list('ER_CANT_CREATE_TABLE')                     = 1005;
err_list('ER_CANT_CREATE_DB')                        = 1006;
err_list('ER_DB_CREATE_EXISTS')                      = 1007;
err_list('ER_DB_DROP_EXISTS')                        = 1008;
err_list('ER_DB_DROP_DELETE')                        = 1009;
err_list('ER_DB_DROP_RMDIR')                         = 1010;
err_list('ER_CANT_DELETE_FILE')                      = 1011;
err_list('ER_CANT_FIND_SYSTEM_REC')                  = 1012;
err_list('ER_CANT_GET_STAT')                         = 1013;
err_list('ER_CANT_GET_WD')                           = 1014;
err_list('ER_CANT_LOCK')                             = 1015;
err_list('ER_CANT_OPEN_FILE')                        = 1016;
err_list('ER_FILE_NOT_FOUND')                        = 1017;
err_list('ER_CANT_READ_DIR')                         = 1018;
err_list('ER_CANT_SET_WD')                           = 1019;
err_list('ER_CHECKREAD')                             = 1020;
err_list('ER_DISK_FULL')                             = 1021;
err_list('ER_DUP_KEY')                               = 1022;
err_list('ER_ERROR_ON_CLOSE')                        = 1023;
err_list('ER_ERROR_ON_READ')                         = 1024;
err_list('ER_ERROR_ON_RENAME')                       = 1025;
err_list('ER_ERROR_ON_WRITE')                        = 1026;
err_list('ER_FILE_USED')                             = 1027;
err_list('ER_FILSORT_ABORT')                         = 1028;
err_list('ER_FORM_NOT_FOUND')                        = 1029;
err_list('ER_GET_ERRNO')                             = 1030;
err_list('ER_ILLEGAL_HA')                            = 1031;
err_list('ER_KEY_NOT_FOUND')                         = 1032;
err_list('ER_NOT_FORM_FILE')                         = 1033;
err_list('ER_NOT_KEYFILE')                           = 1034;
err_list('ER_OLD_KEYFILE')                           = 1035;
err_list('ER_OPEN_AS_READONLY')                      = 1036;
err_list('ER_OUTOFMEMORY')                           = 1037;
err_list('ER_OUT_OF_SORTMEMORY')                     = 1038;
err_list('ER_UNEXPECTED_EOF')                        = 1039;
err_list('ER_CON_COUNT_ERROR')                       = 1040;
err_list('ER_OUT_OF_RESOURCES')                      = 1041;
err_list('ER_BAD_HOST_ERROR')                        = 1042;
err_list('ER_HANDSHAKE_ERROR')                       = 1043;
err_list('ER_DBACCESS_DENIED_ERROR')                 = 1044;
err_list('ER_ACCESS_DENIED_ERROR')                   = 1045;
err_list('ER_NO_DB_ERROR')                           = 1046;
err_list('ER_UNKNOWN_COM_ERROR')                     = 1047;
err_list('ER_BAD_NULL_ERROR')                        = 1048;
err_list('ER_BAD_DB_ERROR')                          = 1049;
err_list('ER_TABLE_EXISTS_ERROR')                    = 1050;
err_list('ER_BAD_TABLE_ERROR')                       = 1051;
err_list('ER_NON_UNIQ_ERROR')                        = 1052;
err_list('ER_SERVER_SHUTDOWN')                       = 1053;
err_list('ER_BAD_FIELD_ERROR')                       = 1054;
err_list('ER_WRONG_FIELD_WITH_GROUP')                = 1055;
err_list('ER_WRONG_GROUP_FIELD')                     = 1056;
err_list('ER_WRONG_SUM_SELECT')                      = 1057;
err_list('ER_WRONG_VALUE_COUNT')                     = 1058;
err_list('ER_TOO_LONG_IDENT')                        = 1059;
err_list('ER_DUP_FIELDNAME')                         = 1060;
err_list('ER_DUP_KEYNAME')                           = 1061;
err_list('ER_DUP_ENTRY')                             = 1062;
err_list('ER_WRONG_FIELD_SPEC')                      = 1063;
err_list('ER_PARSE_ERROR')                           = 1064;
err_list('ER_EMPTY_QUERY')                           = 1065;
err_list('ER_NONUNIQ_TABLE')                         = 1066;
err_list('ER_INVALID_DEFAULT')                       = 1067;
err_list('ER_MULTIPLE_PRI_KEY')                      = 1068;
err_list('ER_TOO_MANY_KEYS')                         = 1069;
err_list('ER_TOO_MANY_KEY_PARTS')                    = 1070;
err_list('ER_TOO_LONG_KEY')                          = 1071;
err_list('ER_KEY_COLUMN_DOES_NOT_EXITS')             = 1072;
err_list('ER_BLOB_USED_AS_KEY')                      = 1073;
err_list('ER_TOO_BIG_FIELDLENGTH')                   = 1074;
err_list('ER_WRONG_AUTO_KEY')                        = 1075;
err_list('ER_READY')                                 = 1076;
err_list('ER_NORMAL_SHUTDOWN')                       = 1077;
err_list('ER_GOT_SIGNAL')                            = 1078;
err_list('ER_SHUTDOWN_COMPLETE')                     = 1079;
err_list('ER_FORCING_CLOSE')                         = 1080;
err_list('ER_IPSOCK_ERROR')                          = 1081;
err_list('ER_NO_SUCH_INDEX')                         = 1082;
err_list('ER_WRONG_FIELD_TERMINATORS')               = 1083;
err_list('ER_BLOBS_AND_NO_TERMINATED')               = 1084;
err_list('ER_TEXTFILE_NOT_READABLE')                 = 1085;
err_list('ER_FILE_EXISTS_ERROR')                     = 1086;
err_list('ER_LOAD_INFO')                             = 1087;
err_list('ER_ALTER_INFO')                            = 1088;
err_list('ER_WRONG_SUB_KEY')                         = 1089;
err_list('ER_CANT_REMOVE_ALL_FIELDS')                = 1090;
err_list('ER_CANT_DROP_FIELD_OR_KEY')                = 1091;
err_list('ER_INSERT_INFO')                           = 1092;
err_list('ER_UPDATE_TABLE_USED')                     = 1093;
err_list('ER_NO_SUCH_THREAD')                        = 1094;
err_list('ER_KILL_DENIED_ERROR')                     = 1095;
err_list('ER_NO_TABLES_USED')                        = 1096;
err_list('ER_TOO_BIG_SET')                           = 1097;
err_list('ER_NO_UNIQUE_LOGFILE')                     = 1098;
err_list('ER_TABLE_NOT_LOCKED_FOR_WRITE')            = 1099;
err_list('ER_TABLE_NOT_LOCKED')                      = 1100;
err_list('ER_BLOB_CANT_HAVE_DEFAULT')                = 1101;
err_list('ER_WRONG_DB_NAME')                         = 1102;
err_list('ER_WRONG_TABLE_NAME')                      = 1103;
err_list('ER_TOO_BIG_SELECT')                        = 1104;
err_list('ER_UNKNOWN_ERROR')                         = 1105;
err_list('ER_UNKNOWN_PROCEDURE')                     = 1106;
err_list('ER_WRONG_PARAMCOUNT_TO_PROCEDURE')         = 1107;
err_list('ER_WRONG_PARAMETERS_TO_PROCEDURE')         = 1108;
err_list('ER_UNKNOWN_TABLE')                         = 1109;
err_list('ER_FIELD_SPECIFIED_TWICE')                 = 1110;
err_list('ER_INVALID_GROUP_FUNC_USE')                = 1111;
err_list('ER_UNSUPPORTED_EXTENSION')                 = 1112;
err_list('ER_TABLE_MUST_HAVE_COLUMNS')               = 1113;
err_list('ER_RECORD_FILE_FULL')                      = 1114;
err_list('ER_UNKNOWN_CHARACTER_SET')                 = 1115;
err_list('ER_TOO_MANY_TABLES')                       = 1116;
err_list('ER_TOO_MANY_FIELDS')                       = 1117;
err_list('ER_TOO_BIG_ROWSIZE')                       = 1118;
err_list('ER_STACK_OVERRUN')                         = 1119;
err_list('ER_WRONG_OUTER_JOIN')                      = 1120;
err_list('ER_NULL_COLUMN_IN_INDEX')                  = 1121;
err_list('ER_CANT_FIND_UDF')                         = 1122;
err_list('ER_CANT_INITIALIZE_UDF')                   = 1123;
err_list('ER_UDF_NO_PATHS')                          = 1124;
err_list('ER_UDF_EXISTS')                            = 1125;
err_list('ER_CANT_OPEN_LIBRARY')                     = 1126;
err_list('ER_CANT_FIND_DL_ENTRY')                    = 1127;
err_list('ER_FUNCTION_NOT_DEFINED')                  = 1128;
err_list('ER_HOST_IS_BLOCKED')                       = 1129;
err_list('ER_HOST_NOT_PRIVILEGED')                   = 1130;
err_list('ER_PASSWORD_ANONYMOUS_USER')               = 1131;
err_list('ER_PASSWORD_NOT_ALLOWED')                  = 1132;
err_list('ER_PASSWORD_NO_MATCH')                     = 1133;
err_list('ER_UPDATE_INFO')                           = 1134;
err_list('ER_CANT_CREATE_THREAD')                    = 1135;
err_list('ER_WRONG_VALUE_COUNT_ON_ROW')              = 1136;
err_list('ER_CANT_REOPEN_TABLE')                     = 1137;
err_list('ER_INVALID_USE_OF_NULL')                   = 1138;
err_list('ER_REGEXP_ERROR')                          = 1139;
err_list('ER_MIX_OF_GROUP_FUNC_AND_FIELDS')          = 1140;
err_list('ER_NONEXISTING_GRANT')                     = 1141;
err_list('ER_TABLEACCESS_DENIED_ERROR')              = 1142;
err_list('ER_COLUMNACCESS_DENIED_ERROR')             = 1143;
err_list('ER_ILLEGAL_GRANT_FOR_TABLE')               = 1144;
err_list('ER_GRANT_WRONG_HOST_OR_USER')              = 1145;
err_list('ER_NO_SUCH_TABLE')                         = 1146;
err_list('ER_NONEXISTING_TABLE_GRANT')               = 1147;
err_list('ER_NOT_ALLOWED_COMMAND')                   = 1148;
err_list('ER_SYNTAX_ERROR')                          = 1149;
err_list('ER_DELAYED_CANT_CHANGE_LOCK')              = 1150;
err_list('ER_TOO_MANY_DELAYED_THREADS')              = 1151;
err_list('ER_ABORTING_CONNECTION')                   = 1152;
err_list('ER_NET_PACKET_TOO_LARGE')                  = 1153;
err_list('ER_NET_READ_ERROR_FROM_PIPE')              = 1154;
err_list('ER_NET_FCNTL_ERROR')                       = 1155;
err_list('ER_NET_PACKETS_OUT_OF_ORDER')              = 1156;
err_list('ER_NET_UNCOMPRESS_ERROR')                  = 1157;
err_list('ER_NET_READ_ERROR')                        = 1158;
err_list('ER_NET_READ_INTERRUPTED')                  = 1159;
err_list('ER_NET_ERROR_ON_WRITE')                    = 1160;
err_list('ER_NET_WRITE_INTERRUPTED')                 = 1161;
err_list('ER_TOO_LONG_STRING')                       = 1162;
err_list('ER_TABLE_CANT_HANDLE_BLOB')                = 1163;
err_list('ER_TABLE_CANT_HANDLE_AUTO_INCREMENT')      = 1164;
err_list('ER_DELAYED_INSERT_TABLE_LOCKED')           = 1165;
err_list('ER_WRONG_COLUMN_NAME')                     = 1166;
err_list('ER_WRONG_KEY_COLUMN')                      = 1167;
err_list('ER_WRONG_MRG_TABLE')                       = 1168;
err_list('ER_DUP_UNIQUE')                            = 1169;
err_list('ER_BLOB_KEY_WITHOUT_LENGTH')               = 1170;
err_list('ER_PRIMARY_CANT_HAVE_NULL')                = 1171;
err_list('ER_TOO_MANY_ROWS')                         = 1172;
err_list('ER_REQUIRES_PRIMARY_KEY')                  = 1173;
err_list('ER_NO_RAID_COMPILED')                      = 1174;
err_list('ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE')       = 1175;
err_list('ER_KEY_DOES_NOT_EXITS')                    = 1176;
err_list('ER_CHECK_NO_SUCH_TABLE')                   = 1177;
err_list('ER_CHECK_NOT_IMPLEMENTED')                 = 1178;
err_list('ER_CANT_DO_THIS_DURING_AN_TRANSACTION')    = 1179;
err_list('ER_ERROR_DURING_COMMIT')                   = 1180;
err_list('ER_ERROR_DURING_ROLLBACK')                 = 1181;
err_list('ER_ERROR_DURING_FLUSH_LOGS')               = 1182;
err_list('ER_ERROR_DURING_CHECKPOINT')               = 1183;
err_list('ER_NEW_ABORTING_CONNECTION')               = 1184;
err_list('ER_DUMP_NOT_IMPLEMENTED')                  = 1185;
err_list('ER_FLUSH_MASTER_BINLOG_CLOSED')            = 1186;
err_list('ER_INDEX_REBUILD')                         = 1187;
err_list('ER_MASTER')                                = 1188;
err_list('ER_MASTER_NET_READ')                       = 1189;
err_list('ER_MASTER_NET_WRITE')                      = 1190;
err_list('ER_FT_MATCHING_KEY_NOT_FOUND')             = 1191;
err_list('ER_LOCK_OR_ACTIVE_TRANSACTION')            = 1192;
err_list('ER_UNKNOWN_SYSTEM_VARIABLE')               = 1193;
err_list('ER_CRASHED_ON_USAGE')                      = 1194;
err_list('ER_CRASHED_ON_REPAIR')                     = 1195;
err_list('ER_WARNING_NOT_COMPLETE_ROLLBACK')         = 1196;
err_list('ER_TRANS_CACHE_FULL')                      = 1197;
err_list('ER_SLAVE_MUST_STOP')                       = 1198;
err_list('ER_SLAVE_NOT_RUNNING')                     = 1199;
err_list('ER_BAD_SLAVE')                             = 1200;
err_list('ER_MASTER_INFO')                           = 1201;
err_list('ER_SLAVE_THREAD')                          = 1202;
err_list('ER_TOO_MANY_USER_CONNECTIONS')             = 1203;
err_list('ER_SET_CONSTANTS_ONLY')                    = 1204;
err_list('ER_LOCK_WAIT_TIMEOUT')                     = 1205;
err_list('ER_LOCK_TABLE_FULL')                       = 1206;
err_list('ER_READ_ONLY_TRANSACTION')                 = 1207;
err_list('ER_DROP_DB_WITH_READ_LOCK')                = 1208;
err_list('ER_CREATE_DB_WITH_READ_LOCK')              = 1209;
err_list('ER_WRONG_ARGUMENTS')                       = 1210;
err_list('ER_NO_PERMISSION_TO_CREATE_USER')          = 1211;
err_list('ER_UNION_TABLES_IN_DIFFERENT_DIR')         = 1212;
err_list('ER_LOCK_DEADLOCK')                         = 1213;
err_list('ER_TABLE_CANT_HANDLE_FT')                  = 1214;
err_list('ER_CANNOT_ADD_FOREIGN')                    = 1215;
err_list('ER_NO_REFERENCED_ROW')                     = 1216;
err_list('ER_ROW_IS_REFERENCED')                     = 1217;
err_list('ER_CONNECT_TO_MASTER')                     = 1218;
err_list('ER_QUERY_ON_MASTER')                       = 1219;
err_list('ER_ERROR_WHEN_EXECUTING_COMMAND')          = 1220;
err_list('ER_WRONG_USAGE')                           = 1221;
err_list('ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT')     = 1222;
err_list('ER_CANT_UPDATE_WITH_READLOCK')             = 1223;
err_list('ER_MIXING_NOT_ALLOWED')                    = 1224;
err_list('ER_DUP_ARGUMENT')                          = 1225;
err_list('ER_USER_LIMIT_REACHED')                    = 1226;
err_list('ER_SPECIFIC_ACCESS_DENIED_ERROR')          = 1227;
err_list('ER_LOCAL_VARIABLE')                        = 1228;
err_list('ER_GLOBAL_VARIABLE')                       = 1229;
err_list('ER_NO_DEFAULT')                            = 1230;
err_list('ER_WRONG_VALUE_FOR_VAR')                   = 1231;
err_list('ER_WRONG_TYPE_FOR_VAR')                    = 1232;
err_list('ER_VAR_CANT_BE_READ')                      = 1233;
err_list('ER_CANT_USE_OPTION_HERE')                  = 1234;
err_list('ER_NOT_SUPPORTED_YET')                     = 1235;
err_list('ER_MASTER_FATAL_ERROR_READING_BINLOG')     = 1236;
err_list('ER_SLAVE_IGNORED_TABLE')                   = 1237;
err_list('ER_INCORRECT_GLOBAL_LOCAL_VAR')            = 1238;
err_list('ER_WRONG_FK_DEF')                          = 1239;
err_list('ER_KEY_REF_DO_NOT_MATCH_TABLE_REF')        = 1240;
err_list('ER_OPERAND_COLUMNS')                       = 1241;
err_list('ER_SUBQUERY_NO_1_ROW')                     = 1242;
err_list('ER_UNKNOWN_STMT_HANDLER')                  = 1243;
err_list('ER_CORRUPT_HELP_DB')                       = 1244;
err_list('ER_CYCLIC_REFERENCE')                      = 1245;
err_list('ER_AUTO_CONVERT')                          = 1246;
err_list('ER_ILLEGAL_REFERENCE')                     = 1247;
err_list('ER_DERIVED_MUST_HAVE_ALIAS')               = 1248;
err_list('ER_SELECT_REDUCED')                        = 1249;
err_list('ER_TABLENAME_NOT_ALLOWED_HERE')            = 1250;
err_list('ER_NOT_SUPPORTED_AUTH_MODE')               = 1251;
err_list('ER_SPATIAL_CANT_HAVE_NULL')                = 1252;
err_list('ER_COLLATION_CHARSET_MISMATCH')            = 1253;
err_list('ER_SLAVE_WAS_RUNNING')                     = 1254;
err_list('ER_SLAVE_WAS_NOT_RUNNING')                 = 1255;
err_list('ER_TOO_BIG_FOR_UNCOMPRESS')                = 1256;
err_list('ER_ZLIB_Z_MEM_ERROR')                      = 1257;
err_list('ER_ZLIB_Z_BUF_ERROR')                      = 1258;
err_list('ER_ZLIB_Z_DATA_ERROR')                     = 1259;
err_list('ER_CUT_VALUE_GROUP_CONCAT')                = 1260;
err_list('ER_WARN_TOO_FEW_RECORDS')                  = 1261;
err_list('ER_WARN_TOO_MANY_RECORDS')                 = 1262;
err_list('ER_WARN_NULL_TO_NOTNULL')                  = 1263;
err_list('ER_WARN_DATA_OUT_OF_RANGE')                = 1264;
err_list('WARN_DATA_TRUNCATED')                      = 1265;
err_list('ER_WARN_USING_OTHER_HANDLER')              = 1266;
err_list('ER_CANT_AGGREGATE_2COLLATIONS')            = 1267;
err_list('ER_DROP_USER')                             = 1268;
err_list('ER_REVOKE_GRANTS')                         = 1269;
err_list('ER_CANT_AGGREGATE_3COLLATIONS')            = 1270;
err_list('ER_CANT_AGGREGATE_NCOLLATIONS')            = 1271;
err_list('ER_VARIABLE_IS_NOT_STRUCT')                = 1272;
err_list('ER_UNKNOWN_COLLATION')                     = 1273;
err_list('ER_SLAVE_IGNORED_SSL_PARAMS')              = 1274;
err_list('ER_SERVER_IS_IN_SECURE_AUTH_MODE')         = 1275;
err_list('ER_WARN_FIELD_RESOLVED')                   = 1276;
err_list('ER_BAD_SLAVE_UNTIL_COND')                  = 1277;
err_list('ER_MISSING_SKIP_SLAVE')                    = 1278;
err_list('ER_UNTIL_COND_IGNORED')                    = 1279;
err_list('ER_WRONG_NAME_FOR_INDEX')                  = 1280;
err_list('ER_WRONG_NAME_FOR_CATALOG')                = 1281;
err_list('ER_WARN_QC_RESIZE')                        = 1282;
err_list('ER_BAD_FT_COLUMN')                         = 1283;
err_list('ER_UNKNOWN_KEY_CACHE')                     = 1284;
err_list('ER_WARN_HOSTNAME_WONT_WORK')               = 1285;
err_list('ER_UNKNOWN_STORAGE_ENGINE')                = 1286;
err_list('ER_WARN_DEPRECATED_SYNTAX')                = 1287;
err_list('ER_NON_UPDATABLE_TABLE')                   = 1288;
err_list('ER_FEATURE_DISABLED')                      = 1289;
err_list('ER_OPTION_PREVENTS_STATEMENT')             = 1290;
err_list('ER_DUPLICATED_VALUE_IN_TYPE')              = 1291;
err_list('ER_TRUNCATED_WRONG_VALUE')                 = 1292;
err_list('ER_TOO_MUCH_AUTO_TIMESTAMP_COLS')          = 1293;
err_list('ER_INVALID_ON_UPDATE')                     = 1294;
err_list('ER_UNSUPPORTED_PS')                        = 1295;
err_list('ER_GET_ERRMSG')                            = 1296;
err_list('ER_GET_TEMPORARY_ERRMSG')                  = 1297;
err_list('ER_UNKNOWN_TIME_ZONE')                     = 1298;
err_list('ER_WARN_INVALID_TIMESTAMP')                = 1299;
err_list('ER_INVALID_CHARACTER_STRING')              = 1300;
err_list('ER_WARN_ALLOWED_PACKET_OVERFLOWED')        = 1301;
err_list('ER_CONFLICTING_DECLARATIONS')              = 1302;
err_list('ER_SP_NO_RECURSIVE_CREATE')                = 1303;
err_list('ER_SP_ALREADY_EXISTS')                     = 1304;
err_list('ER_SP_DOES_NOT_EXIST')                     = 1305;
err_list('ER_SP_DROP_FAILED')                        = 1306;
err_list('ER_SP_STORE_FAILED')                       = 1307;
err_list('ER_SP_LILABEL_MISMATCH')                   = 1308;
err_list('ER_SP_LABEL_REDEFINE')                     = 1309;
err_list('ER_SP_LABEL_MISMATCH')                     = 1310;
err_list('ER_SP_UNINIT_VAR')                         = 1311;
err_list('ER_SP_BADSELECT')                          = 1312;
err_list('ER_SP_BADRETURN')                          = 1313;
err_list('ER_SP_BADSTATEMENT')                       = 1314;
err_list('ER_UPDATE_LOG_DEPRECATED_IGNORED')         = 1315;
err_list('ER_UPDATE_LOG_DEPRECATED_TRANSLATED')      = 1316;
err_list('ER_QUERY_INTERRUPTED')                     = 1317;
err_list('ER_SP_WRONG_NO_OF_ARGS')                   = 1318;
err_list('ER_SP_COND_MISMATCH')                      = 1319;
err_list('ER_SP_NORETURN')                           = 1320;
err_list('ER_SP_NORETURNEND')                        = 1321;
err_list('ER_SP_BAD_CURSOR_QUERY')                   = 1322;
err_list('ER_SP_BAD_CURSOR_SELECT')                  = 1323;
err_list('ER_SP_CURSOR_MISMATCH')                    = 1324;
err_list('ER_SP_CURSOR_ALREADY_OPEN')                = 1325;
err_list('ER_SP_CURSOR_NOT_OPEN')                    = 1326;
err_list('ER_SP_UNDECLARED_VAR')                     = 1327;
err_list('ER_SP_WRONG_NO_OF_FETCH_ARGS')             = 1328;
err_list('ER_SP_FETCH_NO_DATA')                      = 1329;
err_list('ER_SP_DUP_PARAM')                          = 1330;
err_list('ER_SP_DUP_VAR')                            = 1331;
err_list('ER_SP_DUP_COND')                           = 1332;
err_list('ER_SP_DUP_CURS')                           = 1333;
err_list('ER_SP_CANT_ALTER')                         = 1334;
err_list('ER_SP_SUBSELECT_NYI')                      = 1335;
err_list('ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG')         = 1336;
err_list('ER_SP_VARCOND_AFTER_CURSHNDLR')            = 1337;
err_list('ER_SP_CURSOR_AFTER_HANDLER')               = 1338;
err_list('ER_SP_CASE_NOT_FOUND')                     = 1339;
err_list('ER_FPARSER_TOO_BIG_FILE')                  = 1340;
err_list('ER_FPARSER_BAD_HEADER')                    = 1341;
err_list('ER_FPARSER_EOF_IN_COMMENT')                = 1342;
err_list('ER_FPARSER_ERROR_IN_PARAMETER')            = 1343;
err_list('ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER')      = 1344;
err_list('ER_VIEW_NO_EXPLAIN')                       = 1345;
err_list('ER_FRM_UNKNOWN_TYPE')                      = 1346;
err_list('ER_WRONG_OBJECT')                          = 1347;
err_list('ER_NONUPDATEABLE_COLUMN')                  = 1348;
err_list('ER_VIEW_SELECT_DERIVED')                   = 1349;
err_list('ER_VIEW_SELECT_CLAUSE')                    = 1350;
err_list('ER_VIEW_SELECT_VARIABLE')                  = 1351;
err_list('ER_VIEW_SELECT_TMPTABLE')                  = 1352;
err_list('ER_VIEW_WRONG_LIST')                       = 1353;
err_list('ER_WARN_VIEW_MERGE')                       = 1354;
err_list('ER_WARN_VIEW_WITHOUT_KEY')                 = 1355;
err_list('ER_VIEW_INVALID')                          = 1356;
err_list('ER_SP_NO_DROP_SP')                         = 1357;
err_list('ER_SP_GOTO_IN_HNDLR')                      = 1358;
err_list('ER_TRG_ALREADY_EXISTS')                    = 1359;
err_list('ER_TRG_DOES_NOT_EXIST')                    = 1360;
err_list('ER_TRG_ON_VIEW_OR_TEMP_TABLE')             = 1361;
err_list('ER_TRG_CANT_CHANGE_ROW')                   = 1362;
err_list('ER_TRG_NO_SUCH_ROW_IN_TRG')                = 1363;
err_list('ER_NO_DEFAULT_FOR_FIELD')                  = 1364;
err_list('ER_DIVISION_BY_ZERO')                      = 1365;
err_list('ER_TRUNCATED_WRONG_VALUE_FOR_FIELD')       = 1366;
err_list('ER_ILLEGAL_VALUE_FOR_TYPE')                = 1367;
err_list('ER_VIEW_NONUPD_CHECK')                     = 1368;
err_list('ER_VIEW_CHECK_FAILED')                     = 1369;
err_list('ER_PROCACCESS_DENIED_ERROR')               = 1370;
err_list('ER_RELAY_LOG_FAIL')                        = 1371;
err_list('ER_PASSWD_LENGTH')                         = 1372;
err_list('ER_UNKNOWN_TARGET_BINLOG')                 = 1373;
err_list('ER_IO_ERR_LOG_INDEX_READ')                 = 1374;
err_list('ER_BINLOG_PURGE_PROHIBITED')               = 1375;
err_list('ER_FSEEK_FAIL')                            = 1376;
err_list('ER_BINLOG_PURGE_FATAL_ERR')                = 1377;
err_list('ER_LOG_IN_USE')                            = 1378;
err_list('ER_LOG_PURGE_UNKNOWN_ERR')                 = 1379;
err_list('ER_RELAY_LOG_INIT')                        = 1380;
err_list('ER_NO_BINARY_LOGGING')                     = 1381;
err_list('ER_RESERVED_SYNTAX')                       = 1382;
err_list('ER_WSAS_FAILED')                           = 1383;
err_list('ER_DIFF_GROUPS_PROC')                      = 1384;
err_list('ER_NO_GROUP_FOR_PROC')                     = 1385;
err_list('ER_ORDER_WITH_PROC')                       = 1386;
err_list('ER_LOGGING_PROHIBIT_CHANGING_OF')          = 1387;
err_list('ER_NO_FILE_MAPPING')                       = 1388;
err_list('ER_WRONG_MAGIC')                           = 1389;
err_list('ER_PS_MANY_PARAM')                         = 1390;
err_list('ER_KEY_PART_0')                            = 1391;
err_list('ER_VIEW_CHECKSUM')                         = 1392;
err_list('ER_VIEW_MULTIUPDATE')                      = 1393;
err_list('ER_VIEW_NO_INSERT_FIELD_LIST')             = 1394;
err_list('ER_VIEW_DELETE_MERGE_VIEW')                = 1395;
err_list('ER_CANNOT_USER')                           = 1396;
err_list('ER_XAER_NOTA')                             = 1397;
err_list('ER_XAER_INVAL')                            = 1398;
err_list('ER_XAER_RMFAIL')                           = 1399;
err_list('ER_XAER_OUTSIDE')                          = 1400;
err_list('ER_XAER_RMERR')                            = 1401;
err_list('ER_XA_RBROLLBACK')                         = 1402;
err_list('ER_NONEXISTING_PROC_GRANT')                = 1403;
err_list('ER_PROC_AUTO_GRANT_FAIL')                  = 1404;
err_list('ER_PROC_AUTO_REVOKE_FAIL')                 = 1405;
err_list('ER_DATA_TOO_LONG')                         = 1406;
err_list('ER_SP_BAD_SQLSTATE')                       = 1407;
err_list('ER_STARTUP')                               = 1408;
err_list('ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR')      = 1409;
err_list('ER_CANT_CREATE_USER_WITH_GRANT')           = 1410;
err_list('ER_WRONG_VALUE_FOR_TYPE')                  = 1411;
err_list('ER_TABLE_DEF_CHANGED')                     = 1412;
err_list('ER_SP_DUP_HANDLER')                        = 1413;
err_list('ER_SP_NOT_VAR_ARG')                        = 1414;
err_list('ER_SP_NO_RETSET')                          = 1415;
err_list('ER_CANT_CREATE_GEOMETRY_OBJECT')           = 1416;
err_list('ER_FAILED_ROUTINE_BREAK_BINLOG')           = 1417;
err_list('ER_BINLOG_UNSAFE_ROUTINE')                 = 1418;
err_list('ER_BINLOG_CREATE_ROUTINE_NEED_SUPER')      = 1419;
err_list('ER_EXEC_STMT_WITH_OPEN_CURSOR')            = 1420;
err_list('ER_STMT_HAS_NO_OPEN_CURSOR')               = 1421;
err_list('ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG')       = 1422;
err_list('ER_NO_DEFAULT_FOR_VIEW_FIELD')             = 1423;
err_list('ER_SP_NO_RECURSION')                       = 1424;
err_list('ER_TOO_BIG_SCALE')                         = 1425;
err_list('ER_TOO_BIG_PRECISION')                     = 1426;
err_list('ER_M_BIGGER_THAN_D')                       = 1427;
err_list('ER_WRONG_LOCK_OF_SYSTEM_TABLE')            = 1428;
err_list('ER_CONNECT_TO_FOREIGN_DATA_SOURCE')        = 1429;
err_list('ER_QUERY_ON_FOREIGN_DATA_SOURCE')          = 1430;
err_list('ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST')      = 1431;
err_list('ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE') = 1432;
err_list('ER_FOREIGN_DATA_STRING_INVALID')           = 1433;
err_list('ER_CANT_CREATE_FEDERATED_TABLE')           = 1434;
err_list('ER_TRG_IN_WRONG_SCHEMA')                   = 1435;
err_list('ER_STACK_OVERRUN_NEED_MORE')               = 1436;
err_list('ER_TOO_LONG_BODY')                         = 1437;
err_list('ER_WARN_CANT_DROP_DEFAULT_KEYCACHE')       = 1438;
err_list('ER_TOO_BIG_DISPLAYWIDTH')                  = 1439;
err_list('ER_XAER_DUPID')                            = 1440;
err_list('ER_DATETIME_FUNCTION_OVERFLOW')            = 1441;
err_list('ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG')   = 1442;
err_list('ER_VIEW_PREVENT_UPDATE')                   = 1443;
err_list('ER_PS_NO_RECURSION')                       = 1444;
err_list('ER_SP_CANT_SET_AUTOCOMMIT')                = 1445;
err_list('ER_MALFORMED_DEFINER')                     = 1446;
err_list('ER_VIEW_FRM_NO_USER')                      = 1447;
err_list('ER_VIEW_OTHER_USER')                       = 1448;
err_list('ER_NO_SUCH_USER')                          = 1449;
err_list('ER_FORBID_SCHEMA_CHANGE')                  = 1450;
err_list('ER_ROW_IS_REFERENCED_2')                   = 1451;
err_list('ER_NO_REFERENCED_ROW_2')                   = 1452;
err_list('ER_SP_BAD_VAR_SHADOW')                     = 1453;
err_list('ER_TRG_NO_DEFINER')                        = 1454;
err_list('ER_OLD_FILE_FORMAT')                       = 1455;
err_list('ER_SP_RECURSION_LIMIT')                    = 1456;
err_list('ER_SP_PROC_TABLE_CORRUPT')                 = 1457;
err_list('ER_SP_WRONG_NAME')                         = 1458;
err_list('ER_TABLE_NEEDS_UPGRADE')                   = 1459;
err_list('ER_SP_NO_AGGREGATE')                       = 1460;
err_list('ER_MAX_PREPARED_STMT_COUNT_REACHED')       = 1461;
err_list('ER_VIEW_RECURSIVE')                        = 1462;
err_list('ER_NON_GROUPING_FIELD_USED')               = 1463;
err_list('ER_TABLE_CANT_HANDLE_SPKEYS')              = 1464;
err_list('ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA')          = 1465;
err_list('ER_REMOVED_SPACES')                        = 1466;
err_list('ER_AUTOINC_READ_FAILED')                   = 1467;
err_list('ER_USERNAME')                              = 1468;
err_list('ER_HOSTNAME')                              = 1469
err_list('ER_WRONG_STRING_LENGTH')                   = 1470;
err_list('ER_NON_INSERTABLE_TABLE')                  = 1471;
err_list('ER_ADMIN_WRONG_MRG_TABLE')                 = 1472;
err_list('ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT')  = 1473;
err_list('ER_NAME_BECOMES_EMPTY')                    = 1474;
err_list('ER_AMBIGUOUS_FIELD_TERM')                  = 1475;
err_list('ER_FOREIGN_SERVER_EXISTS')                 = 1476;
err_list('ER_FOREIGN_SERVER_DOESNT_EXIST')           = 1477;
err_list('ER_ILLEGAL_HA_CREATE_OPTION')              = 1478;
err_list('ER_PARTITION_REQUIRES_VALUES_ERROR')       = 1479;
err_list('ER_PARTITION_WRONG_VALUES_ERROR')          = 1480;
err_list('ER_PARTITION_MAXVALUE_ERROR')              = 1481;
err_list('ER_PARTITION_SUBPARTITION_ERROR')          = 1482;
err_list('ER_PARTITION_SUBPART_MIX_ERROR')           = 1483;
err_list('ER_PARTITION_WRONG_NO_PART_ERROR')         = 1484;
err_list('ER_PARTITION_WRONG_NO_SUBPART_ERROR')      = 1485;
err_list('ER_CONST_EXPR_IN_PARTITION_FUNC_ERROR')    = 1486;
err_list('ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR')  = 1487;
err_list('ER_FIELD_NOT_FOUND_PART_ERROR')            = 1488;
err_list('ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR')     = 1489;
err_list('ER_INCONSISTENT_PARTITION_INFO_ERROR')     = 1490;
err_list('ER_PARTITION_FUNC_NOT_ALLOWED_ERROR')      = 1491;
err_list('ER_PARTITIONS_MUST_BE_DEFINED_ERROR')      = 1492;
err_list('ER_RANGE_NOT_INCREASING_ERROR')            = 1493;
err_list('ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR')  = 1494;
err_list('ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR') = 1495;
err_list('ER_PARTITION_ENTRY_ERROR')                 = 1496;
err_list('ER_MIX_HANDLER_ERROR')                     = 1497;
err_list('ER_PARTITION_NOT_DEFINED_ERROR')           = 1498;
err_list('ER_TOO_MANY_PARTITIONS_ERROR')             = 1499;
err_list('ER_SUBPARTITION_ERROR')                    = 1500;
err_list('ER_CANT_CREATE_HANDLER_FILE')              = 1501;
err_list('ER_BLOB_FIELD_IN_PART_FUNC_ERROR')         = 1502;
err_list('ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF')      = 1503;
err_list('ER_NO_PARTS_ERROR')                        = 1504;
err_list('ER_PARTITION_MGMT_ON_NONPARTITIONED')      = 1505;
err_list('ER_FOREIGN_KEY_ON_PARTITIONED')            = 1506;
err_list('ER_DROP_PARTITION_NON_EXISTENT')           = 1507;
err_list('ER_DROP_LAST_PARTITION')                   = 1508;
err_list('ER_COALESCE_ONLY_ON_HASH_PARTITION')       = 1509;
err_list('ER_REORG_HASH_ONLY_ON_SAME_NO')            = 1510;
err_list('ER_REORG_NO_PARAM_ERROR')                  = 1511;
err_list('ER_ONLY_ON_RANGE_LIST_PARTITION')          = 1512;
err_list('ER_ADD_PARTITION_SUBPART_ERROR')           = 1513;
err_list('ER_ADD_PARTITION_NO_NEW_PARTITION')        = 1514;
err_list('ER_COALESCE_PARTITION_NO_PARTITION')       = 1515;
err_list('ER_REORG_PARTITION_NOT_EXIST')             = 1516;
err_list('ER_SAME_NAME_PARTITION')                   = 1517;
err_list('ER_NO_BINLOG_ERROR')                       = 1518;
err_list('ER_CONSECUTIVE_REORG_PARTITIONS')          = 1519;
err_list('ER_REORG_OUTSIDE_RANGE')                   = 1520;
err_list('ER_PARTITION_FUNCTION_FAILURE')            = 1521;
err_list('ER_PART_STATE_ERROR')                      = 1522;
err_list('ER_LIMITED_PART_RANGE')                    = 1523;
err_list('ER_PLUGIN_IS_NOT_LOADED')                  = 1524;
err_list('ER_WRONG_VALUE')                           = 1525;
err_list('ER_NO_PARTITION_FOR_GIVEN_VALUE')          = 1526;
err_list('ER_FILEGROUP_OPTION_ONLY_ONCE')            = 1527;
err_list('ER_CREATE_FILEGROUP_FAILED')               = 1528;
err_list('ER_DROP_FILEGROUP_FAILED')                 = 1529;
err_list('ER_TABLESPACE_AUTO_EXTEND_ERROR')          = 1530;
err_list('ER_WRONG_SIZE_NUMBER')                     = 1531;
err_list('ER_SIZE_OVERFLOW_ERROR')                   = 1532;
err_list('ER_ALTER_FILEGROUP_FAILED')                = 1533;
err_list('ER_BINLOG_ROW_LOGGING_FAILED')             = 1534;
err_list('ER_BINLOG_ROW_WRONG_TABLE_DEF')            = 1535;
err_list('ER_BINLOG_ROW_RBR_TO_SBR')                 = 1536;
err_list('ER_EVENT_ALREADY_EXISTS')                  = 1537;
err_list('ER_EVENT_STORE_FAILED')                    = 1538;
err_list('ER_EVENT_DOES_NOT_EXIST')                  = 1539;
err_list('ER_EVENT_CANT_ALTER')                      = 1540;
err_list('ER_EVENT_DROP_FAILED')                     = 1541;
err_list('ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG') = 1542;
err_list('ER_EVENT_ENDS_BEFORE_STARTS')              = 1543;
err_list('ER_EVENT_EXEC_TIME_IN_THE_PAST')           = 1544;
err_list('ER_EVENT_OPEN_TABLE_FAILED')               = 1545;
err_list('ER_EVENT_NEITHER_M_EXPR_NOR_M_AT')         = 1546;
err_list('ER_COL_COUNT_DOESNT_MATCH_CORRUPTED')      = 1547;
err_list('ER_CANNOT_LOAD_FROM_TABLE')                = 1548;
err_list('ER_EVENT_CANNOT_DELETE')                   = 1549;
err_list('ER_EVENT_COMPILE_ERROR')                   = 1550;
err_list('ER_EVENT_SAME_NAME')                       = 1551;
err_list('ER_EVENT_DATA_TOO_LONG')                   = 1552;
err_list('ER_DROP_INDEX_FK')                         = 1553;
err_list('ER_WARN_DEPRECATED_SYNTAX_WITH_VER')       = 1554;
err_list('ER_CANT_WRITE_LOCK_LOG_TABLE')             = 1555;
err_list('ER_CANT_LOCK_LOG_TABLE')                   = 1556;
err_list('ER_FOREIGN_DUPLICATE_KEY')                 = 1557;
err_list('ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE')  = 1558;
err_list('ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR') = 1559;
err_list('ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT') = 1560;
err_list('ER_NDB_CANT_SWITCH_BINLOG_FORMAT')         = 1561;
err_list('ER_PARTITION_NO_TEMPORARY')                = 1562;
err_list('ER_PARTITION_CONST_DOMAIN_ERROR')          = 1563;
err_list('ER_PARTITION_FUNCTION_IS_NOT_ALLOWED')     = 1564;
err_list('ER_DDL_LOG_ERROR')                         = 1565;
err_list('ER_NULL_IN_VALUES_LESS_THAN')              = 1566;
err_list('ER_WRONG_PARTITION_NAME')                  = 1567;
err_list('ER_CANT_CHANGE_TX_ISOLATION')              = 1568;
err_list('ER_DUP_ENTRY_AUTOINCREMENT_CASE')          = 1569;
err_list('ER_EVENT_MODIFY_QUEUE_ERROR')              = 1570;
err_list('ER_EVENT_SET_VAR_ERROR')                   = 1571;
err_list('ER_PARTITION_MERGE_ERROR')                 = 1572;
err_list('ER_CANT_ACTIVATE_LOG')                     = 1573;
err_list('ER_RBR_NOT_AVAILABLE')                     = 1574;
err_list('ER_BASE64_DECODE_ERROR')                   = 1575;
err_list('ER_EVENT_RECURSION_FORBIDDEN')             = 1576;
err_list('ER_EVENTS_DB_ERROR')                       = 1577;
err_list('ER_ONLY_INTEGERS_ALLOWED')                 = 1578;
err_list('ER_UNSUPORTED_LOG_ENGINE')                 = 1579;
err_list('ER_BAD_LOG_STATEMENT')                     = 1580;
err_list('ER_CANT_RENAME_LOG_TABLE')                 = 1581;
err_list('ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT')        = 1582;
err_list('ER_WRONG_PARAMETERS_TO_NATIVE_FCT')        = 1583;
err_list('ER_WRONG_PARAMETERS_TO_STORED_FCT')        = 1584;
err_list('ER_NATIVE_FCT_NAME_COLLISION')             = 1585;
err_list('ER_DUP_ENTRY_WITH_KEY_NAME')               = 1586;
err_list('ER_BINLOG_PURGE_EMFILE')                   = 1587;
err_list('ER_EVENT_CANNOT_CREATE_IN_THE_PAST')       = 1588;
err_list('ER_EVENT_CANNOT_ALTER_IN_THE_PAST')        = 1589;
err_list('ER_SLAVE_INCIDENT')                        = 1590;
err_list('ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT')   = 1591;
err_list('ER_BINLOG_UNSAFE_STATEMENT')               = 1592;
err_list('ER_SLAVE_FATAL_ERROR')                     = 1593;
err_list('ER_SLAVE_RELAY_LOG_READ_FAILURE')          = 1594;
err_list('ER_SLAVE_RELAY_LOG_WRITE_FAILURE')         = 1595;
err_list('ER_SLAVE_CREATE_EVENT_FAILURE')            = 1596;
err_list('ER_SLAVE_MASTER_COM_FAILURE')              = 1597;
err_list('ER_BINLOG_LOGGING_IMPOSSIBLE')             = 1598;
err_list('ER_VIEW_NO_CREATION_CTX')                  = 1599;
err_list('ER_VIEW_INVALID_CREATION_CTX')             = 1600;
err_list('ER_SR_INVALID_CREATION_CTX')               = 1601;
err_list('ER_TRG_CORRUPTED_FILE')                    = 1602;
err_list('ER_TRG_NO_CREATION_CTX')                   = 1603;
err_list('ER_TRG_INVALID_CREATION_CTX')              = 1604;
err_list('ER_EVENT_INVALID_CREATION_CTX')            = 1605;
err_list('ER_TRG_CANT_OPEN_TABLE')                   = 1606;
err_list('ER_CANT_CREATE_SROUTINE')                  = 1607;
err_list('ER_SLAVE_AMBIGOUS_EXEC_MODE')              = 1608;
err_list('ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT') = 1609;
err_list('ER_SLAVE_CORRUPT_EVENT')                   = 1610;
err_list('ER_LOAD_DATA_INVALID_COLUMN')              = 1611;
err_list('ER_LOG_PURGE_NO_FILE')                     = 1612;
err_list('ER_XA_RBTIMEOUT')                          = 1613;
err_list('ER_XA_RBDEADLOCK')                         = 1614;
err_list('ER_NEED_REPREPARE')                        = 1615;
err_list('ER_DELAYED_NOT_SUPPORTED')                 = 1616;
err_list('WARN_NO_MASTER_INFO')                      = 1617;
err_list('WARN_OPTION_IGNORED')                      = 1618;
err_list('WARN_PLUGIN_DELETE_BUILTIN')               = 1619;
err_list('WARN_PLUGIN_BUSY')                         = 1620;
err_list('ER_VARIABLE_IS_READONLY')                  = 1621;
err_list('ER_WARN_ENGINE_TRANSACTION_ROLLBACK')      = 1622;
err_list('ER_SLAVE_HEARTBEAT_FAILURE')               = 1623;
err_list('ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE')    = 1624;
err_list('ER_NDB_REPLICATION_SCHEMA_ERROR')          = 1625;
err_list('ER_CONFLICT_FN_PARSE_ERROR')               = 1626;
err_list('ER_EXCEPTIONS_WRITE_ERROR')                = 1627;
err_list('ER_TOO_LONG_TABLE_COMMENT')                = 1628;
err_list('ER_TOO_LONG_FIELD_COMMENT')                = 1629;
err_list('ER_FUNC_INEXISTENT_NAME_COLLISION')        = 1630;
err_list('ER_DATABASE_NAME')                         = 1631;
err_list('ER_TABLE_NAME')                            = 1632;
err_list('ER_PARTITION_NAME')                        = 1633;
err_list('ER_SUBPARTITION_NAME')                     = 1634;
err_list('ER_TEMPORARY_NAME')                        = 1635;
err_list('ER_RENAMED_NAME')                          = 1636;
err_list('ER_TOO_MANY_CONCURRENT_TRXS')              = 1637;
err_list('WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED') = 1638;
err_list('ER_DEBUG_SYNC_TIMEOUT')                    = 1639;
err_list('ER_DEBUG_SYNC_HIT_LIMIT')                  = 1640;
err_list('ER_ERROR_LAST')                            = 1640;

err_list('CR_MIN_ERROR')                             = 2000;
err_list('CR_ERROR_FIRST')                           = 2000;
err_list('CR_UNKNOWN_ERROR')                         = 2000;
err_list('CR_SOCKET_CREATE_ERROR')                   = 2001;
err_list('CR_CONNECTION_ERROR')                      = 2002;
err_list('CR_CONN_HOST_ERROR')                       = 2003;
err_list('CR_IPSOCK_ERROR')                          = 2004;
err_list('CR_UNKNOWN_HOST')                          = 2005;
err_list('CR_SERVER_GONE_ERROR')                     = 2006;
err_list('CR_VERSION_ERROR')                         = 2007;
err_list('CR_OUT_OF_MEMORY')                         = 2008;
err_list('CR_WRONG_HOST_INFO')                       = 2009;
err_list('CR_LOCALHOST_CONNECTION')                  = 2010;
err_list('CR_TCP_CONNECTION')                        = 2011;
err_list('CR_SERVER_HANDSHAKE_ERR')                  = 2012;
err_list('CR_SERVER_LOST')                           = 2013;
err_list('CR_COMMANDS_OUT_OF_SYNC')                  = 2014;
err_list('CR_NAMEDPIPE_CONNECTION')                  = 2015;
err_list('CR_NAMEDPIPEWAIT_ERROR')                   = 2016;
err_list('CR_NAMEDPIPEOPEN_ERROR')                   = 2017;
err_list('CR_NAMEDPIPESETSTATE_ERROR')               = 2018;
err_list('CR_CANT_READ_CHARSET')                     = 2019;
err_list('CR_NET_PACKET_TOO_LARGE')                  = 2020;
err_list('CR_EMBEDDED_CONNECTION')                   = 2021;
err_list('CR_PROBE_SLAVE_STATUS')                    = 2022;
err_list('CR_PROBE_SLAVE_HOSTS')                     = 2023;
err_list('CR_PROBE_SLAVE_CONNECT')                   = 2024;
err_list('CR_PROBE_MASTER_CONNECT')                  = 2025;
err_list('CR_SSL_CONNECTION_ERROR')                  = 2026;
err_list('CR_MALFORMED_PACKET')                      = 2027;
err_list('CR_WRONG_LICENSE')                         = 2028;
err_list('CR_NULL_POINTER')                          = 2029;
err_list('CR_NO_PREPARE_STMT')                       = 2030;
err_list('CR_PARAMS_NOT_BOUND')                      = 2031;
err_list('CR_DATA_TRUNCATED')                        = 2032;
err_list('CR_NO_PARAMETERS_EXISTS')                  = 2033;
err_list('CR_INVALID_PARAMETER_NO')                  = 2034;
err_list('CR_INVALID_BUFFER_USE')                    = 2035;
err_list('CR_UNSUPPORTED_PARAM_TYPE')                = 2036;
err_list('CR_SHARED_MEMORY_CONNECTION')              = 2037;
err_list('CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR')   = 2038;
err_list('CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR')    = 2039;
err_list('CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR')  = 2040;
err_list('CR_SHARED_MEMORY_CONNECT_MAP_ERROR')       = 2041;
err_list('CR_SHARED_MEMORY_FILE_MAP_ERROR')          = 2042;
err_list('CR_SHARED_MEMORY_MAP_ERROR')               = 2043;
err_list('CR_SHARED_MEMORY_EVENT_ERROR')             = 2044;
err_list('CR_SHARED_MEMORY_CONNECT_ABANDONED_ERROR') = 2045;
err_list('CR_SHARED_MEMORY_CONNECT_SET_ERROR')       = 2046;
err_list('CR_CONN_UNKNOW_PROTOCOL')                  = 2047;
err_list('CR_INVALID_CONN_HANDLE')                   = 2048;
err_list('CR_SECURE_AUTH')                           = 2049;
err_list('CR_FETCH_CANCELED')                        = 2050;
err_list('CR_NO_DATA')                               = 2051;
err_list('CR_NO_STMT_METADATA')                      = 2052;
err_list('CR_NO_RESULT_SET')                         = 2053;
err_list('CR_NOT_IMPLEMENTED')                       = 2054;
err_list('CR_SERVER_LOST_EXTENDED')                  = 2055;
err_list('CR_STMT_CLOSED')                           = 2056;
err_list('CR_NEW_STMT_METADATA')                     = 2057;
err_list('CR_ERROR_LAST')                            = 2057;
err_list('CR_MAX_ERROR')                             = 2999;
endfunction
