// ====================================================================
// Copyright INRIA 2008
// This file is released into the public domain
// ====================================================================



function buildhelp(language)
  path = get_absolute_file_path('build_help.sce');
  scimax = path + '/SciMax/'; 
  maxima = path + '/Maxima/';
  global maxima_version;
  create_Master_Help ([scimax maxima], ['SciMax' maxima_version], 'SciMax"+...
		      " Toolbox', path+'master_help.xml', language);
  name = 'scilab_'+language+'_help'
  mkdir(name);
  chdir(name);
  buildDoc("javaHelp",path+"/master_help.xml",language,path);
  mkdir(path+'/../../jar');
  copyfile(name+'.jar',path+'/../../jar/'+name+'.jar');
  mdelete(name+'.jar');
endfunction

function create_Master_Help(my_dirs, my_titles, my_tbx_title, output_filename, language)
  	
  if or(language == ["fr_FR";"pt_BR"]) then
    encoding = "ISO-8859-1";
	else
	  encoding = "UTF-8";
  end
  
  master_document = ["<?xml version=""1.0"" encoding="""+encoding+"""?>"; ..
		     "<!DOCTYPE book [";
		     "<!--Begin Entities-->"];
  
  for my_dir=my_dirs
    
    xml_files = basename(listfiles(my_dir+"/*.xml"));
    xml_files = gsort(listfiles(my_dir+"/*.xml"),"lr","i");
    
    xml_files(grep(xml_files,"master_help.xml")) = [];
    
    if MSDOS then
      for j=1:size(xml_files,'*')
	xml_files_tmp(j) = "file:///"+ getshortpathname(xml_files(j));
      end
    else
      xml_files_tmp = xml_files;
    end
    
    master_document    = [master_document; ..
		    "<!ENTITY "+basename(xml_files)+" SYSTEM """+xml_files_tmp+""">"];
  end
  
  master_document    = [ master_document; ..
		    "<!--End Entities-->"; ..
		    "]>"; ..
		    "<book version=""5.0-subset Scilab"" xml:lang="""+language+""""; ..
		    "      xmlns=""http://docbook.org/ns/docbook"""; ..
		    "      xmlns:xlink=""http://www.w3.org/1999/xlink"""; ..
		    "      xmlns:xi=""http://www.w3.org/2001/XInclude"""; ..
		    "      xmlns:svg=""http://www.w3.org/2000/svg"""; ..
		    "      xmlns:mml=""http://www.w3.org/1998/Math/MathML"""; ..
		    "      xmlns:html=""http://www.w3.org/1999/xhtml"""; ..
		    "      xmlns:db=""http://docbook.org/ns/docbook"">"; ..
		    "  <info>"; ..
		    "    <title>"+my_tbx_title+"</title>"; ..
		    "  </info>"; ..
		    "<!--Begin Reference-->"];
  for i=1:size(my_dirs,'*')
    
    xml_files = gsort(listfiles(my_dirs(i)+"/*.xml"),"lr","i");
    
    xml_files(grep(xml_files,"master_help.xml")) = [];
    master_document    = [ master_document; ..
		    "<reference xml:id=''"+title2category(my_tbx_title)+"''>"; ..
		    "<title>"+text2html(my_titles(i))+"</title>"; ..
		    "&"+basename(xml_files)+";"; ..
		    "</reference>"]
  end
  
  master_document    = [ master_document; ..
		    "  <!--End Reference-->"; ..
		    "</book>" ];
  
  mputl(master_document,output_filename);
  
endfunction

function category = title2category(mytitle)
		
		category = mytitle;
		category = strsubst(category , "&"  , "_" );
		
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "A" );
		category = strsubst(category , ""  , "AE");
		category = strsubst(category , ""  , "C" );
		category = strsubst(category , ""  , "E" );
		category = strsubst(category , ""  , "E" );
		category = strsubst(category , ""  , "E" );
		category = strsubst(category , ""  , "E" );
		category = strsubst(category , ""  , "I" );
		category = strsubst(category , ""  , "I" );
		category = strsubst(category , ""  , "I" );
		category = strsubst(category , ""  , "I" );
		category = strsubst(category , ""  , "D" );
		category = strsubst(category , ""  , "N" );
		category = strsubst(category , ""  , "O" );
		category = strsubst(category , ""  , "O" );
		category = strsubst(category , ""  , "O" );
		category = strsubst(category , ""  , "O" );
		category = strsubst(category , ""  , "O" );
		category = strsubst(category , ""  , "U" );
		category = strsubst(category , ""  , "U" );
		category = strsubst(category , ""  , "U" );
		category = strsubst(category , ""  , "U" );
		category = strsubst(category , ""  , "Y" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "a" );
		category = strsubst(category , ""  , "ae");
		category = strsubst(category , ""  , "c" );
		category = strsubst(category , ""  , "e" );
		category = strsubst(category , ""  , "e" );
		category = strsubst(category , ""  , "e" );
		category = strsubst(category , ""  , "e" );
		category = strsubst(category , ""  , "i" );
		category = strsubst(category , ""  , "i" );
		category = strsubst(category , ""  , "i" );
		category = strsubst(category , ""  , "i" );
		category = strsubst(category , ""  , "n" );
		category = strsubst(category , ""  , "o" );
		category = strsubst(category , ""  , "o" );
		category = strsubst(category , ""  , "o" );
		category = strsubst(category , ""  , "o" );
		category = strsubst(category , ""  , "o" );
		category = strsubst(category , ""  , "u" );
		category = strsubst(category , ""  , "u" );
		category = strsubst(category , ""  , "u" );
		category = strsubst(category , ""  , "u" );
		category = strsubst(category , ""  , "y" );
		category = strsubst(category , ""  , "y" );
		
		category = strsubst(category , ":"  , ""  );
		category = strsubst(category , "\"  , "_" );
		category = strsubst(category , "/"  , "_" );
		category = strsubst(category , "''" , "_" );
		category = strsubst(category , "  " , " " );
		category = strsubst(category , " "  , "_" );
		category = strsubst(category , "["  , ""  );
		category = strsubst(category , "]"  , ""  );
		
		category = convstr(category,"l");
		category = "category_"+category;
		
endfunction


function out = text2html(in)
		
		out = in;
		out = strsubst(out , "&"  , "&amp;"    );
		
// 		
// 		out = strsubst(out , """" , "&quot;"   );
// 		out = strsubst(out , "&"  , "&amp;"    );
// 		out = strsubst(out , ""  , "&euro;"   );
// 		out = strsubst(out , ""  , "&Agrave;" );
// 		out = strsubst(out , ""  , "&Aacute;" );
// 		out = strsubst(out , ""  , "&Acirc;"  );
// 		out = strsubst(out , ""  , "&Atilde;" );
// 		out = strsubst(out , ""  , "&Auml;"   );
// 		out = strsubst(out , ""  , "&Aring;"  );
// 		out = strsubst(out , ""  , "&Aelig"   );
// 		out = strsubst(out , ""  , "&Ccedil;" );
// 		out = strsubst(out , ""  , "&Egrave;" );
// 		out = strsubst(out , ""  , "&Eacute;" );
// 		out = strsubst(out , ""  , "&Ecirc;"  );
// 		out = strsubst(out , ""  , "&Euml;"   );
// 		out = strsubst(out , ""  , "&Igrave"  );;
// 		out = strsubst(out , ""  , "&Iacute;" );
// 		out = strsubst(out , ""  , "&Icirc;"  );
// 		out = strsubst(out , ""  , "&Iuml;"   );
// 		out = strsubst(out , ""  , "&eth;"    );
// 		out = strsubst(out , ""  , "&Ntilde;" );
// 		out = strsubst(out , ""  , "&Ograve;" );
// 		out = strsubst(out , ""  , "&Oacute;" );
// 		out = strsubst(out , ""  , "&Ocirc;"  );
// 		out = strsubst(out , ""  , "&Otilde;" );
// 		out = strsubst(out , ""  , "&Ouml;"   );
// 		out = strsubst(out , ""  , "&Ugrave;" );
// 		out = strsubst(out , ""  , "&Uacute;" );
// 		out = strsubst(out , ""  , "&Ucirc;"  );
// 		out = strsubst(out , ""  , "&Uuml;"   );
// 		out = strsubst(out , ""  , "&Yacute;" );
// 		out = strsubst(out , ""  , "&thorn;"  );
// 		out = strsubst(out , ""  , "&szlig;"  );
// 		out = strsubst(out , ""  , "&agrave;" );
// 		out = strsubst(out , ""  , "&aacute;" );
// 		out = strsubst(out , ""  , "&acirc;"  );
// 		out = strsubst(out , ""  , "&atilde;" );
// 		out = strsubst(out , ""  , "&auml;"   );
// 		out = strsubst(out , ""  , "&aring;"  );
// 		out = strsubst(out , ""  , "&aelig;"  );
// 		out = strsubst(out , ""  , "&ccedil;" );
// 		out = strsubst(out , ""  , "&egrave"  );;
// 		out = strsubst(out , ""  , "&eacute;" );
// 		out = strsubst(out , ""  , "&ecirc;"  );
// 		out = strsubst(out , ""  , "&euml;"   );
// 		out = strsubst(out , ""  , "&igrave"  );;
// 		out = strsubst(out , ""  , "&iacute;" );
// 		out = strsubst(out , ""  , "&icirc;"  );
// 		out = strsubst(out , ""  , "&iuml;"   );
// 		out = strsubst(out , ""  , "&eth;"    );
// 		out = strsubst(out , ""  , "&ntilde;" );
// 		out = strsubst(out , ""  , "&ograve;" );
// 		out = strsubst(out , ""  , "&oacute;" );
// 		out = strsubst(out , ""  , "&ocirc;"  );
// 		out = strsubst(out , ""  , "&otilde;" );
// 		out = strsubst(out , ""  , "&ouml;"   );
// 		out = strsubst(out , ""  , "&ugrave;" );
// 		out = strsubst(out , ""  , "&uacute;" );
// 		out = strsubst(out , ""  , "&ucirc;"  );
// 		out = strsubst(out , ""  , "&uuml;"   );
// 		out = strsubst(out , ""  , "&yacute;" );
// 		out = strsubst(out , ""  , "&thorn;"  );
// 		out = strsubst(out , ""  , "&yuml;"   );
// 		out = strsubst(out , ""  , "&micro;"  );
	
endfunction