#include "ScilabJavaObject.hxx"
/* Generated by GIWS (version 1.2.4) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace ScilabObjects {

// Returns the current env

JNIEnv * ScilabJavaObject::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

ScilabJavaObject::~ScilabJavaObject() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintinvokejintjstringjintArray_ID=NULL; 
voidinitScilabJavaObjectID=NULL; 
voidgarbageCollectID=NULL; 
jstringgetRepresentationjintID=NULL; 
jbooleanisValidJavaObjectjintID=NULL; 
voidenableTracejstringID=NULL; 
voiddisableTraceID=NULL; 
voidsetFieldjintjstringjintID=NULL; 
jintgetFieldjintjstringID=NULL; 
jintgetFieldTypejintjstringID=NULL; 
jintjavaCastjintjstringID=NULL; 
jintjavaCastjintjintID=NULL; 
jstringgetClassNamejintID=NULL; 
jintgetArrayElementjintjintArray_ID=NULL; 
voidsetArrayElementjintjintArray_jintID=NULL; 
voidremoveScilabJavaObjectjintID=NULL; 
voidlimitDirectBufferjintID=NULL; 
jintisUnwrappablejintID=NULL; 
jintwrapDoublejdoubleID=NULL; 
jintwrapDoublejdoubleArray_ID=NULL; 
jintwrapDoublejobjectArray__ID=NULL; 
jintwrapIntjintID=NULL; 
jintwrapIntjintArray_ID=NULL; 
jintwrapIntjobjectArray__ID=NULL; 
jintwrapUIntjlongID=NULL; 
jintwrapUIntjlongArray_ID=NULL; 
jintwrapUIntjobjectArray__ID=NULL; 
jintwrapBytejbyteID=NULL; 
jintwrapBytejbyteArray_ID=NULL; 
jintwrapBytejobjectArray__ID=NULL; 
jintwrapUBytejshortID=NULL; 
jintwrapUBytejshortArray_ID=NULL; 
jintwrapUBytejobjectArray__ID=NULL; 
jintwrapShortjshortID=NULL; 
jintwrapShortjshortArray_ID=NULL; 
jintwrapShortjobjectArray__ID=NULL; 
jintwrapUShortjintID=NULL; 
jintwrapUShortjintArray_ID=NULL; 
jintwrapUShortjobjectArray__ID=NULL; 
jintwrapStringjstringID=NULL; 
jintwrapStringjobjectArray_ID=NULL; 
jintwrapStringjobjectArray__ID=NULL; 
jintwrapBooleanjbooleanID=NULL; 
jintwrapBooleanjbooleanArray_ID=NULL; 
jintwrapBooleanjobjectArray__ID=NULL; 
jintwrapCharjcharID=NULL; 
jintwrapCharjcharArray_ID=NULL; 
jintwrapCharjobjectArray__ID=NULL; 
jintwrapFloatjfloatID=NULL; 
jintwrapFloatjfloatArray_ID=NULL; 
jintwrapFloatjobjectArray__ID=NULL; 
jintwrapLongjlongID=NULL; 
jintwrapLongjlongArray_ID=NULL; 
jintwrapLongjobjectArray__ID=NULL; 


}

ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintinvokejintjstringjintArray_ID=NULL; 
voidinitScilabJavaObjectID=NULL; 
voidgarbageCollectID=NULL; 
jstringgetRepresentationjintID=NULL; 
jbooleanisValidJavaObjectjintID=NULL; 
voidenableTracejstringID=NULL; 
voiddisableTraceID=NULL; 
voidsetFieldjintjstringjintID=NULL; 
jintgetFieldjintjstringID=NULL; 
jintgetFieldTypejintjstringID=NULL; 
jintjavaCastjintjstringID=NULL; 
jintjavaCastjintjintID=NULL; 
jstringgetClassNamejintID=NULL; 
jintgetArrayElementjintjintArray_ID=NULL; 
voidsetArrayElementjintjintArray_jintID=NULL; 
voidremoveScilabJavaObjectjintID=NULL; 
voidlimitDirectBufferjintID=NULL; 
jintisUnwrappablejintID=NULL; 
jintwrapDoublejdoubleID=NULL; 
jintwrapDoublejdoubleArray_ID=NULL; 
jintwrapDoublejobjectArray__ID=NULL; 
jintwrapIntjintID=NULL; 
jintwrapIntjintArray_ID=NULL; 
jintwrapIntjobjectArray__ID=NULL; 
jintwrapUIntjlongID=NULL; 
jintwrapUIntjlongArray_ID=NULL; 
jintwrapUIntjobjectArray__ID=NULL; 
jintwrapBytejbyteID=NULL; 
jintwrapBytejbyteArray_ID=NULL; 
jintwrapBytejobjectArray__ID=NULL; 
jintwrapUBytejshortID=NULL; 
jintwrapUBytejshortArray_ID=NULL; 
jintwrapUBytejobjectArray__ID=NULL; 
jintwrapShortjshortID=NULL; 
jintwrapShortjshortArray_ID=NULL; 
jintwrapShortjobjectArray__ID=NULL; 
jintwrapUShortjintID=NULL; 
jintwrapUShortjintArray_ID=NULL; 
jintwrapUShortjobjectArray__ID=NULL; 
jintwrapStringjstringID=NULL; 
jintwrapStringjobjectArray_ID=NULL; 
jintwrapStringjobjectArray__ID=NULL; 
jintwrapBooleanjbooleanID=NULL; 
jintwrapBooleanjbooleanArray_ID=NULL; 
jintwrapBooleanjobjectArray__ID=NULL; 
jintwrapCharjcharID=NULL; 
jintwrapCharjcharArray_ID=NULL; 
jintwrapCharjobjectArray__ID=NULL; 
jintwrapFloatjfloatID=NULL; 
jintwrapFloatjfloatArray_ID=NULL; 
jintwrapFloatjobjectArray__ID=NULL; 
jintwrapLongjlongID=NULL; 
jintwrapLongjlongArray_ID=NULL; 
jintwrapLongjobjectArray__ID=NULL; 


}

// Generic methods

void ScilabJavaObject::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}

void ScilabJavaObject::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}
// Method(s)

int ScilabJavaObject::invoke (JavaVM * jvm_, int id, char * methodName, int* args, int argsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintinvokejintjstringjintArray_ID = curEnv->GetStaticMethodID(cls, "invoke", "(ILjava/lang/String;[I)I" ) ;
if (jintinvokejintjstringjintArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "invoke");
}

jstring methodName_ = curEnv->NewStringUTF( methodName );
if (methodName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jintArray args_ = curEnv->NewIntArray( argsSize ) ;

if (args_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( args_, 0, argsSize, (jint*)(args) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintinvokejintjstringjintArray_ID ,id, methodName_, args_));
                        curEnv->DeleteLocalRef(methodName_);
curEnv->DeleteLocalRef(args_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::initScilabJavaObject (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidinitScilabJavaObjectID = curEnv->GetStaticMethodID(cls, "initScilabJavaObject", "()V" ) ;
if (voidinitScilabJavaObjectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidinitScilabJavaObjectID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::garbageCollect (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidgarbageCollectID = curEnv->GetStaticMethodID(cls, "garbageCollect", "()V" ) ;
if (voidgarbageCollectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "garbageCollect");
}

                         curEnv->CallStaticVoidMethod(cls, voidgarbageCollectID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char * ScilabJavaObject::getRepresentation (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetRepresentationjintID = curEnv->GetStaticMethodID(cls, "getRepresentation", "(I)Ljava/lang/String;" ) ;
if (jstringgetRepresentationjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getRepresentation");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetRepresentationjintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

bool ScilabJavaObject::isValidJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisValidJavaObjectjintID = curEnv->GetStaticMethodID(cls, "isValidJavaObject", "(I)Z" ) ;
if (jbooleanisValidJavaObjectjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isValidJavaObject");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisValidJavaObjectjintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void ScilabJavaObject::enableTrace (JavaVM * jvm_, char * filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidenableTracejstringID = curEnv->GetStaticMethodID(cls, "enableTrace", "(Ljava/lang/String;)V" ) ;
if (voidenableTracejstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "enableTrace");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidenableTracejstringID ,filename_);
                        curEnv->DeleteLocalRef(filename_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::disableTrace (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddisableTraceID = curEnv->GetStaticMethodID(cls, "disableTrace", "()V" ) ;
if (voiddisableTraceID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "disableTrace");
}

                         curEnv->CallStaticVoidMethod(cls, voiddisableTraceID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::setField (JavaVM * jvm_, int id, char * fieldName, int idarg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFieldjintjstringjintID = curEnv->GetStaticMethodID(cls, "setField", "(ILjava/lang/String;I)V" ) ;
if (voidsetFieldjintjstringjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFieldjintjstringjintID ,id, fieldName_, idarg);
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::getField (JavaVM * jvm_, int id, char * fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFieldjintjstringID = curEnv->GetStaticMethodID(cls, "getField", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldjintjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldjintjstringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::getFieldType (JavaVM * jvm_, int id, char * fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFieldTypejintjstringID = curEnv->GetStaticMethodID(cls, "getFieldType", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldTypejintjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFieldType");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldTypejintjstringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, char * objName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintjavaCastjintjstringID = curEnv->GetStaticMethodID(cls, "javaCast", "(ILjava/lang/String;)I" ) ;
if (jintjavaCastjintjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

jstring objName_ = curEnv->NewStringUTF( objName );
if (objName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintjstringID ,id, objName_));
                        curEnv->DeleteLocalRef(objName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, int classId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintjavaCastjintjintID = curEnv->GetStaticMethodID(cls, "javaCast", "(II)I" ) ;
if (jintjavaCastjintjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintjintID ,id, classId));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char * ScilabJavaObject::getClassName (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetClassNamejintID = curEnv->GetStaticMethodID(cls, "getClassName", "(I)Ljava/lang/String;" ) ;
if (jstringgetClassNamejintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getClassName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetClassNamejintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

int ScilabJavaObject::getArrayElement (JavaVM * jvm_, int id, int* index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetArrayElementjintjintArray_ID = curEnv->GetStaticMethodID(cls, "getArrayElement", "(I[I)I" ) ;
if (jintgetArrayElementjintjintArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetArrayElementjintjintArray_ID ,id, index_));
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::setArrayElement (JavaVM * jvm_, int id, int* index, int indexSize, int idArg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetArrayElementjintjintArray_jintID = curEnv->GetStaticMethodID(cls, "setArrayElement", "(I[II)V" ) ;
if (voidsetArrayElementjintjintArray_jintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetArrayElementjintjintArray_jintID ,id, index_, idArg);
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::removeScilabJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveScilabJavaObjectjintID = curEnv->GetStaticMethodID(cls, "removeScilabJavaObject", "(I)V" ) ;
if (voidremoveScilabJavaObjectjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveScilabJavaObjectjintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::limitDirectBuffer (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidlimitDirectBufferjintID = curEnv->GetStaticMethodID(cls, "limitDirectBuffer", "(I)V" ) ;
if (voidlimitDirectBufferjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "limitDirectBuffer");
}

                         curEnv->CallStaticVoidMethod(cls, voidlimitDirectBufferjintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::isUnwrappable (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintisUnwrappablejintID = curEnv->GetStaticMethodID(cls, "isUnwrappable", "(I)I" ) ;
if (jintisUnwrappablejintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isUnwrappable");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintisUnwrappablejintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejdoubleID = curEnv->GetStaticMethodID(cls, "wrapDouble", "(D)I" ) ;
if (jintwrapDoublejdoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejdoubleID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejdoubleArray_ID = curEnv->GetStaticMethodID(cls, "wrapDouble", "([D)I" ) ;
if (jintwrapDoublejdoubleArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

jdoubleArray x_ = curEnv->NewDoubleArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( x_, 0, xSize, (jdouble*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejdoubleArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapDouble", "([[D)I" ) ;
if (jintwrapDoublejobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[D"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jdoubleArray xLocal = curEnv->NewDoubleArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( xLocal, 0, xSizeCol, (jdouble*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjintID = curEnv->GetStaticMethodID(cls, "wrapInt", "(I)I" ) ;
if (jintwrapIntjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjintID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjintArray_ID = curEnv->GetStaticMethodID(cls, "wrapInt", "([I)I" ) ;
if (jintwrapIntjintArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

jintArray x_ = curEnv->NewIntArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( x_, 0, xSize, (jint*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjintArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapInt", "([[I)I" ) ;
if (jintwrapIntjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[I"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jintArray xLocal = curEnv->NewIntArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( xLocal, 0, xSizeCol, (jint*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjlongID = curEnv->GetStaticMethodID(cls, "wrapUInt", "(J)I" ) ;
if (jintwrapUIntjlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjlongID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjlongArray_ID = curEnv->GetStaticMethodID(cls, "wrapUInt", "([J)I" ) ;
if (jintwrapUIntjlongArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

jlongArray x_ = curEnv->NewLongArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( x_, 0, xSize, (jlong*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjlongArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapUInt", "([[J)I" ) ;
if (jintwrapUIntjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[J"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jlongArray xLocal = curEnv->NewLongArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( xLocal, 0, xSizeCol, (jlong*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejbyteID = curEnv->GetStaticMethodID(cls, "wrapByte", "(B)I" ) ;
if (jintwrapBytejbyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejbyteID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejbyteArray_ID = curEnv->GetStaticMethodID(cls, "wrapByte", "([B)I" ) ;
if (jintwrapBytejbyteArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

jbyteArray x_ = curEnv->NewByteArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( x_, 0, xSize, (jbyte*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejbyteArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapByte", "([[B)I" ) ;
if (jintwrapBytejobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[B"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jbyteArray xLocal = curEnv->NewByteArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( xLocal, 0, xSizeCol, (jbyte*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejshortID = curEnv->GetStaticMethodID(cls, "wrapUByte", "(S)I" ) ;
if (jintwrapUBytejshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejshortID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejshortArray_ID = curEnv->GetStaticMethodID(cls, "wrapUByte", "([S)I" ) ;
if (jintwrapUBytejshortArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

jshortArray x_ = curEnv->NewShortArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( x_, 0, xSize, (jshort*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejshortArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapUByte", "([[S)I" ) ;
if (jintwrapUBytejobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[S"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jshortArray xLocal = curEnv->NewShortArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( xLocal, 0, xSizeCol, (jshort*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjshortID = curEnv->GetStaticMethodID(cls, "wrapShort", "(S)I" ) ;
if (jintwrapShortjshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjshortID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjshortArray_ID = curEnv->GetStaticMethodID(cls, "wrapShort", "([S)I" ) ;
if (jintwrapShortjshortArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

jshortArray x_ = curEnv->NewShortArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( x_, 0, xSize, (jshort*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjshortArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapShort", "([[S)I" ) ;
if (jintwrapShortjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[S"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jshortArray xLocal = curEnv->NewShortArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( xLocal, 0, xSizeCol, (jshort*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjintID = curEnv->GetStaticMethodID(cls, "wrapUShort", "(I)I" ) ;
if (jintwrapUShortjintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjintID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjintArray_ID = curEnv->GetStaticMethodID(cls, "wrapUShort", "([I)I" ) ;
if (jintwrapUShortjintArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

jintArray x_ = curEnv->NewIntArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( x_, 0, xSize, (jint*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjintArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapUShort", "([[I)I" ) ;
if (jintwrapUShortjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[I"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jintArray xLocal = curEnv->NewIntArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( xLocal, 0, xSizeCol, (jint*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char * x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjstringID = curEnv->GetStaticMethodID(cls, "wrapString", "(Ljava/lang/String;)I" ) ;
if (jintwrapStringjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}

jstring x_ = curEnv->NewStringUTF( x );
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjstringID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char ** x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjobjectArray_ID = curEnv->GetStaticMethodID(cls, "wrapString", "([Ljava/lang/String;)I" ) ;
if (jintwrapStringjobjectArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, stringArrayClass, NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < xSize; i++)
{
jstring TempString = curEnv->NewStringUTF( x[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( x_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjobjectArray_ID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char *** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapString", "([[Ljava/lang/String;)I" ) ;
if (jintwrapStringjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < xSize; i++)
{
jobjectArray xLocal = curEnv->NewObjectArray( xSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < xSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( x[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( xLocal, j, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);

}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjbooleanID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "(Z)I" ) ;
if (jintwrapBooleanjbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jboolean x_ = (static_cast<bool>(x) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjbooleanID ,x_));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjbooleanArray_ID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "([Z)I" ) ;
if (jintwrapBooleanjbooleanArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jbooleanArray x_ = curEnv->NewBooleanArray( xSize ) ;
curEnv->SetBooleanArrayRegion( x_, 0, xSize, (jboolean*)x ) ;

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjbooleanArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "([[Z)I" ) ;
if (jintwrapBooleanjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[Z"),NULL);
for (int i=0; i<xSize; i++){
                        jbooleanArray xLocal = curEnv->NewBooleanArray( xSizeCol ) ;
                        curEnv->SetBooleanArrayRegion( xLocal, 0, xSizeCol, (jboolean*)(x[i]) ) ;
                        curEnv->SetObjectArrayElement(x_, i, xLocal);
                        curEnv->DeleteLocalRef(xLocal);
                        }

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjcharID = curEnv->GetStaticMethodID(cls, "wrapChar", "(C)I" ) ;
if (jintwrapCharjcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjcharID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjcharArray_ID = curEnv->GetStaticMethodID(cls, "wrapChar", "([C)I" ) ;
if (jintwrapCharjcharArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

jcharArray x_ = curEnv->NewCharArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( x_, 0, xSize, (jchar*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjcharArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapChar", "([[C)I" ) ;
if (jintwrapCharjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[C"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jcharArray xLocal = curEnv->NewCharArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( xLocal, 0, xSizeCol, (jchar*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjfloatID = curEnv->GetStaticMethodID(cls, "wrapFloat", "(F)I" ) ;
if (jintwrapFloatjfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjfloatID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjfloatArray_ID = curEnv->GetStaticMethodID(cls, "wrapFloat", "([F)I" ) ;
if (jintwrapFloatjfloatArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

jfloatArray x_ = curEnv->NewFloatArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( x_, 0, xSize, (jfloat*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjfloatArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapFloat", "([[F)I" ) ;
if (jintwrapFloatjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[F"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jfloatArray xLocal = curEnv->NewFloatArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( xLocal, 0, xSizeCol, (jfloat*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjlongID = curEnv->GetStaticMethodID(cls, "wrapLong", "(J)I" ) ;
if (jintwrapLongjlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjlongID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjlongArray_ID = curEnv->GetStaticMethodID(cls, "wrapLong", "([J)I" ) ;
if (jintwrapLongjlongArray_ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

jlongArray x_ = curEnv->NewLongArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( x_, 0, xSize, (jlong*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjlongArray_ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long** x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjobjectArray__ID = curEnv->GetStaticMethodID(cls, "wrapLong", "([[J)I" ) ;
if (jintwrapLongjobjectArray__ID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[J"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jlongArray xLocal = curEnv->NewLongArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( xLocal, 0, xSizeCol, (jlong*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjobjectArray__ID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
