//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.


// Actions associated with CelestLab menu
// => see CL__menu 
function [action] = CL__menu_action(k)

  // actions associated with each label
  actions = [ ..
    "CL__demos();" ; ..
    "help(''CelestLab'');" ; ..
    "CL__releaseNotes();" ; ..
    "" ; ..
    "messagebox(CL_home(), ''CelestLab home directory'');" ; ..
    "CL_d = fullfile(CL_home(),''data'',''utils'');" + ..
    "CL_l = findfiles(CL_d, ''*.scd'');" +..
    "if (CL_l <> []);" +..
    "  CL_n = x_choose(CL_l, CL_d + '':'');" +..
    "  if (CL_n  > 0);" +..
    "    editor(fullfile(CL_d, CL_l(CL_n)), ''readonly'');" +..
    "  end;" + ..
    "end" ];   


  if (k >= 1 & k <= size(actions, "*"))
    action = actions(k); 
  else
    action = "";  
  end

endfunction


