//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function s = CL_stumpS(z)
// Stumpff function S(z)
//
// Calling Sequence
// s = CL_stumpS(z)
//
// Description
// <itemizedlist><listitem>
// evaluates the Stumpff function S(z) according to the following equation :
// <para/><inlinemediaobject><imageobject><imagedata fileref="stumpS.gif"/></imageobject></inlinemediaobject></listitem>
// </itemizedlist>
// <para><emphasis role="bold">( Last updated: 2010-02-17 )</emphasis></para>
//
// Parameters
// z: input argument (1xN)
// s: value of S(z) (1xN)
//
// Authors
// CNES - DCT/SB
//
// Bibliography
// 1 Orbital Mechanics for engineering students, H D Curtis, Chapter 3 and Appendix D.4
// 2 Modern astrodynamics Fundamentals and perturbation methods, V Bond and M Allman, Chapter 6.2
//
// See also
// CL_stumpC
//
// Examples
// z=0:1:500;
// s=CL_stumpS(z);
// plot(z,s);
//

// Declarations:


// Code:

s=zeros(z);

z1=find(z>0)
z2=find(z<0)
z3=find(z==0)

s(z1) = (sqrt(z(z1)) - sin(sqrt(z(z1))))./(sqrt(z(z1))).^3;
s(z2) = (sinh(sqrt(-z(z2))) - sqrt(-z(z2)))./(sqrt(-z(z2))).^3;
s(z3) = 1/6;


endfunction
