//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [norms] = CL_colNorm(M)
// Norm of column vectors
//
// Calling Sequence
// norms = CL_colNorm(M)
//
// Description
// <itemizedlist><listitem>
// Computes the norms of column vectors. 
// </listitem>
// <listitem>
// Deprecated. 
// <para> Use CL_norm instead. </para>
// </listitem>
// </itemizedlist>
// <para><emphasis role="bold">( Last updated: 2010-02-17 )</emphasis></para>
//
// Parameters
// M: Matrix (PxNxK) 
// norms: Norms of column vectors (1xNxK), where norms(1,j,k) = norm(M(:,j,k))
//
// Authors
// CNES - DCT/SB
//
// See also
// CL_unitVector
// CL_colMult
//
// Examples
// // With a matrix :
// M = rand(3,5);
// norms = CL_colNorm(M);
//
// // With an hypermatrix :
// M = rand(3,5,2);
// norms = CL_colNorm(M);


// Declarations:


// Code:

M_type = typeof(M);

if (M_type == 'constant')
  norms = sqrt(sum(M.^2,'r'));

elseif (M_type == 'hypermat')
  norms = ones(1,M.dims(2),M.dims(3));
  for k = 1:M.dims(3)
    norms(:,:,k) = CL_colNorm(M(:,:,k));
  end

else
  CL__error('Invalid type of input argument');
end

endfunction
