/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_edit_dialog.h"
#include "sg_dialogs.h"
#include "sg_dataset.h"
#include "sg.h"

#define DATASET_NAME_LENGTH 100

static SGlayerType layer_type;
static SGdialog active_dialog = COLUMNS_DIALOG;

static SGdataset *dataset = NULL;
static GtkWidget *window = NULL;
static GtkWidget *main_table;
static GtkWidget *worksheet_combo, *goto_combo;
static SGplot *plot;
static GtkWidget* dialog = NULL;
static gboolean return_ok;

static gint goto_dialog                                 (SGdataset *dataset);


static gboolean
mw_destroy(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */

  sg_dialog_kill(widget);

  gtk_main_quit ();

  return FALSE;
}

static gboolean
cancel_pressed(GtkWidget *widget)
{
  gtk_widget_destroy(window);

  dataset = NULL;
  return FALSE;
}

static gboolean
ok_pressed(GtkWidget *widget)
{
  SGdataset *new_dataset = NULL;
  gboolean veto;
  gchar column_text[9][100];
  gint i;
  gchar name[DATASET_NAME_LENGTH] = "";


  switch(active_dialog){

   case COLUMNS_DIALOG:
    new_dataset = sg_edit_columns_update();
    if(!new_dataset) return FALSE;

    break;
   case MATRIX_DIALOG:
    new_dataset = sg_edit_3d_update();
    if(!new_dataset) return FALSE;

    break;
  case FUNCTIONS_DIALOG:
    new_dataset = sg_edit_function_update();
    if(!new_dataset) return FALSE;

    break;
  case PYTHON_DIALOG:

    new_dataset = sg_edit_exp_update();
    if(!new_dataset) return FALSE;

    break;
  }

  return_ok = TRUE;
  gtk_widget_destroy(widget);

  return FALSE;
}


void
sg_edit_data_dialog (SGdataset *dataset, SGlayerType type)
{
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *worksheet_combo;
  GList *list;
  SGplot *plot;
  gchar text[DATASET_NAME_LENGTH];
  gint i;

  if(!dataset) return;

  return_ok = FALSE;

  layer_type = type;

  dialog = NULL;

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  sg_dialog_new(window);

  gtk_window_set_title (GTK_WINDOW(window),"Edit dataset");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_container_add(GTK_CONTAINER (window), frame);

/**********************************************************/
  main_table = gtk_table_new(3, 1, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 10);
  gtk_container_add(GTK_CONTAINER(frame), main_table);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 5);

  main_box = gtk_vbox_new (FALSE, 5);
  gtk_table_attach_defaults(GTK_TABLE(main_table), main_box, 0, 1, 3, 4);

  goto_dialog(dataset);

/**********************************************************/

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_container_set_border_width(GTK_CONTAINER(action_area), 5);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = sg_stock_button ("Button_Ok");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  cancel_button = sg_stock_button ("Button_Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */

  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (cancel_pressed),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (ok_pressed),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

}

static gint
goto_dialog(SGdataset *dataset)
{
  gchar name[DATASET_NAME_LENGTH];

  if(GTK_IS_WIDGET(dialog)) gtk_container_remove(GTK_CONTAINER(main_table), dialog);

  switch(dataset->type){
    case SG_DATA_FUNCTION:
      active_dialog = FUNCTIONS_DIALOG;
      dialog = sg_edit_function_dialog(dataset);
      break;
    case SG_DATA_PYTHON:
      active_dialog = PYTHON_DIALOG;
      dialog = sg_edit_exp_dialog(dataset, layer_type);
      break;
    case SG_DATA_MATRIX:
      active_dialog = MATRIX_DIALOG;
      dialog = sg_edit_3d_dialog(dataset, layer_type);
      break;
    case SG_DATA_COLUMNS:
    default:
      active_dialog = COLUMNS_DIALOG;
      dialog = sg_edit_columns_dialog(dataset, layer_type);
      break;
  }

  gtk_table_attach_defaults(GTK_TABLE(main_table), dialog, 0, 1, 1, 2);

  gtk_widget_show_all(dialog);
  return TRUE;
}

