### help.tcl: Help pages for Scid.

#################################################

set helpTitle(Contents) "Contents"
set helpText(Contents) {<h1>Scid Help Contents</h1>

<h4>Starting out and general help</h4>
<ul>
<li><a Guide><b>Quick Guide</b> to using Scid</a> <red>(Read this first)</red></li>
<li><a Hints><b>Hints</b> for getting more out of Scid</a></li>
<li><a MainWindow>The Scid <b>main window</b></a></li>
<li><a Menus>Scid <b>menus</b></a> <red>(updated!)</red></li>
<li><a Moves>Entering <b>chess moves</b></a></li>
<li><a Searches><b>Searches</b> in Scid</a></li>
<li><a Clipbase>Using the <b>Clipbase</b> database</a></li>
<li><a Annotating><b>Annotating games</b></a></li>
</ul>

<h4>Other Scid windows</h4>
<ul>
<li><a Analysis><b>Analysis</b> window</a></li>
<li><a Comment><b>Comment editor</b> window</a></li>
<li><a Crosstable><b>Crosstable</b> window</a></li>
<li><a Switcher><b>Database Switcher</b> window</a></li>
<li><a Email><b>Email</b> chess manager window</a></li>
<li><a Finder><b>File Finder</b> window</a></li>
<li><a GameList><b>Game List</b> window</a></li>
<li><a Import><b>Import game</b> window</a></li>
<li><a Reports><b>Reports</b></a> <red>(updated!)</red></li>
<li><a PGN><b>PGN</b> (game text) window</a></li>
<li><a PTracker><b>Piece Tracker</b></a></li>
<li><a PList><b>Player Finder</b> window</a></li>
<li><a PInfo><b>Player Info</b> window</a></li>
<li><a Repertoire><b>Repertoire editor</b> window</a></li>
<li><a Tmt><b>Tournament Finder</b> window</a></li>
<li><a Tree><b>Tree</b> window</a></li>
<li><a Graphs><b>Graph</b> windows</a></li>
<li><a TB>Using <b>Tablebases</b> in Scid</a> <red>(updated!)</red></li>
</ul>

<h4>Other utilities and information</h4>
<ul>
<li><a Bookmarks><b>Bookmarks</b></a></li>
<li><a Cmdline>Command-line options</a></li>
<li><a Compact><b>Compacting</b> a database</a></li>
<li><a Maintenance><b>Database maintenance</b> tools</a></li>
<li><a ECO><b>ECO</b> openings classification</a></li>
<li><a EPD><b>EPD</b> files</a></li>
<li><a Export><b>Exporting</b> games to text files</a> <red>(updated!)</red></li>
<li><a Flags>Game <b>Flags</b></a></li>
<li><a LaTeX>Using <b>LaTeX</b> with Scid</a></li>
<li><a Options><b>Options</b> and preferences</a> <red>(updated!)</red></li>
<li><a Sorting><b>Sorting</b> a database</a></li>
<li><a Pgnscid><b>Pgnscid</b>: converting PGN files</a></li>
<li><a NAGs>Standard <b>NAG</b> annotation values</a></li>
<li><a Formats>Scid database <b>file formats</b></a></li>
<li><a Author>Contact information</a></li>
</ul>

<p><footer>(Updated: Scid 3.5, December 2003)</footer></p>
}

###############
### Topic Index

set helpTitle(Index) "Scid Help Topic Index"
set helpText(Index) {<h1>Scid Help Topic Index</h1>

<h3>A</h3>
<ul>
<li><a Analysis>Analysis</a> window</li>
<li><a Annotating>Annotating games</a></li>
<li><a NAGs>Annotation symbols</a></li>
<li><a Author>Author, contacting</a></li>
<li><a MainWindow Autoplay>Autoplay mode</a></li>
</ul>

<h3>B</h3>
<ul>
<li><a Tree Best>Best games</a> window</li>
<li><a Searches Board>Board searches</a></li>
<li><a Bookmarks>Bookmarks</a></li>
<li><a GameList Browsing>Browsing games</a></li>
</ul>

<h3>C</h3>
<ul>
<li><a Maintenance Cleaner>Cleaner</a></li>
<li><a Clipbase>Clipbase</a></li>
<li><a Cmdline>Command-line options</a></li>
<li><a Comment>Comment editor</a></li>
<li><a Compact>Compacting a database</a></li>
<li><a Author>Contact information</a></li>
<li><a Contents>Contents</a></li>
<li><a Crosstable>Crosstable</a> window</li>
</ul>

<h3>D</h3>
<ul>
<li><a Compact>Database compaction</a></li>
<li><a Formats>Database file formats</a></li>
<li><a Maintenance>Database maintenance</a></li>
<li><a Sorting>Database sorting</a></li>
<li><a Switcher>Database switcher</a> window</li>
<li><a Maintenance Twins>Deleting twin games</a></li>
</ul>

<h3>E</h3>
<ul>
<li><a ECO Browser>ECO Browser</a> window</li>
<li><a ECO Codes>ECO code system</a></li>
<li><a ECO>ECO openings classification</a></li>
<li><a Menus Edit>Edit menu</a></li>
<li><a Email>Email manager</a> window</li>
<li><a Analysis List>Engines list</a></li>
<li><a Moves>Entering chess moves</a></li>
<li><a EPD>EPD files</a></li>
<li><a Export>Exporting games to text files</a></li>
</ul>

<h3>F</h3>
<ul>
<li><a Finder>File Finder</a></li>
<li><a Formats>File formats</a></li>
<li><a Menus File>File menu</a></li>
<li><a Searches Filter>Filter</a></li>
<li><a Export>Filter, exporting</a></li>
<li><a Graphs Filter>Filter graph</a></li>
<li><a Flags>Flags</a></li>
<li><a Options Fonts>Fonts</a></li>
</ul>

<h3>G</h3>
<ul>
<li><a Flags>Game flags</a></li>
<li><a GameList>Game List</a> window</li>
<li><a Menus Game>Game menu</a></li>
<li><a Graphs>Graph windows</a></li>
</ul>

<h3>H</h3>
<ul>
<li><a Searches Header>Header searches</a></li>
<li><a Menus Help>Help menu</a></li>
<li><a Hints>Hints</a></li>
</ul>

<h3>I</h3>
<ul>
<li><a Import>Import</a> window</li>
</ul>

<h3>L</h3>
<ul>
<li><a LaTeX>LaTeX</a> output format</li>
</ul>

<h3>M</h3>
<ul>
<li><a MainWindow>Main Window</a></li>
<li><a Maintenance>Maintenance tools</a></li>
<li><a Searches Material>Material/pattern searches</a></li>
<li><a Menus>Menus</a></li>
<li><a GameList Browsing>Merging games</a></li>
<li><a Moves>Move entry</a></li>
</ul>

<h3>N</h3>
<ul>
<li><a Maintenance Editing>Names, editing</a></li>
<li><a Maintenance Spellcheck>Names, spellchecking</a></li>
<li><a NAGs>NAG annotation values</a></li>
<li><a Annotating Null>Null moves</a></li>
</ul>

<h3>O</h3>
<ul>
<li><a ECO>Opening classification (ECO)</a></li>
<li><a Repertoire>Opening repertoires</a></li>
<li><a Reports Opening>Opening report</a> window</li>
<li><a Options>Options</a></li>
</ul>

<h3>P</h3>
<ul>
<li><a PGN>PGN</a> window</li>
<li><a Pgnscid>Pgnscid</a></li>
<li><a PTracker>Piece Tracker</a> window</li>
<li><a PList>Player Finder</a> window</li>
<li><a PInfo>Player Info</a> window</li>
<li><a Reports Player>Player report</a> window</li>
</ul>

<h3>Q</h3>
<ul>
<li><a Guide>Quick guide to using Scid</a></li>
</ul>

<h3>R</h3>
<ul>
<li><a Graphs Rating>Rating graph</a></li>
<li><a Repertoire>Repertoire editor</a></li>
</ul>

<h3>S</h3>
<ul>
<li><a Searches Filter>Search filter</a></li>
<li><a Menus Search>Search menu</a></li>
<li><a Searches>Searches</a></li>
<li><a Sorting>Sorting a database</a></li>
<li><a Maintenance Spellcheck>Spellchecking names</a></li>
<li><a Switcher>Switcher</a> window</li>
</ul>

<h3>T</h3>
<ul>
<li><a TB>Tablebases</a></li>
<li><a Menus Tools>Tools menu</a></li>
<li><a Tmt>Tournament finder</a></li>
<li><a Tree>Tree window</a></li>
<li><a Moves Trial>Trial mode</a></li>
<li><a Maintenance Twins>Twin (duplicate) games</a></li>
</ul>

<h3>V</h3>
<ul>
<li><a Annotating Vars>Variations</a></li>
</ul>

<h3>W</h3>
<ul>
<li><a Menus Windows>Windows menu</a></li>
</ul>

<p><footer>(Updated: Scid 3.5, February 2003)</footer></p>
}


####################
### Quick Guide help:

set helpTitle(Guide) "Quick Guide to using Scid"
set helpText(Guide) {<h1>Quick Guide to using Scid</h1>
<p>
Scid is a chess database application; with it you can browse
databases of chess games, edit games and <a Searches>search</a>
for games by various criteria.
</p>
<p>
Scid uses its own special three-file <a Formats>database format</a>
which is very compact and fast, but it can convert to and from
the standard PGN (Portable Game Notation) format.
Scids <a PGN>PGN window</a> displays the text of the current game in
PGN format.
</p>
<p>
You can use Scid to add chess games to a database, using the keyboard or
mouse to enter moves. See the help page on <a Moves>entering chess moves</a>
for more details.
</p>
<p>
You can also use Scid as a <a PGN>PGN</a> file browser, by pasting
PGN text into Scids <a Import>Import</a> window or by opening a PGN file
in Scid.
However, PGN files cannot be edited by Scid (it opens them read-only) and
they use more memory and are slower to load, so for large PGN files it
is recommended that you create a Scid database from them first with the
<a Pgnscid>pgnscid</a> utility.
</p>
<p>
The <a MainWindow>main window</a>
of Scid (with the graphical chess board) shows details of
the active game and database. At any time, you can have up to four
databases open (five including the <a Clipbase>clipbase</a>),
and each will have its own active game.
(A game numbered 0 indicates a scratch game that is not part of the
actual database).
You can switch between the open databases with the
<a Menus File>File menu</a>.
</p>
<p>
For more information, please read the other help pages listed in the
<a Index>Help Index</a>.
</p>
<p>
See the <a Author>contact information</a> page if you need to contact the
author of Scid.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


####################
### Hints page:
set helpTitle(Hints) "Scid Hints"
set helpText(Hints) {<h1>Scid Hints</h1>
<p>
This page contains useful hints in question and answer format to help you
use Scid better. If you are new to Scid, please read the
<a Guide>quick guide</a> first.
Most of the information on this page is available in more detail on the
other help pages listed in the <a Index>index</a>.
If you think of a useful hint to add to this page, please send it
to the <a Author>author of Scid</a>.
</p>

<h4>Can I get Scid to load a database when it starts?</h4>
<p>
Yes, you can add databases, PGN files or <a EPD>EPD files</a>
to the command line. For example:
<ul>
<li> <b>scid  mybase  games.pgn.gz</b> </li>
</ul>
will load the Scid database <b>mybase</b> and also load the
Gzip-compressed PGN file <b>games.pgn.gz</b>.
</p>

<h4>Is there an easier way to change the board size than using the
options menu?</h4>
<p>
Yes, you can use the shortcut keys <b>Control+Shift+LeftArrow</b> and
<b>Control+Shift+RightArrow</b> to decrease or increase the board size.
</p>

<h4>I am training by playing through a game, so I do not want Scid to
print the next move in the game information area below the chessboard.
Can I hide it?</h4>
<p>
You can hide the next move by pressing the <b>right</b> mouse button in the
game information area, and selecting <b>Hide next move</b> from the
menu that appears.
</p>

<h4>How can I see the ECO opening code for the current position?</h4>
<p>
The ECO code is displayed on the bottom line of the game
information box, below the chessboard in the <a MainWindow>main window</a>,
if you have the ECO classification file (<b>scid.eco</b>) loaded. <br>
The <a ECO>ECO codes</a> help page explains how to load the ECO classification
file and save options so it will be loaded every time you start Scid.
</p>

<h4>I am entering a game, and I am up to move 30, but just saw that move
10 was wrong. How can I correct it and keep all the moves after it?</h4>
<p>
You can use the <a Import>Import</a> window; see the
<a Moves Mistakes>entering moves</a> help page for more information.
</p>

<h4>How do I copy games from one database to another?</h4>
<p>
Use the <a Switcher>database switcher window</a>: drag from the source
database to the target database to copy all games in the source database
<a Searches Filter>filter</a>.
</p>

<h4>Every time I enter a move where one already exists, I get a
"Replace move?" dialog box. How do I avoid that?</h4>
<p>
Turn it off with the <b>Ask before replacing moves</b> option in the
<menu>Options: Moves</menu> menu.
Or, get into the habit of taking back moves using the right-mouse button,
which actually removes the move from the game if you are at the last move of
the game.
</p>

<h4>How do I change column widths in the Game List window?</h4>
<p>
Click the left or right mouse button on each column title.
</p>

<h4>How can I use the tree window on a selection of games, not my whole
database?</h4>
<p>
Use the <a Clipbase>clipbase</a>. Set your database filter to contain the
games you want to use the tree on, then copy them to the clipbase using the
<a Switcher>database switcher</a>. Then, just open the tree window in the
clipbase.
</p>

<h4>The Tree is slow for large databases. How do I speed it up?</h4>
<p>
Save the Tree cache often, to save tree results for future use.
See the caching section of the <a Tree>Tree</a> help page for details.
</p>

<h4>How can I edit the PGN representation of the game directly?</h4>
<p>
You cannot use the <a PGN>PGN</a> window to edit the current game, but you can
still edit its PGN representation using the <a Import>Import game</a> window.
Just open it (shortcut key: <b>Control+Shift+I</b>) and then press the
<b>Paste current game</b> button, then edit the game, then press <b>Import</b>.
</p>

<h4>My database has several spellings for some player names. How do I
correct them all?</h4>
<p>
You can edit individual names or spellcheck all the names in a database
with the commands in the <menu>File: Maintenance</menu> menu.
See the <a Maintenance Editing>maintenance</a> page.
</p>

<h4>I have two databases open: one with my own games, and a large database of
grandmaster games. How do I compare one of my games to those in the large
database?</h4>
<p>
In the large database, open the <a Tree>tree window</a> and press the
<term>Lock</term> button to lock the tree to that database. Then switch
to the other database, and the tree will continue to show data for the
large database.
</p>

<p><footer>(Updated: Scid 2.6, August 2001)</footer></p>
}


####################
### Main window help:

set helpTitle(MainWindow) "Scid main window"
set helpText(MainWindow) {<h1>Scid main window</h1>
<p>
The main window in Scid displays the current board position of the
active game and information about the current game and database.
Separate help pages describe the <a Menus>menus</a> and ways to
<a Moves>enter chess moves</a>.
</p>

<h3>Game navigation buttons</h3>
<p>
The navigation buttons above the board have the following meanings, from
left to right:
<ul>
<li> <button tb_start> Move to the start of the game. </li>
<li> <button tb_prev> Move back one move. </li>
<li> <button tb_next> Move forward one move. </li>
<li> <button tb_end> Move to the end of the game. </li>
<li> <button tb_invar> Move into a variation. </li>
<li> <button tb_outvar> Move out of the current variation. </li>
<li> <button tb_addvar> Add a new variation. </li>
<li> <button autoplay_off> Start/stop autoplay mode (see below). </li>
<li> <button tb_trial> Start/stop <a Moves Trial>trial mode</a>. </li>
<li> <button tb_flip> Rotate the board 180 degrees. </li>
<li> <button tb_coords> Show/hide board coordinates. </li>
</ul>

<h4><name Autoplay>Autoplay mode</name></h4>
<p>
In autoplay mode, Scid automatically plays the moves in the current game,
moving forward until the end of the game. The time delay between moves can
be set from the <menu>Options: Moves</menu> menu, and is saved to your
options file when you save options.
</p>
<p>
The shortcut key <b>Control+Z</b> starts or stops autoplay mode, and
you can also exit autoplay mode by pressing the <b>Escape</b> key.
</p>
<p>
If you start autoplay mode when the <a Analysis>analysis window</a> is open,
the game is <term>annotated</term>: the score and analysis for each position
are added to the game as a new variation just before each move is made.
See the <a Analysis>analysis window</a> help page for details.
</p>

<h3>The game information area</h3>
<p>
The area below the chessboard showing information about the game is called
the <term>game information area</term>.
Its first three lines show information such as the players, result,
date, and site.
The fourth line indicates the current position in the game, and what the
next move is.
</p>
<p>
The fifth line shows the <a ECO>ECO</a> (Encyclopedia of Chess
Openings) code for the current position, if the position appears in
the ECO file being used.
</p>
<p>
The game information area has a menu activated with the right mouse button,
with options to hide the next move (useful if you are training using a game
and want to guess each move) and to delete or undelete the current game.
You can also activate this menu without using the mouse, by pressing the
<b>[F9]</b> function key.
</p>

<h4>Tablebases</h4>
<p>
The game information area also displays tablebase results whenever the
displayed position reaches a material configuration found in a
tablebase file. See the <a TB>tablebases</a> help page for details.
</p>

<h3>The status bar</h3>
<p>
The status bar shows information about the current database.
The first field indicates the game status: <b>XX</b> means it has been
altered and not yet saved, while <b>--</b> means it is unchanged,
and <b>%%</b> indicates the database is read-only (not alterable).
</p>
<p>
If you want a database to be opened read-only, just set the permissions
of its Scid files, or at least its index file, for example:
<b>chmod a-w myfile.si3</b>
as a shell command, and it will be opened read-only by Scid.
</p>
<p>
The status bar also shows how many games are currently in the
<a Searches Filter>filter</a>.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


####################
### Menus help screen:

set helpTitle(Menus) "Menus"
set helpText(Menus) {<h1>Scid menus</h1>

<h3><name File>File</name></h3>
<ul>
<li><menu>New</menu>: Creates a new empty Scid database.</li>
<li><menu>Open</menu>: Opens an existing Scid database.</li>
<li><menu>Close</menu>: Closes the current Scid database.</li>
<li><menu>Finder</menu>: Opens the <a Finder>File Finder</a>.</li>
<li><menu>Bookmarks</menu>: <a Bookmarks>Bookmarks</a> and bookmark
    functions.</li>
<li><menu>Maintenance</menu>: Database <a Maintenance>maintenance</a>
functions.</li>
<ul>
  <li><menu>Maintenance window</menu>: Opens/closes the database maintenance
      window.</li>
  <li><menu>Delete twin games</menu>: Finds <a Maintenance Twins>twin</a>
      games in the database.</li>
  <li><menu>ECO-Classify games</menu>: Recomputes the
      <a ECO>ECO code</a> for all games in the database. </li>
  <li><menu>Name editor</menu>: Replaces all occurrences of a player,
      event site or round name.</li>
</ul>
<li><menu>Read-Only</menu>: Makes the current database read-only.</li>
<li><menu>Base 1/2/3/4/5</menu>: These commands let you switch between
    the four available database slots and the <a Clipbase>clipbase</a>
    database.</li>
<li><menu>Exit</menu>: Exits Scid. </li>
</ul>

<h3><name Edit>Edit</name></h3>
<ul>
<li><menu>Add Variation</menu>: Adds a new empty variation for the
    next move, or for the previous move if there is no next move yet.</li>
<li><menu>Delete Variation</menu>: Provides a submenu of variations for
    the current move, so one can be deleted.</li>
<li><menu>Make First Variation</menu>: Promotes a variation to be the
    first variation of the current move.</li>
<li><menu>Promote Variation to Main line</menu>: Promotes a variation
    to be the main line, swapping it with its parent.</li>
<li><menu>Try Variation</menu>: Enters <a Moves Trial>trial mode</a> for
    testing a temporary variation without altering the current game.</li>
<li><menu>Strip</menu>: Strips all comments or variations from the current
    game.</li>
<br>
<li><menu>Empty Clipbase</menu>: Empties the <a Clipbase>clipbase</a>
    so it contains no games.</li>
<li><menu>Copy this game to clipbase</menu>: Copies the current game
    to the <a Clipbase>clipbase</a> database.</li>
<li><menu>Paste last clipbase game</menu>: Pastes the active game of
    the <a Clipbase>clipbase</a> to be the active game of the current
    database.</li>
<br>
<li><menu>Setup start board</menu>: Sets the starting position for the
    current game.</li>
<li><menu>Paste start board</menu>: Sets the start board from the current
    text selection (clipboard).</li>
</ul>

<h3><name Game>Game</name></h3>
<ul>
<li><menu>New Game</menu>: Resets the active game to an empty state,
    discarding any unsaved changes.</li>
<li><menu>Load First/Previous/Next/Last Game</menu>: These load the first,
    previous, next or last game in the <a Searches Filter>filter</a>.</li>
<li><menu>Reload this game</menu>: Reloads the current game, discarding
    any changes made.</li>
<li><menu>Load Game Number</menu>: Loads the game given its game number
    in the current database.</li>
<br>
<li><menu>Save: Replace game</menu>: Saves the current game, replacing
    its original version in the database.</li>
<li><menu>Save: Add new game</menu>: Saves the current game as a new
    game, appending to the end of the database.</li>
<br>
<li><menu>Identify opening</menu>: Finds the deepest
    position in the current game that is in the ECO file.</li>
<li><menu>Goto move number</menu>: Goes to the specified move number in
    the current game.</li>
<li><menu>Find novelty</menu>: Finds the first move of the current game
    that has not been played before.</li>
</ul>

<h3><name Search>Search</name></h3>
<ul>
<li><menu>Reset Filter</menu>: Resets the <a Searches Filter>filter</a>
so all games are included.</li>
<li><menu>Negate filter</menu>: Inverts the filter to only include
games that were excluded.</li>
<br>
<li><menu>Current board</menu>: Searches for the
<a Searches Board>current board</a> position.</li>
<li><menu>Header</menu>: Searches by <a Searches Header>header</a>
information such as player names.</li>
<li><menu>Material/Pattern</menu>: Searches by
<a Searches Material>material</a> or chessboard patterns</a>.</li>
<br>
<li><menu>Using search file</menu>: Searches using
<a Searches Settings>settings</a> from a SearchOptions file.</li>
</ul>

<h3><name Windows>Windows</name></h3>
<ul>
<li><menu>Comment Editor</menu>: Opens/closes the
    <a Comment>Comment Editor</a> window.</li>
<li><menu>Game List window</menu>: Opens/closes the
    <a GameList>Game List window</a>.</li>
<li><menu>PGN window</menu>: Opens/closes the
    <a PGN>PGN window</a>.</li>
<li><menu>Tournament Finder</menu>: Opens/closes the
    <a Tmt>Tournament Finder</a> window.</li>
<br>
<li><menu>Database switcher</menu>: Opens/closes the
    <a Switcher>Database Switcher</a> window, which lets you switch to
    another database or copy games between databases easily.</li>
<li><menu>Maintenance window</menu>: Opens/closes the database
    <a Maintenance>maintenance</a> window.</li>
<br>
<li><menu>ECO Browser</menu>: Opens/closes the
    <a ECO browser>ECO Browser</a> window.</li>
<li><menu>Repertoire editor</menu>: Opens/closes the
    <a Repertoire>repertoire editor</a>.</li>
<li><menu>Statistics window</menu>: Opens/closes the
    <term>Filter statistics window</term> which gives a win/loss summary
    of the games in the <a Searches Filter>filter.</a></li>
<li><menu>Tree window</menu>: Opens/closes the <a Tree>tree window</a>.</li>
<li><menu>Endgame Tablebase window</menu>: Opens/closes the window that
    displays <a TB>tablebase</a> information.</li>
</ul>

<h3><name Tools>Tools</name></h3>
<ul>
<li><menu>Analysis engine</menu>: Starts/stops the chess analysis
    engine, displaying the evaluation of the current position
    in the <a Analysis>analysis window</a>.</li>
<li><menu>Analysis engine #2</menu>: Starts/stops a second analysis
    engine.</li>
<li><menu>Crosstable</menu>: Constructs a tournament
    <a Crosstable>crosstable</a> for the current game. </li>
<li><menu>Email manager</menu>: Opens/closes the <a Email>email manager</a>
    window, for managing email correspondence games.</li>
<br>
<li><menu>Opening report</menu>: Generates an
    <a Reports Opening>opening report</a> for the current position.</li>
<li><menu>Piece Tracker</menu>: Opens the <a PTracker>piece tracker</a>
    window.</li>
<br>
<li><menu>Player information</menu>: Displays <a PInfo>player information</a>
    for one of the two players of the current game.</li>
<li><menu>Rating graph</menu>: Displays the
    <a Graphs Rating>rating graph</a>.</li>
<li><menu>Score graph</menu>: Displays the
    <a Graphs Score>score graph</a>.</li>
<br>
<li><menu>Export current game</menu>: Saves the current game to a text
    file in PGN, HTML or LaTeX format. See the <a Export>export</a> help
    page.</li>
<li><menu>Export all filter games</menu>: Saves all games in the
    search <a Searches Filter>filter</a> to a text file in PGN, HTML or
    LaTeX format. See the <a Export>export</a> help page.</li>
<br>
<li><menu>Import PGN game</menu>: Opens the <a Import>Import window</a>
    for entering a game by typing or pasting its text in
    <a PGN>PGN format</a>.</li>
<li><menu>Import file of PGN games</menu>: Imports a whole file containing
    games in PGN format to the current database.</li>
</ul>

<h3><name Options>Options</name></h3>
<p>
This menu provides entries for setting most of Scid's configurable
options.
The <menu>Save options</menu> entry saves the current options to the
file "<b>~/.scid/scidrc</b>" (or <b>scid.opt</b> in the
directory of the Scid executable programs for Windows users);
this file is loaded each time you start up Scid.
</p>

<h3><name Help>Help</name></h3>
<p>
This menu contains help functions, and access to the tip of the day
window or the startup window which provides information about the
files Scid loaded when it started.
</p>

<p><footer>(Updated: Scid 3.5, February 2003)</footer></p>
}


####################
### Entering moves help:

set helpTitle(Moves) "Entering moves"
set helpText(Moves) {<h1>Entering chess moves</h1>
<p>
In Scid, you can enter the moves for a game using the
mouse or the keyboard. As you move the mouse over a square,
it and one other square will change color if there is a legal
move to or from that square. This is the <term>suggested move</term>.
To make this move simply click the <term>left</term> mouse button.
You can turn off move suggestion using the Options menu if it annoys you.
</p>
<p>
To make any move other than the suggested move, you can use
the <term>left</term> mouse button: just press the button over one square,
and release it over the other square.
</p>
<p>
If you prefer to make moves with two mouse clicks instead of dragging with
the mouse button pressed, you can use the <term>middle</term> button: just
click on one square then the other.
</p>

<h4>Retracting a move</h4>
<p>
To take back a move, click the right mouse button. This goes back one move,
and deletes the move if it is the last in the game or variation.
</p>

<h4>Replacing old moves</h4>
<p>
When you enter a move at a point in the game where a move already exists,
Scid will present a dialog box asking if you really want to replace the
old move (the old move and all moves after it will be lost), or want
to add the new move as a variation instead. Some people may find this
dialog box annoying and always want to replace old moves, so it can be
turned off with the <menu>Options: Moves</menu> menu option
"<i>Ask before replacing moves</i>".
</p>

<h4><name Trial>Trial mode</name></h4>
<p>
If you are studying a game and reach a position where you want to try
an alternative variation on the board without altering the game, select
<b>Try variation</b> from the <menu>Edit</menu> menu to enter trial
mode. In this mode, you can make temporary moves and changes to the
game, then return to the original position when you exit trial mode.
</p>

<h3><name Mistakes>Correcting mistakes</name></h3>
<p>
If you are entering a game and suddenly see an incorrect move several
moves earlier, it is possible to correct it without losing the extra
moves you have added. The only way is to edit the PGN representation
of the game: open the <a Import>Import</a> window, select "Paste current
game", correct the incorrect move, then select "Import".
</p>

<h3>Keyboard move entry</h3>
<p>
To enter moves at the keyboard, simply press letter and digit
keys. Note that accepted moves should be in <term>SAN notation</term>,
<i>without</i> the capture symbol (x) or the promotion symbol (=).
Moves are matched case-insensitively, so you can type
[n][f][3] instead of Nf3, for example -- but see the note below
about conflicts with pawn moves.
</p>
<p>
To ensure that no move is a prefix of any other move, the notation
for kingside and queenside castling is [O][K] and
[O][Q] respectively, instead of the usual O-O and O-O-O.
</p>
<p>
As you enter a move, the status bar will show the list of matching moves.
You can press the [space] bar at any time to choose the first
matching move in the list and add it to the game.
To delete a character, press [Backspace] or [Delete].
</p>
<p>
<b>Note</b> that a lower-case letter matches to a pawn first, so a
[b] can match to a pawn or Bishop, but if there is a conflict
you must use a capital [B] for the Bishop move.
</p>

<h4>Auto-Completion</h4>
<p>
In the Options menu, you can turn on or off <term>Auto-Completion</term>
of moves.
With auto-completion, a move is made as soon as you have typed enough
to distinguish it from any other legal move. For example, with
auto-completion, you would only need to type [n][f] instead
of [n][f][3] for <b>Nf3</b> in the starting position.
</p>

<h3><name Null>Entering null moves</name></h3>
<p>
<a Annotating Null>Null</a> (empty) moves can be useful in variations, where
you want to skip a move for one side. You can enter a null move with the
mouse by capturing one king with the other king, or with the keyboard by
typing "<b>--</b>" (that is, pressing the minus key twice).
</p>

<h3>Entering common annotation symbols</h3>
<p>
You can also add common <a NAGs>annotation symbols</a> using the keyboard
in the main window, without needing to use the <a Comment>comment editor</a>
window. The following list shows which symbols you can add, and their
keyboard shortcuts:
<ul>
<li> !  : [!][Return] </li>
<li> ?  : [?][Return] </li>
<li> !? : [!][?][Return] </li>
<li> ?! : [?][!][Return] </li>
<li> !! : [!][!][Return] </li>
<li> ?? : [?][?][Return] </li>
<li> </li>
<li> +- : [+][-] </li>
<li> +/-: [+][/] </li>
<li> += : [+][=] </li>
<li> =  : [=][Return] </li>
<li> -+ : [-][+] </li>
<li> -/+: [-][/] </li>
<li> =+ : [=][+] </li>
</ul>

<p><footer>(Updated: Scid 3.4, July 2002)</footer></p>
}


########################################
### Searches help screen:

set helpTitle(Searches) "Searches"
set helpText(Searches) {<h1>Searches in Scid</h1>
<p>
Scid can perform many different types of search on a database.
The three main types of search are:
<ul>
<li><b>1)</b> for the current board, </li>
<li><b>2)</b> for specified material and piece patterns, and </li>
<li><b>3)</b> by header information such as players, result, date. </li>
</ul>
<p>
In addition to these, there is also an automatic search mode called the
<a Tree>Tree window</a> which is explained separately.
</p>

<h3><name Filter>The Search Filter</name></h3>
<p>
Searches in Scid are based on the concept of a <term>filter</term>.
The filter represents a subset of the current database; at any time,
each game is either included in or excluded from the filter.
</p>
<p>
With each type of search, you can choose to restrict the existing
filter, add to it, or ignore it and search the whole database.
This choice permits complex searches to be built up incrementally.
</p>
<p>
You can also copy all games in the filter of one database to another,
using the <a Switcher>database switcher</a> window.
</p>
<p>
With exact position, <a Tree>tree</a> or material/pattern searches, the
move number of the first matching position of each matching game is
remembered, so when you load each game it will show the matching position
automatically.
</p>
<p>
<b>Note</b> that searches only apply to the main line moves of a game,
not to any moves in variations.
</p>

<h3><name Board>Search: Current Board</name></h3>
<p>
This search finds games that contain the current displayed position,
ignoring castling and <i>en passant</i> rights.
</p>
<p>
There are four board search types available. All four require a position
to have the same exact material and side to move for a match.
The types are:
<ul>
<li> [1] exact (the two positions must match on every square), </li>
<li> [2] pawns (the pawn structure must match exactly, but other pieces
     can be anywhere), </li>
<li> [3] files (the number of white and black pawns on each file must match
     exactly, but other pieces can be anywhere), and </li>
<li> [4] material (pawns and pieces can be anywhere). </li>
</ul>
<p>
The pawns search is useful for studying openings by pawn structure, and
the files and material searches are useful for finding similar positions
in an endgame.
</p>
<p>
To search for an arbitrary position, you can set the position first
(from the <menu>Edit: Setup Start Board</menu> menu) and then
start the search.
</p>
<p>
You can request that the search look in variations (instead of only
examining actual game moves) by selecting the <b>Look in variations</b>
checkbox, but this may make the search much slower if your database
is large and has many games with variations.
</p>

<h3><name Material>Search: Material/Pattern</name></h3>
<p>
This search is useful for finding endgame or middlegame themes.
You can specify minimum and maximum amounts of each type of material,
and find patterns such as a Bishop on f7, or a pawn on the f-file.
</p>
<p>
A number of common material and pattern settings are provided, such
as Rook vs. Pawn endings, or isolated Queens pawns.
</p>
<p>
<b>Hints:</b><br>
The speed of pattern searches can vary widely. You can reduce the time
needed for a search by setting restrictions intelligently. For example,
if you set the minimum move number to 20 for an ending, all games that
end in under 20 moves can be skipped.
</p>

<h3><name Header>Search: Header</name></h3>
<p>
This search can be used to find aspects of the game that are
stored in the header (such as date, result, names, flags and ratings),
so it does not require any moves to be decoded.
</p>
<p>
For a game to match a Header search, <b>all</b> fields that you
specify must match.
</p>
<p>
The name fields (White, Black, Event, Site and Round) match on any text
inside the name, case-insensitive and ignoring spaces.
</p>
<p>
You can do case-sensitive wildcard searches for the White, Black, Event,
Site and Round fields (with <b>?</b> representing one character and
<b>*</b> representing zero or more characters) by putting the
search text in double quotes. For example a search for the site <b>USA</b>
will find American cities and also <b>Lausanne SUI</b>, which is probably
not what you wanted! A search for the site <b>"*USA"</b> (remember to
use the double-quotes) will only match cities in the United States.
</p>
<p>
If you are searching for a particular player (or pair of opponents) as White
or Black and it does not matter what color they played, select the
<b>Ignore Colors</b> option.
</p>
<p>
Finally, the Header search can be used to find any text (case-sensitive
and without wildcards) in the PGN representation of each game.
You may enter up to three text phrases, and they must all appear in a
game for it to be a match.
This search is very useful for searching in the comments or extra tags of
a game (such as <b>lost on time</b> or <b>Annotator</b>),
or for a move sequence like <b>Bxh7+</b> and <b>Kxh7</b> for a bishop
sacrifice on h7 that was accepted.
However, this type of search can be <i>very</i> slow since all the games that
match other criteria must be decoded and scanned for the text phrases.
So it is a good idea to limit these searches as much as possible.
Here are some examples.
To find games with under-promotions to a rook,
search for <b>=R</b> and also set the <b>Promotions</b> flag to Yes.
When searching for text that would appear in comments, set
the <b>Comments</b> flag to Yes.
If you are searching for the moves <b>Bxh7+</b> and <b>Kxh7</b>, you
may want to restrict the search to games with a 1-0 result and at least 40
half-moves, for example, or do a material/pattern search first to find
games where a white bishop moves to h7.
</p>

<h3><name Settings>Saving search settings</name></h3>
<p>
The Material/Pattern and Header search windows provide a
<term>Save settings</term> button. This lets you save the current
search settings for later use, to a <term>SearchOptions</term> file
(suffix .sso).
To search using a previously saved SearchOptions (.sso) file, select
<menu>Open</menu> from the <menu>Search</menu> menu.
</p>

<h3>Search times and skipped games</h3>
<p>
Most searches produce a message indicating the time taken and the number
of games that were <term>skipped</term>. A skipped game is one that can
be excluded from the search without decoding any of its moves, based on
information stored in the index. See the help page on
<a Formats>file formats</a> for more information.
</p>

<p><footer>(Updated: Scid 3.0, November 2001)</footer></p>
}


#################
### Clipbase help:

set helpTitle(Clipbase) "The Clipbase"
set helpText(Clipbase) {<h1>The Clipbase database</h1>
<p>
In addition to the databases you have open, Scid provides
a <term>clipbase</term> database, which is just like any other database
except that it exists in memory only and has no files for permanent storage.
</p>
<p>
The clipbase is useful as a temporary database, for merging
the results of searches on more than one database or for treating the
results of a search as a separate database.
</p>
<p>
For example, assume you want to prepare for an opponent and have searched
a database so the <a Searches Filter>filter</a> contains only games where
the opponent played White.
You can copy these games to the clipbase (by dragging from their database
to the clipbase in the <a Switcher>database switcher</a> window),
switch to the clipbase database, and then open
the <a Tree>Tree window</a> to examine that players repertoire.
</p>
<p>
Note that you can copy games in the filter of one database directly to another
opened database (without needing the clipbase as an intermediary
location) using the <a Switcher>database switcher</a> window.
</p>
<p>
Note that the clipbase <i>cannot</i> be closed; selecting the
<menu>File: Close</menu> command while in the clipbase is equivalent
to <menu>Edit: Reset Clipbase</menu> which empties the clipbase.
</p>
<p>
The clipbase has a limit of 20,000 games at any time, since it exists in
memory only.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

#################################
### Variations and comments help:

set helpTitle(Annotating) "Annotating games"
set helpText(Annotating) {<h1>Annotating games</h1>
<p>
Scid lets you add notes to games. There are three types of
annotation you can add after a move: symbols, a comment,
and variations.
</p>

<h3>Symbols and comments</h3>
<p>
Symbols are used to indicate an evaluation of the position (such as
"+-" or "=") or point out good ("!") and bad ("?") moves, while
comments can be any text. To add symbols and comments to a game, use
the <a Comment>Comment editor</a> window.
There is also a help page listing <a NAGs>standard symbol values</a>.
</p>
<p>
Note that each move can have more than one annotation symbol, but only
one comment. A comment before the first move of the game is printed as text
before the start of the game.
</p>

<h3><name Vars>Variations</name></h3>
<p>
A <term>variation</term> of a move is an alternative sequence of
moves at a particular point in a game. Variations can contain
comments and even recursively have sub-variations. The buttons
above the board with a "<b>V</b>" symbol, and commands in the
<menu>Edit</menu> menu, can be used to create, navigate and edit
variations.
</p>

<h4>Keyboard shortcuts</h4>
<p>
When a move has variations, they are shown in the game information
area. The first will be named <b>v1</b>, the second <b>v2</b>, etc.
You can click on a variation to enter it, or press "<b>v</b>" followed
by the variation number. (If there is only one variation, simply
pressing <b>v</b> will enter it.)
To leave a variation, you can use the "<b>z</b>" shortcut key.
</p>

<h3><name Null>Null moves</name></h3>
<p>
Sometimes, you may find it useful in a variation to skip over a move
for one side. For example, you may want to add the move 14.Bd3 to
a variation and point out that it threatens 15.Bxh7+ Kxh7 16.Ng5+
with an attack. You can do this by making a <term>null move</term>
between 14.Bd3 and 15.Bxh7+, in the above example. A null move is
displayed as "<b>--</b>" and can be inserted using the mouse by making
an illegal move of capturing one king with the other, or from the
keyboard by typing "<b>--</b>" (two minus signs).
</p>
<p>
Note that null moves are not a part of the PGN standard, so if you
export games with null moves to a PGN file, Scid will provide (among
other export options) an option to preserve null moves or convert them
to comments for compatibility with other software.
See the <a Export>Exporting</a> help page for more details.
</p>

<p><footer>(Updated: Scid 3.4, July 2002)</footer></p>
}

###############################
### Comment editor window help:

set helpTitle(Comment) "Comment Editor window"
set helpText(Comment) {<h1>The Comment Editor window</h1>
<p>
The Comment Editor window lets you add or edit comments and symbolic
annotation symbols for moves in the active chess game.
</p>

<h3>Annotation symbols</h3>
<p>
Scid uses the <a Author Related>PGN standard</a>
for annotation symbols, accepting
<a NAGs>NAG (numeric annotation glyph)</a> values for annotations.
Some of the most common symbols (such as "!" or "+-") are displayed
as symbols, and have a button in the comment editor window for fast
entry. For other symbols, you can enter the appropriate
numeric NAG value which is a number from 1 to 255.
For example, the NAG value 36 means "White has the initiative" and will
be displayed as "$36" in the <a PGN>PGN text</a> of the game.
</p>
<p>
See the help page of <a NAGs>NAG values</a> for NAG values defined
by the PGN standard.
</p>
<p>
<b>Hint:</b> You can add the common move evaluation symbols (!, ?, !!,
??, !? and ?!) while in the main window, without needing
to use the comment editor window, by typing the symbol followed by
the [Return] key.
This is especially useful if you are <a Moves>entering chess moves</a>
using the keyboard.
</p>

<h3>Comments</h3>
<p>
You can edit comments by typing in the text area provided and using
the Clear, Revert and Store buttons.
You do not need to press the Store button to update a comment; it is
automatically updated whenever you move to another position in the game.
</p>

<h3>Coloring squares</h3>
<p>
You can color any square with any color using a special embedded command
which can appear anywhere in a comment. The command format is:
</p>
<ul>
<li><b>[%mark square color]</b><li>
</ul>
<p>
where <b>square</b> is a square name like d4 and <b>color</b> is any
recognized color name (such as red, blue4, darkGreen, lightSteelBlue, etc)
or RGB code (a <b>#</b> followed by six hexadecimal digits, such as #a0b0c8).
If the color is omitted, it defaults to <red>red</red>.
</p>
<p>
A comment may contain any number of color commands, but each must have
in its own <b>[%mark ...]</b> tag.
For example, the comment text</p>
<p>
  Now d6 [%mark d6] is weak and the knight can attack it
  from b5. [%mark b5 #000070]
</p>
<p>
will color d6 <red>red</red> and b5 with the dark-blue color
<darkblue>#000070</darkblue>.
</p>

<h3>Drawing arrows</h3>
<p>
You can draw an arrow from one square to another using a special
comment command similar to the for coloring squares described above.
The format is:
</p>
<ul>
<li><b>[%arrow fromSquare toSquare color]</b><li>
</ul>
<p>
where <b>fromSquare</b> and <b>toSquare</b> are square names like d4
and <b>color</b> is any recognized color name (such as red, blue4, etc)
or RGB code (like #a0b0c0).
If the color is omitted, it defaults to <red>red</red>.
</p>
<p>
For example, the comment text
</p>
<p>
  The c3-knight and c4-bishop control the weak d5 square.
  [%arrow c3 d5 red] [%arrow c4 d5 blue]
</p>
<p>
will draw a red arrow from c3 to d5 and a blue one from c4 to d5.
</p>

<p><footer>(Updated: Scid 3.2, February 2002)</footer></p>
}

####################
### Crosstable window help:

set helpTitle(Crosstable) "Crosstable window"
set helpText(Crosstable) {<h1>The Crosstable window</h1>
<p>
The crosstable window shows the tournament crosstable for the
current game. Each time you refresh the crosstable window (by
pressing its Refresh button, by pressing the <b>Return</b> key in the
crosstable window, or by typing <b>Control+Shift+X</b> in the
<a MainWindow>main</a> or <a GameList>game list</a> windows), Scid
searches for all games in the same tournament as the current game.
</p>
<p>
Any game played up to <b>three months before or after</b> the current game,
with the <b>exact same Event and Site tags</b>, is considered to be in
the tournament.
</p>
<p>
A single left-mouse button click on any result in the crosstable
loads the corresponding game.
You can add all the games in the tournament to the
<a Searches Filter>filter</a>
with the <b>Add to filter</b> button in the crosstable window.
</p>

<h4>Crosstable window menus</h4>
<p>
The <menu>File</menu> menu lets you print the current table to a file
in plain text, LaTeX or HTML table format.
</p>
<p>
The <menu>Display</menu> menu allows you to choose the table format:
<b>All-play-all</b>, <b>Swiss</b> or <b>Knockout</b> or <b>Auto</b>.
</p>
<p>
The all-play-all format (for round-robin-type events) has a limit of 30
players, but the Swiss format (for tournaments with many players) can
display up to 200 players and up to 20 rounds. <b>Auto</b>, which chooses
the best format automatically for each tournament, is the default.
</p>
<p>
Note that Scid uses the <b>Round</b> tag of each game to produce a Swiss
crosstable, so you will not see any games in the Swiss table for a tournament
if its games do not have numeric round values: 1, 2, 3, etc.
</p>
<p>
The Display menu also lets you customize the data presented to
include or exclude ratings, countries and player titles. You can also
choose whether color allocations in Swiss tables are displayed.
</p>
<p>
The <b>Separate score groups</b> option only affects the layout of the table
when the players are sorted by score: it causes a blank line to be inserted
between each group of players with the same score.
</p>
<p>
The <menu>Sort</menu> menu allows you to sort the players by name, rating
or score; by score is the default.
</p>
<p>
The <menu>Color</menu> menu lets you turn color (hypertext) display on or off.
Since it can take a long time to format and display large crosstables in
hypertext, selecting <b>Plain text</b> for large events will save a
lot of time.
However, in plain text mode you cannot click on players or games.
</p>

<h4>Duplicate games in crosstables</h4>
<p>
To get good results with the crosstable, you should mark duplicate games
for deletion and your games should have consistent spelling of player,
site and event names.
See the <a Maintenance>database maintenance</a> page for help on
deleting duplicate games and editing (or spellchecking)
player/event/site names.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


####################
### Database switcher help:

set helpTitle(Switcher) "Database Switcher"
set helpText(Switcher) {<h1>The Database Switcher window</h1>
<p>
The Database Switcher window provides a view which makes it easy to
switch between databases or copy games between databases.
The name, <a Searches Filter>filter</a> state and graphic type icon
of each database is displayed, and the active database is highlighted
with a yellow background.
</p>
<p>
You can open the database switcher window from the <menu>Windows</menu> menu,
or by its shortcut key: <b>Control+D</b>.
</p>
<p>
To copy all the filtered games in one database to another, drag with the
left mouse button from the source base to the target base. You will then
see a confirmation dialog (if the target database is not the
<a Clipbase>clipbase</a>) if the games can be copied, or an error message
if the games cannot be copied (for example, if a selected database is not
open).
</p>
<p>
Pressing right mouse button over a database produces a popup menu applying
to that database, from which you can change the database type icon or
reset its <a Searches Filter>filter</a>. You can also use this menu to
change the orientation of the window (to arrange the database slots
vertically or horizontally) which is useful for smaller screens.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


####################
### File Finder window help:

set helpTitle(Finder) "File Finder window"
set helpText(Finder) {<h1>The File Finder window</h1>
<p>
The <term>File Finder</term> helps you find files of any type you can
use in Scid: databases, <a PGN>PGN</a> files, <a EPD>EPD</a> files,
and <a Repertoire>repertoire</a> files.
</p>
<p>
The finder shows useful information about each file, such as its size
(see below) and date of last modification. You can open any displayed
file by selecting it with a single left mouse button click.
</p>

<h3>Looking in subdirectories</h3>
<p>
When you want to find all files in all subdirectories of the current
directory, turn on the <b>Look in subdirectories</b> checkbox. This
will make Scid recursively examine every subdirectory for files that
can be opened in Scid. This can take a long time if there are many
subdirectories, so you may not want to do it for a directory near the
root of the file system. You can interrupt the file search by pressing
the <b>Stop</b> button.
</p>

<h3>File sizes</h3>
<p>
The meaning of a file size displayed by the finder depends on the file
type. For Scid databases and PGN files, it is the number of games. For
EPD files, it is the number of positions. For repertoire files, it is
the number of (include or exclude) lines.
</p>
<p>
For all file types except Scid databases, the file size is an estimate
taken by examining only the first 64 kilobytes of the file, so the size
may not be correct for files larger than 64 kb. Estimate sizes are shown
with a tilde (~) to show they are not exact.
</p>

<p><footer>(Updated: Scid 2.7, September 2001)</footer></p>
}

####################
### Tournament Finder window help:

set helpTitle(Tmt) "Tournament Finder window"
set helpText(Tmt) {<h1>The Tournament Finder window</h1>
<p>
The <term>Tournament Finder</term> lets you find tournaments in the
current database. It scans all the database games and collates data
about the tournaments found. Note that two games are considered to
be in the same tournament if they have the same Event tag, same Site
tag and were played within three months of each other.
</p>
<p>
You can limit the list of tournaments by the number of players and
games, date, mean Elo rating and country, by editing the fields below
the tournament list and then pressing the <b>Update</b> button.
</p>
<p>
The displayed list can be sorted by date, number of players, number
of games, mean Elo rating, site, event or the surname of the winner.
Select the category from the <menu>Sort</menu> menu or click on a
column title to change the sort field.
</p>
<p>
To load the first game of any displayed tournament, just click the
left mouse button when its line is highlighted. This will also
update the <a Crosstable>Crosstable</a> window if it is open.
If you press the right mouse button instead, the game will be loaded
and the Crosstable window will be opened even if it is closed.
</p>
<p>
To speed up the tournament searching process, it is a good idea to
set a fairly small date range (like a few years at most) or select
a particular country (by its three-letter standard code). Doing
these will greatly reduce the number of games Scid has to consider
when trying to form tournaments out of the games in the database.
</p>

<p><footer>(Updated: Scid 3.3, April 2002)</footer></p>
}

####################
### GameList window help:

set helpTitle(GameList) "Game List window"
set helpText(GameList) {<h1>The Game List window</h1>
<p>
The Game List window displays a one-line summary for each game included
in the current <term>filter</term>.
</p>

<h3>Navigating the game list</h3>
<p>
You can scroll the game list using the slider bar or the four
buttons under the list.
You can also use the [Home], [End],
[Page Up], [Page Down] and arrow keys to scroll
using the keyboard.
</p>
<p>
You can find the next game in the list which has certain text in its
White, Black, Event or Site field, using the <b>Find text</b> box.
</p>

<h3>Actions on games in the list</h3>
<p>
To load a game from the game list, double-click the left mouse button
on the game.
Clicking the middle mouse button shows the initial moves of a game;
this can be useful for checking a games opening before loading it.
</p>
<p>
The right mouse button produces a menu for the selected game, in which
you can browse or merge the game (see below), delete (or undelete) the
game, or exclude it from the filter.
Note that deleting a game only turns on its delete flag; it will remain in
the database until you <a Compact>compact</a> it.
</p>

<h3>Configuring the game list</h3>
<p>
Click the left or right mouse button on a column title to configure the
game list. You can alter widths, add or remove columns, and change
the color for each column.
</p>
<p>
If you only want to change the width of a column, there is a shortcut:
while pressing the <b>Control</b> (or <b>Shift</b>) key, pressing
the left mouse button on the column title will make it narrower
and pressing the right mouse button will make it wider.
</p>

<h3>Altering the size of the game list</h3>
<p>
The size of the game list window is stored in the options file
whenever you save options.
So if you want the game list to show 10 games by default, just resize
the game list window and then select <menu>Save options</menu>
from the <menu>Options</menu> menu.
</p>

<h3><name Browsing>Browsing and merging games</name></h3>
<p>
The game list right-mouse menu (and some other windows, such as the
<a Reports Opening>opening report</a> window and the
<a Tree Best>best games list</a> of the <a Tree>tree</a> window)
provide the choice of loading, browsing or merging a game.
</p>
<p>
When <term>Browse game</term> is selected, the moves of the selected
game (without comments or variations) will be displayed in a separate
window. This is a useful way of previewing another game without
affecting the currently loaded game.
</p>
<p>
The <term>Merge game</term> feature provides a way to include the
selected game as a variation of the current game. Scid finds the
deepest point where the selected game differs from the current
game (taking transpositions into account) and adds a variation
for the selected game at that position. You can change the number
of moves of the selected game to be shown, depending on whether you
are interested in adding the whole game or just its opening phase.
</p>

<p><footer>(Updated: Scid 3.2, February 2002)</footer></p>
}


####################
### Import window help:

set helpTitle(Import) "Import window"
set helpText(Import) {<h1>The Import window</h1>
<p>
Scids Import window provides an easy way for you to paste a game
in <a PGN>PGN format</a> into Scid from some other application or window.
</p>
<p>
The large white frame in the window is where you type or paste
the text of the game in PGN format, and the gray frame below it
provides feedback of any errors or warnings.
</p>

<h3>Editing the current game with the Import window</h3>
<p>
The Import window also doubles as a convenient way to make a few changes
to the current game: you can paste the current game into the
Import window (with the <b>Paste current game</b> button), edit the
text, and click <b>Import</b> when done.
</p>

<h3>PGN tags in the Import window</h3>
<p>
Scid expects to see PGN header tags such as
<ul>
<li> <b>[Result "*"]</b> </li>
</ul>
before any moves, but you can just paste in a game fragment like
<ul>
<li> <b>1.e4 e5 2.Bc4 Bc5 3.Qh5?! Nf6?? 4.Qxf7# 1-0</b> </li>
</ul>
without any header tags and Scid will import it.
</p>

<h3>Using PGN files in Scid</h3>
<p>
If you want to use a PGN format file in Scid but do not
want to convert it with <a Pgnscid>pgnscid</a> first, there are two
possible ways.
</p>
<p>
First, you can import the games in the file to an existing database
with the <menu>Tools: Import file of PGN games...</menu> menu command.
</p>
<p>
The alternative is to open the PGN file directly in Scid. However, PGN
format files are opened read-only and consume more memory than a
comparable Scid database, so this is only recommended for relatively
small PGN files.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### Exporting help:

set helpTitle(Export) "Exporting games"
set helpText(Export) {<h1>Exporting games</h1>
<p>
You can use commands under the <menu>Tools</menu> menu to export the current
game or all games in the current filter to a text file.
</p>
<p>
Three text file formats are available: <a PGN>PGN</a> (portable game
notation), HTML (for web pages) and LaTeX (a popular typesetting system).
</p>
<p>
When exporting, you can choose to create a new file, or add the games to
an existing file of games exported by Scid.
</p>

<h3>Diagrams</h3>
<p>
When exporting in HTML or LaTeX format, Scid will automatically add a
diagram wherever a diagram <a NAGs>nag</a> ("D") or a <a Comment>comment</a>
that starts with the character "#" appears in the game.
</p>

<h3><name Null>Null moves in PGN Export</name></h3>
<p>
Scid allows <a Annotating Null>null (empty) moves</a> to be stored in
games, as they can be helpful when annotating games using variations.
However, the PGN standard has no null move concept. So if you export
Scid games with null moves to a PGN file, other PGN-reading software
will not be able to read the null moves.
</p>
<p>
To solve this problem, Scid provides an extra option,
<b>Convert null moves to comments</b>, when exporting games in PGN format.
If you want to create a PGN file that other software can use, turn this
option on and variations containing null moves will be converted to
comments. However, if you want to create a PGN file that can be imported
back into Scid later with null moves preserved, leave the option off.
</p>

<h3>HTML Export</h3>
<p>
Scid can export games to an HTML file. For diagrams to appear, you will
need the diagram images (distributed with Scid in the directory
"<b>bitmaps/</b>") to be in a subdirectory <b>bitmaps/</b> under the
directory the HTML file is in.
</p>

<h3>LaTeX Export</h3>
<p>
Scid can export games to a LaTeX file.
Games be printed two columns to a page and moves are in
figurine algebraic notation.
</p>
<p>
See the <a LaTeX>Using LaTeX with Scid</a> help page for more information.
</p>

<p><footer>(Updated: Scid 3.4, July 2002)</footer></p>
}

####################
### LaTeX help:

set helpTitle(LaTeX) "Scid and LaTeX"
set helpText(LaTeX) {<h1>Using LaTeX with Scid</h1>
<p>
Scid can save games and opening reports to files in LaTeX format.
LaTeX is an extension to TeX, a popular typesetting system.
</p>
<p>
To typeset the LaTeX files produced by Scid, you must have
LaTeX (of course) and have the "chess12" chess font package installed.
This font package is usually not part of standard LaTeX installations,
so even if you have LaTeX, you may not have the chess font.
</p>
<p>
For information about downloading and installing the LaTeX chess font,
visit the
<url http://scid.sourceforge.net/latex.html>Using LaTeX with Scid</url>
page at the <url http://scid.sourceforge.net/>Scid website</url>.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### PGN window help:

set helpTitle(PGN) "PGN window"
set helpText(PGN) {<h1>The PGN window</h1>
<p>
Scids PGN window displays the contents of the current game
in standard PGN representation. In the move text, comments
appear {in braces} and variations appear (in parentheses).
</p>

<h3>PGN format</h3>
<p>
PGN (Portable Game Notation) is a common standard for transferring
chess games between computer programs.
A PGN game consists of two sections. The first is
the header, which contains tags
such as
<b>[White "Kasparov, Gary"]</b>
and
<b>[Result "1/2-1/2"]</b>.
</p>
<p>
The second section contains the actual moves of the game, in
standard algebraic notation (SAN) along with any variations,
<a NAGs>annotation symbols</a> and <a Comment>comments</a>.
</p>

<h3>Actions in the PGN window</h3>
<p>
You can use the PGN window to navigate around the game: clicking the
left mouse button on a move will jump to that move. Click the left
mouse button on a comment will edit it.
The arrow keys and (<b>v</b> and <b>z</b> keys for entering or leaving
variations) work for game navigation just as in the main window.
</p>

<h3>PGN display options</h3>
<p>
The PGN window menus contain options that affect the PGN window display.
Scid can display the game in color or plain text -- see the
<menu>Display</menu> menu in the PGN window.
The color display is easier to read, and allows you to select moves and
comments using the mouse, but it is much slower to update. For very long
games, you may want to select plain text display.
</p>
<p>
You can also alter the format of comments and variations, choosing
to display them indented on a separate line for greater visibility.
</p>
<p>
The PGN display options, and the size of the PGN window, are saved to the
options file whenever you <b>Save Options</b> from the <menu>Options</menu>
menu of the main window.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


####################
### Piece Tracker help:

set helpTitle(PTracker) "Piece tracker"
set helpText(PTracker) {<h1>The Piece Tracker window</h1>
<p>
The <term>Piece Tracker</term> is a tool that tracks the movements
of a particular piece in all games in the current filter, and
generates a "footprint" showing how often each square has been
visited by the piece.
</p>
<p>
To use the Piece Tracker, first make sure the filter contains the
games you are interested in, such as games reaching a particular
opening position or all games where a certain player had the white pieces.
Then, select the piece to track and set other tracking options; these are
explained below. Then press the <b>Update</b> button.
</p>
<p>
The tracked piece movement information is displayed in two ways: a
graphical "footprint", and a text list with one line of data per square.
</p>

<h3>Selecting the tracked piece</h3>
<p>
The chess pieces are displayed as in the standard chess starting position
below the footprint chart. A single piece (such as the White b1 knight or
the Black d7 pawn) can be selected with the left mouse button, and all
pieces of the same type and color (such as all White pawns or both Black
rooks) can be selected using the right mouse button.
</p>

<h3>Other piece tracker settings</h3>
<p>
The move number range controls when tracking should start and stop in
each game. The default range of 1-20 (meaning tracking should stop after
Black's 20th move) is appropriate for examining opening themes, but (for
example) a range like 15-35 would be better when looking for middlegame
trends.
</p>
<p>
There are two types of statistic the tracker can generate:
<ul>
<li> <b>% games with move to square</b>: shows what proportion of filter
     games contain a move by the tracked piece to each square. This is
     the default setting and usually the most suitable choice.
<li> <b>% time in each square</b>: shows the proportion of time the
     tracked piece has spent on each square.
</ul>
</p>

<h3>Hints</h3>
<p>
There are (at least) three good uses for the Piece Tracker: opening
preparation, middlegame themes, and player preparation.
</p>
<p>
For opening preparation, use the piece tracker with the <a Tree>Tree</a>
opened. By tracking pieces you can see trends in the current opening
such as common pawn pushes, knight outposts, and where the bishops are
most often placed. You may find it useful to set the move number range
to start after the current move in the game, so the moves made to reach
the current position are not included in the statistics.
</p>
<p>
For middlegame themes, the piece tracker can be useful when the filter
has been set to contain a certain ECO range (using a
<a Searches Header>Header search</a>) or perhaps a pattern such as a
White IQP (using a <a Searches Material>Material/pattern search</a>).
Set the move range to something suitable (such as 20-40), and track
pieces to see pawn pushes in the late middlegame or early endgame,
for example.
</p>
<p>
For player preparation, use a <a Searches Header>Header search</a> or
the <a PInfo>Player information</a> window to find all games by a
certain player with one color. The Piece Tracker can then be used to
discover how likely the player is to fianchetto bishops, castle
queenside, or set up a d5 or e5 pawn wedge, for example.
</p>

<p><footer>(Updated: Scid 3.3, April 2002)</footer></p>
}


####################
### Repertoire editor help:

set helpTitle(Repertoire) "Repertoire editor"
set helpText(Repertoire) {<h1>The Repertoire editor window</h1>
<p>
The Repertoire editor lets you create, view, edit and <term>repertoire</term>
files. A repertoire (.sor) file is a list of the opening positions you want to
reach or try to avoid, and you can use it to manage your chess opening
preferences and also to search databases in Scid.
</p>

<h3>Repertoire groups and lines</h3>
<p>
A repertoire contains two types of elements: <term>groups</term> and
<term>lines</term>. Groups are not actually part of your repertoire; they
are only used to structure it the same way directories give structure to the
files on a computer disk.
</p>
<p>
Lines in a repertoire come in two types: <term>include</term> lines which
represent opening positions you are interested in and try to reach,
and <term>exclude</term> lines which are those you have no interest in
playing and try to avoid.
For example, if you play the QGA (1.d4 d5 2.c4 dxc4) as Black and you play
all moves after 3.e4 <i>except</i> 3...Nf6, you would have
1.d4 d5 2.c4 dxc4 3.e4 as an include line and 1.d4 d5 2.c4 dxc4 3.e4 Nf6 as
an exclude line.
</p>

<h3>Comments and notes</h3>
<p>
Each group or line can have comments attached to it. There are two types:
short (single-line) comments appear (in red) in the repertoire hierarchy
next to the moves of a group or line, while a long (multiple-line) comment
is only shown when the group or line is selected.
</p>

<h3>Using the repertoire editor window</h3>
<p>
The <b>left</b> side of the window shows the repertoire hierarchy. You can
click on folder icons to expand and collapse groups, and click on the
moves of a group or line to select it and see its comments.
Include lines are shown with a blue tick icon, and exclude lines have
a red cross.
</p>
<p>
If a line or group has a short comment, it is shown after the moves. If it
has a long comment, this is indicated with <b><red>**</red></b> after the
moves. Groups have a number in parentheses after their moves showing the
number of (include and exclude) lines they contain.
</p>
<p>
Clicking the right mouse button on a group or line produces a menu
of functions for it, such as deleting it or changing its state.
</p>
<p>
The <b>right</b> side of the window contains three frames. The first frame
is a list of the moves in the currently selected line or group. You can click
the left mouse button on this to paste the moves in the
<a Import>Import</a> window, which is useful for setting the current game
to start with a line in the repertoire.
The second frame contains the short comment for the line or group, and
the third frame contains its long comment.
</p>

<h3>Adding groups and lines to the repertoire</h3>
<p>
To add a line or group to the window, just make its moves on the
chessboard in the main window, then use the <menu>Edit</menu> menu
in the repertoire editor to add it as a group, include line or exclude line.
</p>
<p>
To delete a group or line, click the right mouse button on it and select
the appropriate command from the menu that appears.
</p>

<h3><name Search>Searching databases using repertoire files</name></h3>
<p>
The repertoire editor <menu>Search</menu> menu lets you search the
current database using the repertoire. Each game will be searched for
the positions in the repertoire and will only match the search if
the <i>deepest</i> repertoire position found is for an <i>include</i> line.
</p>
<p>
You can choose to search using the whole repertoire, or just the displayed
lines. Searching by displayed lines only is useful when you only want to
use some of the repertoire. For example, a repertoire might have two main
groups at the top level, one for 1.e4 and one for 1.d4. If you are only
interested in the 1.e4 lines, simply collapse the 1.d4 group and then
search by displayed lines only.
</p>

<h3>Extra hints</h3>
<p>
A repertoire file is great for finding new games in your opening systems.
For example, each time you get a new PGN file to add to your main database
(such as the excellent weekly PGN file from
<url http://www.chesscenter.com/twic/>The Week In Chess</url>),
just open the PGN file in Scid and do a repertoire search. Then you
can browse the filtered games to see all the games played that are
in your repertoire.
</p>
<p>
You may want to keep two repertoire files: one for Black and one for
White, so you can search with each file separately.
</p>
<p>
A repertoire file can be opened from the command line, for example: <br>
<b>scid mybase white.sor</b>
</p>
<p>
You can edit a repertoire (.sor) file in any text editor, but be careful
to preserve its format or it may not be loadable or searchable in Scid.
</p>

<p><footer>(Updated: Scid 2.6, August 2001)</footer></p>
}

####################
### Tree window help:

set helpTitle(Tree) "Tree window"
set helpText(Tree) {<h1>The Tree window</h1>
<p>
The <term>Tree</term> window displays information on all the
moves made from the current position in games in the database.
In tree mode, the tree window is updated automatically whenever the
main windows board changes. This can be slow for large databases.
</p>
<p>
Note that whenever the tree window is updated, the
<a Searches Filter>filter</a>
is reset and only the games that contain the current position will
be included.
</p>
<p>
Clicking the left mouse button on a move in the tree window adds that
move to the game.
</p>

<h3>Tree window contents</h3>
<p>
The tree window shows the <a ECO>ECO code</a> (if any), frequency (both as
number of games, and a percentage) and score of each move.
The <term>score</term> is always computed from the <b>White</b>
perspective, so 100% means all White wins and 0% means all Black wins.
</p>
<p>
The moves in the tree window can be sorted by move (alphabetically),
ECO code, frequency, or score. You can change the sort method
using the <menu>Sort</menu> menu.
</p>

<h3><name Best>Best games window</name></h3>
<p>
The tree window has a File menu command and button for opening the
<term>Best games</term> window, which shows a list of the highest-rated
games in the currently displayed tree branch.
The games are listed in order of average rating, and you can restrict
the list to show games with a particular result.
</p>

<h3><name Graph>Tree graph window</name></h3>
<p>
The tree window buttons include a button marked <term>Graph</term>
which produces a graphical display of the relative performance of each
move from the current position.
All moves that have been played at least 1% of the time, and at least 5
times, are displayed.
Percentage scores are always from White's perspective even when it is
Black to move.
</p>
<p>
In the tree graph, a red line is plotted showing the mean over all games
from the current position, and the area between 50 and 55% (where most
standard openings are expected to score) is colored blue
to assist comparison of moves. Note that white usually scores around 55%
in master level chess.
</p>

<h3><name Lock>Locking the tree window</name></h3>
<p>
The <term>Lock</term> button in the tree window can be used to lock the
tree to the current database. This means the tree will continue to use
that database even when you switch to another open database. This is
useful if you want to use a large database as a reference while
playing through a game in another database: simply open the tree on the
reference database, lock it, then switch to the other base.
</p>

<h3><name Training>Training</name></h3>
<p>
When the <term>Training</term> checkbox in the tree window is selected,
Scid will randomly make a move every time you add a move to the game.
The move Scid chooses depends on database statistics, so a move played
in 80% of database games will be chosen by Scid with 80% probability.
Turning on this feature, then hiding (or iconifying) the Tree window and
playing openings against a large database, is a great way to test your
knowledge of your opening repertoire.
</p>

<h3>Using the Tree with EPD files open</h3>
<p>
For each open <a EPD>EPD file</a>, the tree window will contain an extra
column that shows a short (five character) summary of the contents of the
EPD file for each position reached from the moves listed.
</p>
<p>
The summary could be an evaluation, an opening code or a suggested move;
it will be the contents of the first EPD field found from the
following list: <b>ce, eco, nic, pv, pm, bm, id</b>,
or just the first EPD field if none of the above are present.
</p>
<p>
For a description of EPD fields, see the <a EPD>EPD file</a> help page.
Note that if the summary is of the <b>ce</b> field, it is shown as an
evaluation in pawns from Whites perspective (rather than as a score in
centipawns from the perspective of the side to move, which is its stored
format in the EPD file) for improved readability.
</p>

<h3>Caching for faster results</h3>
<p>
Scid maintains a cache of tree search results for the positions with the
most matching games. If you move forward and back in a game in tree mode,
you will see the tree window update almost instantly when the position
being searched for is in the cache.
</p>
<p>
The tree window has a file menu command named <term>Save Cache</term>.
When you select this, the current contents of the tree cache in memory
are written to a file (with the suffix <b>.stc</b>) to speed up future
use of Tree mode with this database.
</p>
<p>
The <term>Fill cache file</term> command in the file menu of the tree
window fills the cache file with data for many opening positions.
It does a tree search for about 100 of the most common opening positions,
then saves the cache file.
</p>
<p>
Note that a tree cache (.stc) file is completely redundant; you can remove
it without affecting the database, and in fact it is removed by Scid
whenever an action occurs that could leave it out of date -- for example,
adding or replacing a game, or sorting the database.
</p>

<p><footer>(Updated: Scid 3.0, November 2001)</footer></p>
}



####################
### Compaction help:

set helpTitle(Compact) "Database compaction"
set helpText(Compact) {<h1>Database compaction</h1>
<p>
Database <term>compaction</term> is a specific type of
<a Maintenance>maintenance</a> that keeps a database as small and
efficient as possible.
Compacting a database means removing any unused space in its files.
There are two types: name file and game file compaction.
</p>

<h3>Name file compaction</h3>
<p>
Over time, you may find a database starts to contain a number of player,
event, site or round names that are no longer used in any game. This will
often happen after you spellcheck names. The unused names waste space in
the name file, and can slow down name searches.
Name file compaction removes all names that are not used in any games.
</p>

<h3>Game file compaction</h3>
<p>
Whenever a game is replaced or deleted, wasted space is left in the game
file (the largest of the three files in a Scid database). Game file
compaction removes all wasted space, leaving no deleted games in the
database. Note that this operation is irreversible: after compaction,
the deleted games are gone forever!
</p>
<p>
Game file compaction is also recommended after <a Sorting>sorting</a> a
database, to keep the order of the game file consistent with the sorted
index file.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}


####################
### Database maintenance tools help:

set helpTitle(Maintenance) "Database maintenance"
set helpText(Maintenance) {<h1>Database maintenance</h1>
<p>
Scid provides a number of tools for maintaining databases,
available from the Scid <a Menus File>File</a> menu. The
database <a Compact>compaction</a> and <a Sorting>sorting</a>
functions are explained in separate help pages.
</p>

<h3>Maintenance window</h3>
<p>
Most Scid database maintenance can be done from the Maintenance
window, which can be opened from the <menu>File: Maintenance</menu>
or <menu>Windows</menu> menus or the shortcut key <b>Ctrl+M</b>.
</p>
<p>
You can use this window to maintain <a Flags>game flags</a>,
spellcheck names, <a Compact>compact</a> or <a Sorting>sort</a>
a database. Note that any operations that are not available
for the current database (for example, because it may be read-only
or a PGN file) will be grayed out.
</p>

<h3><name Twins>Deleting twin games</name></h3>
<p>
The <menu>File: Maintenance</menu> menu has a command
<menu>Delete twin games...</menu> for detecting extra copies
(twins) of games in the database.
This command finds all pairs of games that are twins and, for each pair,
flags the shorter game deleted leaving the longer game undeleted.
Two games are considered to be twins if their players
(and any other tags that you can optionally specify) match exactly.
</p>
<p>
If you specify the "same moves" option, each pair of games must have the
same actual moves up to the length of the shorter game (or up to move 60,
whichever comes first) to be twins.
</p>
<p>
When you have deleted twins, it is a good idea to check that each
game deleted really is a copy of another game.
You can do this easily if you selected the
"<b>Set filter to all deleted games</b>" option in the
delete twins dialog box. The filter will now contain all deleted games.
You can browse through them (using the <b>p</b> and <b>n</b> keys) with
the <term>twins checker</term> window (available from the maintenance
menu, or the shortcut key <b>Ctrl+Shift+T</b>) to verify that each game is
deleted because it actually is a twin of another game.
</p>

<h3><name Editing>Editing player, event, site and round names</name></h3>
<p>
You may find mis-spelt names in your databases and want to correct them.
You can do this in Scid with the <term>Name editor</term> window
(shortcut key: <b>Control+Shift+N</b>),
available from the <menu>File: Maintenance</menu> submenu.
</p>
<p>
Each unique name is only stored once in the name file, so changing a name
actually changes all occurrences of it.
</p>

<h3><name Spellcheck>Spellchecking names</name></h3>
<p>
Scid comes with a <term>spellcheck</term> file named <b>spelling.ssp</b>,
for correction of player, event, site and round names.
Scid will try to load the spellcheck file whenever it starts up; if it
does not load, you can load it from the <menu>Options</menu> menu.
</p>
<p>
Once the spellcheck file is loaded, you can use it on a
a Scid database using the spellcheck commands in the
<menu>File: Maintenance</menu> menu, or from the maintenance window.
</p>
<p>
When you spellcheck a database, Scid produces a list of corrections that you
can edit before actually making any corrections, so you can remove any
corrections you do not want to make.
</p>
<p>
Spellchecking is especially useful for standardizing a database so all
instances of a particular player are spelt the same way.
For example, with the standard spellcheck file, the names "Kramnik,V.",
"Vladimir Kramnik", and "V. Kramnik" would all be corrected
to "Kramnik, Vladimir".
</p>
<p>
The spellcheck file has one
additional use: when it is loaded, its player data is
used to enhance the <a PInfo>player information</a> window and the
<a Crosstable>crosstable</a> window:
you will see FIDE master title
(<b>gm</b> = International Grandmaster, <b>im</b> = International Master, etc)
and country information for any player that is
listed in the spellcheck file. Over 6500 strong players of the past and
present are listed in the <b>spelling.ssp</b> file that comes with Scid.
</p>

<h3><name Ratings>Adding Elo ratings to games</name></h3>
<p>
The "Add Elo ratings..." button in the Maintenance window causes Scid
to search the current database for games where a player does not have
a rating, but the spellcheck file has an Elo rating listed for that
player at the date of the game. Scid will add all such ratings
automatically. This is very useful for a database of master-level games
which has few ratings.
</p>
<p>
The spellcheck file "spelling.ssp" that comes with Scid does not contain
the Elo rating information needed for this function, but a larger version
of it called "ratings.ssp" is available from the <a Author>Scid website</a>.
</p>

<h3><name Cleaner>The Cleaner</name></h3>
<p>
The Scid <term>Cleaner</term> (available from the Maintenance window) is
a tool for doing a number of maintenance tasks on a database in one
action. You can choose which tasks you want to do, and Scid will
perform them on the current database without requiring user interaction.
This is especially useful for maintenance of large databases.
</p>

<h3>Setting the database autoload game</h3>
<p>
The <term>autoload</term> game of a database is the game automatically
loaded whenever that database is opened. To change the autoload game of
a database, use the "Autoload game number..." button. If you always want
the last game of a database to be opened (regardless of the actual number
of games in the database), just set it to a very high number such as
9999999.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}

####################
### Sorting help:

set helpTitle(Sorting) "Sorting a database"
set helpText(Sorting) {<h1>Sorting a database</h1>
<p>
The <term>sorting</term> function sorts all games in a database.
You can select a number of sort criteria.
When two games are equal according to the the first criteria, they
are sorted using the second criteria, and so on.
</p>

<h3>Sort criteria</h3>
<p>
The available sorting criteria are:
</p>
<ul>
<li> Date (oldest games first)
<li> Year (same as date, but using the year only)
<li> Event name
<li> Site name
<li> Country (last 3 letters of Site name)
<li> Round name
<li> White name
<li> Rating (average of White and Black ratings, highest first)
<li> Black name
<li> Result (White wins, then draws, then Black wins)
<li> Length (number of full moves in the game)
<li> ECO (the <a ECO>Encyclopedia of Chess Openings code</a>)
</ul>

<h3>Sort results</h3>
<p>
When you sort a Scid database that is not read-only, the sort results
are saved so the order of games in the database is permanently changed.
If you want to the sort results to be temporary, make the database
read-only first using the <b>File: Read-only</b> menu command.
</p>
<p>
When you sort a database that is read-only or is actually a PGN file,
the sort results cannot be saved so the sorted order of games will be lost
when the file is closed.
</p>
<p>
Note that sorting a database resets the
<a Searches Filter>search filter</a> to contain all games.
</p>

<h3>Important note about sorting databases:</h3>
<p>
When a database is sorted, the index file is altered but the game file
is not changed. This means sorting a database will leave the game file
records in a scrambled order relative to the index file. This can
really <b>slow down</b> <a Tree>tree</a>, position and material/pattern
<a Searches>searches</a>, so you should reorder the game file by
<a Compact>compacting</a> it after sorting the database to maintain
good search performance.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### Flags help:

set helpTitle(Flags) "Game Flags"
set helpText(Flags) {<h1>Game Flags</h1>

<p>
A <term>flag</term> is an indicator of some chess characteristic
that can be turned on or off for each game in the database.
There are 13 user-settable flags that you can directly set for
each game. Of these, only the Delete flag has any special
significance: games with the Delete flag turned on are marked
for deletion and will removed when the database is
<a Compact>compacted</a>.
</p>
<p>
The other 12 user-settable flags and their symbols are:
</p>

<ul>
<li>White opening (W)</li>
<li>Black opening (B)</li>
<li>Middlegame (M)</li>
<li>Endgame (E)</li>
<li>Novelty (N)</li>
<li>Pawn structure (P)</li>
<li>Tactics (T)</li>
<li>Queenside play (Q)</li>
<li>Kingside play (K)</li>
<li>Brilliancy (!)</li>
<li>Blunder (?)</li>
<li>User-defined (U)</li>
</ul>

<p>
A flag can be set for the current game, all filter games, or all
database games using the <a Maintenance>maintenance</a> window.
</p>
<p>
You can use a <a Searches Header>header search</a> to find all
games in a database that have a particular flag turned on or off,
or use flags as part of more complex searches.
</p>
<p>
Since all the user-settable flags (except the Delete flag) have
no significance to Scid, you can use them for any purpose that
suits your needs. For example, you could use the Kingside (K)
flag for kingside pawn storms, or kingside heavy piece attacks,
or even for endgames with all pawns on the kingside.
</p>

<p><footer>(Updated: Scid 3.0, November 2001)</footer></p>
}

####################
### Analysis window help:

set helpTitle(Analysis) "Analysis window"
set helpText(Analysis) {<h1>The Analysis window</h1>
<p>
The Scid analysis window shows the analysis by a chess program (known
as an <term>engine</term>) of the current board position. Whenever the
board changes, Scid sends the new position to the engine and it
shows its assessment of that position.
</p>
<p>
The score shown in the analysis window is always from the perspective
of White, so a negative score indicates Black is better.
The lower frame in the window (with the scrollbar) shows the history of
evaluations produced by the engine for the current position, so you can
see how the assessment has changed.
</p>
<p>
To add the best move chosen by the engine as a new move in the current
game, press the <b>Add move</b> button.
</p>

<h3><name List>The Analysis Engines List</name></h3>
<p>
Scid maintains a list of the engines you have used, along with an
estimated Elo rating (if you guess one) and the date when each
engine was last used. You can sort the engine list by name, Elo
rating, or date.
Select the <b>New</b> or <b>Edit</b> buttons to add a new engine to
the list or edit the details for an existing entry.
</p>
<h3><name Start>Engine commands and directories</name></h3>
<p>
For each engine, you must specify the executable file to run and
which directory Scid should run it in.
</p>
<p>
The most likely cause of engine starting problems is the choice of
which directory the engine should run in. Some engines require an
initialization or opening book file in their start directory to run
properly.
Other engines (like Crafty) write log files to the directory they start
in, so you will need to run them in a directory where you have write
access.
If the directory setting for an engine is ".", Scid will just start
the engine in the current directory.
</p>
<p>
So if an engine that should work fine in Scid does not start, try
changing its directory setting. To avoid engines creating log files
in many different directories, I recommend starting engines in
the directory of the Scid User files (this is where the <b>scid.exe</b>
file is located on Windows, or <b>~/.scid/</b> on Unix); there is a
button in the dialog box for editing engine details marked
<b>scid.exe dir</b> on Windows or <b>~/.scid</b> on Unix that lets
you set the engine to start in this directory.
</p>

<h3>Training</h3>
<p>
With the <b>Training</b> button, you can play moves against the analysis
engine. The time for each move is fixed, and the analysis results are
not shown when training mode is on.
</p>

<h3>Annotating a game</h3>
<p>
The <b>Add variation</b> button in the analysis window adds the current
score and best line of play as a new variation in the game.
</p>
<p>
You can do this automatically for a number of moves (annotating the game)
by pressing the <b>Annotate</b> button. This prompts you for some
annotation options and then turns on autoplay mode.
When autoplay mode is used and the analysis window is open, a variation
containing the score and best line of play is automatically added for each
position as autoplay mode moves through the game.
Only positions from the current position until the end of the game
(or until you exit autoplay mode) are annotated, so you can skip annotation
of opening moves by moving to a middlegame position before starting autoplay.
</p>
<p>
To cancel annotation at any time, just turn off autoplay mode, for example by
pressing the <b>Escape</b> key in the main window.
</p>
<p>
Note that for simplicity, the <b>Annotate</b> button is only available
in the window opened as analysis engine 1. If you open an engine as
analysis engine 2, you cannot use it to annotate the game.
</p>

<h3>Analysis board</h3>
<p>
Pressing the chessboard-icon button in an analysis window will show
or hide the analysis board, which shows the position at the end of
the current best line of play found by the engine. This works for
most Scid-compatible engines but may not work for all; it depends on
the move notation an engine uses.
</p>

<h3>Engine priority</h3>
<p>
If an engine is using too much CPU time and affecting the use of Scid
or other applications, turning on the <b>Low CPU priority</b> checkbox
may help; it gives the engine a low priority for CPU scheduling.
</p>

<h3>Interface details</h3>
<p>
To use the analysis window, you will need a chess program that supports
the <term>WinBoard/Xboard</term> protocol.
</p>
<p>
Scid sends he <b>xboard</b>, <b>post</b> and <b>protover 2</b> to an
engine when it starts, and will use the <b>setboard</b> and <b>analyze</b>
commands for more efficient communication if the engine responds indicating
that it supports them.
If an engine does not support the <b>setboard</b> command, it will
not be able to provide analysis in any game that begins with a
non-standard start position.
</p>
<p>
For programs that do not support the <b>analyze</b> command, Scid sends
the following commands every time the position changes: <b>new</b> and
<b>force</b>, then the moves in the game to the current position, then
<b>go</b>.
</p>
<p>
Bob Hyatt's excellent free chess program <term>Crafty</term> is what I
use and recommend for the Scid analysis window, but many other WinBoard
or XBoard compatible programs have been successfully used with Scid.
Some download sites for a few engines are listed below.
</p>
<p>
Crafty:
<url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url>
</p>
<p>
Yace:
<url http://home1.stofanet.dk/moq/>http://home1.stofanet.dk/moq/</url>
</p>
<p>
Phalanx:
<url ftp://ftp.math.muni.cz/pub/math/people/Dobes/>ftp://ftp.math.muni.cz/pub/math/people/Dobes/</url>
</p>
<p>
Comet:
<url http://members.aol.com/utuerke/comet/>http://members.aol.com/utuerke/comet/</url>
</p>
<p>
Gnuchess:
<url http://www.gnu.org/software/chess/chess.html>http://www.gnu.org/software/chess/chess.html</url>
</p>
<p>
The Crazy Bishop:
<url http://remi.coulom.free.fr/>http://remi.coulom.free.fr/</url>
</p>

<p><footer>(Updated: Scid 3.4, September 2002)</footer></p>
}

####################
### EPD files help:

set helpTitle(EPD) "EPD files"
set helpText(EPD) {<h1>EPD files</h1>
<p>
An EPD (extended position description) file is a collection of positions,
where each position has some associated text. Like <a PGN>PGN</a>, it
is a common standard for chess information.
</p>
<p>
An EPD file has a number of defined <term>opcodes</term> (fields)
which are stored separated by semicolons (<b>;</b>) in the file
but are shown on separate lines in a Scid EPD window to make editing easier.
A semicolon within an EPD field is stored as "<b>\s</b>" by Scid to
distinguish it from an end-of-field marker.
Each position and its associated opcodes are stored on one single line
in the EPD file.
</p>
<p>
Standard EPD opcodes include:
<ul>
<li> <b>acd</b> Analysis count: depth searched.</li>
<li> <b>acn</b> Analysis count: number of nodes searched.</li>
<li> <b>acs</b> Analysis count: search time in seconds.</li>
<li> <b>bm</b> Best moves: move(s) judged best for some reason.</li>
<li> <b>ce</b> Centipawn evaluation: evaluation in hundredths of a
pawn from the perspective of the <b>side to move</b> -- note this
differs from the Analysis window which shows evaluations in pawns from
Whites perspective. </li>
<li> <b>cX</b> Comment (where <b>X</b> is a digit, 0-9).</li>
<li> <b>eco</b> <a ECO>ECO</a> system opening code.</li>
<li> <b>id</b> Unique Identification for this position.</li>
<li> <b>nic</b> <i>New In Chess</i> system opening code.</li>
<li> <b>pm</b> Predicted move: the first move of the PV.</li>
<li> <b>pv</b> Predicted variation: the line of best play.</li>
</ul>

<p>
EPD files have a number of uses: Scid uses an EPD file to classify
games according to the <a ECO>Encyclopedia of Chess Openings</a> (ECO)
system, and you can create an EPD file for your opening repertoire,
adding comments for positions you regularly reach in games.
</p>
<p>
You can create a new EPD file or open an existing one, from the
<menu>New</menu> and <menu>Open</menu> commands of the
<menu>File</menu> menu. At most four EPD files can be open at any time.
</p>

<h3>EPD windows</h3>
<p>
For each open EPD file, you will see a window which shows the text for
the current position. You do not have to press the Store button to store
any changes you make to a positions text; the text will be stored whenever
you move to a different position in the game.
</p>

<h3>Navigating EPD files</h3>
<p>
To browse through the positions in a EPD file, use the
<menu>Next position</menu> and <menu>Previous position</menu> commands
from the EPD window <menu>Tools</menu> menu, or use the shortcut
keys <b>Ctrl+DownArrow</b> and <b>Ctrl+UpArrow</b>.
These commands move to the next/previous position in the file, clearing
the current game and setting its start position.
</p>

<h3>Stripping out EPD fields</h3>
<p>
EPD files you find on the Internet may contain fields that do not
interest you, and they can waste a lot of space in the file.
For example, an EPD file of computer evaluations might have ce, acd,
acn, pm, pv and id fields but you may only need the ce and pv fields.
</p>
<p>
You can strip out an EPD opcode from all positions in the EPD file using
the <menu>Strip out EPD field</menu> from the EPD window <menu>Tools</menu>
menu.
</p>

<h3>The EPD window status bar</h3>
<p>
The status bar of each EPD window shows:
<ul>
<li>- the file status (<b>--</b> means unchanged, <b>XX</b> means
      changed, and <b>%%</b> means read-only); </li>
<li>- the file name; </li>
<li>- the number of positions in the file; </li>
<li>- legal moves from the current position reach another position
in this EPD file.</li>
</ul>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### Email window help:

set helpTitle(Email) "Email window"
set helpText(Email) {<h1>The Email window</h1>
<p>
Scids email manager window provides a way for you to manage correspondence
chess games played by email.
If you do not play email chess, this will be of no interest to you.
But if you play correspondence chess by email, you can send your email
messages directly from Scid!
</p>
<p>
To use the email manager:
<ul>
<li><b>1)</b> Create the game(s) for your opponent in the
database. </li>
<li><b>2)</b> In the email manager window, select <b>Add</b> and enter
your opponents details: name, email address, and the game numbers in the
database. </li>
<li><b>3)</b> Select <b>Send email</b> in the email window each time you
have added moves to the game(s) and want to send a message. </li>
</ul>

<p>
When you send an email message, Scid generates the message with the games
in PGN format <b>without</b> any comments, annotations or variations, since
you would not usually want your opponent to see your analysis.
You can edit the message before sending it to add conditional moves or
other text.
</p>
<p>
For each opponent, you may have any number of games; one or two is most
common. Note that Scid does not check if game numbers change, so after
setting up the details of your opponents, be careful to avoid deleting games
or sorting your database of email games, since this will rearrange games
and the game numbers for each opponent will be incorrect.
</p>

<h3>Limitations</h3>
<p>
Scid does not have any capability to check your email folder yet, so you
still need to add your opponents moves to the games manually.
</p>

<h3>Configuration</h3>
<p>
A copy of each email message sent by Scid is stored in the file
<b>~/.scid/scidmail.log</b>. If you want them to be stored
in a different file, you will need to edit the file <b>tcl/start.tcl</b>
and recompile Scid.
</p>
<p>
Scid can send email messages using an SMTP server or sendmail.
User the <b>Settings</b> button in the Email Manager to specify which
you want to use.
</p>
<p>
Scid stores the opponent details for a database in a file
with the same name as the database and the suffix "<b>.sem</b>".
</p>

<p><footer>(Updated: Scid 3.0, November 2001)</footer></p>
}

####################
### Reports help:

set helpTitle(Reports) "Reports"
set helpText(Reports) {<h1>Reports</h1>
<p>
A <term>Report</term> in Scid is a document containing information about
a particular position and/or player. There are two types of report Scid can
generate: Opening Reports and Player Reports.
</p>

<h3><name Opening>Opening Reports</name></h3>
<p>
Scid can produce an <term>opening report</term> that displays interesting
facts about an opening position. To generate an opening report, first make
sure the displayed position is the one you want a report for, then select
<b>Opening Report</b> from the <b>Tools</b> menu.
</p>
<p>
The <term>Opening Report</term> window displays the results of the report
Scid generated. The <b>File</b> menu has commands to save the report
to a file in plain text, HTML or <a LaTeX>LaTeX</a> format.
</p>
<p>
The first sections of the report present information on the games that
reach the report position, and moves played from the position. You can
see if the opening is becoming more popular, if it has many short draws,
and what move orders (transpositions) are used to reach it.
</p>
<p>
The Positional Themes section reports the frequency of certain common
positional themes in the report games. For this, the first 20 moves of
each game (hence the first 40 positions of each game after the starting
position) are examined. To be counted as containing a theme, a game must
contain that particular theme in at least 4 positions of its first 20
moves. This avoids the brief occurrence of a theme (such as an isolated
Queen pawn which is quickly captured) distorting results.
</p>
<p>
The final and largest part of the report is the theory table. When saving
the report to a file, you can choose to save just the theory table, a compact
report without the theory table, or the whole report.
</p>
<p>
Almost all the report sections can be turned on or off or adjusted in
the opening report options, so you can customize a report to only show
the information that interests you.
</p>
<p>
Most items of information in the report window that are shown in color,
invoke some action when selected with the left mouse button. For example,
you can click on a game reference to load that game, or click on a
positional theme to set the filter to contain only the report games where
that theme occurred.
</p>

<h4>Favorites</h4>
<p>
The <menu>Favorites</menu> menu in the report window lets you maintain a
collection of favorite opening report positions and generate the opening
reports for all those positions easily. Selecting "Add Report..." from
the Favorites menu will add the current position as a favorite report
position; you will be prompted to enter a name that will be used as
the filename when favorite reports are generated.
</p>
<p>
Select "Generate Reports..." from the Favorites menu to generate a report
for each of your favorite reports using the current database. A dialog
box will appear allowing you to specify the report type and format, and
a directory where report files will be saved. A suitable suffix for the
format you selected (e.g. ".html" for HTML format) will be added to each
report file name.
</p>

<h3><name Player>Player Reports</name></h3>
<p>
A <term>Player Report</term> is very similar to an opening report, but it
contains information about the games of a single player with the white or
black pieces. You can generate a player report from the Tools menu, or from
the <a PInfo>Player Info</a> window.
</p>
<p>
A player report can be generated either for all games by the specified player
with the specified pieces, or for only the subset of those games which reach
the current position on the main window chessboard.
</p>

<h3>Limits</h3>
<p>
There is a limit of 2000 games for most data generated by reports, so
if the report position occurs in more than 2000 games, some results may
be slightly incorrect.
</p>
<p>
Also, there is a limit of 500 games for the theory table. If the report
position occurs in more than 500 games, only the 500 games with the highest
average Elo rating are used to generate the theory table. You can adjust the
number of games used to generate the theory table in the Report options.
</p>

<p><footer>(Updated: Scid 3.5, February 2003)</footer></p>
}


####################
### Player List help:

set helpTitle(PList) "Player Finder window"
set helpText(PList) {<h1>The Player Finder window</h1>
<p>
The <term>Player Finder</term> window displays a list of names of
players in the current database. Selecting a player will open the
<a PInfo>Player Info</a> window to display more detailed information
about that player.
</p>
<p>
Five columns are displayed showing each player's name, peak Elo
rating, number of games played and the year of their oldest and
newest game.
Click on any column title at the top of the list to sort the
list by that column.
</p>
<p>
The controls below the list allow you to filter the list contents.
You can alter the maximum list size, enter a case-insensitive player
name prefix (such as "ada" to search for "Adams"), and restrict the
ranges of Elo rating and number of games played.
</p>

<p><footer>(Updated: Scid 3.4, July 2002)</footer></p>
}

####################
### Player Info help:

set helpTitle(PInfo) "Player Info window"
set helpText(PInfo) {<h1>The Player Info window</h1>
<p>

The <term>Player Information</term> window is produced or updated whenever
you click the left mouse button on a player name in the game information
area (below the chessboard) or in the <a Crosstable>crosstable</a> window.
</p>
<p>
It displays (hopefully) useful information about the player, including their
success with White and Black, favorite openings (by <a ECO>ECO code</a>),
and rating history.
</p>
<p>
All percentages displayed are an expected score (success rate), from the
player's perspective -- so higher is always better for the player, whether they
are White or Black.
</p>
<p>
You can see the player's rating history in a graph by pressing the
<a Graphs Rating>Rating graph</a> button.
</p>
<p>
Any number printed in red can be clicked with the left mouse button to set
the <a Searches Filter>filter</a> to the games it represents.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### Graphs help:

set helpTitle(Graphs) "Graph windows"
set helpText(Graphs) {<h1>Graph windows</h1>
<p>
Scid has a number of windows which display information graphically.
They are explained below.
</p>

<h3><name Filter>Filter Graph window</name></h3>
<p>
The <term>Filter Graph</term> window shows trends by date or by
Elo rating for the games in the current filter, compared to the
entire database. For example, it is useful when the <a Tree>tree</a>
is open as a tool showing how the current opening position has changed
in popularity in recent years or decades, or whether it is especially
popular among higher-rated players such as grandmasters.
Each point on the graph represents the number of games in the filter
per 1000 games in the entire database, for a particular date or Elo
rating range.
</p>
<p>
When plotting the Filter graph by rating, Scid uses the average (mean)
rating for each game. Estimate ratings (such as those in the spelling file)
are not used. If one player in a game has a rating but the opponent
does not, the opponent is presumed to have the same up to a limit of 2200.
For example, if one player is rated 2500 and the opponent has no rating,
the mean rating is (2500+2200)/2=2350.
</p>

<h3><name Rating>Rating Graph window</name></h3>
<p>
The <term>Rating Graph</term> window shows the rating history of one
player or the two players of the current game.
You can produce the graph for a single player by pressing the
<b>Rating graph</b> button in the <a PInfo>player information</a>
window, or produce it for the two players of the current game by
selecting <b>Rating graph</b> from the <menu>Tools</menu> menu.
</p>

<h3><name Score>Score Graph window</name></h3>
<p>
The <term>Score Graph</term> window shows the numeric evaluations (scores)
stored in the comments of the current game as a graph.
You can click the left mouse button anywhere in the score graph to go to the
corresponding position in the game.
</p>
<p>
Two types of evaluation comment are recognized: those produced by
the Scid <a Analysis>analysis</a> window (which have the format
<ul>
<li><b>1.e4 {"+0.25 ...."}</b></li>
</ul>
and are always scores from White's perspective) and those produced
by the Crafty annotate command (which have the format
<ul>
<li><b>1.e4 ({9:+0.25} ....)</b></li>
</ul>
and are also scores from White's perspective).
</p>

<h3><name Tree>Tree Graph window</name></h3>
<p>
The <term>Tree Graph</term> window is available from the tree
window. It shows the performance of the most popular moves from the
current position. More information is available from the
<a Tree Graph>Tree</a> help page.
</p>

<p><footer>(Updated: Scid 3.3, April 2002)</footer></p>
}

####################
### Tablebases help:

set helpTitle(TB) "Tablebases"
set helpText(TB) {<h1>Tablebases</h1>

<p>
A <term>tablebase</term> is a file containing the perfect result
information about all positions of a particular material setup,
such as King and Rook versus King and Pawn. Tablebases for all
material situations up to five men (including the Kings) have been
generated, and some simple 6-men tablebases are also available.
</p>
<p>
Scid can use Nalimov-format tablebases that are used by many modern
chess engines. These often end with the file suffix <b>.nbw.emd</b>
or <b>.nbb.emd</b>. All 3-, 4- and 5-men Nalimov tablebases can be
used in Scid.
</p>

<h3>Using tablebases in Scid</h3>
<p>
To use tablebase files in Scid, simply set their directories by
selecting <b>Tablebase directory...</b> from the <menu>Options</menu> menu.
You can select up to 4 directories where your tablebase files are stored.
You can press a <b>...</b> button to the right of an entry to choose a
file, to specify that the directory of that file should be used.
</p>
<p>
When a position found in a tablebase file is reached, the game information
area (below the chessboard) will show tablebase information. You can
configure the amount of information shown by clicking the right-mouse
button in that area or selecting <b>Game information</b> from the
<menu>Options</menu> menu. Selecting the "result and best moves" option
gives the most useful information, but is much often slower than
the "result only" option.
</p>

<h3>The Tablebase window</h3>
<p>
You can get even more tablebase information about the current position
by opening the <term>Tablebase window</term> (<menu>Windows</menu> menu,
shortcut: Ctrl+Shift+=). This window shows the result with perfect play
of all legal moves from the current position.
</p>
<p>
The window has two main parts. The summary frame (on the left) shows
which tablebases Scid found on your computer and a summary for each
tablebase. The results frame (on the right) shows optimal results for
all moves from the current position displayed in the main window.
</p>

<h4>The summary frame</h4>
<p>
The top part of the summary frame lets you select a particular
tablebase. Those you have available are shown in blue and unavailable
tablebases are shown in gray, but you can select any tablebase.
The lower part of the summary frame shows summary information for the
selected tablebase. (Not all tablebases have a summary recorded in
Scid yet.)
</p>
<p>
The summary includes the frequency (how many games per million reach a
position with this material, computed from a database of more than
600,000 master-level games), a longest mate for either side, and the
number of mutual (or "reciprocal") zugzwangs. A mutual zugwang is a
position where white to move draws and black to move loses, or where
white to move loses and black to move draws, or where whoever moves
loses.
</p>
<p>
For some tablebases with mutual zugzwangs, the summary also includes
a list of all of the zugwang positions or a selection of them. A full
list for every tablebase is not feasible since some tablebases have
thousands of mutual zugzwangs.
</p>
<p>
You can set up a random position from the selected tablebase by pressing
the <b>Random</b> button.
</p>

<h4>The results frame</h4>
<p>
The results frame is updated whenever the chessboard in the main window
changes. The first line shows how many moves win (+), draw (=), lose (-),
or have an unknown result (?). The rest of the frame gives a more detailed
list of results, ranking them from shortest to longest mates, then draws,
then longest to shortest losses. All distances are to checkmate.
</p>

<h4>The results board</h4>
<p>
In a tablebase position, it is often useful what the tablebase results
would be if all the pieces in the current position were on their
current squares but one particular piece was moved somewhere else.
For example, you may want to determine how close a king has to be to
a passed pawn to win or draw a particular position. In endgame books
this information is often called the <i>winning zone</i> or
<i>drawing zone</i> of a piece in a position.
</p>
<p>
You can find this information in Scid by pressing the button with an
image of a chessboard, to show the <term>results board</term> in the
tablebase window.
When you press the left mouse button on any piece in this board, a
symbol is drawn in each empty square showing what the tablebase result
would be (with the same side to move as the current main window position)
if the selected piece was on that square.
</p>
<p>
There are five different symbols a square can have:
a white <b>#</b> means White wins;
a black <b>#</b> means Black wins;
a blue <b>=</b> means the position is drawn;
a red <b>X</b> means the position is illegal (because the kings are
adjacent or the side to move is giving check); and
a red <b>?</b> means the result is unknown because the necessary
tablebase file is not available.
</p>

<h3>Obtaining Tablebase files</h3>
<p>
See the <a Author Related>related links</a> section for help on finding
tablebase files on the Internet.
</p>

<p><footer>(Updated: Scid 3.4, September 2002)</footer></p>
}

####################
### Bookmarks help:

set helpTitle(Bookmarks) "Bookmarks"
set helpText(Bookmarks) {<h1>Bookmarks</h1>
<p>
Scid allows you to <term>bookmark</term> important games for easy
future reference. The bookmarks menu is available from the
<menu>File</menu> menu, the toolbar, or the <B>Ctrl+B</b> shortcut key.
</p>
<p>
When you select a bookmarked game from the Bookmarks menu, Scid will
open its database if necessary, find that game, and move to the game
position at which it was bookmarked.
</p>
<p>
Only games in a Scid format database (not a PGN file or the clipbase)
can be bookmarked.
</p>
<p>
If the database of a bookmarked game is sorted or compacted, the bookmark
details may become out of date. When that happens, Scid will search the
database for the best matching game (comparing player names, site, etc)
when the bookmark is selected, so the bookmarked game should still be
loaded. However, if details of the bookmarked game change, it is possible
that a different game will match the bookmark details better and be
loaded instead. So it is a good idea to re-bookmark a game if you edit
its players, site, result, round or year.
</p>

<h3>Editing bookmarks</h3>
<p>
With the bookmark editor, you can change the menu text displayed for
each bookmarked game and add folders to categorize bookmarks.
</p>

<h3>Hints</h3>
<p>
You can use bookmarks for fast access to databases you use often
by bookmarking a game from each database. Another good use for
bookmarks is to add important games you find when studying a
particular chess opening.
</p>
<p>
The bookmarks menu contains an entry for controlling the display of
bookmark folders: they can be shown as submenus (useful when there are
many bookmarks), or as a single list.
</p>

<p><footer>(Updated: Scid 3.0, November 2001)</footer></p>
}

####################
### Command-line options help:

set helpTitle(Cmdline) "Command-line options"
set helpText(Cmdline) {<h1>Command-line options</h1>
<p>
When you start Scid from a shell or console, there are command-line
options you can specify. Scid-format databases (with or without a
file suffix such as ".si3") and PGN files to be opened can be given,
for example:
<ul>
<li>scid mybase newgames.pgn</li>
</ul>
will start Scid and open the Scid database called mybase and the
PGN file named newgames.pgn.
</p>
<p>
There are also optional arguments to control which files Scid should
search for and use when it starts. You can turn off the use of
<a TB>tablebases</a> with the <b>-xtb</b> (or <b>-xt</b>) option,
avoid loading the <a ECO>ECO openings classification</a> file with
<b>-xeco</b> or <b>-xe</b>, and avoid loading the
<a Maintenance Spellcheck>spelling</a> file
with <b>-xspell</b> or <b>-xs</b>. Also, the option <b>-fast</b>
or <b>-f</b> does all three, so <b>scid -f</b> is equivalent
to <b>scid -xeco -xspell -xtb</b>.
</p>

<p><footer>(Updated: Scid 3.1, November 2001)</footer></p>
}

####################
### Pgnscid help:

set helpTitle(Pgnscid) "Pgnscid"
set helpText(Pgnscid) {<h1>Pgnscid</h1>
<p>
<term>Pgnscid</term> is the separate program that you need to use to
convert PGN (portable game notation) files into Scid databases.
</p>
<p>
To convert a file named <i>myfile.pgn</i>, simply type:
<ul>
<li> <b>pgnscid myfile.pgn</b> </li>
</ul>
and the scid database (consisting of <i>myfile.si3</i>, <i>myfile.sg3</i>
and <i>myfile.sn3</i>) will be created.
Any errors or warnings will be written to the file <i>myfile.err</i>.
</p>
<p>
If you want the database to be created in a different directory or have
a different name, you can add the database name to the command line,
for example:
<ul>
<li> <b>pgnscid myfile.pgn mybase</b> </li>
</ul>
will create a database consisting of the files <i>mybase.si3</i>,
<i>mybase.sg3</i> and <i>mybase.sn3</i>.
</p>
<p>
Note that pgnscid (and scid) can read Gzipped PGN files
(e.g. <b>mybase.pgn.gz</b>)
directly, so if you have a large PGN file compressed with Gzip to save
disk space, you do not have to un-gzip it first.
</p>

<h3>Options</h3>
<p>
There are two optional arguments pgnscid can accept before the filename:
<b>-f</b> and <b>-x</b>.
</p>
<p>
The <b>-f</b> option forces overwriting of an existing database; by
default, pgnscid will not convert to a database that already exists.
</p>
<p>
The <b>-x</b> option causes pgnscid to ignore all text between games.
By default, text between games is stored as a pre-game comment of the
game that follows. This option only affects text between games; standard
comments inside each game are still converted and stored.
</p>

<h3>Formatting player names</h3>
<p>
To reduce the number of multiple spellings of names that refer to the
same player, some basic formatting of player names is done by pgnscid.
For example, the number of spaces after each comma is standardized to one,
any spaces at the start and end of a name are removed, and a dot at the
end of a name is removed.
Dutch prefixes such as "van den" and "Van Der" are also normalized to have
a capital V and small d.
</p>
<p>
You can edit (and even spellcheck) player, event, site and round names in
Scid; see the <a Maintenance Editing>Maintenance</a> help page for details.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}


####################
### File formats help:

set helpTitle(Formats) "File Formats"
set helpText(Formats) {<h1>Scid File Formats</h1>
<p>
Scid databases consist of three essential files: an Index file, a Name
file and a Game file. All have a two-letter suffix starting with "s":
".si" for index files, ".sn" for name files, and ".sg" for game files.
</p>

<h3>The Index (.si) file</h3>
<p>
This file contains a description for the database and a small fixed-size
entry for each game. The current size is 41 bytes per game.
Of this, about 28 bytes is essential information such as the result,
date, player/event/site name ID numbers (the actual names are in the
Name file), etc.
</p>
<p>
The remaining 13 bytes contain redundant but useful information about the
game that is used to speed up position, material and pattern searches.
See the section <a Formats Fast>Fast searches</a> below for more information.
</p>

<h3>The Name (.sn) file</h3>
<p>
This file contains all player, event, site and round names used in the
database. Each name is stored only once even if it occurs in many games.
The name file is usually the smallest of the three essential files in a
database.
</p>

<h3>The Game (.sg) file</h3>
<p>
This file contains the actual moves, variations and comments of each game.
The move encoding format is very compact: most moves take only one byte
of storage.
</p>
<p>
When a game is replaced, its new version is saved to the <i>end</i> of
the game file, so wasted space can accumulate over time. You can restore
a database to its minimal size by <a Compact>compacting</a> it.
</p>

<h3>Other Scid files</h3>
<p>
An <a EPD>EPD</a> file (suffix: ".epd")
contains a number of chess positions, each with a text comment.
The EPD file format is described in the <a Author Related>PGN standard</a>.
</p>
<p>
An email (suffix: ".sem") file for a database stores details of the opponents
you send email messages to.
</p>
<p>
A SearchOptions (suffix: ".sso") file contains Scid
<a Searches Header>header</a> or
<a Searches Material>material/pattern</a> search settings.
</p>

<h3><name Fast>Fast searches in Scid</name></h3>
<p>
As mentioned above, the index file stores some redundant but useful
information about each game to speed up position or material searches.
</p>
<p>
For example, the material of the final position is stored. If you search
for rook and pawn endings, then all games that end with a queen, bishop
or knight on the board (and have no pawn promotions) will be quickly
skipped over.
</p>
<p>
Another useful piece of information stored is the order in which pawns
leave their home squares (by moving, or by being captured). This is used
to speed up tree or exact position searches, especially for opening
positions. For example, when searching for the starting position of the
French defence (1.e4 e6), every game starts with 1.e4 c5, or 1.d4, etc, will
be skipped, but games starting with 1.e4 e5 will still need to be searched.
</p>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}

####################
### Options and Fonts help:

set helpTitle(Options) "Options"
set helpText(Options) {<h1>Options and preferences</h1>
<p>
Many Scid options and preferences (such as the board size, colors, fonts,
and default settings) are adjustable from the <menu>Options</menu> menu.
All these (and more, such as the last directory you loaded a database from
and the sizes of some windows) are saved to an options file when
you select <b>Save Options</b> from the Options menu.
The options file is loaded whenever you start Scid.
</p>
<p>
If you use Windows, the options file is <b>scid.opt</b> in the directory
where the Scid program file <b>scid.exe</b> is located. For users of Unix
operating systems (such as Solaris or Linux) the file
is <b>~/.scid/scidrc</b>.
</p>

<h3><name MyPlayerNames>Setting your player names</name></h3>
<p>
There may be a player name (or several names) for whom, whenever a game
is loaded, you would like the main window chessboard to be displayed from
the perspective of that player. You can configure a list of such names
using <b>My Player Names...</b> from the <menu>Options/Chessboard</menu>
menu. In the dialog box that appears, enter one player name on each line.
Wildcard characters ("<b>?</b>" for exactly one character and "<b>*</b>"
for a sequence of zero or more characters) can be used.
</p>

<h3><name Fonts>Setting Fonts</name></h3>
<p>
Scid has three basic fonts it uses in most of its windows, and you can
customize all of them. They are called <b>regular</b>, <b>small</b> and
<b>fixed</b>.
</p>
<p>
The fixed font should be a fixed-width (not proportional) font. It is used
for the <a Tree>tree</a> and <a Crosstable>crosstable</a> windows.
</p>

<p><footer>(Updated: Scid 3.5, February 2003)</footer></p>
}

####################
### NAG values help:

set helpTitle(NAGs) "NAG values"
set helpText(NAGs) {<h1>Standard NAG values</h1>
<p>
Standard NAG (Numeric Annotation Symbol) values defined in the
<a Author Related>PGN standard</a> are:
</p>
<cyan>
<ul>
<li>  1   Good move (!) </li>
<li>  2   Poor move (?) </li>
<li>  3   Excellent move (!!) </li>
<li>  4   Blunder (??) </li>
<li>  5   Interesting move (!?) </li>
<li>  6   Dubious move (?!) </li>
<li>  7   Forced move </li>
<li>  8   Singular move; no reasonable alternatives </li>
<li>  9   Worst move </li>
<li> 10   Drawish position (=) </li>
<li> 11   Equal chances, quiet position (=) </li>
<li> 12   Equal chances, active position (=) </li>
<li> 13   Unclear position (~) </li>
<li> 14   White has a slight advantage (+=) </li>
<li> 15   Black has a slight advantage (=+) </li>
<li> 16   White has a moderate advantage (+/-) </li>
<li> 17   Black has a moderate advantage (-/+) </li>
<li> 18   White has a decisive advantage (+-) </li>
<li> 19   Black has a decisive advantage (-+) </li>
<li> 20   White has a crushing advantage (+-) </li>
<li> 21   Black has a crushing advantage (-+) </li>
<li> 22   White is in zugzwang </li>
<li> 23   Black is in zugzwang </li>
<li> 24   White has a slight space advantage </li>
<li> 25   Black has a slight space advantage </li>
<li> 26   White has a moderate space advantage </li>
<li> 27   Black has a moderate space advantage </li>
<li> 28   White has a decisive space advantage </li>
<li> 29   Black has a decisive space advantage </li>
<li> 30   White has a slight time (development) advantage </li>
<li> 31   Black has a slight time (development) advantage </li>
<li> 32   White has a moderate time (development) advantage </li>
<li> 33   Black has a moderate time (development) advantage </li>
<li> 34   White has a decisive time (development) advantage </li>
<li> 35   Black has a decisive time (development) advantage </li>
<li> 36   White has the initiative </li>
<li> 37   Black has the initiative </li>
<li> 38   White has a lasting initiative </li>
<li> 39   Black has a lasting initiative </li>
<li> 40   White has the attack </li>
<li> 41   Black has the attack </li>
<li> 42   White has insufficient compensation for material deficit </li>
<li> 43   Black has insufficient compensation for material deficit </li>
<li> 44   White has sufficient compensation for material deficit </li>
<li> 45   Black has sufficient compensation for material deficit </li>
<li> 46   White has more than adequate compensation for material deficit </li>
<li> 47   Black has more than adequate compensation for material deficit </li>
<li> 48   White has a slight center control advantage </li>
<li> 49   Black has a slight center control advantage </li>
<li> 50   White has a moderate center control advantage </li>
<li> 51   Black has a moderate center control advantage </li>
<li> 52   White has a decisive center control advantage </li>
<li> 53   Black has a decisive center control advantage </li>
<li> 54   White has a slight kingside control advantage </li>
<li> 55   Black has a slight kingside control advantage </li>
<li> 56   White has a moderate kingside control advantage </li>
<li> 57   Black has a moderate kingside control advantage </li>
<li> 58   White has a decisive kingside control advantage </li>
<li> 59   Black has a decisive kingside control advantage </li>
<li> 60   White has a slight queenside control advantage </li>
<li> 61   Black has a slight queenside control advantage </li>
<li> 62   White has a moderate queenside control advantage </li>
<li> 63   Black has a moderate queenside control advantage </li>
<li> 64   White has a decisive queenside control advantage </li>
<li> 65   Black has a decisive queenside control advantage </li>
<li> 66   White has a vulnerable first rank </li>
<li> 67   Black has a vulnerable first rank </li>
<li> 68   White has a well protected first rank </li>
<li> 69   Black has a well protected first rank </li>
<li> 70   White has a poorly protected king </li>
<li> 71   Black has a poorly protected king </li>
<li> 72   White has a well protected king </li>
<li> 73   Black has a well protected king </li>
<li> 74   White has a poorly placed king </li>
<li> 75   Black has a poorly placed king </li>
<li> 76   White has a well placed king </li>
<li> 77   Black has a well placed king </li>
<li> 78   White has a very weak pawn structure </li>
<li> 79   Black has a very weak pawn structure </li>
<li> 80   White has a moderately weak pawn structure </li>
<li> 81   Black has a moderately weak pawn structure </li>
<li> 82   White has a moderately strong pawn structure </li>
<li> 83   Black has a moderately strong pawn structure </li>
<li> 84   White has a very strong pawn structure </li>
<li> 85   Black has a very strong pawn structure </li>
<li> 86   White has poor knight placement </li>
<li> 87   Black has poor knight placement </li>
<li> 88   White has good knight placement </li>
<li> 89   Black has good knight placement </li>
<li> 90   White has poor bishop placement </li>
<li> 91   Black has poor bishop placement </li>
<li> 92   White has good bishop placement </li>
<li> 93   Black has good bishop placement </li>
<li> 94   White has poor rook placement </li>
<li> 95   Black has poor rook placement </li>
<li> 96   White has good rook placement </li>
<li> 97   Black has good rook placement </li>
<li> 98   White has poor queen placement </li>
<li> 99   Black has poor queen placement </li>
<li>100   White has good queen placement </li>
<li>101   Black has good queen placement </li>
<li>102   White has poor piece coordination </li>
<li>103   Black has poor piece coordination </li>
<li>104   White has good piece coordination </li>
<li>105   Black has good piece coordination </li>
<li>106   White has played the opening very poorly </li>
<li>107   Black has played the opening very poorly </li>
<li>108   White has played the opening poorly </li>
<li>109   Black has played the opening poorly </li>
<li>110   White has played the opening well </li>
<li>111   Black has played the opening well </li>
<li>112   White has played the opening very well </li>
<li>113   Black has played the opening very well </li>
<li>114   White has played the middlegame very poorly </li>
<li>115   Black has played the middlegame very poorly </li>
<li>116   White has played the middlegame poorly </li>
<li>117   Black has played the middlegame poorly </li>
<li>118   White has played the middlegame well </li>
<li>119   Black has played the middlegame well </li>
<li>120   White has played the middlegame very well </li>
<li>121   Black has played the middlegame very well </li>
<li>122   White has played the ending very poorly </li>
<li>123   Black has played the ending very poorly </li>
<li>124   White has played the ending poorly </li>
<li>125   Black has played the ending poorly </li>
<li>126   White has played the ending well </li>
<li>127   Black has played the ending well </li>
<li>128   White has played the ending very well </li>
<li>129   Black has played the ending very well </li>
<li>130   White has slight counterplay </li>
<li>131   Black has slight counterplay </li>
<li>132   White has moderate counterplay </li>
<li>133   Black has moderate counterplay </li>
<li>134   White has decisive counterplay </li>
<li>135   Black has decisive counterplay </li>
<li>136   White has moderate time control pressure </li>
<li>137   Black has moderate time control pressure </li>
<li>138   White has severe time control pressure </li>
<li>139   Black has severe time control pressure </li>
</ul>
</cyan>

<p>
Other proposed NAG values for Chess Informant publication symbols include:
</p>
<cyan>
<ul>
<li>140   With the idea ... </li>
<li>141   Aimed against ... </li>
<li>142   Better move </li>
<li>143   Worse move </li>
<li>144   Equivalent move </li>
<li>145   Editor's Remark ("RR") </li>
<li>146   Novelty ("N") </li>
<li>147   Weak point </li>
<li>148   Endgame </li>
<li>149   Line </li>
<li>150   Diagonal </li>
<li>151   White has a pair of Bishops </li>
<li>152   Black has a pair of Bishops </li>
<li>153   Bishops of opposite color </li>
<li>154   Bishops of same color </li>
</ul>
</cyan>

<p>
Other suggested values are:
</p>
<cyan>
<ul>
<li>190   Etc. </li>
<li>191   Doubled pawns </li>
<li>192   Isolated pawn </li>
<li>193   Connected pawns </li>
<li>194   Hanging pawns </li>
<li>195   Backwards pawn </li>
</ul>
</cyan>

<p>
Symbols defined by Scid for its own use are:
</p>
<cyan>
<ul>
<li>201   Diagram ("D", sometimes denoted "#") </li>
</ul>
</cyan>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}


set helpTitle(ECO) "ECO guide"
set helpText(ECO) {<h1>ECO openings classification</h1>
<p>
Scid can classify chess games according to the <b>ECO</b>
(Encyclopedia of Chess Openings) chess openings classification.
An standard ECO code consists of a letter (A..E) followed by two
digits, so there are 500 distinct standard ECO codes.
</p>

<h3>Scid extensions to the ECO system</h3>
<p>
The ECO system is very limited and not sufficient for modern games:
some of the 500 codes are almost never seen any more, while some
are seen very often. To improve this situation, Scid allows an optional
extension to the basic ECO codes: each code can be extended with a
letter (a..z), with a further extension (another digit, 1..4) being
possible but not used in the standard Scid ECO file yet.
So an extended Scid ECO code looks like "<b>A41e</b>" or "<b>E99b2</b>".
Many of the most common ECO codes found in modern master-level games have
extensions defined in the Scid ECO file.
</p>

<h3><name Browser>The ECO Browser window</name></h3>
<p>
The <term>ECO Browser</term> window shows you the positions that are
used to classify each ECO code, and the frequency and performance of
ECO codes in the current database.
</p>
<p>
The upper pane shows the frequency of each ECO code in the current
database. The bars in the graph have three sections: the lowest
(lightest color) is the number of White wins, the middle is the
number of draws, and the highest (darkest) is the number of Black wins.
This lets you see at a glance the characteristics of an opening: for
example, if White is scoring very well, or if draws are very common.
</p>
<p>
To go to a deeper ECO level, click the left mouse button
on a bar in the graph (or type the
letter or digit it corresponds to). To go back to the higher level,
click the right mouse button anywhere in the graph, or press the left
arrow (or delete or backspace) key.
</p>
<p>
The lower pane shows the positions that comprise a particular ECO code,
according to the ECO file you have loaded.
</p>

<h3>Loading the Scid ECO file</h3>
<p>
The ECO file that comes with Scid is called <b>scid.eco</b>,
and Scid tries to load this when it starts up.
If Scid cannot find it, you will need to do the following to enable ECO
classification:
<ul>
<li>(a) In Scid, use the menu command
        <menu>Options: Load ECO file</menu>
        and select the file <b>scid.eco</b>. </li>
<li>(b) Save options (from the <menu>Options</menu> menu). </li>
</ul>
After you do this, the ECO file will be loaded every time you start Scid.
</p>

<h3><name Codes>ECO code system</name></h3>
<p>
The basic structure of the ECO system is:
</p>
<p>
<b><blue><run ::windows::eco::Refresh A>A</run></blue></b>
   1.d4 Nf6 2...;  1.d4 ...;  1.c4;  1.various
<ul>
<li>  <b>A0</b>  1.<i>various</i>
      (<b>A02-A03</b> 1.f4: <i>Bird's Opening</i>,
      <b>A04-A09</b>  1.Nf3: <i>Reti, King's Indian Attack</i>) </li>
<li>  <b>A1</b>  1.c4 ...: <i>English</i> </li>
<li>  <b>A2</b>  1.c4 e5: <i>King's English</i> </li>
<li>  <b>A3</b>  1.c4 c5: <i>English, Symmetrical </i> </li>
<li>  <b>A4</b>  1.d4 ...: <i>Queen's Pawn</i> </li>
<li>  <b>A5</b>  1.d4 Nf6 2.c4 ..: <i>Indian Defence </i> </li>
<li>  <b>A6</b>  1.d4 Nf6 2.c4 c5 3.d5 e6: <i>Modern Benoni</i> </li>
<li>  <b>A7</b>  A6 + 4.Nc3 exd5 5.cxd5 d6 6.e4 g6 7.Nf3 </li>
<li>  <b>A8</b>  1.d4 f5: <i>Dutch Defence</i> </li>
<li>  <b>A9</b>  1.d4 f5 2.c4 e6: <i>Dutch Defence</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh B>B</run></blue></b>
   1.e4 c5;  1.e4 c6;  1.e4 d6;  1.e4 <i>various</i>
<ul>
<li>  <b>B0</b>  1.e4 ...
      (<b>B02-B05</b>  1.e4 Nf6: <i>Alekhine Defence</i>;
      <b>B07-B09</b>  1.e4 d6: <i>Pirc</i>) </li>
<li>  <b>B1</b>  1.e4 c6: <i>Caro-Kann</i> </li>
<li>  <b>B2</b>  1.e4 c5: <i>Sicilian Defence </i> </li>
<li>  <b>B3</b>  1.e4 c5 2.Nf3 Nc6: <i>Sicilian</i> </li>
<li>  <b>B4</b>  1.e4 c5 2.Nf3 e6: <i>Sicilian</i> </li>
<li>  <b>B5</b>  1.e4 c5 2.Nf3 d6: <i>Sicilian</i> </li>
<li>  <b>B6</b>  B5 + 3.d4 cxd4 4.Nxd4 Nf6 5.Nc3 Nc6 </li>
<li>  <b>B7</b>  B5 + 4.Nxd4 Nf6 5.Nc3 g6: <i>Sicilian Dragon</i> </li>
<li>  <b>B8</b>  B5 + 4.Nxd4 Nf6 5.Nc3 e6: <i>Sicilian Scheveningen</i> </li>
<li>  <b>B9</b>  B5 + 4.Nxd4 Nf6 5.Nc3 a6: <i>Sicilian Najdorf</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh C>C</run></blue></b>
   1.e4 e5;  1.e4 e6
<ul>
<li>  <b>C0</b>  1.e4 e6: <i>French Defence</i> </li>
<li>  <b>C1</b>  1.e4 e6 2.d4 d5 3.Nc3: <i>French, Winawer/Classical</i> </li>
<li>  <b>C2</b>  1.e4 e5: <i>Open Game</i> </li>
<li>  <b>C3</b>  1.e4 e5 2.f4: <i>King's Gambit</i> </li>
<li>  <b>C4</b>  1.e4 e5 2.Nf3: <i>Open Game</i> </li>
<li>  <b>C5</b>  1.e4 e5 2.Nf3 Nc6 3.Bc4: <i>Italian; Two Knights</i> </li>
<li>  <b>C6</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5: <i>Spanish (Ruy Lopez)</i> </li>
<li>  <b>C7</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5 a6 4.Ba4: <i>Spanish</i> </li>
<li>  <b>C8</b>  C7 + 4...Nf6 5.O-O: <i>Spanish, Closed and Open</i>
      (<b>C80-C83</b>  5.O-O Nxe4: <i>Spanish, Open System</i>;
      <b>C84-C89</b>  5.O-O Be7: <i>Spanish, Closed System</i>) </li>
<li>  <b>C9</b>  C8 + 5...Be7 6.Re1 b5 7.Bb3 d6: <i>Spanish, Closed</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh D>D</run></blue></b>
   1.d4 d5; 1.d4 Nf6 2.c4 g6 with 3...d5
<ul>
<li>  <b>D0</b>   1.d4 d5: <i>Queen's Pawn</i> </li>
<li>  <b>D1</b>   1.d4 d5 2.c4 c6: <i>Slav Defence</i> </li>
<li>  <b>D2</b>  1.d4 d5 2.c4 dxc4: <i>Queen's Gambit Accepted (QGA)</i> </li>
<li>  <b>D3</b>  1.d4 d5 2.c4 e6: <i>Queen's Gambit Declined (QGD)</i> </li>
<li>  <b>D4</b>  D3 + 3.Nc3 Nf6 4.Nf3 c5/c6: <i>Semi-Tarrasch; Semi-Slav</i> </li>
<li>  <b>D5</b>  D3 + 3.Nc3 Nf6 4.Bg5: <i>QGD Classical</i> </li>
<li>  <b>D6</b>  D5 + 4...Be7 5.e3 O-O 6.Nf3 Nbd7: <i>QGD Orthodox</i> </li>
<li>  <b>D7</b>  1.d4 Nf6 2.c4 g6 with 3...d5: <i>Grunfeld</i> </li>
<li>  <b>D8</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5: <i>Grunfeld</i> </li>
<li>  <b>D9</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5 4.Nf3: <i>Grunfeld</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh E>E</run></blue></b>
   1.d4 Nf6 2.c4 e6; 1.d4 Nf6 2.c4 g6 </li>
<ul>
<li>  <b>E0</b>  1.d4 Nf6 2.c4 e6: <i>Catalan, etc</i> </li>
<li>  <b>E1</b>  1.d4 Nf6 2.c4 e6 3.Nf3 (b6): <i>Queen's Indian, etc</i> </li>
<li>  <b>E2</b>  1.d4 Nf6 2.c4 e6 3.Nc3 (Bb4): <i>Nimzo-Indian, etc</i> </li>
<li>  <b>E3</b>  E2 + 4.Bg5 or 4.Qc2: <i>Nimzo-Indian</i> </li>
<li>  <b>E4</b>  E2 + 4.e3: <i>Nimzo-Indian, Rubinstein</i> </li>
<li>  <b>E5</b>  E4 + 4...O-O 5.Nf3: <i>Nimzo-Indian, main line</i> </li>
<li>  <b>E6</b>  1.d4 Nf6 2.c4 g6: <i>King's Indian</i> </li>
<li>  <b>E7</b>  1.d4 Nf6 2.c4 g6 3.Nc3 Bg7 4.e4: <i>King's Indian</i> </li>
<li>  <b>E8</b>  E7 + 4...d6 5.f3: <i>King's Indian, Samisch</i> </li>
<li>  <b>E9</b>  E7 + 4...d6 5.Nf3: <i>King's Indian, main lines</i> </li>
</ul>

<p><footer>(Updated: Scid 2.5, June 2001)</footer></p>
}


set helpTitle(Author) "Contact information"
set helpText(Author) {<h1>Contact Information</h1>
<p>
The Scid web page is located at: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
It has downloads of the latest version of Scid and any extra
files that are available.
</p>
<p>
Please send any comments, questions, suggestions or bug reports to the
author of Scid, Shane Hudson, at the email address:<br>
<b>sgh@users.sourceforge.net</b>
</p>

<h3><name Related>Related Links</name></h3>
<p>
If you enjoy using Scid, you may find the following websites interesting:
</p>
<ul>
<li><url http://www.tim-mann.org/chess.html>http://www.tim_mann.org/chess.html</url> --
Home page of Tim Mann's <b>xboard & winboard</b> program which is a PGN
reader and an interface for Internet chess servers. His site also has
good information on Crafty, GNUchess and other free chess programs.</li>

<li><url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url> --
the strong chess-playing program Crafty.
The subdirectory there named <b>TB</b> has many Nalimov-format tablebase
files that you can use in several chess programs and in Scid.</li>

<li><url http://www.chesscenter.com/twic/>http://www.chesscenter.com/twic/</url> --
TWIC (the week in chess), an excellent weekly bulletin of international
chess games in available in PGN format.</li>

<li><url http://scid.sourceforge.net/doc/standard.txt>http://scid.sourceforge.net/doc/standard.txt</url> --
the <b>PGN Standard</b>, created by Steven J. Edwards in 1994.
This text file explains the PGN and EPD formats in detail.</li>
</ul>

<p><footer>(Updated: Scid 2.6, August 2001)</footer></p>
}

