/*
 * Javascript for SchoolTool dropdown action menu item.
 */

DDM_visible_menu_list_id = null;
DDM_menu_hide_timeout_id = null;
DDM_hide_timeout = 300;


function DDM_getOffsetLeft (elem)
{
    var offset = elem.offsetLeft;
    var elem = elem.offsetParent;
    while (elem != null){
        offset += elem.offsetLeft;
        elem = elem.offsetParent;
    }
    return offset;
}


function DDM_onShow(el_id)
{
    var menu = document.getElementById(el_id);
    var mlist = document.getElementById(el_id + "_list");
    if (!menu || !mlist)
        return;

    DDM_cancelDelayedHide();

    if (DDM_visible_menu_list_id)
    {
        if (mlist.id == DDM_visible_menu_list_id)
            return;
        else
            DDM_performHide();
    }

    mlist.style.left = DDM_getOffsetLeft(menu) + "px";
    DDM_visible_menu_list_id = mlist.id;
    mlist.style.display="block";
}


function DDM_onHide(el_id){
    var menu = document.getElementById(el_id);
    var mlist = document.getElementById(el_id + "_list");
    if (!menu || !mlist)
        return;

    DDM_delayHide(mlist.id);
}


function DDM_delayHide(menu_id)
{
    DDM_cancelDelayedHide();
    DDM_menu_hide_timeout_id = setTimeout("DDM_performHide();", DDM_hide_timeout);
}


function DDM_cancelDelayedHide()
{
    if (DDM_menu_hide_timeout_id)
        clearTimeout(DDM_menu_hide_timeout_id);
}


function DDM_performHide()
{
    if (!DDM_visible_menu_list_id)
        return;
    DDM_cancelDelayedHide();
    var mlist = document.getElementById(DDM_visible_menu_list_id);
    DDM_visible_menu_list_id = null;
    if (!mlist)
        return;
    mlist.style.display="none";
}
