Schoolkit, une trousse pour la géométrie
========================================

Dans une trousse scolaire, on trouve des outils de géométrie.

Ce paquet fournit une petite bibliothèque en Javascript, qui implémente
ces outils pour l'écran, sous forme de graphismes vectoriels SVG
interactifs.

Les outils actuellement implémentés sont :

 - le double décimètre
 - le rapporteur

Dépendances
-----------

La bibliothèque Schoolkit s'appuie sur Raphael, voir
https://dmitrybaranovskiy.github.io/raphael/

Utilisation de Schoolkit
------------------------

Téléchargez une archive de ce dépôt, ou clonez-le à l'aide de `git`.

Le fichier `index.htm` permet de faire une démonstration de la bibliothèque ;
Modifiez la ligne 5 du fichier, remplacez
`/usr/share/javascript/raphael/raphael.js` par une URL valide vers la
bibliothèque Raphael.

Le fichier `index.html` est prévu pour une démonstration identique, à
ceci près que les fichier `schoolkit.js` est censé être installé dans
le répertoire `/usr/share/javascript/schoolkit`, ce qui est le cas si
on utilise le paquet Debian `libjs-schoolkit` ; dans ce cas, le
fichier `raphael.js` sera fourni par le paquet Debian `libjs-raphael`.

Examen du code qui met en place un outil
----------------------------------------

``` JavaScript
      let p = new GeomPaper("canvas_container1", 1000, 600);
```

Quand on instancie la classe `GeomPaper` on utilise trois paramètres :

 - l'identifiant d'un élément `<div>` où insérer la zone graphique
 - la largeur de la zone graphique en pixels
 - la hauteur de la zone graphique en pixels



``` JavaScript
      let o = new Rapporteur();
      p.addTool(o, new DOMPoint(500,300), 3);
```

Les deux lignes de code ci-dessus mettent en place un rapporteur,
centré sur le point (500, 300), à l'échelle 3.

 - on instancie la classe `Rapporteur` ;
 - on ajoute l'instance de `Rapporteur` à l'instance de `GeomPaper`,
   en précisant une position (facultative) pour le centre de rotation,
   et une échelle (facultative).
