#include <genht/htsp.h>

/* Make s the current sheet (in the GUI) */
void sch_rnd_multi_switch_to(csch_sheet_t *s);

/* Called after a sch_rnd_multi_switch_to(NULL) followed by a failed load; this
   switches to s without trying to save current (broken) state */
void sch_rnd_multi_abort_switch_to(csch_sheet_t *s);

/* Change current sheet to curr+step in the linear sheet list;
   if curr is NULL, use the GUI-current sheet */
void sch_rnd_multi_switch_to_delta(csch_sheet_t *curr, int step);

/* Special case: first switch after loading all pages from the command line */
void sch_rnd_multi_switch_to_initial(csch_sheet_t *s);


csch_sheet_t *sch_rnd_multi_load(const char *fn, const char *fmt);
csch_sheet_t *sch_rnd_multi_new_empty(void);

/* Assuming s is not the current sheet, unload it, removing from the list of sheets */
void sch_rnd_multi_unload(csch_sheet_t *s);

/* Return the next (or previous) sheet or NULL if sheet was the last sheet open */
csch_sheet_t *sch_rnd_multi_neighbour_sheet(csch_sheet_t *sheet);



extern htsp_t sch_rnd_projects; /* all projects currently open */


void sch_rnd_multi_init(void);
void sch_rnd_multi_uninit(void);
