#include <librnd/core/hidlib.h>
#include <libcschem/project.h>

/* Allocate a new output file name; use explicit if available or construct
   the name from hl's filename replacing it's "extension" */
char *cschem_export_filename(rnd_hidlib_t *hl, const char *explicit, const char *ext);

/* Compile abstract model for export if view_name is neither NULL nor empty.
   Cookie is an opaque pointer-storage provided by the caller. Call _post after
   the export. */
int cschem_export_compile_pre(csch_project_t *prj, const char *view_name, void **cookie);

/* Restore project state after a compilation-for-export */
void cschem_export_compile_post(csch_project_t *prj, void **cookie);
