/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file cubew_file_layout_embedded.c
 * \brief Provides names for avery part of cube report according to the "embedded layout: anchot.cubex + [metic id].index, [metric id].data
 *
 *
 */

#ifndef __CUBEW_FILE_LAYOUT_EMBEDDED_C
#define __CUBEW_FILE_LAYOUT_EMBEDDED_C 0

#include <config.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#include "cubew_file_layout_embedded.h"

/**
 *
 */

char*
cube_get_path_to_anchor( const char* cubename )
{
    if ( cubename == NULL )
    {
        fprintf( stderr, "WARNING: cubename in the call \"cube_get_path_to_anchor\" is NULL.\n" );
    }
    char* to_return = cubew_strdup( "anchor.xml" );
    return to_return;
}

char*
cube_get_path_to_metric_data( const char* cubename,  cube_metric* met )
{
    if ( cubename == NULL )
    {
        fprintf( stderr, "WARNING: cubename in the call \"cube_get_path_to_metric_data\" is NULL.\n" );
    }
    unsigned id = cube_metric_get_id( met );
    char     buf[ 50 ];
    memset( buf, 0, 50 );
    sprintf( buf, "%u.data", id );
    char* to_return = cubew_strdup( buf );
    return to_return;
}


char*
cube_get_path_to_metric_index( const char* cubename,   cube_metric* met )
{
    if ( cubename == NULL )
    {
        fprintf( stderr, "WARNING: cubename in the call \"cube_get_path_to_metric_index\" is NULL.\n" );
    }
    unsigned id = cube_metric_get_id( met );
    char     buf[ 50 ];
    memset( buf, 0, 50 );
    sprintf( buf, "%u.index", id );
    char* to_return = cubew_strdup( buf );
    return to_return;
}

char*
cube_get_path_to_misc_data( const char* cubename,   const char* dataname )
{
    if ( cubename == NULL )
    {
        fprintf( stderr, "WARNING: cubename in the call \"cube_get_path_to_misc_data\" is NULL.\n" );
    }
    char* to_return = cubew_strdup( dataname );
    return to_return;
}
#endif
