/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file cubew_direct_writing.c
 * \brief Provides a fooled file name transformation scheme: name -> name, withot any changes. Produces direct manyfile writing of cube report
 *
 *
 *
 */

#ifndef __CUBEW_DIRECT_WRITING_C
#define __CUBEW_DIRECT_WRITING_C 0

#include <config.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "cubew_direct_writing.h"


direct_writer_t* direct_writer = NULL;    /* global struct saving the name of the cube file. used to build a name for cube report*/


// char * cube_get_anchor_file_name( char * cubename)
// {
//     return cube_get_path_to_anchor(cubename);
// }
// char * cube_get_metric_data_file(  char * cubename,  cube_metric * met )
// {
//     return cube_get_path_to_metric_data(cubename, met);
// }
//
// char * cube_get_metric_index_file( char * cubename,  cube_metric * met )
// {
//     return cube_get_path_to_metric_index(cubename, met);
// }

// void cube_report_finish( FILE * file) {};


FILE*
cube_report_anchor_start( report_layout_writer* direct_writer )
{
//     if (direct_writer->cube_flavour != CUBE_MASTER ) return;
    if ( direct_writer == NULL )
    {
        fprintf( stderr, "Non stanard run. Create faked direct_writer with temp name of cube \"__NOFILE__\". \n" );
        cube_writing_start( "__NOFILE__", CUBE_MASTER );
    }
    char* anchorname = cube_get_path_to_anchor( direct_writer->cubename );
    __create_path_for_file( anchorname );
    FILE* anchorfile = fopen( anchorname, "wb" );
    if ( anchorfile == NULL )
    {
        fprintf( stderr, "Cannot open file %s. \n", anchorname );
        perror( "The following error occurred" );
        fprintf( stderr, "Return NULL.\n" );
    }
    free( anchorname );
    return anchorfile;
};


FILE*
cube_report_metric_data_start( report_layout_writer* direct_writer, cube_metric* met )
{
//     if (direct_writer->cube_flavour == CUBE_SLAVE ) return;
    if ( direct_writer == NULL )
    {
        fprintf( stderr, "Non stanard run. Create faked direct_writer with temp name of cube \"__NOFILE__\". \n" );
        cube_writing_start( "__NOFILE__", CUBE_MASTER );
    }
    char* dataname = cube_get_path_to_metric_data( direct_writer->cubename, met );
    __create_path_for_file( dataname );
    FILE* datafile = fopen( dataname, "wb" );
    if ( datafile == NULL )
    {
        fprintf( stderr, "Cannot open file %s. \n", dataname );
        perror( "The following error occurred" );
        fprintf( stderr, "Return NULL.\n" );
    }
    free( dataname );
    return datafile;
};


FILE*
cube_report_metric_index_start( report_layout_writer* direct_writer, cube_metric* met )
{
    if ( direct_writer == NULL )
    {
        fprintf( stderr, "Non stanard run. Create faked direct_writer with temp name of cube \"__NOFILE__\". \n" );
        cube_writing_start( "__NOFILE__", CUBE_MASTER );
    }
    char* indexname = cube_get_path_to_metric_index( direct_writer->cubename, met );
    __create_path_for_file( indexname );
    FILE* indexfile = fopen( indexname, "wb" );
    if ( indexfile == NULL )
    {
        fprintf( stderr, "Cannot open file %s. \n", indexname );
        perror( "The following error occurred" );
        fprintf( stderr, "Return NULL.\n" );
    }
    free( indexname );
    return indexfile;
};

FILE*
cube_report_misc_data_start( report_layout_writer* direct_writer,
                             char*                 dataname )
{
    if ( direct_writer == NULL )
    {
        fprintf( stderr, "Non stanard run. Create faked direct_writer with temp name of cube \"__NOFILE__\". \n" );
        cube_writing_start( "__NOFILE__", CUBE_MASTER );
    }
    if ( direct_writer->actual_metric != NULL )
    {
        cube_metric_finish( direct_writer->actual_metric, ( direct_writer->cube_flavour == CUBE_MASTER ) ? 1 : 0 );  /* 1 - signalizes, that writing will be  done. This call can be performed only by CUBE_MASTER */
    }
    direct_writer->actual_metric = NULL;

    // from here we finished writing metric.

    char* dataname = cube_get_path_to_misc_data( direct_writer->cubename, dataname );
    __create_path_for_file( dataname );
    FILE* datafile = fopen( dataname, "wb" );
    if ( datafile == NULL )
    {
        fprintf( stderr, "Cannot open file %s. \n", datafile );
        perror( "The following error occurred" );
        fprintf( stderr, "Return NULL.\n" );
    }
    free( dataname );
    return datafile;
}



void
cube_report_metric_data_finish( report_layout_writer* direct_writer, cube_metric* met, FILE* file )
{
    fclose( file );
}

void
cube_report_metric_data_weak_finish( report_layout_writer* direct_writer, cube_metric* met, FILE* file )
{
    fclose( file );
}
void
cube_report_misc_data_finish( report_layout_writer* rlw,
                              FILE*                 file )
{
    fclose( file );
}

void
cube_report_metric_index_finish( report_layout_writer* direct_writer, cube_metric* met, FILE* file )
{
    fclose( file );
}

void
cube_report_anchor_finish( report_layout_writer* direct_writer, FILE* file )
{
    fclose( file );
}




void
cube_report_write_metric_row( report_layout_writer* direct_writer, cube_metric* met )
{
    if ( direct_writer->cube_flavour == CUBE_SLAVE )
    {
        return;
    }
    if ( met->data_file != NULL )
    {
        return;
    }
    if ( direct_writer->actual_metric == met )
    {
        return;
    }
    if ( direct_writer->actual_metric != NULL )
    {
        cube_metric_finish( direct_writer->actual_metric, ( direct_writer->cube_flavour == CUBE_MASTER ) ? 1 : 0 );  /* 1 - signalizes, that writing will be  done. This call can be performed only by CUBE_MASTER */
    }
    met->data_file               = cube_report_metric_data_start( direct_writer, met );
    direct_writer->actual_metric = met;
    return;
}


report_layout_writer*
cube_writing_start( char* cubename, enum CubeFlavours_t cf )
{
    report_layout_writer* direct_writer = ( direct_writer_t* )calloc( 1, sizeof( direct_writer_t ) );
    if ( direct_writer != NULL )
    {
        if ( direct_writer->cubename != NULL )
        {
            free( direct_writer->cubename );
        }
    }
    direct_writer->cubename      = cubew_strdup( cubename );
    direct_writer->cube_flavour  = cf;
    direct_writer->actual_metric = NULL;
    return direct_writer;
}

report_layout_writer*
cube_writing_end( report_layout_writer* direct_writer )
{
    if ( direct_writer != NULL )
    {
        if ( direct_writer->cubename != NULL )
        {
            free( direct_writer->cubename );
        }
        free( direct_writer );
    }
    return direct_writer;
}


#endif
