/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_HYBRIDEVENTFACTORY_H
#define PEARL_HYBRIDEVENTFACTORY_H


#include "MpiEventFactory.h"
#include "OmpEventFactory.h"


/*-------------------------------------------------------------------------*/
/**
 *  @file    HybridEventFactory.h
 *  @ingroup PEARL_hybrid
 *  @brief   Declaration of the class HybridEventFactory.
 *
 *  This header file provides the declaration of the class HybridEventFactory.
 **/
/*-------------------------------------------------------------------------*/

namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   HybridEventFactory
 *  @ingroup PEARL_hybrid
 *  @brief   Abstract factory class for MPI and OpenMP event representations.
 **/
/*-------------------------------------------------------------------------*/

class HybridEventFactory : public MpiEventFactory, public OmpEventFactory
{
 public:
    /// @}
    /// @name Buffer-based factory methods
    /// @{

    virtual Event_rep* createEvent(event_t           type,
                                   const GlobalDefs& defs,
                                   Buffer&           buffer) const;

    /// @}
};


}   // namespace pearl


#endif   // !PEARL_HYBRIDEVENTFACTORY_H
