/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include "HybridEventFactory.h"

#include <cstddef>

using namespace pearl;


//---------------------------------------------------------------------------
//
//  class HybridEventFactory
//
//---------------------------------------------------------------------------


//--- Buffer-based factory methods ------------------------------------------

Event_rep* HybridEventFactory::createEvent(event_t           type,
                                           const GlobalDefs& defs,
                                           Buffer&           buffer) const
{
  Event_rep* result = NULL;
  
  switch (type) {
    case MPI_COLLECTIVE_BEGIN:
    case MPI_COLLECTIVE_END:
    case MPI_SEND:
    case MPI_SEND_REQUEST:
    case MPI_SEND_COMPLETE:
    case MPI_RECV:
    case MPI_RECV_REQUEST:
    case MPI_RECV_COMPLETE:
    case MPI_REQUEST_TESTED:
    case MPI_CANCELLED:
    case MPI_RMA_PUT_START:
    case MPI_RMA_PUT_END:
    case MPI_RMA_GET_START:
    case MPI_RMA_GET_END:
    case MPI_RMA_GATS:
    case MPI_RMA_COLLECTIVE_BEGIN:
    case MPI_RMA_COLLECTIVE_END:
    case MPI_RMA_LOCK:
    case MPI_RMA_UNLOCK:
      result = MpiEventFactory::createEvent(type, defs, buffer);
      break;

    case OMP_FORK:
    case OMP_JOIN:
    case OMP_ACQUIRE_LOCK:
    case OMP_RELEASE_LOCK:
    case OMP_TASK_CREATE:
    case OMP_TASK_COMPLETE:
    case OMP_TASK_SWITCH:
      result = OmpEventFactory::createEvent(type, defs, buffer);
      break;

  default:
    result = EventFactory::createEvent(type, defs, buffer);
    break;
  }
  
  return result;
}
