/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include "UnknownLocationGroup.h"

using namespace pearl;


/*-------------------------------------------------------------------------*/
/**
 *  @file    UnknownLocationGroup.cpp
 *  @ingroup PEARL_base
 *  @brief   Implementation of the class UnknownLocationGroup.
 *
 *  This file provides the implementation of the class UnknownLocationGroup
 *  and related functions.
 **/
/*-------------------------------------------------------------------------*/


//--- Constructors & destructor ---------------------------------------------

UnknownLocationGroup::UnknownLocationGroup(const IdType      id,
                                           const String&     name,
                                           SystemNode* const parent)
    : LocationGroup(id, name, parent)
{
}


//--- Access definition data ------------------------------------------------

LocationGroup::Type
UnknownLocationGroup::getType() const
{
    return LocationGroup::TYPE_UNKNOWN;
}
