/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include "Process.h"

#include <cassert>

using namespace std;
using namespace pearl;


/*-------------------------------------------------------------------------*/
/**
 *  @file    Process.cpp
 *  @ingroup PEARL_base
 *  @brief   Implementation of the class Process.
 *
 *  This file provides the implementation of the class Process and related
 *  functions.
 **/
/*-------------------------------------------------------------------------*/


//--- Constructors & destructor ---------------------------------------------

Process::Process(const IdType      id,
                 const String&     name,
                 SystemNode* const parent)
    : LocationGroup(id, name, parent),
      mRank(-1)
{
}


//--- Access definition data ------------------------------------------------

LocationGroup::Type
Process::getType() const
{
    return LocationGroup::TYPE_PROCESS;
}


int
Process::getRank() const
{
    return mRank;
}


//--- Set definition data ---------------------------------------------------

void
Process::setRank(int rank)
{
    // Assigned rank numbers need to be >= 0
    assert(rank >= 0);

    // ...and the assigment is only allowed once
    assert(-1 == mRank);

    mRank = rank;
}
