/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_OTF2ARCHIVE_H
#define PEARL_OTF2ARCHIVE_H


#include <otf2/OTF2_Reader.h>

#include <pearl/TraceArchive.h>

#include "Threading.h"


/*-------------------------------------------------------------------------*/
/**
 *  @file    Otf2Archive.h
 *  @ingroup PEARL_base
 *  @brief   Declaration of the class Otf2Archive.
 *
 *  This header file provides the declaration of the class Otf2Archive and
 *  related functions.
 **/
/*-------------------------------------------------------------------------*/

namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   Otf2Archive
 *  @ingroup PEARL_base
 *  @brief   Representation of an OTF2 trace experiment archive.
 *
 *  @todo Add documentation.
 **/
/*-------------------------------------------------------------------------*/

class Otf2Archive
    : public TraceArchive
{
    public:
        //--- Public methods -------------------------------

        /// @name Constructors & destructor
        /// @{

        /// @brief Constructor.
        ///
        /// Creates a new OTF2 trace experiment representation and initializes
        /// it with the given archive name.
        ///
        /// @param  anchorName  Name of the trace experiment archive anchor
        ///                     file/directory
        /// @param  archiveDir  Name of the trace experiment archive directory
        ///
        Otf2Archive(const std::string& anchorName,
                    const std::string& archiveDir);

        /// @brief Destructor.
        ///
        /// Implicitly closes the archive, releases all allocated resources
        /// and destroys the instance.
        ///
        virtual
        ~Otf2Archive();

        /// @}


    private:
        //--- Data members ---------------------------------

        /// OTF2 trace archive reader
        OTF2_Reader* mArchiveReader;

        /// Timer resolution in ticks per second
        uint64_t mTimerResolution;

        /// Global time offset (approx. timestamp of first event)
        uint64_t mGlobalOffset;

        /// %Mutex used to ensure exclusive access to some OTF2 archive
        /// functionality.
        Mutex mMutex;


        //--- Private methods & friends --------------------

        virtual void
        open();
        virtual void
        readDefinitions(GlobalDefs* defs);
        virtual void
        readTrace(const GlobalDefs& defs,
                  const Location&   location,
                  LocalTrace*       trace);
};


}   // namespace pearl


#endif   // !PEARL_OTF2ARCHIVE_H
