/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <pearl/OmpTaskSwitch_rep.h>

#include <iostream>

using namespace std;
using namespace pearl;


//---------------------------------------------------------------------------
//
//  class OmpTaskSwitch_rep
//
//---------------------------------------------------------------------------

//--- Constructors & destructor ---------------------------------------------

OmpTaskSwitch_rep::OmpTaskSwitch_rep(timestamp_t timestamp,
                                     uint64_t    taskId)
  : Event_rep(timestamp),
    mTaskId(taskId)
{
}


/// @todo Fix use of PEARL_NO_REQUEST
OmpTaskSwitch_rep::OmpTaskSwitch_rep(const GlobalDefs& defs, Buffer& buffer)
  : Event_rep(defs, buffer),
    mTaskId(PEARL_NO_REQUEST)   // Task ID is only local
{
}


//--- Event type information ------------------------------------------------

event_t OmpTaskSwitch_rep::getType() const
{
  return OMP_TASK_SWITCH;
}


bool OmpTaskSwitch_rep::isOfType(event_t type) const
{
  return ((OMP_TASK_SWITCH == type)
          || (GROUP_ALL == type));
}


//--- Access event data -----------------------------------------------------

uint64_t OmpTaskSwitch_rep::getTaskId() const
{
  return mTaskId;
}


//--- Generate human-readable output of event data (protected) --------------

ostream& OmpTaskSwitch_rep::output(ostream& stream) const
{
  Event_rep::output(stream);

  return stream << "  taskId = " << mTaskId << endl;
}
