/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <pearl/OmpJoin_rep.h>

using namespace pearl;


//---------------------------------------------------------------------------
//
//  class OmpJoin_rep
//
//---------------------------------------------------------------------------

//--- Constructors & destructor ---------------------------------------------

OmpJoin_rep::OmpJoin_rep(timestamp_t timestamp)
  : Event_rep(timestamp)
{
}


OmpJoin_rep::OmpJoin_rep(const GlobalDefs& defs, Buffer& buffer)
  : Event_rep(defs, buffer)
{
}


//--- Event type information ------------------------------------------------

event_t OmpJoin_rep::getType() const
{
  return OMP_JOIN;
}


bool OmpJoin_rep::isOfType(event_t type) const
{
  return ((OMP_JOIN == type)
          || (GROUP_ALL == type));
}
